{ ****************************************************************
  Info               :  TLabelGC2000X
                        Freeware

  Source File Name   :  X2000LABELGC.PAS
  Author / Modified  :  Baldemaier Florian(Baldemaier.Florian@gmx.net)
  Original made by   :  Andreas Windisch (wist@gmx.de)
  Compiler           :  Delphi 5.0 Professional
  Decription         :  Label with gradient text color 

****************************************************************   }
unit x2000LabelGC;
interface

uses

  WinProcs, Wintypes, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Menus, ShellApi, x2000AboutInfo;

type
  TLabelGC2000X = class(TCustomLabel)
   private
    FAbout     : TAboutInfo2000X;
    FAutoSize2 : Boolean;
    FColor1    : TColor;
    FColor2    : TColor;
    procedure ChangeColor1(C : TColor);
    procedure ChangeColor2(C : TColor);
    procedure ChangeAutoSize2(B : Boolean);
    procedure SetMaxSize(C: TCanvas;MaxBreite, MaxHoehe: Integer; const TestString: string);
    procedure DispColorText(P: TCanvas; Text: string; Start, Ende: TColor);
   protected
    procedure Paint; override;
   public
    constructor Create(AOwner: TComponent); override;
   published
    property About     : TAboutInfo2000X read FAbout     write FAbout          Stored False;
    property AutoSize2 : Boolean         read FAutoSize2 write ChangeAutoSize2;
    property Color1    : TColor          read FColor1    write ChangeColor1;
    property Color2    : TColor          read FColor2    write ChangeColor2;

    property Align;
    property Alignment;
    property AutoSize;
    property Caption;
    property Color;
    property DragCursor;
    property DragMode;
    property Enabled;
    property FocusControl;
    property Font;
    property ParentColor;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowAccelChar;
    property ShowHint;
    property Transparent;
    property Visible;
    property WordWrap;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    {$IFDEF WIN32}
    property OnStartDrag;
    {$ENDIF}
  end;

implementation

{==============================================================================}
procedure TLabelGC2000X.ChangeAutoSize2(B : Boolean);
{==============================================================================}
begin
  FAutoSize2 := B;
  AutoSize := not B;
  Refresh;
end;
{==============================================================================}
procedure TLabelGC2000X.ChangeColor1(C : TColor);
{==============================================================================}
begin
  FColor1 := C;
  Refresh;
end;
{==============================================================================}
procedure TLabelGC2000X.ChangeColor2(C : TColor);
{==============================================================================}
begin
  FColor2 := C;
  Refresh;
end;
{==============================================================================}
constructor TLabelGC2000X.Create(aOwner:TComponent);
{==============================================================================}
begin
  inherited Create(aOwner);
  Font.Name := 'Arial';
end;
{==============================================================================}
procedure TLabelGC2000X.SetMaxSize(C: TCanvas;MaxBreite, MaxHoehe: Integer; const TestString: string);
{==============================================================================}
begin
   with C do begin
      Font.Size := 100;
      while ((TextWidth(TestString) > MaxBreite) or (TextHeight(TestString) > MaxHoehe)) and (Font.Size>2) do
         Font.Size := Font.Size div 2;
      while (TextWidth(TestString) < MaxBreite) and (TextHeight(TestString) < MaxHoehe) do
         Font.Size := Font.Size + 1;
      if Font.Size >= 2 then
         Font.Size := Font.Size - 1;
      MoveTo((MaxBreite - TextWidth(TestString)) div 2, (MaxHoehe - TextHeight(TestString)) div 2);
   end;
end;
{==============================================================================}
procedure TLabelGC2000X.DispColorText(P: TCanvas; Text: string; Start, Ende: TColor);
{==============================================================================}
  {==================================================}
  procedure GetRGB(CL: TColor; var r, g, b: Integer);
  {==================================================}
  var L: LongInt;
  begin
    L := ColorToRGB(CL);
    R := L and $FF;
    G := (L shr 8)  and $FF;
    B := (L shr 16) and $FF;
  end;
  {==================================================}
var
  Anz, i,
  r1, g1, b1,
  r2, g2, b2 : Integer;
  rd, gd, bd : Real;
begin
  P.MoveTo(0,0);

  Anz := Length(Text);
  GetRGB(Start, r1, g1, b1);
  GetRGB(Ende, r2, g2, b2);
  rd := (r2 - r1) / Anz;
  gd := (g2 - g1) / Anz;
  bd := (b2 - b1) / Anz;

  if FAutoSize2 then SetMaxSize(P, Width, Height, Text);

  for i := 1 to Anz do begin
    P.Font.Color:=RGB(r1,g1,b1);
    P.TextOut(P.Penpos.x,P.Penpos.Y, Text[i]);

    r1 := Trunc(r1 + rd);
    g1 := Trunc(g1 + gd);
    b1 := Trunc(b1 + bd);
  end;
end;
{==============================================================================}
procedure TLabelGC2000X.Paint;
{==============================================================================}
begin
  with Canvas do begin
    if not Transparent then begin
      Brush.Color := Self.Color;
      Brush.Style := bsSolid;
      FillRect(ClientRect);
    end;
    Brush.Style := bsClear;
  end;
  DispColorText(Canvas, Caption, FColor1, FColor2);
end;

end.
