{ ****************************************************************
  Info               :  TIconDialog2000X
                        Freeware

  Source File Name   :  X2000IconDialog.PAS
  Author             :  Baldemaier Florian (Baldemaier.Florian@gmx.net)
  Original           :  Workshell Software
  Compiler           :  Delphi 5.0 Professional
  Decription         :  Undocumented Windows API functions founded by Workshell Software
**************************************************************** }

unit X2000IconDialog;

interface

uses
  Windows, Messages, Forms, SysUtils, Classes, Graphics, Controls, ShellAPI,
  x2000AboutInfo;

type
  TIconDialog2000X = class(TComponent)
  private
    FAbout: TAboutInfo2000X;
    FIcon: TIcon;
    FFileName: String;
    FIndex: Integer;
    function GetAnyFile: String;
  protected
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  public
    function Execute: Boolean;
    property Icon: TIcon read FIcon;
  published
    property About    : TAboutInfo2000X read FAbout    write FAbout     Stored False;
    property FileName : String          read FFileName write FFileName;
    property IconIndex: Integer         read FIndex    write FIndex;
  end;

implementation

function PickIconDlgA(OwnerWnd: HWND; lpstrFile: PAnsiChar; var nMaxFile: LongInt;
 var lpdwIconIndex: LongInt): LongBool; stdcall; external 'SHELL32.DLL' index 62;

constructor TIconDialog2000X.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FIcon := TIcon.Create;
end;

destructor TIconDialog2000X.Destroy;
begin
  FIcon.Free;
  inherited Destroy;
end;

function TIconDialog2000X.Execute: Boolean;
var
  zFileName: array [0..MAX_PATH - 1] of Char;
  zSize, zIndex: LongInt;
begin
  zSize := MAX_PATH;
  StrPCopy(zFileName,GetAnyFile);
  if FileName <> '' then
  begin
    StrPCopy(zFileName,FileName);
  end;
  Result := PickIconDlgA(0,zFilename,zSize,zIndex);
  FileName := StrPas(zFileName);
  IconIndex := zIndex;
  if (FileName <> '') and (IconIndex <> -1) then
  begin
   FIcon.Handle := ExtractIcon(hInstance,zFileName,zIndex);
  end;
end;

function TIconDialog2000X.GetAnyFile: String;
var
  zSysDir: array [0..MAX_PATH - 1] of Char;
  SysDir: String;
begin
  GetSystemDirectory(zSysDir,255);
  SysDir := StrPas(zSysDir);
  if SysDir[Length(SysDir)] <> '\' then
  begin
    SysDir := SysDir + '\';
  end;
  Result := SysDir + 'SHELL32.DLL';
end;

end.
