{ ****************************************************************
  Info               :  TFindFile2000X
                        Freeware

  Source File Name   :  X2000FindFile.PAS
  Author             :  Baldemaier Florian (Baldemaier.Florian@gmx.net)
  Compiler           :  Delphi 5.0 Professional
**************************************************************** }
unit X2000FindFile;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  x2000AboutInfo;

type
  TFindFile2000X = class(TComponent)
  private
    FFoundList:TStrings;
    FAbout: TAboutInfo2000X;
  protected
    fndlist    :tstrings;
    procedure SetFoundList(Value:TStrings);
  public
    constructor create(AOwner:TComponent); override;
    procedure find(StartDirectory:String; FileName:String);
  published
    property About    : TAboutInfo2000X read FAbout     write FAbout       Stored False;
    property FoundList:TStrings         read FFoundList write SetFoundList Stored False;
  end;

implementation

constructor TFindFile2000X.create(AOwner:TComponent);
begin
  inherited create(AOwner);
  ffoundlist:=tstringlist.create;
  fndlist:=tstringlist.create;
end;

procedure TFindFile2000X.SetFoundList(Value :TStrings);
begin
  FFoundList.assign(Value);
end;

procedure TFindFile2000X.Find(StartDirectory:String; FileName:String);

procedure RecursiveFileSearch(TheWorkingDirectory:String);
var
    Finished        : Boolean;      
    TheSR           : TSearchRec;   
    TheResult       : Integer;      
    TargetPath ,
    FileMask   ,
    TheStoredWorkingDirectory ,
    ModifiedDirectory  : String;    
begin
  Finished := false;
  TheStoredWorkingDirectory := TheWorkingDirectory;
  Targetpath := ExtractFilePath( TheWorkingDirectory );
  FileMask := ExtractFileName( TheWorkingDirectory );
  TheResult := FindFirst( TheWorkingDirectory , faAnyFile , TheSR );

  if TheResult <> 0 then finished := true;
  if (( TheSr.Name <> '.' ) and ( TheSr.Name <> '..' ) and ( TheResult >= 0 ))
  then begin
    if (( FileGetAttr( TargetPath + TheSR.Name ) and faDirectory ) =
     faDirectory ) then
    begin 

    end
    else
    begin
      fndlist.Add(TargetPath + TheSr.Name);
    end;
  end;
  while not Finished do
  begin
    TheResult := FindNext( TheSR );
    if TheResult <> 0 then finished := true else
    begin
      if (( FileGetAttr( TargetPath + TheSR.Name ) and faDirectory ) =
       faDirectory ) then
      begin
      end
      else
      begin
        fndlist.Add(TargetPath + TheSr.Name);
      end;
    end;
  end;
  Finished := false;
  ModifiedDirectory := ExtractFilePath( TheWorkingdirectory ) + '*.*';
  TheResult := FindFirst( ModifiedDirectory , faDirectory , TheSR );
  while not Finished do
  begin
    TheResult := FindNext( TheSR );
    if TheResult <> 0 then finished := true
    else
    begin
      if TheSR.Name <> '..' then { Ignore backup in this case }
      begin
        if (( FileGetAttr( TargetPath + TheSR.Name ) and faDirectory )
        = faDirectory ) then
        begin
          ModifiedDirectory := ExtractFilePath( TheStoredWorkingDirectory ) +
           TheSR.Name + '\' + FileMask;
          RecursiveFileSearch( ModifiedDirectory);
        end;
      end;
    end;
  end;
end;

begin
  fndlist.Clear;
  RecursiveFileSearch(StartDirectory+FileName);
  setfoundlist(fndlist);
end;

end.
