{ ****************************************************************
  Info               :  TFindFilesDialog2000X
                        TFindComputerDialog2000X
                        Freeware

  Source File Name   :  X2000FindDialog.PAS
  Author             :  Baldemaier Florian (Baldemaier.Florian@gmx.net)
  Original           :  Workshell Software
  Compiler           :  Delphi 5.0 Professional
  Decription         :  Undocumented Windows API functions founded by Workshell Software
**************************************************************** }

unit X2000FindDialog;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ShlObj, x2000AboutInfo;

type
  TFindFilesDialog2000X = class(TComponent)
  private
    FAbout: TAboutInfo2000X;
  public
    function Execute: Boolean;
    function ExecuteEx(pidlRoot, pidlSavedSearch: PItemIDList): Boolean;
  published
    property About: TAboutInfo2000X read FAbout write FAbout Stored False;
  end;

  TFindComputerDialog2000X = class(TComponent)
  private
    FAbout: TAboutInfo2000X;
  public
    function Execute: Boolean;
    function ExecuteEx(pidlRoot, pidlSavedSearch: PItemIDList): Boolean;
  published
    property About: TAboutInfo2000X read FAbout write FAbout Stored False;
  end;

implementation

function SHFindFiles(pidlRoot: PItemIDList; pidlSavedSearch: PItemIDList): Boolean;
 stdcall; external 'Shell32.dll' index 90;

function SHFindComputer(pidlRoot: PItemIDList; pidlSavedSearch: PItemIDList): Boolean;
 stdcall; external 'Shell32.dll' index 91;

function TFindFilesDialog2000X.Execute: Boolean;
begin
  Result := SHFindFiles(nil,nil);
end;

function TFindFilesDialog2000X.ExecuteEx(pidlRoot, pidlSavedSearch: PItemIDList): Boolean;
begin
  Result := SHFindFiles(pidlRoot,pidlSavedSearch);
end;

function TFindComputerDialog2000X.Execute: Boolean;
begin
  Result := SHFindComputer(nil,nil);
end;

function TFindComputerDialog2000X.ExecuteEx(pidlRoot, pidlSavedSearch: PItemIDList): Boolean;
begin
  Result := SHFindComputer(pidlRoot,pidlSavedSearch);
end;

end.
