{ ****************************************************************
  Info               :  TFileCompress2000X
                        Freeware

  Source File Name   :  X2000FileCompress.PAS
  Author             :  Baldemaier Florian (Baldemaier.Florian@gmx.net)
  LHA Algorithm      :  Haruhiko Okomura and Haruyasu Yoshizaki.
  LHA Modified       :  Gregory L. Bullock
  Compiler           :  Delphi 5.0 Professional
  Decription         :  Tool for compress a file with LHA.


  IMPORTANT !!!! NOT 100 % LHA KOMPATIBLE
**************************************************************** }

unit X2000FileCompress;

interface

uses
   Windows, SysUtils, Messages, Classes, Graphics, Controls, Forms,
   Dialogs, ExtCtrls, StdCtrls, ShellAPI, Filectrl, x2000lhacompress,
   x2000AboutInfo;

type
    TFileCompress2000X=class (TComponent)
    private
       FInput         : TFilename;
       FOutPut        : TFilename;
       FOver          : Boolean;
       FAbout         : TAboutInfo2000X;
       procedure SetFile(value: TFilename);
       procedure SetFile2(value: TFilename);
       procedure SetAllow(value: Boolean);
    public
       procedure Compress;
       procedure Expand;
    published
       property InputFile      : TFilename   read FInput  write SetFile;
       property OutputFile     : TFilename   read FOutput write SetFile2;
       property AllowOverride  : Boolean     read FOver   write SetAllow default false;
       property About          : TAboutInfo2000X read FAbout write FAbout Stored False;
    end;

implementation

procedure TFileCompress2000X.Expand;
var
  InStr, OutStr: TFileStream;
  FTemp: TFilename;
begin
  FInput := AnsiUppercase(FInput);
  FOutput:= AnsiUppercase(FOutput);
  if not Fileexists(FInput) then begin
     MessageDlg('Input File doent exists',mterror,[mbok],0);
     exit;
  end;
  if not FOver then begin
    if FInput=FOutput then begin
       MessageDlg('Input File cant be the same as Output File',mterror,[mbok],0);
       exit;
    end;
    if FOutput='' then begin
       MessageDlg('You must enter a filename.',mterror,[mbok],0);
       exit;
    end;
    if Fileexists(FOutput) then begin
       MessageDlg('Output File does exists. You must enter a filename that are not exists.',mterror,[mbok],0);
       exit;
    end;
    InStr := TFileStream.Create(FInput,fmOpenRead);
    OutStr := TFileStream.Create(FOutput,fmCreate);
    LHAExpand(InStr, OutStr);
    InStr.Free;
    OutStr.Free;
  end;
  if FOver then begin
    FTemp:=ExtractFilepath(FInput);
    if copy(FTemp,length(FTemp),1)<>'\' then FTemp:=FTemp+'\';
    FTemp:=FTemp+'Temp.tmp';
    if FileExists(FTemp) then deleteFile(FTemp);
    InStr := TFileStream.Create(FInput,fmOpenRead);
    OutStr := TFileStream.Create(FTemp,fmCreate);
    LHAExpand(InStr, OutStr);
    try
      InStr.Free;
      OutStr.Free;
    finally
      DeleteFile (FInput);
      RenameFile (FTemp, FInPut);
    end;
  end;
end;

procedure TFileCompress2000X.Compress;
var
  InStr, OutStr: TFileStream;
  FTemp: TFilename;
begin
  FInput := AnsiUppercase(FInput);
  FOutput:= AnsiUppercase(FOutput);
  if not Fileexists(FInput) then begin
     MessageDlg('Input File doent exists',mterror,[mbok],0);
     exit;
  end;
  if not FOver then begin
    if Fileexists(FOutput) then begin
       MessageDlg('Output File does exists. You must enter a filename that are not exists.',mterror,[mbok],0);
       exit;
    end;
    if FOutput='' then begin
       MessageDlg('You must enter a filename.',mterror,[mbok],0);
       exit;
    end;
    if FInput=FOutput then begin
       MessageDlg('Input File cant be the same as Output File',mterror,[mbok],0);
       exit;
    end;
    InStr  := TFileStream.Create(FInput,fmOpenRead);
    OutStr := TFileStream.Create(FOutput,fmCreate);
    LHACompress(InStr, OutStr);
    InStr.Free;
    OutStr.Free;
  end;
  if FOver then begin
    FTemp:=ExtractFilepath(FInput);
    if copy(FTemp,length(FTemp),1)<>'\' then FTemp:=FTemp+'\';
    FTemp:=FTemp+'Temp.tmp';
    if FileExists(FTemp) then deleteFile(FTemp);
    InStr := TFileStream.Create(FInput,fmOpenRead);
    OutStr := TFileStream.Create(FTemp,fmCreate);
    LHACompress(InStr, OutStr);
    try
     InStr.Free;
     OutStr.Free;
    finally
     deleteFile (FInput);
     RenameFile (FTemp, FInPut);
    end;
  end;

end;

procedure TFileCompress2000X.SetAllow(value: Boolean);
begin
  if value then begin
    FOver:=True;
    FOutput:='(not required)';
  end;
  if not value then begin
    FOver:=false;
    if FOutput='(not required)' then FOutput:='';
  end;

end;

procedure TFileCompress2000X.SetFile(value: TFilename);
begin
   if fileexists(value) then FInput:=value;
end;

procedure TFileCompress2000X.SetFile2(value: TFilename);
begin
   if FOver then FOutput:='(not required)';
   if not FOver then FOutput:=value;
end;

end.
