{ ****************************************************************
  Info               :  TShutdownDialog
                        TRestartDialog
                        Freeware

  Source File Name   :  X2000ExitDialog.PAS
  Author             :  Baldemaier Florian (Baldemaier.Florian@gmx.net)
  Original           :  Workshell Software
  Compiler           :  Delphi 5.0 Professional
  Decription         :  Undocumented Windows API functions founded by Workshell Software
**************************************************************** }

unit X2000ExitDialog;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  x2000AboutInfo;

type
  TShutdownDialog2000X = class(TComponent)
  private
    FAbout: TAboutInfo2000X;
  public
    procedure Execute;
  published
    property About             : TAboutInfo2000X read FAbout write FAbout Stored False;
  end;

type
 TRestartKind = (rkLogoff, rkShutdown, rkReboot, rkRestart);

type
 TRestartDialog2000X = class(TComponent)
  private
    FRestartKind: TRestartKind;
    FAbout: TAboutInfo2000X;
    procedure SetRestartKind(Value: TRestartKind);
  protected
    constructor Create(AOwner: TComponent); override;
  public
    function Execute: Boolean;
    function ExecuteEx(Kind: TRestartKind): Boolean;
  published
    property About      : TAboutInfo2000X read FAbout       write FAbout         Stored False;
    property RestartKind: TRestartKind    read FRestartKind write SetRestartKind Stored False;
  end;

var
 Flags: LongInt = 2;

implementation

procedure ExitWindowsDialog(ParentWnd: HWND); stdcall;
 external 'Shell32.dll' index 60;

function RestartDialog(ParentWnd: HWND; Reason: PAnsiChar; Flags: LongInt): LongInt;
 stdcall; external 'Shell32.dll' index 59;

procedure TShutdownDialog2000X.Execute;
begin
  ExitWindowsDialog(0);
end;

constructor TRestartDialog2000X.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  RestartKind := rkRestart;
end;

function TRestartDialog2000X.Execute: Boolean;
begin
  case RestartKind of
   rkLogoff:   Flags := EWX_LOGOFF;
   rkShutdown: Flags := EWX_SHUTDOWN;
   rkReboot:   Flags := EWX_REBOOT;
   rkRestart:  Flags := EW_RESTARTWINDOWS;
  end;
 if RestartDialog(0,nil,Flags) = IDYES then
   begin
   Result := True;
    end
  else
   Result := False;
end;

function TRestartDialog2000X.ExecuteEx(Kind: TRestartKind): Boolean;
begin
  case Kind of
   rkLogoff:   Flags := EWX_LOGOFF;
   rkShutdown: Flags := EWX_SHUTDOWN;
   rkReboot:   Flags := EWX_REBOOT;
   rkRestart:  Flags := EW_RESTARTWINDOWS;
  end;
  if RestartDialog(0,nil,Flags) = IDYES then
   begin
    Result := True;
   end
  else
  Result := False;
end;

procedure TRestartDialog2000X.SetRestartKind(Value: TRestartKind);
begin
  if Value <> FRestartKind then
   begin
    FRestartKind := Value;
   end;
end;

end.
