{ ****************************************************************
  Info               :  TDisplayInfo2000X
                        Freeware

  Source File Name   :  X2000DISPLAYINFO.PAS
  Author             :  Baldemaier Florian(Baldemaier.Florian@gmx.net)
  Compiler           :  Delphi 5.0 Professional
  Decription         :  Same as in TSystemInfo.

****************************************************************   }
unit X2000DisplayInfo;

interface

uses
  Windows, Messages, Forms, Classes, Graphics, Controls, SysUtils, ShellAPI, Dialogs,
  x2000AboutInfo;

type
  TDisplayInfo2000X=class (TComponent)
  private
    FAbout    : TAboutInfo2000X;

    FRasterCapabilities    :TStrings;
    FCurveCapabilities     :TStrings;
    FLineCapabilities      :TStrings;
    FPolygonalCapabilities :TStrings;
    FTextCapabilities      :TStrings;

    FDisplayDrv, FDisplayVXD, FDisplayDPI, FDisplayResolution, FDisplayBpp, FMonitor:string;
    FModes:TStrings;
    procedure SetNone1(Value: String);
  public
    constructor Create(aOwner: TComponent); override;
    destructor Destroy; override;
    procedure Refresh;
  published
    property About                      : TAboutInfo2000X read FAbout             write FAbout   Stored False;
    property Display_Driver_Description : string          read FDisplayDrv        write SetNone1 Stored False;
    property Display_Driver             : string          read FDisplayVXD        write SetNone1 Stored False;
    property DisplayDPI                 : string          read FDisplayDPI        write SetNone1 Stored False;
    property DisplayResolution          : string          read FDisplayResolution write SetNone1 Stored False;
    property DisplayBpp                 : string          read FDisplayBpp        write SetNone1 Stored False;
    property Monitor                    : String          read FMonitor           write SetNone1 Stored False;
    property Modes                      : TStrings        read FModes             write FModes   Stored False;
    property RasterCapabilities         : TStrings        read FRasterCapabilities               Stored False;
    property CurveCapabilities          : TStrings        read FCurveCapabilities                Stored False;
    property LineCapabilities           : TStrings        read FLineCapabilities                 Stored False;
    property PolygonalCapabilities      : TStrings        read FPolygonalCapabilities            Stored False;
    property TextCapabilities           : TStrings        read FTextCapabilities                 Stored False;
  end;


implementation

uses X2000SystemInfoHardware;

constructor TDisplayInfo2000X.Create(aOwner: TComponent);
begin
  inherited Create(aOwner);
  FRasterCapabilities    :=TStringlist.create;
  FCurveCapabilities     :=TStringlist.create;
  FLineCapabilities      :=TStringlist.create;
  FPolygonalCapabilities :=TStringlist.create;
  FTextCapabilities      :=TStringlist.create;
  Modes                  :=TStringList.Create;
  Refresh;
end;

destructor TDisplayInfo2000X.Destroy;
begin
  inherited Destroy;
end;

procedure TDisplayInfo2000X.SetNone1(Value: String);
begin
end;

procedure TDisplayInfo2000X.Refresh;
var
  devmode : TDEVMODE;
  i:integer;
begin

  fDisplayDPI                 := GetDisplay(1);
  fDisplayResolution          := GetDisplay(2);
  fDisplayBPP                 := GetDisplay(3);
  fDisplayDrv                 := GetDisplay(4);
  fDisplayVXD                 := GetDisplay(5);
  fMonitor                    := GetDisplay(6);
  devmode.dmSize        := SizeOf(TDEVMODE);
  devmode.dmDriverExtra := 0;
    for i := 0 to 25 do
      if EnumDisplaySettings(nil, i, devmode) then
        Modes.Add(IntToStr(devmode.dmPelsWidth) + ' x ' + IntToStr(devmode.dmPelsHeight) + ' - ' + IntToStr(devmode.dmBitsPerPel) + 'Bit');

  GetCapabilities(1, FRasterCapabilities);
  GetCapabilities(2, FCurveCapabilities);
  GetCapabilities(3, FLineCapabilities);
  GetCapabilities(4, FPolygonalCapabilities);
  GetCapabilities(5, FTextCapabilities);

end;

end.
