{ ****************************************************************
  Info               :  TCPUInfo2000X
                        Freeware

  Source File Name   :  X2000CPUINFO.PAS
  Author             :  Baldemaier Florian(Baldemaier.Florian@gmx.net)
  Compiler           :  Delphi 5.0 Professional
  Decription         :  Same as in TSystemInfo.

****************************************************************   }
unit X2000CpuInfo;

interface

uses
  Windows, Messages, Forms, Classes, Graphics, Controls, SysUtils, ShellAPI, Dialogs, x2000AboutInfo;

type
  TCPUInfo2000X = class(TComponent)
  private
    FAbout    : TAboutInfo2000X;
    FProcessorSpeed, FNumberOfProcessors, FActiveProcessor, FProcessor, FProcessorVendor, FProcessorMMX:string;
    FProcessorRevision:string;
    FCoPro:string;
    procedure SetNone1(Value: String);
  public
    constructor Create(aOwner: TComponent); override;
    destructor Destroy; override;
    procedure Refresh;
  published
    property About              : TAboutInfo2000X read FAbout              write FAbout   Stored False;
    property Processor          : string          read FProcessor          write SetNone1 Stored False;
    property ProcessorSpeed     : string          read FProcessorSpeed     write SetNone1 Stored False;
    property ProcessorVendor    : string          read FProcessorVendor    write SetNone1 Stored False;
    property ProcessorRevision  : string          read FProcessorRevision  write SetNone1 Stored False;
    property ProcessorMMX       : string          read FProcessorMMX       write SetNone1 Stored False;
    property NumberOfProcessors : String          read FNumberOfProcessors write SetNone1 Stored False;
    property ActiveProcessor    : String          read FActiveProcessor    write SetNone1 Stored False;
    property CoProcessor        : String          read FCoPro              write SetNone1 Stored False;
  end;

implementation

uses X2000SystemInfoHardware;

constructor TCPUInfo2000X.Create(aOwner: TComponent);
begin
  inherited Create(aOwner);
  refresh;
end;

destructor TCPUInfo2000X.Destroy;
begin
  inherited Destroy;
end;

procedure TCPUInfo2000X.SetNone1(Value: String);
begin
end;

procedure TCPUInfo2000X.Refresh;
begin
  fProcessor          := GetCpu(1);
  fProcessorVendor    := GetCpu(2);
  fProcessorMMX       := GetCpu(3);
  fCoPro        := GetCpu(4);
  fProcessorSpeed     := GetCpu(5);
  fNumberOfProcessors := GetCpu(6);
  fActiveProcessor    := GetCpu(7);
  fProcessorRevision  := GetCpu(8);
end;

end.
