{ ****************************************************************
  Info               :  TCheckBox2000X
                        TRadioButton2000X
				TCheckGroupBox2000X
                        Freeware

  Source File Name   :  X2000Controls.PAS
  Author             :  Baldemaier Florian(Baldemaier.Florian@gmx.net)
  Compiler           :  Delphi 5.0 Professional
  Decription         :  Same as in TSystemInfo.

****************************************************************   }
unit X2000Controls;

interface

uses Windows, Forms, Graphics, Classes, Controls, StdCtrls, Messages, x2000AboutInfo;

type
  TVertAlignment = (vaTopJustify, vaCenter, vaBottomJustify);
  TStyle = (vsNormal, vsFlat, vsPushButton);

  TCheckBox2000X = class(TCheckBox)
  private
    FAbout    : TAboutInfo2000X;
    FHorzAlign: TAlignment;
    FVertAlign: TVertAlignment;
    FWordWrap: Boolean;
    FStyle: TStyle;
    procedure SetHorzAlign(Value: TAlignment);
    procedure SetVertAlign(Value: TVertAlignment);
    procedure SetWordWrap(Value: boolean);
    procedure SetStyle(Value: TStyle);
  protected
    procedure CreateParams(var Params: TCreateParams); override;
  public
    constructor Create(AOwner: TComponent); override;
  published
    property About              : TAboutInfo2000X read FAbout     write FAbout       Stored False;
    property HorizontalAlignment: TAlignment      read FHorzAlign write SetHorzAlign;
    property VerticalAlignment  : TVertAlignment  read FVertAlign write SetVertAlign;
    property WordWrap           : boolean         read FWordWrap  write SetWordWrap;
    property Style              : TStyle          read FStyle     write SetStyle;
  end;

  TRadioButton2000X = class(TRadioButton)
  private
    FAbout    : TAboutInfo2000X;
    FHorzAlign: TAlignment;
    FVertAlign: TVertAlignment;
    FWordWrap: Boolean;
    FStyle: TStyle;
    procedure SetHorzAlign(Value: TAlignment);
    procedure SetVertAlign(Value: TVertAlignment);
    procedure SetWordWrap(Value: boolean);
    procedure SetStyle(Value: TStyle);
  protected
    procedure CreateParams(var Params: TCreateParams); override;
  public
    constructor Create(AOwner: TComponent); override;
  published
    property About              : TAboutInfo2000X read FAbout     write FAbout        Stored False;
    property HorizontalAlignment: TAlignment      read FHorzAlign write SetHorzAlign;
    property VerticalAlignment  : TVertAlignment  read FVertAlign write SetVertAlign;
    property WordWrap           : boolean         read FWordWrap  write SetWordWrap;
    property Style              : TStyle          read FStyle     write SetStyle;
  end;


  TXCheckBox = class(TCustomCheckBox)
  published
    property AllowGrayed;
    property Color;
    property Ctl3D;
    property Enabled;
    property ShowHint;
    property State;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
  end;

  TCheckCustomGroupBox2000X = class(TCustomGroupBox)
  private
    FCheckBox: TXCheckBox;
    FChecked: boolean;
    FOnCheckBoxClick: TNotifyEvent;
    function GetAlignment: TLeftRight;
    procedure SetAlignment(Value: TLeftRight);
    function GetCaption: TCaption;
    procedure SetCaption(Value: TCaption);
    procedure AdjustCheckBounds;
    procedure SetChecked(Value: boolean);
    procedure WMENABLE(var Message: TWMEnable); message WM_ENABLE;
  protected
    procedure CheckBoxClick(Sender: TObject); virtual;
    procedure EnableControls(WControl: TWinControl; var Message: TWMEnable{Comp: TComponent; Enable: boolean}); virtual;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    property CheckBox: TXCheckBox read FCheckBox write FCheckBox;
  published
    property BoxAlignment: TLeftRight read GetAlignment write SetAlignment;
    property Caption: TCaption read GetCaption write SetCaption;
    property Checked: boolean read FChecked write SetChecked;
    property OnCheckBoxClick: TNotifyEvent read FOnCheckBoxClick write FOnCheckBoxClick;
  end;

  TCheckGroupBox2000X = class(TCheckCustomGroupBox2000X)
  private
    FAbout    : TAboutInfo2000X;
  published
    property About     : TAboutInfo2000X read FAbout write FAbout Stored False;
    property Align;
    property Caption;
    property Color;
    property Ctl3D;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Visible;
    property OnClick;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDrag;
  end;

const
  BoxWith = 19;

implementation

procedure CreateParamsInternal(var Params: TCreateParams; AHorzAlign: TAlignment;
  AVertAlign: TVertAlignment; AStyle: TStyle; AWordWrap: boolean);
begin
  Params.Style:=Params.Style and not(BS_LEFT or BS_RIGHT or BS_CENTER or
    BS_TOP or BS_BOTTOM or BS_VCENTER or BS_FLAT or BS_PUSHLIKE or BS_MULTILINE);
  case AHorzAlign of
    taLeftJustify: Params.Style:=Params.Style or BS_LEFT;
    taRightJustify: Params.Style:=Params.Style or BS_RIGHT;
    taCenter: Params.Style:=Params.Style or BS_CENTER;
  end;
  case AVertAlign of
    vaTopJustify: Params.Style:=Params.Style or BS_TOP;
    vaBottomJustify: Params.Style:=Params.Style or BS_BOTTOM;
    vaCenter: Params.Style:=Params.Style or BS_VCENTER;
  end;
  case AStyle of
    vsFlat: Params.Style:=Params.Style or BS_FLAT;
    vsPushButton: Params.Style:=Params.Style or BS_PUSHLIKE;
  end;
  if AWordWrap then Params.Style:=Params.Style or BS_MULTILINE;
end;

constructor TCheckBox2000X.Create(AOwner: TComponent);
begin
  FWordWrap:=true;
  width:=113;
  inherited;
end;

procedure TCheckBox2000X.CreateParams(var Params: TCreateParams);
begin
  inherited;
  CreateParamsInternal(Params,FHorzAlign,FVertAlign,FStyle,FWordWrap);
end;

procedure TCheckBox2000X.SetHorzAlign(Value: TAlignment);
begin
  if Value <> FHorzAlign then begin
    FHorzAlign:=Value;
    RecreateWnd;
  end;
end;

procedure TCheckBox2000X.SetStyle(Value: TStyle);
begin
  if Value <> FStyle then begin
    FStyle:=Value;
    RecreateWnd;
  end;
end;

procedure TCheckBox2000X.SetVertAlign(Value: TVertAlignment);
begin
  if Value <> FVertAlign then begin
    FVertAlign:=Value;
    RecreateWnd;
  end;
end;

procedure TCheckBox2000X.SetWordWrap(Value: boolean);
begin
  if Value <> FWordWrap then begin
    FWordWrap:=Value;
    RecreateWnd;
  end;
end;

constructor TRadioButton2000X.Create(AOwner: TComponent);
begin
  FWordWrap:=true;
  width:=121;
  inherited;
end;

procedure TRadioButton2000X.CreateParams(var Params: TCreateParams);
begin
  inherited;
  CreateParamsInternal(Params,FHorzAlign,FVertAlign,FStyle,FWordWrap);
end;

procedure TRadioButton2000X.SetHorzAlign(Value: TAlignment);
begin
  if Value <> FHorzAlign then begin
    FHorzAlign:=Value;
    RecreateWnd;
  end;
end;

procedure TRadioButton2000X.SetStyle(Value: TStyle);
begin
  if Value <> FStyle then begin
    FStyle:=Value;
    RecreateWnd;
  end;
end;

procedure TRadioButton2000X.SetVertAlign(Value: TVertAlignment);
begin
  if Value <> FVertAlign then begin
    FVertAlign:=Value;
    RecreateWnd;
  end;
end;

procedure TRadioButton2000X.SetWordWrap(Value: boolean);
begin
  if Value <> FWordWrap then begin
    FWordWrap:=Value;
    RecreateWnd;
  end;
end;

constructor TCheckCustomGroupBox2000X.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  inherited Text := '-';
  FCheckBox := TXCheckBox.Create(Self);
  FChecked := true;
  with FCheckBox do
  begin
    TCheckBox.Create(Self);
    Parent := Self;
    OnClick := CheckBoxClick;
    Checked := true;
    Left := 6;
    Width := 18;
    inherited Top := 0;
    Caption := '';
  end;
end;

destructor TCheckCustomGroupBox2000X.Destroy;
begin
  FCheckBox.Free;
  inherited Destroy;
end;

procedure TCheckCustomGroupBox2000X.WMENABLE(var Message: TWMEnable);
begin
  EnableControls(Self, Message);
end;

function TCheckCustomGroupBox2000X.GetAlignment: TLeftRight;
begin
  Result := FCheckBox.Alignment;
end;

procedure TCheckCustomGroupBox2000X.SetAlignment(Value: TLeftRight);
begin
  FCheckBox.Alignment := Value;
end;

function TCheckCustomGroupBox2000X.GetCaption: TCaption;
begin
  Result := FCheckBox.Caption;
end;

procedure TCheckCustomGroupBox2000X.SetCaption(Value: TCaption);
begin
  if (FCheckBox.Left + Canvas.TextWidth(Value) + BoxWith) < Width then
  begin
    FCheckBox.Caption := Value;
    AdjustCheckBounds;
  end;
end;

procedure TCheckCustomGroupBox2000X.AdjustCheckBounds;
const
  WordWraps: array[Boolean] of Word = (0, DT_WORDBREAK);
begin
  // Par dfaut La Font du checkbox est celle de son parent
  FCheckBox.Width := BoxWith + Canvas.TextWidth(FCheckBox.Caption) + 2;
  FCheckBox.Repaint;
end;

procedure TCheckCustomGroupBox2000X.SetChecked(Value: boolean);
begin
  FCheckBox.Checked := Value;
  CheckBoxClick(nil);
end;

procedure TCheckCustomGroupBox2000X.CheckBoxClick(Sender: TObject);
var
  i: integer;
begin
  inherited Click;
  FChecked := FCheckBox.Checked;
  for i := 0 to ControlCount - 1 do
  begin
    if Controls[i] is TXCheckBox then
      continue;
    Controls[i].Enabled := FChecked;
  end;
  if Assigned(FOnCheckBoxClick) then FOnCheckBoxClick(Self);
end;

procedure TCheckCustomGroupBox2000X.EnableControls(WControl: TWinControl; var Message: TWMEnable{Comp: TComponent; Enable: boolean});
var
  i: integer;
begin
  if not (csDesigning in ComponentState) then
    if WControl.controlcount > 0 then
    begin
      if (WControl = Self) then
        if (not Self.Enabled) and (not FChecked) and  (not Message.Enabled) then
          Self.FCheckBox.Enabled := false  // Pour griser aussi la chexbox
        else                               // quand le contrle est dsactiv
          Self.FCheckBox.Enabled := true;
      for i := 0 to WControl.ControlCount - 1 do
        if (WControl.Controls[i] is TWinControl) and FChecked then
            EnableControls(TWinControl(WControl.Controls[i]), Message);
    end else
      if WControl.HandleAllocated then
        if (WControl.Parent is TCheckCustomGroupBox2000X) and
          not (WControl.Parent as TCheckCustomGroupBox2000X).Checked then
        begin
          if (WControl is TXCheckbox) and WControl.Parent.Enabled then
            EnableWindow(WControl.Handle, Message.Enabled);
        end else
          EnableWindow(WControl.Handle, Message.Enabled);
end;

end.
