{ ****************************************************************
  Info               :  Base64 Encode-Decode for TStringCrypt2000X
                        Freeware

  Source File Name   :  X2000Base64.PAS
  Author             :  ????
  Compiler           :  Delphi 5.0 Professional
**************************************************************** }
unit X2000Base64;

interface

uses Windows, Sysutils;

function  Base64Encode(const s: string): string;
function  Base64Decode(const s: string): string;

implementation

const
    Base64: string = '23456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz~#%&*+-';
    UnBase64: array[0..255] of byte =
       (128,128,128,128,128,128,128,128, 128,128,128,128,128,128,128,128, //0-15
        128,128,128,128,128,128,128,128, 128,128,128,128,128,128,128,128,  //16-31
        128,128,128, 58,128, 59, 60,128, 128,128, 61, 62,128, 63,128,128,  //32-47
        128,128,  0,  1,  2,  3,  4,  5,   6,  7,128,128,128,128,128,128,  //48-63
        128,  8,  9, 10, 11, 12, 13, 14,  15,128, 16, 17, 18, 19, 20,128,  //64-79
         21, 22, 23, 24, 25, 26, 27, 28,  29, 30, 31,128,128,128,128,128,  //80-95
        128, 32, 33, 34, 35, 36, 37, 38,  39, 40, 41, 42,128, 43, 44, 45,  //96-111
         46, 47, 48, 49, 50, 51, 52, 53,  54, 55, 56,128,128,128, 57,128,  //112-127
        128,128,128,128,128,128,128,128, 128,128,128,128,128,128,128,128,  //128-143
        128,128,128,128,128,128,128,128, 128,128,128,128,128,128,128,128,  //144-159
        128,128,128,128,128,128,128,128, 128,128,128,128,128,128,128,128,  //160-175
        128,128,128,128,128,128,128,128, 128,128,128,128,128,128,128,128,  //176-191
        128,128,128,128,128,128,128,128, 128,128,128,128,128,128,128,128,  //192-207
        128,128,128,128,128,128,128,128, 128,128,128,128,128,128,128,128,  //208-223
        128,128,128,128,128,128,128,128, 128,128,128,128,128,128,128,128,  //224-239
        128,128,128,128,128,128,128,128, 128,128,128,128,128,128,128,128);  //240-255

function Base64Encode(const s: string): string;
var s4: string;
    i, j, k: integer;
    b: byte;
    begin
    Result := '';
    SetLength(s4, 4);
    b := 0;
    i := 1;
    j := 2;
    k := 2;
    while i <= length(s) do
        begin
        b := b or ((ord(s[i]) and $C0) shr k);
        inc(k,2);
        s4[j] := Base64[(ord(s[i]) and $3F)+1];
        inc(i);
        inc(j);
        if j > 4 then
            begin
            s4[1] := Base64[b+1];
            b := 0;
            j := 2;
            k := 2;
            Result := Result + s4;
            end;
        end;
    if j <> 2 then
        begin // Flush data in s4.
        s4[j] := '.';
        s4[1] := Base64[b+1];
        Result := Result + s4;
        SetLength(Result, Length(Result) - (4 - j));
        end
    else
        Result := Result + '.';
    end;

function Base64Decode(const s: string): string;
var i, j, k: integer;
    b: byte;
    begin
    Result := '';
    b := 0;
    i := 1;
    j := 0;
    while (i <= length(s)) and (s[i] <> '.') do
        begin
        if j = 0 then
            begin
            b := UnBase64[ord(s[i])];
            k := 2;
            end
        else
            begin
            Result := Result + chr(UnBase64[ord(s[i])] or ((b shl k) and $C0));
            inc(k,2);
            end;
        inc(j);
        j := j and 3;
        inc(i);
        end;
    end;

end.

