{ ****************************************************************** }
{                                                                    }
{   VCL component TFireCracker                                       }
{                                                                    }
{   Component to Control the FireCracker Module for X10 Devices      }
{                                                                    }
{   Code generated by Component Create for Delphi                    }
{                                                                    }
{   Generated from source file c:\borland\components\cc\x10unit.cd   }
{   on 20 Sept 1999 at 2:07                                          }
{                                                                    }
{   Copyright  1999 by Lee Christensen                              }
{                                                                    }
{ ****************************************************************** }

unit X10Unit;

interface

uses WinTypes, WinProcs, Messages, SysUtils, Classes, Controls,
     Windows;

{ Unit-wide declarations }
 type
  TPortType = (Com1,Com2,Com3,Com4,Com5,Com6,Com7,Com8);
  TCommandType = (ctOn,ctOff,ctBright,ctDim);

 var
   Alpha    : Array [1..16] of String;
   x10alpha : array [1..16] of byte;
   x10on    : array [1..8] of string;
   x10off   : array [1..8] of string;
   x10dim   : array [1..2]  of string;

type
  TFireCracker = class(TComponent)
    private
      { Private fields of TFireCracker }
        { Storage for property Command }
        FCommand : TCommandType;
        { Storage for property Connected }
        FConnected : Boolean;
        { Storage for property Port }
        FPort : TPortType;
        { Storage for property ReadBufSize }
        FReadBufSize : DWORD;
        { Storage for property WriteBufSize }
        FWriteBufSize : DWORD;
        { Storage for property X10Address }
        FX10Address : String;
        { Handle to the comm port }
        FHandle : THandle;
        { String to send after the command string }
        Footer : String;
        { Header to send before the command string }
        Header : String;

      { Private methods of TFireCracker }
        { Method to set variable and property values and create objects }
        procedure AutoInitialize;
        { Method to free any objects created by AutoInitialize }
        procedure AutoDestroy;
        { Read method for property Command }
        function GetCommand : TCommandType;
        { Write method for property Command }
        procedure SetCommand(Value : TCommandType);
        { Read method for property Connected }
        function GetConnected : Boolean;
        { Read method for property Port }
        function GetPort : TPortType;
        { Write method for property Port }
        procedure SetPort(Value : TPortType);
        { Read method for property X10Address }
        function GetX10Address : String;
        { Write method for property X10Address }
        procedure SetX10Address(Value : String);
        { Converts number to binary string }
        function ByteToBin(t:byte): string;
        { Gets the name of the comm port as a string }
        function CommString : String;
        { Gets the handle to the comm port }
        procedure CreateHandle;
        { releases the handle to the comm port }
        procedure DestroyHandle;
        { Sets the Parameters for the comm port }
        procedure SetDCB;
        { Initializes the port }
        procedure SetupComPort;
        {returns the string of the comm port}
        function  ComString: String;
        {puts the firecracker in a standy mode}
        procedure Standby;
    protected
      { Protected fields of TFireCracker }
        { Selected Comm Port }
        property ReadBufSize : DWORD
             read FReadBufSize write FReadBufSize
             default 4096;
        property WriteBufSize : DWORD
             read FWriteBufSize write FWriteBufSize
             default 4096;

      { Protected methods of TFireCracker }
        procedure Loaded; override;
        { Sends the commands to the FireCracker Module }
        function SendCommand(Addr : String;Command : TCommandType) : Boolean;
        procedure SetDTR(State: Boolean);
        procedure SetRTS(State: Boolean);

    public
      { Public fields and properties of TFireCracker }

      { Public methods of TFireCracker }
        constructor Create(AOwner: TComponent); override;
        destructor Destroy; override;
        { Executes the SendCommand Function }
        function Execute : Boolean;
        function LastErr :String;
        { OPens a connection to a comm port }
        procedure Open;
        procedure SetComm;
        procedure Close;
    published
      { Published properties of TFireCracker }
        { command to send to the FireCracker }
        property Command : TCommandType
             read GetCommand write SetCommand
             default ctOff;
        property Connected : Boolean
             read GetConnected write FConnected
             default False;
        { Comm Port Description }
        property Port : TPortType read GetPort write SetPort default Com1;
        { X10 Module Address to send the commands }
        property X10Address : String read GetX10Address write SetX10Address;

  end;

  EFireCracker = class(Exception);

procedure Register;

implementation

procedure Register;
begin
     { Register TFireCracker with X10 as its
       default page on the Delphi component palette }
     RegisterComponents('X10', [TFireCracker]);
end;

{ Method to set variable and property values and create objects }
procedure TFireCracker.AutoInitialize;
begin
     Footer := '10101101';
     Header := '1101010110101010';
     FCommand := ctOff;
     FConnected := False;
     FPort := Com1;
     FReadBufSize := 4096;
     FWriteBufSize := 4096;
     FX10Address := 'A1';

     Alpha [1]  := 'A';
     Alpha [2]  := 'B';
     Alpha [3]  := 'C';
     Alpha [4]  := 'D';
     Alpha [5]  := 'E';
     Alpha [6]  := 'F';
     Alpha [7]  := 'G';
     Alpha [8]  := 'H';
     Alpha [9]  := 'I';
     Alpha [10] := 'J';
     Alpha [11] := 'K';
     Alpha [12] := 'L';
     Alpha [13] := 'M';
     Alpha [14] := 'N';
     Alpha [15] := 'O';
     Alpha [16] := 'P';

     x10alpha [1] :=  96;   //A
     x10alpha [2] := 112;   //B
     x10alpha [3] :=  64;   //C
     x10alpha [4] :=  72;   //D
     x10alpha [5] := 128;   //E
     x10alpha [6] := 136;   //F
     x10alpha [7] := 160;   //G
     x10alpha [8] :=  96;   //H
     x10alpha [9] := 224;   //I
     x10alpha[10] := 240;   //J
     x10alpha[11] := 192;   //K
     x10alpha[12] := 208;   //L
     x10alpha[13] :=   0;   //M
     x10alpha[14] :=  16;   //N
     x10alpha[15] :=  32;   //O
     x10alpha[16] :=  48;   //P

     //Turn on commands...
     x10on [1]  := '00000000';
     x10on [2]  := '00010000';
     x10on [3]  := '00001000';
     x10on [4]  := '00011000';
     x10on [5]  := '01000000';
     x10on [6]  := '01010000';
     x10on [7]  := '01001000';
     x10on [8]  := '01011000';

     //Turn off commands...
     x10off [1]  := '00100000';
     x10off [2]  := '00110000';
     x10off [3]  := '00101000';
     x10off [4]  := '00111000';
     x10off [5]  := '01100000';
     x10off [6]  := '01110000';
     x10off [7]  := '01101000';
     x10off [8]  := '01111000';

     //Dim
     x10dim[1]  := '10001000';  //Brighten
     x10dim[2]  := '10011000';  //Dim

end; { of AutoInitialize }

{ Method to free any objects created by AutoInitialize }
procedure TFireCracker.AutoDestroy;
begin
     { No objects from AutoInitialize to free }
end; { of AutoDestroy }

{ Read method for property Command }
function TFireCracker.GetCommand : TCommandType;
begin
   Result := FCommand
end;

{ Write method for property Command }
procedure TFireCracker.SetCommand(Value : TCommandType);
begin
     { Update the component based on argument S
       and new property setting in Value }
  Case Value of
    ctOn     : FCommand := ctOn;
    ctOff    : FCommand := ctOff;
    ctBright : FCommand := ctBright;
    ctDim    : FCommand := ctDim;
  end;
end;

{ Read method for property Connected }
function TFireCracker.GetConnected : Boolean;
begin
     Result := FConnected;
end;

{ Read method for property Port }
function TFireCracker.GetPort : TPortType;
begin
     Result := FPort;
end;

{ Write method for property Port }
procedure TFireCracker.SetPort(Value : TPortType);
begin
     FPort := Value;
end;

{ Read method for property X10Address }
function TFireCracker.GetX10Address : String;
begin
     Result := FX10Address;
end;

{ Write method for property X10Address }
procedure TFireCracker.SetX10Address(Value : String);
begin
     FX10Address := Value;
end;

{ Converts number to binary string }
function TFireCracker.ByteToBin(t:byte): string;
var
  hold : string;
begin
  hold := '';

  if t >= 128 then begin
     hold := '1';
     t :=  t - 128;
  end
  else hold := '0';

  if t >= 64  then begin
    hold := Hold +'1';
    t :=  t - 64;
  end
  else hold := hold + '0';

  if t >= 32  then begin
    hold := Hold +'1';
    t :=  t - 32;
  end
  else hold := hold +'0';

  if t >= 16  then begin
    hold := Hold +'1';
    t :=  t - 16;
  end
  else hold := hold + '0';

  if t >= 8   then begin
    hold := Hold +'1';
    t :=  t - 8;
  end
  else hold := hold + '0';

  if t >= 4   then begin
    hold := Hold +'1';
    t :=  t - 4;
  end
  else hold := hold + '0';

  if t >= 2   then begin
    hold := Hold +'1';
    t :=  t - 2;
  end
  else hold := hold + '0';

  if t >= 1   then begin
    hold := Hold +'1';
    t :=  t - 1;
  end
  else hold := hold + '0';

  result := hold;
end;

{ Gets the name of the comm port as a string }
function TFireCracker.CommString : String;
begin
  case FPort of
    COM1: Result := 'COM1';
    COM2: Result := 'COM2';
    COM3: Result := 'COM3';
    COM4: Result := 'COM4';
    COM5: Result := 'COM5';
    COM6: Result := 'COM6';
    COM7: Result := 'COM7';
    COM8: Result := 'COM8';
  end;
end;

constructor TFireCracker.Create(AOwner: TComponent);
begin
     { Call the Create method of the parent class }
     inherited Create(AOwner);

     { AutoInitialize sets the initial values of variables and      }
     { properties; also, it creates objects for properties of       }
     { standard Delphi object types (e.g., TFont, TTimer,           }
     { TPicture) and for any variables marked as objects.           }
     { AutoInitialize method is generated by Component Create.      }
     AutoInitialize;

     { Code to perform other tasks when the component is created }

end;

{ Gets the handle to the comm port }
procedure TFireCracker.CreateHandle;
begin
  FHandle := CreateFile(PChar(ComString),GENERIC_READ or GENERIC_WRITE,
    0,nil,OPEN_EXISTING,FILE_FLAG_OVERLAPPED,0);

  if FHandle = INVALID_HANDLE_VALUE then
    raise EFireCracker.Create('Unable to open com port: ' + LastErr);
end;

destructor TFireCracker.Destroy;
begin
     { AutoDestroy, which is generated by Component Create, frees any   }
     { objects created by AutoInitialize.                               }
     AutoDestroy;

     { Here, free any other dynamic objects that the component methods  }
     { created but have not yet freed.  Also perform any other clean-up }
     { operations needed before the component is destroyed.             }

     { Last, free the component by calling the Destroy method of the    }
     { parent class.                                                    }
     inherited Destroy;
end;

{ releases the handle to the comm port }
procedure TFireCracker.DestroyHandle;
begin
  if FHandle <> INVALID_HANDLE_VALUE then
    CloseHandle(FHandle);
end;

{ Executes the SendCommand Function }
function TFireCracker.Execute : Boolean;
begin
  Result := SendCommand(FX10Address,FCommand);
end;

function TFireCracker.LastErr :String;
begin
  Result := IntToStr(GetLastError);
end;

procedure TFireCracker.Loaded;
begin
     inherited Loaded;

     { Perform any component setup that depends on the property
       values having been set }

end;

{ OPens a connection to a comm port }
procedure TFireCracker.Open;
begin
  Close;
  CreateHandle;
  FConnected := True;
  try
    SetupComPort;
  except
    DestroyHandle;
    FConnected := False;
    raise;
  end;
end;

{ Sends the commands to the FireCracker Module }
function TFireCracker.SendCommand(Addr : String;Command : TCommandType) : Boolean;
var
  I,J     : Integer;
  Ch      : String;
  hold    : byte;
  number  : integer;
  output  : string;
  AddrLtr : String;
  Cmd     : Integer;
begin
  Case Command of
    ctOff    : Cmd := 0;
    ctOn     : Cmd := 1;
    ctBright : Cmd := 2;
    ctDim    : Cmd := 3;
  end;

  //get the array number for the letter entered
  AddrLtr := Copy(Addr,1,1);
  for I := 1 to 16 do begin
    if UpperCase(AddrLtr) = Alpha[I] then begin
      J := I;
      break;
    end;
  end;

  //get the binary value assigned for the letter entered
  Hold := x10Alpha[J];

  number := StrToInt(Copy(Addr,2,Length(Addr)));

  output := '';
  output := header;

  if (number > 8) and (Cmd < 2) then begin
    hold := hold +4;
    number := number - 8;
  end;

   //off
  if Cmd = 0 then begin
    output := output + bytetobin(hold);
    output := output + x10off[number];
  end

   //On...
  else if Cmd = 1 then begin
    output := output + bytetobin(hold);
    output := output + x10on[number];
  end

   //Dim/Brighten (2 = Brighten, 3 = Dim)
  else if Cmd > 1 then begin
    if Cmd > 3 then exit;
    output := output + bytetobin(hold);
    output := output + x10dim[Cmd-1];
  end;

  Output := Output + Footer;
  StandBy;

  for I := 1 to Length(Output) do begin
    Ch := Copy(Output,I,1);

    if (Trim(Ch) = '1') then begin
      SetDTR(False);
      Sleep(1);
      SetDTR(True);
    end;

    if (Trim(Ch) = '0') then begin
      SetRTS(False);
      Sleep(1);
      SetRTS(True);
    end;

  end;//for loop

end;

procedure TFireCracker.SetComm;
begin
  if FConnected then begin
    if not SetupComm(FHandle, FReadBufSize, FWriteBufSize) then
      raise EFireCracker.Create('Unable to set com state: ' + LastErr);
  end;
end;

{ Sets the Parameters for the comm port }
procedure TFireCracker.SetDCB;
var
  DCB: TDCB;
  Temp: DWORD;
begin
  if FConnected then begin
    FillChar(DCB, SizeOf(DCB), 0);

    DCB.DCBlength := SizeOf(DCB);
    DCB.XonChar := #17;
    DCB.XoffChar := #19;
    DCB.XonLim := 4096 div 4;
    DCB.XoffLim := DCB.XonLim;
    DCB.EvtChar := #9;

    DCB.Flags := DCB.Flags or $00000001;
    DCB.Flags := DCB.Flags or $00000004;
    Temp := 0;
    Temp := DTR_CONTROL_ENABLE;
    DCB.Flags := DCB.Flags or Integer($00000030 and (Temp shl 4));
    Temp := 0;
    Temp := RTS_CONTROL_ENABLE;
    DCB.Flags := DCB.Flags or Integer($00003000 and (Temp shl 12));
    DCB.Flags := DCB.Flags or $00000100;
    DCB.Parity := NOPARITY;
    DCB.StopBits := ONESTOPBIT;
    DCB.BaudRate := CBR_9600;
    DCB.ByteSize := 8;

    if not SetCommState(FHandle, DCB) then
      raise EFireCracker.Create('Unable to set com state: ' + LastErr);
  end;
end;

{ Initializes the port }
procedure TFireCracker.SetupComPort;
begin
  SetComm;
  SetDCB;
end;


function TFireCracker.ComString: String;
begin
  case FPort of
    COM1: Result := 'COM1';
    COM2: Result := 'COM2';
    COM3: Result := 'COM3';
    COM4: Result := 'COM4';
    COM5: Result := 'COM5';
    COM6: Result := 'COM6';
    COM7: Result := 'COM7';
    COM8: Result := 'COM8';
  end;
end;

procedure TFireCracker.Standby;
begin
  SetDtr(True);
  SetRTS(True);
end;

procedure TFireCracker.SetDTR(State: Boolean);
var
  Act: DWORD;
begin
  if State then
    Act := Windows.SETDTR
  else
    Act := Windows.CLRDTR;

  if not EscapeCommFunction(FHandle, Act) then
    raise EFireCracker.Create('Unable to set signal: ' + LastErr);
end;

procedure TFireCracker.SetRTS(State: Boolean);
var
  Act: DWORD;
begin
  if State then
    Act := Windows.SETRTS
  else
    Act := Windows.CLRRTS;

  if not EscapeCommFunction(FHandle, Act) then
    raise EFireCracker.Create('Unable to set signal: ' + LastErr);
end;

procedure TFireCracker.Close;
begin
  DestroyHandle;
  FConnected := False;
end;

end.
