unit WizardNotebook;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls;

// Events
type TbtnBackClick = procedure (Sender: TObject) of object;
type TbtnNextClick = procedure (Sender: TObject; const FinalState: boolean) of object;

type
  TWizardNotebook = class(TNotebook)
  private
    { Private declarations }
    FbtnBackClick: TbtnBackClick;
    FbtnNextClick: TbtnNextClick;
    FbtnNext,
    FbtnBack: TButton;
    FlblHeader,
    FlblInfo: TLabel;
    FHeaderCaption,
    FInfoCaption: TStrings;

    procedure PHeaderCaption(Value: TStrings);
    procedure PInfoCaption(Value: TStrings);
    procedure PbtnBack(const Value: TButton);
    procedure PbtnNext(const Value: TButton);
    procedure PlblHeader(const Value: TLabel);
    procedure PlblInfo(const Value: TLabel);
  protected
    { Protected declarations }
    procedure btnBackClick(Sender: TObject);
    procedure btnNextClick(Sender: TObject);
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    //procedure MoveBack;
    //procedure MoveForward;
  published
    { Published declarations }
    property btnNext: TButton
      read FbtnNext
      write PbtnNext;
    property btnBack: TButton
      read FbtnBack
      write PbtnBack;
    property lblHeader: TLabel
      read FlblHeader
      write PlblHeader;
    property lblInfo: TLabel
      read FlblInfo
      write PlblInfo;
    property HeaderCaption: TStrings
      read FHeaderCaption
      write PHeaderCaption;
    property InfoCaption: TStrings
      read FInfoCaption
      write PInfoCaption;

    // Events
    property OnButtonBackClick: TbtnBackClick
      read FbtnBackClick
      write FbtnBackClick;
    property OnButtonNextClick: TbtnNextClick
      read FbtnNextClick
      write FbtnNextClick;
  end;

procedure Register;

implementation

constructor TWizardNotebook.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  try
    FHeaderCaption := TStringList.Create;
    FInfoCaption := TStringList.Create;
  except
  end;

  // does not go to first page automatically
  
end;

destructor TWizardNotebook.Destroy;
begin
  FHeaderCaption.Free;
  FInfoCaption.Free;
  inherited Destroy;
end;

procedure TWizardNotebook.PbtnNext(const Value: TButton);
begin
  FbtnNext := Value;
  if not (csDesigning in ComponentState) then
  begin
    if FbtnNext <> nil then FbtnNext.OnClick := btnNextClick;
    if (Pages.Count = 1) and (btnNext <> nil) then btnNext.Caption := '&Finish';
  end;
end;

procedure TWizardNotebook.PbtnBack(const Value: TButton);
begin
  FbtnBack := Value;
  if not (csDesigning in ComponentState) then
  begin
    if FbtnBack <> nil then FbtnBack.OnClick := btnBackClick;
    if FbtnBack <> nil then FbtnBack.Visible := false;
  end;
end;

procedure TWizardNotebook.PlblHeader(const Value: TLabel);
begin
  FlblHeader := Value;
  if not (csDesigning in ComponentState) then
    if (FlblHeader <> nil) and (HeaderCaption.Count > 0) then FlblHeader.Caption := HeaderCaption.Strings[PageIndex];
end;

procedure TWizardNotebook.PlblInfo(const Value: TLabel);
begin
  FlblInfo := Value;
  if not (csDesigning in ComponentState) then
    if (FlblInfo <> nil) and (InfoCaption.Count > 0) then FlblInfo.Caption := InfoCaption.Strings[PageIndex];
end;

procedure TWizardNotebook.PHeaderCaption(Value: TStrings);
begin
  FHeaderCaption.Assign(Value);
end;

procedure TWizardNotebook.PInfoCaption(Value: TStrings);
begin
  FInfoCaption.Assign(Value);
end;

{-------------------------------------------------------------------------------
EVENTS
-------------------------------------------------------------------------------}
procedure TWizardNotebook.btnBackClick(Sender: TObject);
var OnFirstPage: boolean;
begin
  OnFirstPage := (PageIndex = 0);

  // only one page (Do NOT allow)
  if (Pages.Count = 1) Or (OnFirstPage) then
  begin
    if (btnBack <> nil) then btnBack.Visible := false;
  end
  // TWO .. N pages and not OnFirstPage  (Allow Move)
  else if not (OnFirstPage) then
  begin
    PageIndex := PageIndex - 1;
    if (lblHeader <> nil) and (HeaderCaption.Count >= (PageIndex - 1)) then lblHeader.Caption := HeaderCaption.Strings[PageIndex];
    if (lblInfo <> nil) and (InfoCaption.Count >= (PageIndex - 1)) then lblInfo.Caption := InfoCaption.Strings[PageIndex];
    if (btnNext <> nil) then btnNext.Caption := '&Next >>';
  end;

  // Check to see if on First page after move
  OnFirstPage := (PageIndex = 0);
  if (OnFirstPage) And (Pages.Count > 1) then
    if (btnBack <> nil) then btnBack.Visible := false;

  FbtnBackClick(Sender);
end;

procedure TWizardNotebook.btnNextClick(Sender: TObject);
var FinalState,
    OnLastPage: boolean;
begin
  OnLastPage := Pages.Count = (PageIndex + 1);

  // only one page (Do NOT allow)
  if (Pages.Count = 1) Or (OnLastPage) then
  begin
    FinalState := true;
  end
  // TWO .. N pages and not OnLastPage  (Allow Move)
  else if not (OnLastPage) then
  begin
    PageIndex := PageIndex + 1;
    if (lblHeader <> nil) and (HeaderCaption.Count >= (PageIndex + 1)) then lblHeader.Caption := HeaderCaption.Strings[PageIndex];
    if (lblInfo <> nil) and (InfoCaption.Count >= (PageIndex + 1)) then lblInfo.Caption := InfoCaption.Strings[PageIndex];
    if (btnBack <> nil) then btnBack.Visible := true;
  end;

  // Check to see if on Last page after move
  OnLastPage := Pages.Count = (PageIndex + 1);
  if (OnLastPage) And (btnNext <> nil) then btnNext.Caption := '&Finish';

  FbtnNextClick(Sender, FinalState);
end;

{-------------------------------------------------------------------------------
REGISTER
-------------------------------------------------------------------------------}
procedure Register;
begin
  RegisterComponents('Custom', [TWizardNotebook]);
end;

end.
