{
  25.01.2001
  [*] Correct painting label when Transparent=True 
}

unit VVMLabel;

interface

uses
  Windows, Messages, SysUtils,
  Classes, Graphics, Controls,
  Forms, Dialogs,
  StdCtrls;

type
  TVVMColorLabel = class(TLabel)
  private
    { Private declarations }
  protected
    { Protected declarations }
  public
    constructor Create(AOwner: TComponent); override;
    procedure Paint; override;
    { Public declarations }
  published
    { Published declarations }
  end;

Procedure DrawStringEx(ACanvas : TCanvas; ARect: TRect;ABrush: TColor;AFont: TFont;
                       const S: string; bTransp: Boolean=False);
procedure Register;

implementation

{$R VVMLbl.dcr}

procedure Register;
begin
  RegisterComponents('VVMPage', [TVVMColorLabel]);
end;

Procedure DrawStringEx(ACanvas : TCanvas; ARect: TRect;ABrush: TColor;AFont: TFont;
                       const S: string; bTransp: Boolean=False);
var oldColor: TColor;
    oldStyle: TFontStyles;
    I: Integer;
    sCmd,sAux: String;
    rctNow: TRect;
Procedure SetBold(b: Boolean);
begin
  If B then ACanvas.Font.Style:=ACanvas.Font.Style+[fsBold]
    else ACanvas.Font.Style:=ACanvas.Font.Style-[fsBold];
end;
Procedure SetItalic(b: Boolean);
begin
  If B then ACanvas.Font.Style:=ACanvas.Font.Style+[fsItalic]
    else ACanvas.Font.Style:=ACanvas.Font.Style-[fsItalic];
end;
Procedure SetUnderline(b: Boolean);
begin
  If B then ACanvas.Font.Style:=ACanvas.Font.Style+[fsUnderline]
    else ACanvas.Font.Style:=ACanvas.Font.Style-[fsUnderline];
end;
Procedure DrawStr(S: String);
var iW,iRW: Integer;
    sAux1: String;
begin
  while S<>'' do begin
    If rctNow.Top>ARect.Bottom then Exit;
    iW:=ACanvas.TextWidth(S);
    If iW<=rctNow.Right-rctNow.Left then begin
      ACanvas.TextOut(rctNow.Left, rctNow.Top, S);
      rctNow.Left:=rctNow.Left+iW;
      S:='';
    end
    else begin
      sAux1:='';
      iRw:=rctNow.Right-rctNow.Left;
      While ACanvas.TextWidth(sAux1)<=iRW do begin
        sAux1:=sAux1+S[length(sAux1)+1];
      end;
      Delete(sAux1,Length(sAux1),1);
      ACanvas.TextOut(rctNow.Left, rctNow.Top, sAux1);
      Delete(S,1,Length(sAux1));
      rctNow.Left:=ARect.Left;
      rctNow.Right:=ARect.Right;
      rctNow.Top:=rctNow.Bottom;
      rctNow.Bottom:=rctNow.Top+ACanvas.TextHeight('Wg');
    end;
  end;
end;
begin
  ACanvas.Font:=AFont;
  ACanvas.Brush.Color:=ABrush;
  If bTransp then ACanvas.Brush.Style:=bsClear
    else ACanvas.Brush.Style:=bsSolid;
  ACanvas.FillRect(ARect);
  I:=1;
  oldColor:=ACanvas.Font.Color;
  oldStyle:=ACanvas.Font.Style;
  rctNow:=rect(Arect.Left,ARect.Top,
          ARect.Right,ARect.Top+ACanvas.TextHeight('Wg'));
  While I<=Length(S) do begin
    If S[I]='<' then begin
      sCmd:='';
      Inc(I);
      While (I<=Length(S)) and (S[I]<>'>') do begin
        sCmd:=sCmd+UpCase(S[I]);
        Inc(I);
      end;
      Inc(I);
      If sCmd='<' then DrawStr('<')
        else begin
          If sCmd='/' then begin
            rctNow.Left:=ARect.Left;
            rctNow.Right:=ARect.Right;
            rctNow.Top:=rctNow.Bottom;
            rctNow.Bottom:=rctNow.Top+ACanvas.TextHeight('Wg');
          end
          else If sCmd='B' then SetBold(True)
          else If sCmd='/B' then SetBold(False)
          else If sCmd='I' then SetItalic(True)
          else If sCmd='/I' then SetItalic(False)
          else If sCmd='U' then SetUnderline(True)
          else If sCmd='/U' then SetUnderline(False)
          else If sCmd='RU' then ACanvas.Font.Charset:=RUSSIAN_CHARSET
          else If sCmd='EU' then ACanvas.Font.Charset:=ANSI_CHARSET
          else If Pos('C:',sCmd)=1 then begin
            Delete(sCmd,1,2);
            try
              If Copy(sCmd,1,1)='$' then ACanvas.Font.Color:=StringToColor(sCmd)
                else ACanvas.Font.Color:=StringToColor('cl'+sCmd)
            except
            end;
          end;
        end;
    end
    else begin
      sAux:='';
      While (I<=Length(S)) and (S[I]<>'<') do begin
        sAux:=sAux+S[I];
        Inc(I);
      end;
      DrawStr(sAux);
    end;
  end;
  ACanvas.Font.Color:=oldColor;
  ACanvas.Font.Style:=oldStyle;
end;

{ TVVMLabel }

constructor TVVMColorLabel.Create(AOwner: TComponent);
begin
  inherited;
  AutoSize:=False;
end;

procedure TVVMColorLabel.Paint;
begin
  DrawStringEx(Self.Canvas,Self.ClientRect,Self.Color,
               Self.Font,Caption,Self.Transparent);
end;

end.
