unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DbChk, StdCtrls, DBTables;

type
  TForm1 = class(TForm)
    DBChk: TDbCheck;
    Button1: TButton;
    Label1: TLabel;
    lb_prc: TLabel;
    procedure DBChkBeforeCheck(Sender: TObject; ChkMessage: TChkMessage;
      TblName: String);
    procedure Button1Click(Sender: TObject);
    procedure DBChkFoundDiff(Sender: TObject; ChkMessage: TChkMessage;
      TblName: String; var Correct: Boolean);
    procedure DBChkError(Sender: TObject; Message: EDBEngineError);
    procedure DBChkModifyTable(Sender: TObject; TblName: String);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.DBChkBeforeCheck(Sender: TObject; ChkMessage: TChkMessage;
  TblName: String);
begin
  case ChkMessage of
    CHK_NONE: lb_prc.Caption := Format('Checking table %s...',[TblName]);
    CHK_AUTOINCREPAIR: lb_prc.Caption := Format('Correcting autoincrement error %s...',[TblName]);
  end;
  lb_prc.Refresh;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  MessageBox(Handle,'Now the component will change field and index structure of'+
             ' employee.db','Demo',MB_OK or MB_ICONINFORMATION);
  DBChk.CorrectPath:=ExtractFilePath(Application.ExeName);
  DBChk.CheckDatabase;
  MessageBox(Handle,'That is the end of Demo.'+#13#10+
             'You can close program and check structure of table.'#13#10+
             'Also you can try delete table employee.db and click button again.',
             'Demo',MB_OK or MB_ICONINFORMATION);
end;

procedure TForm1.DBChkFoundDiff(Sender: TObject; ChkMessage: TChkMessage;
  TblName: String; var Correct: Boolean);
begin
  case ChkMessage of
    CHK_TABLECREATE:
     Correct := MessageBox(Handle, PChar(Format('Table "%s" not found. Create?',
                           [TblName])), 'Warning', MB_YESNOCANCEL or MB_ICONWARNING) = ID_YES;
    CHK_TABLEMODIFY:
     Correct := MessageBox(Handle, PChar(Format('Table "%s" has a different structure from '+
                           'standard. Modify structure?',
                           [TblName])), 'Warning', MB_YESNOCANCEL or MB_ICONWARNING) = ID_YES;
  end;
end;

procedure TForm1.DBChkError(Sender: TObject; Message: EDBEngineError);
begin
  MessageBox(Handle, PChar(Format('[Error] %s', [Message.Message])), 'Error', MB_OK or MB_ICONERROR);
end;

procedure TForm1.DBChkModifyTable(Sender: TObject; TblName: String);
begin
  MessageBox(Handle, PChar(Format('Table %s has been modifying', [TblName])),
             'Information', MB_OK or MB_ICONINFORMATION);
end;

end.
