{*******************************************************}
{                                                       }
{                Database Utilites                      }
{                                                       }
{      Copyright (c) 1999-2000 Field of Miracles        }
{            e-mail: deleon@mailru.com                  }
{                                                       }
{*******************************************************}
unit Bde32;

interface

uses
 BDE,       SysUtils,   Classes,   Windows,
 DbTables,  Db;

const
 ID_PARAM_SYSTEMINIT          = 0;
 ID_PARAM_SYSTEMFORMATSDATE   = 1;
 ID_PARAM_SYSTEMFORMATSTIME   = 2;
 ID_PARAM_SYSTEMFORMATSNUMBER = 3;

 PATH_PARADOX_INIT = '\DRIVERS\PARADOX\INIT';

 BDE_LANGRUSPARADOX = szCFGSYSLANGDRV + '=ancyrr';
 BDE_LANGRUSDBASE   = szCFGSYSLANGDRV + '=db866ru0';
 BDE_LANGRUSFOXPRO  = BDE_LANGRUSDBASE;
 
type
  PFieldDescList = ^TFieldDescList;
  TFieldDescList = array[0..1023] of FLDDesc;

  PIndexDescList = ^TIndexDescList;
  TIndexDescList = array[0..63] of IDXDesc;

  pCROpTypeList = ^TCROpTypeList;
  TCROpTypeList = array[0..255] of CROpType;

{Returns path with slash at the end; e.g:
  GetNormalPath('C:\Data')='C:\Data\'
  GetNormalPath('C:\Data\')='C:\Data\'
  GetNormalPath('C')='C:\'
 }
function  GetNormalPath(bPath: PChar): DBIPATH;
{Returns path of alias}
function  GetAliasPath(DbName: PChar): DBIPATH;
{Returns Paradox constant NET DIR}
function  GetNetDir: string;
function  IsStandardAlias(DbName: PChar): boolean;
function  AliasExists(DbName: PChar): boolean;
function  CheckAlias(DbName, DbPath, DbType: PChar): boolean;
function  DeleteAlias(DbName: PChar): boolean;
function  GetDatabasePath(hDB: hDbiDb): DBIPATH;
function  IsBusy(DbName, TblName, TblType: PChar): boolean;
{Returns full path of table that used by component TTable Tbl}
function  GetTblFileName(Tbl: TTable): DBIPATH;
function  CheckTable(FileName: PChar): DbiResult;
function  SQLCommand(DbName, Command: PChar): DbiResult;
function  CheckOpenTable(DbName, TblName, TblType: PChar; OpenExcl: boolean): DbiResult;
function  DeleteIndexes(DbName, TblName: PChar): boolean;
{Changes language driver of paradox or DBase table with converting or no}
procedure ChangeLangDriver(Tbl: TTable; LDName: PChar; Translate: boolean);

function  PointerToDate(pBuf: Pointer; var zDate: TDateTime): boolean;
function  PointerToTime(pBuf: Pointer; var zTime: TDateTime): boolean;
function  PointerToCurr(pBuf: Pointer; var zCurr: Currency): boolean;
function  PointerToStr(pBuf: Pointer; var zStr: string): boolean;
function  PointerToSmall(pBuf: Pointer; var zSmall: SmallInt): boolean;
function  PointerToInt(pBuf: Pointer; var zInt: Integer): boolean;
function  PointerToWord(pBuf: Pointer; var zWord: Word): boolean;

procedure DateToPointer(zDate: TDateTime; pBuf: Pointer);
procedure TimeToPointer(zTime: TDateTime; pBuf: Pointer);
procedure CurrToPointer(zCurr: Currency; pBuf: Pointer);
procedure StrToPointer(zStr: string; pBuf: Pointer);
procedure SmallToPointer(zSmall: SmallInt; pBuf: Pointer);
procedure IntToPointer(zInt: Integer; pBuf: Pointer);

implementation

function GetNormalPath(bPath: PChar): DBIPATH;
begin
  StrCopy(Result, bPath);
  if ( StrPas(bPath) <> '')and not
     ( bPath[StrLen(bPath)-1] in [':', '\'] ) then
  begin
    if ( StrLen(bPath) = 1 )and
       ( UpCase(bPath[1]) in ['A'..'Z'] )then
     StrCopy(@Result, StrCat(bPath, PChar(':\')))
    else
     StrCopy(@Result, StrCat(bPath, '\'));
  end;
end;

function GetAliasPath(DbName: PChar): DBIPATH;
var DbRec: DbDesc;
begin
 if DbiGetDataBaseDesc(DbName, @DbRec) = DBIERR_NONE then
  Result := GetNormalPath( DbRec.szPhyName )
 else
  FillChar(Result, SizeOf(DBIPATH), #0);
end;

function  GetNetDir: string;
var
 List: TStringList;
begin
 Result := '';
 List := TStringList.Create;
 try
  SESSION.GetConfigParams(PATH_PARADOX_INIT, '', List);
  Result := List.Values['NET DIR'];
 finally
  List.Free;
 end;
end;

function  IsStandardAlias(DbName: PChar): boolean;
var
 Desc: DBDesc;
begin
 Check(DbiGetDatabaseDesc(DbName, @Desc));
 Result := StrIComp(Desc.szDbType, 'STANDARD') = 0;
end;

function AliasExists(DbName: PChar): boolean;
var
 E: DbiResult;
 DbRec: DbDesc;
 IsInit: boolean;
begin
 IsInit := True;
 Result := False;
 while True do
 begin
  E := DbiGetDataBaseDesc(DbName, @DbRec);
  IsInit := ( E <> DBIERR_NOCONFIGFILE );
  if( not IsInit )then
  begin
   DbiInit(nil);
   Continue;
  end;{ IF }
  Result := ( E = DBIERR_NONE );
  Break;
 end;{ WHILE }
 if( not IsInit)then DbiExit;
end;

function CheckAlias(DbName, DbPath, DbType: PChar): boolean;
var PATH: string;
begin
 Result := AliasExists( DbName );
 if not Result then
 begin
  PATH := 'PATH:' + DbPath;
  Result := DbiAddAlias(nil, DbName, DbType, PChar(PATH), True) = DBIERR_NONE;
  if Result then
  SESSION.SaveConfigFile;
  //Result := DbiCfgSave(nil, nil, False) = DBIERR_NONE;
 end;
end;

function DeleteAlias(DbName: PChar): boolean;
var
 E: DBIResult;
begin
 E := DbiDeleteAlias(nil, DbName);
 Result := (E = DBIERR_NONE);
end;

function GetDatabasePath(hDB: hDbiDb): DBIPATH;
begin
 if DbiGetDirectory(hDB, False, @Result) = DBIERR_NONE then
  Result := GetNormalPath( Result )
 else
  FillChar(Result, SizeOf(DBIPATH), #0);
end;

function IsBusy(DbName, TblName, TblType: PChar): boolean;
var
 hDb: hDBIDb;
 hCur: hDBICur;
 E: DbiResult;
begin
 E := DbiOpenDatabase(DbName, nil, dbiREADONLY,
                      dbiOPENSHARED, nil, 0, nil, nil, hDb);
 if(E = 10014)then
 E := DbiSetDirectory(hDb, DbName);

 E := DbiOpenTable(hDb, TblName, TblType, nil, nil, 0,
                   dbiREADONLY, dbiOPENEXCL, xltFIELD,
                   True, nil, hCur);
 Result := (E <> DBIERR_NONE);
 if( E = DBIERR_NONE )then
 DbiCloseCursor(hCur);
 DbiCloseDatabase(hDb);
end;

function GetTblFileName(Tbl: TTable): DBIPATH;
var
 Props: CurProps;
begin
 Check(DbiGetCursorProps(Tbl.Handle, Props));
 Check(DbiFormFullName(Tbl.DBHandle, PChar(Tbl.TableName),
       Props.szTableType, Result));
end;

function  CheckOpenTable(DbName, TblName, TblType: PChar; OpenExcl: boolean): DbiResult;
var
 Db        : DBIPATH;
 DbRec     : DBDesc;
 hDb       : hDBIDb;
 hCur      : hDBICur;
 IsAlias   : boolean;
 ShareMode : DBIShareMode;
begin
 hDb     := nil;
 hCur    := nil;

 IsAlias :=
  DbiGetDataBaseDesc(DbName, @DbRec) = DBIERR_NONE;

 if( IsAlias )then StrCopy(Db, DbName) else StrCopy(Db, '');
 Result :=
  DbiOpenDatabase( Pointer(@Db), nil,
                   dbiREADONLY,
                   dbiOPENSHARED,
                   nil, 0, nil, nil, hDb );
 if( Result = DBIERR_NONE )and( not IsAlias )then
 Result :=
  DbiSetDirectory( hDb, DbName );

 if OpenExcl then ShareMode := dbiOPENEXCL else ShareMode := dbiOPENSHARED;

 if( Result = DBIERR_NONE )then
 Result :=
 DbiOpenTable   ( hDb, TblName, TblType,
                  nil, nil, 0,
                  dbiREADONLY,
                  ShareMode,
                  xltFIELD,
                  False, nil, hCur );

 if( hCur <> nil )then
 DbiCloseCursor ( hCur );
 if( hDb <> nil )then
 DbiCloseDatabase( hDb );
end;

procedure ChangeLangDriver(Tbl: TTable; LDName: PChar; Translate: boolean);
var
  E: DBIResult;
  I: integer;

  TblDesc: CRTblDesc;
  TblCopy: TTable;
  Fld1, Fld2: TField;
  IsActive: boolean;

  OptDesc: FLDDesc;
  OptData, PATH: DBIPATH;
  hDB: hDBIDb;
  CURPROP: CURProps;
begin
  IsActive := Tbl.Active;
  if not( IsActive )then Tbl.Active := True;

  FillChar(OptDesc, SizeOf(OptDesc), #0);
  FillChar(TblDesc, SizeOf(TblDesc), #0);
  StrCopy(OptDesc.szName, 'LANGDRIVER');

  OptDesc.iLen := Length(LDName) + 1;
  Check(DbiGetCursorProps(Tbl.Handle, CURPROP));
  if( Translate )then
  Check(DbiCopyTable(Tbl.DbHandle, True, PChar(Tbl.TableName),
                     CURPROP.szTableType, PChar('_' + Tbl.TableName)));

  with TblDesc do
  begin
   StrPCopy(szTblName, Tbl.TableName);
   StrCopy(szTblType, CURProp.szTableType);
   StrPCopy(OptData, LDName);
   iOptParams:=1;
   pfldOptParams := @OptDesc;
   pOptData := @OptData;
  end;
  { GET TABLE PATH }
  Check(DbiGetDirectory(Tbl.DBHandle, False, PATH));
  Tbl.DisableControls;
  Tbl.Close;
  Check(DbiOpenDatabase(nil, szCFGDBSTANDARD, dbiReadWrite, dbiOpenExcl, nil,
         0, nil, nil, hDB));
  Check(DbiSetDirectory(hDB, PATH));
  try
   E := DbiDoRestructure(hDB, 1, @TblDesc, nil, nil, nil, False);
   if( Translate )and( E = DBIERR_NONE )then
   begin
    TblCopy := TTable.Create(nil);
    TblCopy.DatabaseName := Tbl.DatabaseName;
    TblCopy.TableName    := '_' + Tbl.TableName;
    TblCopy.Active := True;
    Tbl.Active     := True;

    for I := 0 to TblCopy.FieldCount - 1 do
    if( TblCopy.Fields[I].DataType = ftString )then
    begin
     Fld1 := Tbl.Fields[I];
     Fld2 := TblCopy.Fields[I];
     Tbl.First;
     TblCopy.First;
     while not( TblCopy.EOF )do
     begin
      Tbl.Edit;
       Fld1.AsString := Fld2.AsString;
      Tbl.Post;
      Tbl.Next;
      TblCopy.Next;
     end;{ WHILE }
    end;{ IF - FOR }
    Tbl.First;
    TblCopy.Active := False;
    TblCopy.DeleteTable;
    TblCopy.Free;
   end else
   Check(E);
  finally
   Tbl.Active := IsActive;
   Check(DbiCloseDatabase(hDB));
   Tbl.EnableControls;
  end;
end;

function DeleteIndexes(DbName, TblName: PChar): boolean;
var
 Db        : TDatabase;
 DbPath    : DBIPATH;
 Found     : integer;
 SearchRec : TSearchRec;
 DelFile   : string;
 DelExt    : string;
begin
 Result := True;
 Db := Session.OpenDatabase(DbName);
 try
  StrPCopy(DbPath, Db.Directory);
 finally
  Session.CloseDatabase(Db);
 end;
 DbPath  := GetNormalPath(DbPath);
 StrPCopy(TblName, ChangeFileExt(StrPas(TblName), ''));

 Found := FindFirst(StrPas(DbPath) + StrPas(TblName) + '.*', faAnyFile, SearchRec);
 while( Found = 0 )do
 begin
  DelFile := StrPas(DbPath) + SearchRec.Name;
  DelExt  := UpperCase(ExtractFileExt(SearchRec.Name));
  if( DelExt <> '.DB' )and( DelExt <> '.DBF' )then
  Result  := Result and DeleteFile(PChar(DelFile));
  Found   := FindNext( SearchRec );
 end;{ while }
 SysUtils.FindClose( SearchRec );
end;

function SQLCommand(DbName, Command: PChar): DbiResult;
begin
 with(TQuery.Create(nil))do
 begin
  if( DbName <> nil )then
  DatabaseName := StrPas(DbName);
  SQL.Add(StrPas(Command));
  Result := 0;
  try
   ExecSQL;
  except
   Result := DBIERR_INVALIDDESC;
  end;
  Free;
 end;
end;

function CheckTable(FileName: PChar): DbiResult;
const
 OFFS_CHECKPDX1     = 3;
 OFFS_CHECKPDX2     = 5;
 OFFS_FLDCOUNT      = 33;
 OFFS_TBLLEVEL      = 57;
 OFFS_TBLLEVEL1     = 88;
 OFFS_TBLLEVEL2     = 90;
 OFFS_AUTOINCREMENT = 73;

 OFFS_FLDTYPES: Word = 120;
 {
 DBIERR_UNKNOWNTBLTYPE
 DBIERR_UNKNOWNFILE
 DBIERR_MASTERTBLLEVEL
 }
var
 I: integer;
 Buffer: array[0..2047]of Byte;
 Buf: array[0..3]of Byte;
 TBLLEVEL, FldCOUNT: Byte;
 Count: longint;
 Stream: TFileStream;
begin
 Result  := DBIERR_NONE;
 try
  Stream := nil;
  Stream := TFileStream.Create(StrPas(FileName), fmOpenRead);
  Stream.Seek(0, soFromBeginning);
  Count  := Stream.Read(Buffer, SizeOf(Buffer));
  Stream.Free;
 except
  Result := DBIERR_UNKNOWNFILE;
  Exit;
 end;

 { CHECK TBLTYPE }
 if(Buffer[OFFS_CHECKPDX1] <> 8)or(Buffer[OFFS_CHECKPDX2] <> 2)then
 begin
  Result := DBIERR_UNKNOWNTBLTYPE;
  Exit;
 end;

 { GET TBLLEVEL }
 if not(Buffer[OFFS_TBLLEVEL] in [4..12])then
 begin
  if(Buffer[OFFS_TBLLEVEL1] in [9..12])then
  Buffer[OFFS_TBLLEVEL] := Buffer[OFFS_TBLLEVEL1]else
  if(Buffer[OFFS_TBLLEVEL2] in [9..12])then
  Buffer[OFFS_TBLLEVEL] := Buffer[OFFS_TBLLEVEL2]else
  Buffer[OFFS_TBLLEVEL] := 4;
 end;
 TblLevel := Buffer[OFFS_TBLLEVEL];
 if(TblLevel = 4)then OFFS_FLDTYPES := 88;

 { GET FIELDCOUNT }
 if(Buffer[OFFS_FLDCOUNT] < 1)then
 Buffer[OFFS_FLDCOUNT] := 1;
 FldCOUNT := Buffer[OFFS_FLDCOUNT];


 { WRITE REPAIR HEADER }
 try
  Stream := nil;
  Stream := TFileStream.Create(StrPas(FileName), fmOpenWrite);
  Stream.Seek(0, soFromBeginning);
  Stream.Write(Buffer, Count);
  Stream.Free;
 except
  Result := DBIERR_UNKNOWNFILE;
  Exit;
 end;
end;

function PointerToDate(pBuf: Pointer; var zDate: TDateTime): boolean;
var
 TimeStamp: TTimeStamp;
begin
 Result := True;
 TimeStamp.Time := 0;
 try
  TimeStamp.Date := Integer(pBuf^);
  zDate := TimeStampToDateTime(TimeStamp);
 except
  Result := False;
 end;
end;

function PointerToTime(pBuf: Pointer; var zTime: TDateTime): boolean;
var
 TimeStamp: TTimeStamp;
begin
 Result := True;
 try
  TimeStamp.Time := LongInt(pBuf^);
  TimeStamp.Date := DateDelta;
  zTime := TimeStampToDateTime(TimeStamp);
 except
  Result := False;
 end;
end;

function PointerToCurr(pBuf: Pointer; var zCurr: Currency): boolean;
begin
 Result := True;
 try
  zCurr := Double(pBuf^);
 except
  Result := False;
 end;
end;

function PointerToStr(pBuf: Pointer; var zStr: string): boolean;
begin
 Result := True;
 try
  zStr := StrPas(pBuf);
 except
  Result := False;
 end;
end;

function PointerToSmall(pBuf: Pointer; var zSmall: SmallInt): boolean;
begin
 Result := True;
 try
  zSmall := SmallInt(pBuf^);
 except
  Result := False;
 end;
end;

function PointerToInt(pBuf: Pointer; var zInt: Integer): boolean;
begin
 Result := True;
 try
  zInt := Integer(pBuf^);
 except
  Result := False;
 end;
end;

function PointerToWord(pBuf: Pointer; var zWord: Word): boolean;
begin
 Result := True;
 try
  zWord := Word(pBuf^);
 except
  Result := False;
 end;
end;

procedure DateToPointer(zDate: TDateTime; pBuf: Pointer);
begin
 Integer(pBuf^) := DateTimeToTimeStamp(zDate).Date;
end;

procedure TimeToPointer(zTime: TDateTime; pBuf: Pointer);
begin
 Integer(pBuf^) := DateTimeToTimeStamp(zTime).Time;
end;

procedure CurrToPointer(zCurr: Currency; pBuf: Pointer);
begin
 Double(pBuf^) := zCurr;
end;

procedure StrToPointer(zStr: string; pBuf: Pointer);
begin
 StrMove(pBuf, PChar(zStr), Length(zStr) + 1);
end;

procedure IntToPointer(zInt: Integer; pBuf: Pointer);
begin
 Integer(pBuf^) := zInt;
end;

procedure SmallToPointer(zSmall: SmallInt; pBuf: Pointer);
begin
 SmallInt(pBuf^) := zSmall;
end;

end.
