// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'vteExcel.pas' rev: 5.00

#ifndef vteExcelHPP
#define vteExcelHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <vteExcelTypes.hpp>	// Pascal unit
#include <BIFF8_Types.hpp>	// Pascal unit
#include <Math.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Vteexcel
{
//-- type declarations -------------------------------------------------------
typedef unsigned TCardinalArray[1];

typedef unsigned *PCardinalArray;

class DELPHICLASS TvteXLSBorder;
class PASCALIMPLEMENTATION TvteXLSBorder : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Graphics::TColor FColor;
	Vteexceltypes::TvteXLSLineStyleType FLineStyle;
	Vteexceltypes::TvteXLSWeightType FWeight;
	
public:
	__property Graphics::TColor Color = {read=FColor, write=FColor, nodefault};
	__property Vteexceltypes::TvteXLSLineStyleType LineStyle = {read=FLineStyle, write=FLineStyle, nodefault
		};
	__property Vteexceltypes::TvteXLSWeightType Weight = {read=FWeight, write=FWeight, nodefault};
	__fastcall TvteXLSBorder(void);
	__fastcall virtual ~TvteXLSBorder(void);
};


class DELPHICLASS TvteXLSBorders;
class PASCALIMPLEMENTATION TvteXLSBorders : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TvteXLSBorder* FBorders[6];
	TvteXLSBorder* __fastcall GetItem(Vteexceltypes::TvteXLSBorderType i);
	
public:
	__property TvteXLSBorder* Borders[Vteexceltypes::TvteXLSBorderType i] = {read=GetItem/*, default*/}
		;
	__fastcall TvteXLSBorders(void);
	__fastcall virtual ~TvteXLSBorders(void);
};


typedef DynamicArray<Word >  TDynWordArray;

class DELPHICLASS TvteXLSRange;
class DELPHICLASS TvteXLSWorksheet;
class DELPHICLASS TvteXLSWorkbook;
class PASCALIMPLEMENTATION TvteXLSWorkbook : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	AnsiString FUserNameOfExcel;
	Classes::TList* FSheets;
	void __fastcall SetUserNameOfExcel(AnsiString Value);
	void __fastcall ClearSheets(void);
	int __fastcall GetSheetsCount(void);
	TvteXLSWorksheet* __fastcall GetXLSWorkSheet(int i);
	
public:
	__property AnsiString UserNameOfExcel = {read=FUserNameOfExcel, write=SetUserNameOfExcel};
	__property int SheetsCount = {read=GetSheetsCount, nodefault};
	__property TvteXLSWorksheet* Sheets[int i] = {read=GetXLSWorkSheet};
	void __fastcall SaveAsXLSToFile(const AnsiString FileName);
	void __fastcall SaveAsHTMLToFile(const AnsiString FileName);
	TvteXLSWorksheet* __fastcall AddSheet(void);
	void __fastcall Clear(void);
	__fastcall TvteXLSWorkbook(void);
	__fastcall virtual ~TvteXLSWorkbook(void);
};


class DELPHICLASS TvteXLSPageSetup;
class PASCALIMPLEMENTATION TvteXLSPageSetup : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	bool FBlackAndWhite;
	AnsiString FCenterFooter;
	AnsiString FCenterHeader;
	bool FCenterHorizontally;
	bool FCenterVertically;
	bool FDraft;
	int FFirstPageNumber;
	int FFitToPagesTall;
	int FFitToPagesWide;
	AnsiString FLeftFooter;
	AnsiString FLeftHeader;
	Vteexceltypes::TvteXLSOrderType FOrder;
	Vteexceltypes::TvteXLSOrientationType FOrientation;
	Vteexceltypes::TvteXLSPaperSizeType FPaperSize;
	bool FPrintGridLines;
	bool FPrintHeaders;
	bool FPrintNotes;
	AnsiString FRightFooter;
	AnsiString FRightHeader;
	double FLeftMargin;
	double FRightMargin;
	double FTopMargin;
	double FBottomMargin;
	double FFooterMargin;
	double FHeaderMargin;
	int FZoom;
	int FCopies;
	
public:
	__property AnsiString LeftFooter = {read=FLeftFooter, write=FLeftFooter};
	__property AnsiString LeftHeader = {read=FLeftHeader, write=FLeftHeader};
	__property AnsiString CenterFooter = {read=FCenterFooter, write=FCenterFooter};
	__property AnsiString CenterHeader = {read=FCenterHeader, write=FCenterHeader};
	__property AnsiString RightFooter = {read=FRightFooter, write=FRightFooter};
	__property AnsiString RightHeader = {read=FRightHeader, write=FRightHeader};
	__property bool CenterHorizontally = {read=FCenterHorizontally, write=FCenterHorizontally, nodefault
		};
	__property bool CenterVertically = {read=FCenterVertically, write=FCenterVertically, nodefault};
	__property double LeftMargin = {read=FLeftMargin, write=FLeftMargin};
	__property double RightMargin = {read=FRightMargin, write=FRightMargin};
	__property double TopMargin = {read=FTopMargin, write=FTopMargin};
	__property double BottomMargin = {read=FBottomMargin, write=FBottomMargin};
	__property double HeaderMargin = {read=FHeaderMargin, write=FHeaderMargin};
	__property double FooterMargin = {read=FFooterMargin, write=FFooterMargin};
	__property Vteexceltypes::TvteXLSPaperSizeType PaperSize = {read=FPaperSize, write=FPaperSize, nodefault
		};
	__property Vteexceltypes::TvteXLSOrientationType Orientation = {read=FOrientation, write=FOrientation
		, nodefault};
	__property Vteexceltypes::TvteXLSOrderType Order = {read=FOrder, write=FOrder, nodefault};
	__property int FirstPageNumber = {read=FFirstPageNumber, write=FFirstPageNumber, nodefault};
	__property int FitToPagesTall = {read=FFitToPagesTall, write=FFitToPagesTall, nodefault};
	__property int FitToPagesWide = {read=FFitToPagesWide, write=FFitToPagesWide, nodefault};
	__property int Copies = {read=FCopies, write=FCopies, nodefault};
	__property int Zoom = {read=FZoom, write=FZoom, nodefault};
	__property bool BlackAndWhite = {read=FBlackAndWhite, write=FBlackAndWhite, nodefault};
	__property bool Draft = {read=FDraft, write=FDraft, nodefault};
	__property bool PrintNotes = {read=FPrintNotes, write=FPrintNotes, nodefault};
	__property bool PrintGridLines = {read=FPrintGridLines, write=FPrintGridLines, nodefault};
	__property bool PrintHeaders = {read=FPrintHeaders, write=FPrintHeaders, nodefault};
	__fastcall TvteXLSPageSetup(void);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TvteXLSPageSetup(void) { }
	#pragma option pop
	
};


class DELPHICLASS TvteXLSCol;
class DELPHICLASS TvteXLSRow;
class PASCALIMPLEMENTATION TvteXLSWorksheet : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TvteXLSWorkbook* FWorkbook;
	AnsiString FTitle;
	TvteXLSPageSetup* FPageSetup;
	Classes::TList* FRanges;
	Classes::TList* FCols;
	Classes::TList* FRows;
	Windows::TRect FDimensions;
	void __fastcall SetTitle(AnsiString Value);
	TvteXLSRange* __fastcall GetRange(int xl, int yt, int xr, int yb);
	TvteXLSCol* __fastcall GetCol(int ColIndex);
	TvteXLSRow* __fastcall GetRow(int RowIndex);
	int __fastcall GetRangesCount(void);
	TvteXLSRange* __fastcall GetXLSRange(int RangeIndex);
	int __fastcall GetColsCount(void);
	int __fastcall GetRowsCount(void);
	int __fastcall GetIndexInWorkBook(void);
	TvteXLSCol* __fastcall GetColByIndex(int i);
	TvteXLSRow* __fastcall GetRowByIndex(int i);
	TvteXLSRange* __fastcall AddRange(int xl, int yt, int xr, int yb);
	TvteXLSRow* __fastcall AddRow(int RowIndex);
	TvteXLSCol* __fastcall AddCol(int ColIndex);
	
public:
	__property AnsiString Title = {read=FTitle, write=SetTitle};
	__property TvteXLSPageSetup* PageSetup = {read=FPageSetup};
	__property TvteXLSRange* Ranges[int xl][int yt][int xr][int yb] = {read=GetRange/*, default*/};
	__property TvteXLSCol* Cols[int ColIndex] = {read=GetCol};
	__property TvteXLSRow* Rows[int RowIndex] = {read=GetRow};
	__property TvteXLSRange* RangeByIndex[int RangeIndex] = {read=GetXLSRange};
	__property int RangesCount = {read=GetRangesCount, nodefault};
	__property TvteXLSCol* ColByIndex[int ColIndex] = {read=GetColByIndex};
	__property int ColsCount = {read=GetColsCount, nodefault};
	__property TvteXLSRow* RowByIndex[int RowIndex] = {read=GetRowByIndex};
	__property int RowsCount = {read=GetRowsCount, nodefault};
	__property int IndexInWorkBook = {read=GetIndexInWorkBook, nodefault};
	__property TvteXLSWorkbook* Workbook = {read=FWorkbook};
	__property Windows::TRect Dimensions = {read=FDimensions};
	TvteXLSRange* __fastcall FindRange(int xl, int yt, int xr, int yb);
	TvteXLSRow* __fastcall FindRow(int RowIndex);
	TvteXLSCol* __fastcall FindCol(int ColIndex);
	__fastcall TvteXLSWorksheet(TvteXLSWorkbook* AWorkbook);
	__fastcall virtual ~TvteXLSWorksheet(void);
};


class PASCALIMPLEMENTATION TvteXLSRange : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TvteXLSWorksheet* FWorksheet;
	Windows::TRect FPlace;
	TvteXLSBorders* FBorders;
	Graphics::TFont* FFont;
	Vteexceltypes::TvteXLSHorizontalAlignmentType FHorizontalAlignment;
	Vteexceltypes::TvteXLSVerticalAlignmentType FVerticalAlignment;
	bool FWrapText;
	Byte FRotation;
	AnsiString FFormat;
	Variant FValue;
	Vteexceltypes::TvteXLSFillPattern FFillPattern;
	Graphics::TColor FForegroundFillPatternColor;
	Graphics::TColor FBackgroundFillPatternColor;
	void *FExportData;
	TvteXLSWorkbook* __fastcall GetWorkbook(void);
	Vteexceltypes::TvteCellDataType __fastcall GetCellDataType(void);
	void __fastcall SetValue(const Variant &Value);
	
public:
	__property TvteXLSWorksheet* Worksheet = {read=FWorksheet};
	__property TvteXLSWorkbook* Workbook = {read=GetWorkbook};
	__property Windows::TRect Place = {read=FPlace};
	__property TvteXLSBorders* Borders = {read=FBorders};
	__property Graphics::TFont* Font = {read=FFont};
	__property Vteexceltypes::TvteXLSHorizontalAlignmentType HorizontalAlignment = {read=FHorizontalAlignment
		, write=FHorizontalAlignment, nodefault};
	__property Vteexceltypes::TvteXLSVerticalAlignmentType VerticalAlignment = {read=FVerticalAlignment
		, write=FVerticalAlignment, nodefault};
	__property Variant Value = {read=FValue, write=SetValue};
	__property bool WrapText = {read=FWrapText, write=FWrapText, nodefault};
	__property Byte Rotation = {read=FRotation, write=FRotation, nodefault};
	__property AnsiString Format = {read=FFormat, write=FFormat};
	__property Vteexceltypes::TvteXLSFillPattern FillPattern = {read=FFillPattern, write=FFillPattern, 
		nodefault};
	__property Graphics::TColor ForegroundFillPatternColor = {read=FForegroundFillPatternColor, write=FForegroundFillPatternColor
		, nodefault};
	__property Graphics::TColor BackgroundFillPatternColor = {read=FBackgroundFillPatternColor, write=FBackgroundFillPatternColor
		, nodefault};
	__property void * ExportData = {read=FExportData, write=FExportData};
	__property Vteexceltypes::TvteCellDataType CellDataType = {read=GetCellDataType, nodefault};
	__fastcall TvteXLSRange(TvteXLSWorksheet* AWorksheet);
	__fastcall virtual ~TvteXLSRange(void);
};


class PASCALIMPLEMENTATION TvteXLSRow : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	int FInd;
	int FHeight;
	
public:
	__property int Ind = {read=FInd, nodefault};
	__property int Height = {read=FHeight, write=FHeight, nodefault};
	__fastcall TvteXLSRow(void);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TvteXLSRow(void) { }
	#pragma option pop
	
};


class PASCALIMPLEMENTATION TvteXLSCol : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	int FInd;
	int FWidth;
	
public:
	__property int Ind = {read=FInd, write=FInd, nodefault};
	__property int Width = {read=FWidth, write=FWidth, nodefault};
	__fastcall TvteXLSCol(void);
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TvteXLSCol(void) { }
	#pragma option pop
	
};


class DELPHICLASS TvteCustomWriter;
class PASCALIMPLEMENTATION TvteCustomWriter : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	virtual void __fastcall Save(TvteXLSWorkbook* WorkBook, const AnsiString FileName);
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TvteCustomWriter(void) : System::TObject() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TvteCustomWriter(void) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------
#define sXLSWorksheetTitlePrefix "Sheet"
#define sDefaultFontName "Arial"
static const Byte XLSDefaultRowHeight = 0xff;
static const Shortint XLSDefaultColumnWidthInChars = 0x8;
static const Shortint MaxDefaultColors = 0x10;
static const Word MaxBiffRecordSize = 0x2024;
extern PACKAGE bool __fastcall PointInRect(int X, int Y, const Windows::TRect &R);
extern PACKAGE bool __fastcall RectOverRect(const Windows::TRect &r1, const Windows::TRect &r2);

}	/* namespace Vteexcel */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Vteexcel;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// vteExcel
