{******************************************}
{                                          }
{                 PReport v1.5             }
{                                          }
{ Copyright (c) 1999-2002 by Manuzin A.    }
{                                          }
{******************************************}

unit BIFF8_Types;

{$include vtk.inc}

interface

const
  XLSMaxRowsInSheet = 65536;
  XLSMaxRowsInBlock = 32;
  XLSMaxCellsInRow = 256;
  XLSMaxBlocks = XLSMaxRowsInSheet div XLSMaxRowsInBlock;
  XLSMaxColorsInPalette = 56;

  b8_EOF = $000A;
  b8_BOF = $0809;
  b8_COLINFO = $007D;
  b8_XF = $00E0;
  b8_LABEL = $0204;
  b8_BLANK = $0201;
  b8_DIMENSIONS = $0200;
  b8_ROW = $0208;
  b8_INTERFACHDR = $00E1;
  b8_INTERFACEND = $00E2;
  b8_MMS = $00C1;
  b8_CODEPAGE = $0042;
  b8_TABID = $013D;
  b8_FNGROUPCOUNT = $009C;
  b8_WINDOWPROTECT = $0019;
  b8_PROTECT = $0012;
  b8_PASSWORD = $0013;
  b8_WINDOW1 = $003D;
  b8_BACKUP = $0040;
  b8_HIDEOBJ = $008D;
  b8_1904 = $0022;
  b8_PRECISION = $000E;
  b8_BOOKBOOL = $00DA;
  b8_FONT = $0031; // $0231 - in MSDN
  b8_FORMAT = $041E;
  b8_COUNTRY = $008C;
  b8_INDEX = $020B;
  b8_CALCMODE = $000D;
  b8_CALCCOUNT = $000C;
  b8_REFMODE = $000F;
  b8_ITERATION = $0011;
  b8_SAVERECALC = $005F;
  b8_DELTA = $0010;
  b8_PRINTHEADERS = $002A;
  b8_PRINTGRIDLINES = $002B;
  b8_GRIDSET = $0082;
  b8_GUTS = $0080;
  b8_DEFAULTROWHEIGHT = $0225;
  b8_WSBOOL = $0081;
  b8_HEADER = $0014;
  b8_FOOTER = $0015;
  b8_HCENTER = $0083;
  b8_VCENTER = $0084;
  b8_DEFCOLWIDTH = $0055;
  b8_WRITEACCESS = $005C;
  b8_DOUBLESTREAMFILE = $0161;
  b8_PROT4REV = $01AF;
  b8_PROT4REVPASS = $01BC;
  b8_REFRESHALL = $01B7;
  b8_USESELFS = $0160;
  b8_BOUNDSHEET = $0085;
  b8_WINDOW2 = $023E;
  b8_SELECTION = $001D;
  b8_DBCELL = $00D7;
  b8_MULBLANK = $00BE;
  b8_MERGE = $00E5; // see in biffview
  b8_PALETTE = $0092;
  b8_CONTINUE = $003C;
  b8_SETUP = $00A1;
  b8_SST = $00FC;
  b8_EXTSST = $00FF;
  b8_LABELSST = $00FD;
  b8_NUMBER = $0203;





  b8_BOF_vers = $0600;

  b8_BOF_dt_WorkbookGlobals = $0005;
  b8_BOF_dt_VisualBasicModule = $0006;
  b8_BOF_dt_Worksheet = $0010;
  b8_BOF_dt_Chart = $0020;
  b8_BOF_dt_MacroSheet = $0040;
  b8_BOF_dt_WorkspaceFile = $0100;

  b8_BOF_rupBuild_Excel97 = $0DBB;

  b8_BOF_rupYear_Excel07 = $07CC;

  b8_XF_Opt1_fLocked = $0001;
  b8_XF_Opt1_fHidden = $0002;
  b8_XF_Opt1_fStyleXF = $0004;
  b8_XF_Opt1_f123Prefix = $0008;
  b8_XF_Opt1_ixfParent = $FFF0;

  b8_XF_Opt2_alcGeneral = $0000;
  b8_XF_Opt2_alcLeft = $0001;
  b8_XF_Opt2_alcCenter = $0002;
  b8_XF_Opt2_alcRight = $0003;
  b8_XF_Opt2_alcFill = $0004;
  b8_XF_Opt2_alcJustify = $0005;
  b8_XF_Opt2_alcCenterAcrossSelection = $0006;

  b8_XF_Opt2_fWrap = $0008;
  
  b8_XF_Opt2_alcVTop = $0000;
  b8_XF_Opt2_alcVCenter = $0010;
  b8_XF_Opt2_alcVBottom = $0020;
  b8_XF_Opt2_alcVJustify = $0030;

  b8_XF_Opt3_fMergeCell = $0020;
  b8_XF_Opt3_fAtrNum = $0400;
  b8_XF_Opt3_fAtrFnt = $0800;
  b8_XF_Opt3_fAtrAlc = $1000;
  b8_XF_Opt3_fAtrBdr = $2000;
  b8_XF_Opt3_fAtrPat = $4000;
  b8_XF_Opt3_fAtrProt = $8000;

  b8_XF_Border_None = $0000;
  b8_XF_Border_Thin = $0001;
  b8_XF_Border_Medium = $0002;
  b8_XF_Border_Dashed = $0003;
  b8_XF_Border_Dotted = $0004;
  b8_XF_Border_Thick = $0005;
  b8_XF_Border_Double = $0006;
  b8_XF_Border_Hair = $0007;
  b8_XF_Border_MediumDashed = $0008;
  b8_XF_Border_DashDot = $0009;
  b8_XF_Border_MediumDashDot = $000A;
  b8_XF_Border_DashDotDot = $000B;
  b8_XF_Border_MediumDashDotDot = $000C;
  b8_XF_Border_SlantedDashDot = $000D;

  b8_INTERFACHDR_cv_IBMPC = $01B5;
  b8_INTERFACHDR_cv_Macintosh = $8000;
  b8_INTERFACHDR_cv_ANSI = $04E4;

  b8_CODEPAGE_cv_IBMPC = $01B5;
  b8_CODEPAGE_cv_Macintosh = $8000;
  b8_CODEPAGE_cv_ANSI = $04E4;

  b8_WINDOW1_grbit_fHidden = $0001;
  b8_WINDOW1_grbit_fIconic = $0002;
  b8_WINDOW1_grbit_fDspHScroll = $0008;
  b8_WINDOW1_grbit_fDspVScroll = $0010;
  b8_WINDOW1_grbit_fBotAdornment = $0020;

  b8_FONT_grbit_fItalic = $0002;
  b8_FONT_grbit_fStrikeout = $0008;
  b8_FONT_grbit_fOutline = $0010;
  b8_FONT_grbit_fShadow = $0020;

  b8_DEFAULTROWHEIGHT_fUnsynced = $0001;
  b8_DEFAULTROWHEIGHT_fDyZero = $0002;
  b8_DEFAULTROWHEIGHT_fExAsc = $0004;
  b8_DEFAULTROWHEIGHT_fExDsc = $0008;

  b8_WSBOOL_fShowAutoBreaks = $0001;
  b8_WSBOOL_fDialog = $0010;
  b8_WSBOOL_fApplyStyles = $0020;
  b8_WSBOOL_fRwSumsBelow = $0040;
  b8_WSBOOL_fColSumsRight = $0080;
  b8_WSBOOL_fFitToPage = $0100;
  b8_WSBOOL_fDspGuts = $0200;
  b8_WSBOOL_fAee = $0400;
  b8_WSBOOL_fAfe = $8000;

  b8_WINDOW1_fHidden = $0001;
  b8_WINDOW1_fIconic = $0002;
  b8_WINDOW1_fDspHScroll = $0008;
  b8_WINDOW1_fDspVScroll = $0010;
  b8_WINDOW1_fBotAdornment = $0020;


  b8_WINDOW2_grbit_fDspFmla = $0001;
  b8_WINDOW2_grbit_fDspGrid = $0002;
  b8_WINDOW2_grbit_fDspRwCol = $0004;
  b8_WINDOW2_grbit_fFrozen = $0008;
  b8_WINDOW2_grbit_fDspZeros = $0010;
  b8_WINDOW2_grbit_fDefaultHdr = $0020;
  b8_WINDOW2_grbit_fArabic = $0040;
  b8_WINDOW2_grbit_fDspGuts = $0080;
  b8_WINDOW2_grbit_fFrozenNoSplit = $0100;
  b8_WINDOW2_grbit_fSelected = $0200;
  b8_WINDOW2_grbit_fPaged = $0400;
  b8_WINDOW2_grbit_fSLV = $0800;

  b8_ROW_grbit_fCollapsed = $0010;
  b8_ROW_grbit_fDyZero = $0020;
  b8_ROW_grbit_fUnsynced = $0040;
  b8_ROW_grbit_fGhostDirty = $0080;
  b8_ROW_grbit_mask_iOutLevel = $0007;

  b8_COLINFO_fHidden = $0001;
  b8_COLINFO_fCollapsed = $1000;

  b8_SETUP_fLeftToRight = $0001;
  b8_SETUP_fLandscape = $0002;
  b8_SETUP_fNoPls = $0004;
  b8_SETUP_fNoColor = $0008;
  b8_SETUP_fDraft = $0010;
  b8_SETUP_fNotes = $0020;
  b8_SETUP_fNoOrient = $0040;
  b8_SETUP_fUsePage = $0080;

  b8_LEFTMARGIN = $0026;
  b8_RIGHTMARGIN = $0027;
  b8_TOPMARGIN = $0028;
  b8_BOTTOMMARGIN = $0029;

type

rb8BOF = packed record
  vers : word;
  dt : word;
  rupBuild : word;
  rupYear : word;
  bfh : cardinal;
  sfo : cardinal;
end;

rb8COLINFO = packed record
  colFirst : word;
  colLast : word;
  coldx : word;
  ixfe : word;
  grbit : word;
  res1 : byte;
end;

rb8XF = packed record
  ifnt : word;
  ifmt : word;
  Opt1 : word;
  Opt2 : byte;
  trot : byte;
  Opt3 : word;
  Borders1 : word;
{ Line style for borders
    dgLeft : 3..0
    dgRight : 7..4
    dgTop : 11..8
    dgBottom : 15..12 }
  Borders2 : word;
{
    icvLeft : 6..0
    icvRight : 13..7
    grbitDiag : 15..14}
  Borders3 : cardinal;
{
    icvTop : 6..0
    icvBottom : 13..7
    icvDiag : 20..14
    dgDiag : 24..21
    Reserved : 25
    fls : 31..26}
  Colors : word;
{
    icvFore : 6..0
    icvBack : 13..7
    fSxButton : 14
    Reserved : 15}
end;

rb8DIMENSIONS = packed record
  rwMic : cardinal;
  rwMac : cardinal;
  colMic : word;
  colMac : word;
  Res1 : word;
end;

rb8ROW = packed record
  rw : word;
  colMic : word;
  colMac : word;
  miyRw : word;
  irwMac : word;
  Res1 : word;
  grbit : word;
  ixfe : word;
end;

rb8INTERFACHDR = packed record
  cv : word;
end;

rb8MMS = packed record
  caitm : byte;
  cditm : byte;
end;

rb8CODEPAGE = packed record
  cv : word;
end;

rb8FNGROUPCOUNT = packed record
  cFnGroup : word;
end;

rb8WINDOWPROTECT = packed record
  fLockWn : word;
end;

rb8PROTECT = packed record
  fLock : word;
end;

rb8PASSWORD = packed record
  wPassword : word;
end;

rb8BACKUP = packed record
  fBackupFile : word;
end;

rb8HIDEOBJ = packed record
  fHideObj : word;
end;

rb81904 = packed record
  f1904 : word;
end;

rb8PRECISION = packed record
  fFullPrec : word;
end;

rb8BOOKBOOL = packed record
  fNoSaveSupp : word;
end;

rb8FONT = packed record
  dyHeight : word;
  grbit : word;
  icv : word;
  bls : word;
  sss : word;
  uls : byte;
  bFamily : byte;
  bCharSet : byte;
  Res1 : byte;
  cch : byte; // or word ???
  cchgrbit : byte;
end;
pb8FONT = ^rb8FONT;

rb8FORMAT = packed record
  ifmt : word;
  cch : word;
  cchgrbit : byte;
end;
pb8FORMAT = ^rb8FORMAT;

rb8COUNTRY = packed record
  iCountryDef : word;
  iCountryWinIni : word;
end;

rb8INDEX = packed record
  Res1 : cardinal;
  rwMic : cardinal;
  rwMac : cardinal;
  Res2 : cardinal;
end;
pb8INDEX = ^rb8INDEX;

rb8CALCMODE = packed record
  fAutoRecalc : word;
end;

rb8CALCCOUNT = packed record
  cIter : word;
end;

rb8REFMODE = packed record
  fRefA1 : word;
end;

rb8ITERATION = packed record
  fIter : word;
end;

rb8DELTA = packed record
  numDelta : int64; // ??? must be IEEE floating-point 
end;

rb8SAVERECALC = packed record
  fSaveRecalc : word;
end;

rb8PRINTHEADERS = packed record
  fPrintRwCol : word;
end;

rb8PRINTGRIDLINES = packed record
  fPrintGrid : word;
end;

rb8GRIDSET = packed record
  fGridSet : word;
end;

rb8GUTS = packed record
  dxRwGut : word;
  dyColGut : word;
  iLevelRwMac : word;
  iLevelColMac : word;
end;

rb8DEFAULTROWHEIGHT = packed record
  grbit : word;
  miyRw : word;
end;

rb8WSBOOL = packed record
  grbit : word;
end;

rb8HEADER = packed record
  cch : word;
  cchgrbit : byte;
end;
pb8HEADER = ^rb8HEADER;

rb8FOOTER = packed record
  cch : word;
  cchgrbit : byte;
end;
pb8FOOTER = ^rb8FOOTER;

rb8HCENTER = packed record
  fHCenter : word;
end;

rb8VCENTER = packed record
  fVCenter : word;
end;

rb8DEFCOLWIDTH = packed record
  cchdefColWidth : word;
end;

rb8WRITEACCESS = packed record
  stName : array [0..111] of byte; // User name as an unformatted unicode string
end;

rb8DOUBLESTREAMFILE = packed record
  fDSF : word;
end;

rb8PROT4REV = packed record
  fRevLock : word;
end;

rb8PROT4REVPASS = packed record
  wRevPass : word;
end;

rb8WINDOW1 = packed record
  xWn : word;
  yWn : word;
  dxWn : word;
  dyWn : word;
  grbit : word;
  itabCur : word;
  itabFirst : word;
  ctabSel : word;
  wTabRatio : word;
end;

rb8REFRESHALL = packed record
  fRefreshAll : word;
end;

rb8USESELFS = packed record
  fUsesElfs : word;
end;

rb8PALETTE = packed record
  ccv : word;
  colors : array [0..XLSMaxColorsInPalette-1] of cardinal;
end;

rb8BOUNDSHEET = packed record
  lbPlyPos : cardinal;
  grbit : word;
  cch : byte;
  cchgrbit : byte;
end;
pb8BOUNDSHEET = ^rb8BOUNDSHEET;

rb8WINDOW2 = packed record
  grbit : word;
  rwTop : word;
  colLeft : word;
  icvHdr : cardinal;
  wScaleSLV : word;
  wScaleNormal : word;
  Res1 : cardinal;
end;

rb8SELECTION = packed record
  pnn : byte;
  rwAct : word;
  colAct : word;
  irefAct :word;
  cref : word;
end;
pb8SELECTION = ^rb8SELECTION;

rb8DBCELL = packed record
  dbRtrw : cardinal;
end;

Tb8DBCELLCellsOffsArray = array [0..XLSMaxCellsInRow-1] of word;
rb8DBCELLfull = packed record
  dbRtrw : cardinal;
  cellsOffs : Tb8DBCELLCellsOffsArray;
end;

rb8MERGErec = packed record
  top : word;
  bottom : word;
  left : word;
  right : word;
end;
pb8MERGErec = ^rb8MERGErec;

rb8MERGE = packed record
  cnt : word;  // next - array of merge structs top,bottom,left,right 
end;
pb8MERGE = ^rb8MERGE;

rb8LABEL = packed record
  rw : word;
  col : word;
  ixfe : word;
  cch : word;
  cchgrbit : byte;
end;
pb8LABEL = ^rb8LABEL;

rb8BLANK = packed record
  rw : word;
  col : word;
  ixfe : word;
end;

rb8MULBLANK = packed record
  rw : word;
  colFirst : word;
//  colLast : word;
end;
pb8MULBLANK = ^rb8MULBLANK;

rb8SETUP = packed record
  iPaperSize : word;
  iScale : word;
  iPageStart : word;
  iFitWidth : word;
  iFitHeight : word;
  grbit : word;
  iRes : word;
  iVRes : word;
  numHdr : double;
  numFtr : double;
  iCopies : word;
end;

rb8SST = packed record
  cstTotal : cardinal;
  cstUnique : cardinal;
end;
pb8SST = ^rb8SST;

rb8EXTSST = packed record
  Dsst : word;
end;
pb8EXTSST = ^rb8EXTSST;

rb8ISSTINF = packed record
  ib : cardinal;
  cb : word;
  res1 : word;
end;
pb8ISSTINF = ^rb8ISSTINF;

rb8LABELSST = packed record
  rw : word;
  col : word;
  ixfe : word;
  isst : cardinal;
end;

rb8LEFTMARGIN = packed record
  num : double;
end;

rb8RIGHTMARGIN = packed record
  num : double;
end;

rb8TOPMARGIN = packed record
  num : double;
end;

rb8BOTTOMMARGIN = packed record
  num : double;
end;

rb8NUMBER = packed record
  rw : word;
  col : word;
  ixfe : word;
  num : double;
end;

implementation

end.

