
{******************************************}
{                                          }
{           vtk Export library             }
{            Example  program              }
{      Copyright (c) 2002 by vtkTools      }
{                                          }
{******************************************}

unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ShellApi,TypInfo,
  BIFF8_Types, vteExcel, vteExcelTypes, vteWriters;

const
  LargeText =
'Welcome to vtkExport Library'#13#10+
'VtkExport library intended for export from your programs in the Excel and HTML formats.'#13#10+
'The shaping XLS of the file happens without use DDE, OLE, i.e. to receive XLS the file necessarily, that on the computer Excel was installed!.'#13#10+
'The method of export is very simple - you form object TvteXLSWorkBook, which has properties and methods similar to properties and methods OLE of the Excel server and call  him method SaveAsXLS or SaveAsHTML.'#13#10+
'(c) VtkTools, 2002';

type
  TFormMain = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Label1: TLabel;
    ButtonSave: TButton;
    Panel3: TPanel;
    CBorders: TCheckBox;
    COpen: TCheckBox;
    CFonts: TCheckBox;
    CMerges: TCheckBox;
    CBackgrounds: TCheckBox;
    CRotations: TCheckBox;
    CLargeText: TCheckBox;
    Image1: TImage;
    SaveDialog: TSaveDialog;
    CFormats: TCheckBox;
    procedure Image1Click(Sender: TObject);
    procedure ButtonSaveClick(Sender: TObject);
  private
    { Private declarations }
    procedure Build(wb : TvteXLSWorkbook);
    procedure AddBordersSheet(wb : TvteXLSWorkbook);
    procedure AddFontsSheet(wb : TvteXLSWorkbook);
    procedure AddMergesSheet(wb : TvteXLSWorkbook);
    procedure AddFillsSheet(wb : TvteXLSWorkbook);
    procedure AddRotationsSheet(wb : TvteXLSWorkbook);
    procedure AddLargeTextSheet(wb : TvteXLSWorkbook);
    procedure AddNumberFormatsSheet(wb : TvteXLSWorkbook);
  public
    { Public declarations }
  end;

var
  FormMain: TFormMain;

implementation

{$R *.DFM}

procedure TFormMain.Image1Click(Sender: TObject);
begin
  ShellExecute(0,'open',PChar('http://www.vtktools.ru'),'','',SW_SHOWNORMAL);
end;

procedure TFormMain.ButtonSaveClick(Sender: TObject);
var
  wb : TvteXLSWorkbook;
  FileName : string;
  Writer : TvteCustomWriter;
begin
  if SaveDialog.Execute then
  begin
    FileName := SaveDialog.FileName;
    if ExtractFileExt(SaveDialog.FileName) = '' then
      case SaveDialog.FilterIndex of
        1 : FileName := FileName + '.xls';
        2 : FileName := FileName + '.htm';
      end;
    wb := TvteXLSWorkbook.Create;
    try
      Build(wb);
      case SaveDialog.FilterIndex of
        1 : Writer := TvteExcelWriter.Create;
        2 : Writer := TvteHTMLWriter.Create;
      else
        Raise Exception.Create('Logical error');
      end;
      try
        Writer.Save(wb,FileName);
      finally
        Writer.Free;
      end;
    finally
      wb.Free;
    end;
    if COpen.Checked then
      ShellExecute(0,'open',PChar(FileName),'','',SW_SHOWNORMAL);
  end;
end;

procedure TFormMain.AddBordersSheet(wb : TvteXLSWorkbook);
var
  sh : TvteXLSWorksheet;
  i,j : integer;
  s1,s2 : string;
  Row,Col : integer;
begin
sh := wb.AddSheet;
sh.Title := 'Borders';
for j:=integer(Low(TvteXLSLineStyleType)) to integer(High(TvteXLSLineStyleType)) do
  for i:=integer(Low(TvteXLSBorderType)) to integer(High(TvteXLSBorderType)) do
  begin
    Row := 1+j*2;
    Col := 1+(integer(High(TvteXLSBorderType))-i)*2;
    with sh.Ranges[Col,Row,Col,Row] do
      begin
        s1 := 'BorderType : '+Copy(GetEnumName(TypeInfo(TvteXLSBorderType),i),5,1000);
        s2 := 'LineStyleType : '+Copy(GetEnumName(TypeInfo(TvteXLSLineStyleType),j),5,1000);
        Value := s1+#10+s2;
        Borders[TvteXLSBorderType(i)].LineStyle := TvteXLSLineStyleType(j);
        Borders[TvteXLSBorderType(i)].Color := aDefaultColors[Random(MaxDefaultColors-2)+1];
        WrapText := true;
      end;
  end;
for i:=integer(Low(TvteXLSBorderType)) to integer(High(TvteXLSBorderType)) do
    sh.Cols[i*2+1].Width := 30*256;
end;

procedure TFormMain.AddFontsSheet(wb : TvteXLSWorkbook);
const
  MaxFontsVariants = 100;
  MaxFontsNames = 6;
  MaxColors = 16;
  aFonts : array[0..MaxFontsNames-1] of string =
           ('Arial',
            'Courier',
            'Lucida console',
            'Verdana',
            'Tahoma',
            'Times New Roman');
  aColors : array[0..MaxColors-1] of TColor =
            (clWhite,clBlack,clSilver,clGray,
             clRed,clMaroon,clYellow,clOlive,
             clLime,clGreen,clAqua,clTeal,
             clBlue,clNavy,clFuchsia,clPurple);
var
  sh : TvteXLSWorksheet;
  i: integer;
  s1 : string;
begin
  sh := wb.AddSheet;
  sh.Title := 'Fonts';
  for i:=0 to MaxFontsVariants do
    with sh.Ranges[1,i,1,i] do
      begin
        Font.Name := aFonts[Random(MaxFontsNames)];
        Font.Size := 6+Random(40);
        s1 := '';
        if Random(2)=1 then
          begin
            Font.Style := Font.Style+[fsBold];
            s1 := s1+'Bold,';
          end;
        if Random(2)=1 then
          begin
            Font.Style := Font.Style+[fsItalic];
            s1 := s1+'Italic,';
          end;
        if Random(2)=1 then
          begin
            Font.Style := Font.Style+[fsUnderline];
            s1 := s1+'Underline,';
          end;
        if Random(2)=1 then
          begin
            Font.Style := Font.Style+[fsStrikeout];
            s1 := s1+'Strikeout,';
          end;
        Delete(s1,Length(s1),1);
        Font.Color := aColors[1+Random(MaxColors-1)];
        Value := Font.Name+', '+IntToStr(Font.Size)+', ['+s1+']';
      end;
end;

procedure TFormMain.AddMergesSheet(wb : TvteXLSWorkbook);
var
  sh : TvteXLSWorksheet;
  i,x1,y1,x2,y2 : integer;
begin
  sh := wb.AddSheet;
  sh.Title := 'Merge';
  for i := 0 to 30 do
    sh.Cols[i].Width := 256*15;
  for i:=0 to 10 do
    begin
      x1 := Random(10);
      x2 := x1+Random(4);
      y1 := Random(30);
      y2 := y1+Random(5);
      with sh.Ranges[x1,y1,x2,y2] do
        begin
          VerticalAlignment := vtexlVAlignCenter;
          HorizontalAlignment := vtexlHAlignCenter;
          Value := SysUtils.Format('%d,%d,%d,%d',[x1,y1,x2,y2]);
          Borders[vtexlEdgeBottom].LineStyle := vtelsThin;
          Borders[vtexlEdgeTop].LineStyle := vtelsThin;
          Borders[vtexlEdgeLeft].LineStyle := vtelsThin;
          Borders[vtexlEdgeRight].LineStyle := vtelsThin;
        end;
    end;
end;

procedure TFormMain.AddFillsSheet(wb : TvteXLSWorkbook);
var
  sh : TvteXLSWorksheet;
  i,j : integer;
begin
  sh := wb.AddSheet;
  sh.Title := 'Fill';
  for j:=integer(Low(TvteXLSFillPattern)) to integer(High(TvteXLSFillPattern)) do
    begin
      for i:=0 to XLSMaxColorsInPalette-1 do
        begin
          with sh[j,i,j,i] do
            begin
              Value := GetEnumName(TypeInfo(TvteXLSFillPattern),j);
              FillPattern := TvteXLSFillPattern(j);
              ForegroundFillPatternColor := aDefaultColorPalette[i];
              BackgroundFillPatternColor := clWhite;
              VerticalAlignment := vtexlVAlignCenter;
            end;
          if j=0 then
            sh.Rows[i].Height := 20;
        end;
    end;
for j:=integer(Low(TvteXLSFillPattern)) to integer(High(TvteXLSFillPattern)) do
  sh.Cols[j].Width := Length(GetEnumName(TypeInfo(TvteXLSFillPattern),j))*256;
end;

procedure TFormMain.AddRotationsSheet(wb : TvteXLSWorkbook);
var
  sh : TvteXLSWorksheet;
  i : integer;
begin
  sh := wb.AddSheet;
  sh.Title := 'Rotation';
  for i:=0 to 255 do
    with sh[i mod 10,i div 10,i mod 10,i div 10] do
      begin
        Value := i;
        Rotation := i;
        VerticalAlignment := vtexlVAlignCenter;
        HorizontalAlignment := vtexlHAlignCenter;
      end;
end;

procedure TFormMain.AddLargeTextSheet(wb : TvteXLSWorkbook);
var
  sh : TvteXLSWorksheet;
begin
  sh := wb.AddSheet;
  sh.Title := 'LargeText';
  sh.Ranges[0,0,0,0].Value := Label1.Caption+#13#10+LargeText;
  sh.Ranges[0,0,0,0].WrapText := true;
  sh.Cols[0].Width := 80*256;
end;

procedure TFormMain.AddNumberFormatsSheet;
var
  y : integer;
  sh : TvteXLSWorksheet;

  procedure af(number : double; const format : string);
  begin
  sh.Ranges[0,y,0,y].Value := number;
  sh.Ranges[1,y,1,y].Value := number;
  sh.Ranges[1,y,1,y].Format := format;
  sh.Ranges[2,y,2,y].Value := format;
  sh.Ranges[2,y,2,y].HorizontalAlignment := vtexlHAlignRight;
  Inc(y);
  end;

begin
  sh := wb.AddSheet;
  sh.Title := 'NumberFormats';

  sh.Ranges[0,0,0,0].Value := 'Number';
  sh.Ranges[0,0,0,0].FillPattern := vtefpSolid;
  sh.Ranges[0,0,0,0].BackgroundFillPatternColor := clWhite;
  sh.Ranges[0,0,0,0].ForegroundFillPatternColor := $00FF00;
  sh.Cols[0].Width := 10*256;

  sh.Ranges[1,0,1,0].Value := 'Format';
  sh.Ranges[1,0,1,0].FillPattern := vtefpSolid;
  sh.Ranges[1,0,1,0].BackgroundFillPatternColor := clWhite;
  sh.Ranges[1,0,1,0].ForegroundFillPatternColor := $00FF00;
  sh.Cols[1].Width := 10*256;

  sh.Ranges[2,0,2,0].Value := 'Formatted number';
  sh.Ranges[2,0,2,0].FillPattern := vtefpSolid;
  sh.Ranges[2,0,2,0].BackgroundFillPatternColor := clWhite;
  sh.Ranges[2,0,2,0].ForegroundFillPatternColor := $00FF00;
  sh.Cols[2].Width := 20*256;

  y := 1;
  af(10123.456,'# ##0.00');
  af(10123.456,'#,0.00');
  af(10123.456,'0');
end;

procedure TFormMain.Build(wb : TvteXLSWorkbook);
begin
  wb.Clear;
  if CBorders.Checked then AddBordersSheet(wb);
  if CFonts.Checked then AddFontsSheet(wb);
  if CMerges.Checked then AddMergesSheet(wb);
  if CBackgrounds.Checked then AddFillsSheet(wb);
  if CRotations.Checked then AddRotationsSheet(wb);
  if CLargeText.Checked then AddLargeTextSheet(wb);
  if CFormats.Checked then AddNumberFormatsSheet(wb);
end;

end.
