//---------------------------------------------------------------------------

#include <vcl.h>
#include <typinfo.hpp>
#include <typeinfo.h>
#pragma hdrstop
#include "Main.h"
//---------------------------------------------------------------------------

#pragma package(smart_init)
#pragma resource "*.dfm"
TFormMain *FormMain;
//---------------------------------------------------------------------------
__fastcall TFormMain::TFormMain(TComponent* Owner)
        : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::Image1Click(TObject *Sender)
{
  ShellExecute(0,"open","http://www.vtktools.ru","","",SW_SHOWNORMAL);
}
//---------------------------------------------------------------------------

void __fastcall TFormMain::ButtonSaveClick(TObject *Sender)
{
AnsiString FileName;
TvteXLSWorkbook* wb;
TvteCustomWriter* Writer;

if (SaveDialog->Execute())
  {
    FileName = SaveDialog->FileName;
    if (ExtractFileExt(FileName).Length()==0)
      switch (SaveDialog->FilterIndex)
        {
           case 1: {FileName = FileName+".xls"; break;}
           case 2: {FileName = FileName+".htm"; break;}
        }
    wb = new TvteXLSWorkbook;
    try
      {
        Build(wb);
        switch (SaveDialog->FilterIndex)
          {
            case 1: {Writer = (TvteCustomWriter*)new TvteExcelWriter; break;}
            case 2: {Writer = (TvteCustomWriter*)new TvteHTMLWriter; break;}
          }
        try
          {
            Writer->Save(wb,FileName);
            delete Writer;
          }
        catch (...)
          {
            delete Writer;
          }
      delete wb;
      }
    catch (...)
      {
        delete wb;
      }
    if (COpen->Checked) 
      ShellExecute(0,"open",FileName.c_str(),"","",SW_SHOWNORMAL);
  }
}

void __fastcall TFormMain::Build(TvteXLSWorkbook* wb)
{
  wb->Clear();
  if (CBorders->Checked) AddBordersSheet(wb);
  if (CFonts->Checked) AddFontsSheet(wb);
  if (CMerges->Checked) AddMergesSheet(wb);
  if (CBackgrounds->Checked) AddFillsSheet(wb);
  if (CRotations->Checked) AddRotationsSheet(wb);
  if (CLargeText->Checked) AddLargeTextSheet(wb);
  if (CFormats->Checked) AddNumberFormatsSheet(wb);
}

PTypeInfo tp(void)
{
  PTypeInfo ti = new TTypeInfo;
  ti->Name = "TvteXLSBorderType";
  ti->Kind = tkEnumeration;
  return ti;
}

void __fastcall TFormMain::AddBordersSheet(TvteXLSWorkbook* wb)
{
TvteXLSWorksheet* sh;
TvteXLSRange* r;
int i,j,Row,Col;
char s[255];
//AnsiString s;
char* aBordersCaptions[vtexlEdgeTop+1] = {"DiagonalDown","DiagonalUp","EdgeBottom","EdgeLeft","EdgeRight","EdgeTop"};
char* aLineStylesCaptions[vtelsSlantedDashDot+1] = {"None","Thin","Medium","Dashed","Dotted","Thick",
	"Double","Hair","MediumDashed","DashDot","MediumDashDot","DashDotDot","MediumDashDotDot",
	"SlantedDashDot"};

sh = wb->AddSheet();
sh->Title = "Borders";
for (j=(int)vtelsNone; j<=(int)vtelsSlantedDashDot; j++)
  for (i=(int)vtexlDiagonalDown; i<=(int)vtexlEdgeTop; i++)
    {
      Row = 1+j*2;
      Col = 1+((int)vtexlEdgeTop-i)*2;
      r = sh->Ranges[Col][Row][Col][Row];
      wsprintf(s,"BorderType : %s \nLineStyleType : %s",aBordersCaptions[i],aLineStylesCaptions[j]);
      r->Value = s;
      r->Borders->Borders[(TvteXLSBorderType)i]->LineStyle = (TvteXLSLineStyleType)j;
      r->Borders->Borders[(TvteXLSBorderType)i]->Color = (TColor)aDefaultColors[random(MaxDefaultColors-2)+1];
      r->WrapText = true;
    }
for (i=(int)vtexlDiagonalDown; i<=(int)vtexlEdgeTop; i++)
  sh->Cols[1+i*2]->Width = 30*256;
}

void __fastcall TFormMain::AddFontsSheet(TvteXLSWorkbook* wb)
{
#define MaxFontsVariants 100
#define MaxFontsNames 6
#define MaxColors 16
char* aFonts[MaxFontsNames] = {"Arial","Courier","Lucida console","Verdana","Tahoma","Times New Roman"};
TColor aColors[MaxColors] =
            {clWhite,clBlack,clSilver,clGray,
             clRed,clMaroon,clYellow,clOlive,
             clLime,clGreen,clAqua,clTeal,
             clBlue,clNavy,clFuchsia,clPurple};

TvteXLSWorksheet *sh;
TvteXLSRange *r;
int i;
char s1[255],s2[255];

sh = wb->AddSheet();
sh->Title = "Fonts";
for (i=0; i<MaxFontsVariants; i++)
  {
    r = sh->Ranges[1][i][1][i];
    r->Font->Name = aFonts[random(MaxFontsNames)];
    r->Font->Size = 6+random(40);
    s1[0] = 0;
    if (random(2)==1)
      {
        r->Font->Style = r->Font->Style << fsBold;
        strcat(s1,"Bold,");
      }
    if (random(2)==1)
      {
        r->Font->Style = r->Font->Style << fsItalic;
        strcat(s1,"Italic,");
      }
    if (random(2)==1)
      {
        r->Font->Style = r->Font->Style << fsUnderline;
        strcat(s1,"Underline,");
      }
    if (random(2)==1)
      {
        r->Font->Style = r->Font->Style << fsStrikeOut;
        strcat(s1,"StrikeOut,");
      }
    s1[strlen(s1)] = 0;
    r->Font->Color = aColors[random(MaxColors)];
    wsprintf(s2,"%s, %d, [%s]",r->Font->Name.c_str(),r->Font->Size,s1);
    r->Value = s2;
  }
}

void __fastcall TFormMain::AddMergesSheet(TvteXLSWorkbook* wb)
{
TvteXLSWorksheet *sh;
TvteXLSRange *r;
int i,x1,y1,x2,y2;
char s[255];

sh = wb->AddSheet();
sh->Title = "Merge";
for (i=0; i<=30; i++)
  sh->Cols[i]->Width = 256*15;
for (i=0; i<=10; i++)
  {
    x1 = random(10);
    x2 = x1+random(4);
    y1 = random(30);
    y2 = y1+random(5);

    r = sh->Ranges[x1][y1][x2][y2];
    r->VerticalAlignment = vtexlVAlignCenter;
    r->HorizontalAlignment = vtexlHAlignCenter;
    wsprintf(s,"%d,%d,%d,%d",x1,y1,x2,y2);
    r->Value = s;
    r->Borders->Borders[vtexlEdgeBottom]->LineStyle = vtelsThin;
    r->Borders->Borders[vtexlEdgeTop]->LineStyle = vtelsThin;
    r->Borders->Borders[vtexlEdgeLeft]->LineStyle = vtelsThin;
    r->Borders->Borders[vtexlEdgeRight]->LineStyle = vtelsThin;
  }
}

void __fastcall TFormMain::AddFillsSheet(TvteXLSWorkbook* wb)
{
TvteXLSWorksheet *sh;
TvteXLSRange *r;
int i,j;
char* aPatternCaptions[vtefpVertical+1] = {"None", "Automatic", "Checker", "CrissCross", "Down", "Gray8",
	"Gray16", "Gray25", "Gray50", "Gray75", "Grid", "Horizontal", "LightDown", "LightHorizontal",
	"LightUp", "LightVertical", "SemiGray75", "Solid", "Up", "Vertical"};

sh = wb->AddSheet();
sh->Title = "Fill";
for (j=vtefpNone; j<=vtefpVertical; j++)
  for (i=0; i<XLSMaxColorsInPalette; i++)
    {
      r = sh->Ranges[j][i][j][i];
      r->Value = aPatternCaptions[j];
      r->FillPattern = (TvteXLSFillPattern)j;
      r->ForegroundFillPatternColor = clWhite;
      r->BackgroundFillPatternColor = aDefaultColorPalette[i];
      r->VerticalAlignment = vtexlVAlignCenter;
      if (j==0)
        sh->Rows[i]->Height = 20;
    }
for (j=vtefpNone; j<=vtefpVertical; j++)
  sh->Cols[j]->Width = strlen(aPatternCaptions[j])*256;
}

void __fastcall TFormMain::AddRotationsSheet(TvteXLSWorkbook* wb)
{
TvteXLSWorksheet *sh;
TvteXLSRange *r;
int i;

sh = wb->AddSheet();
sh->Title = "Rotation";
for (i=0; i<=255; i++)
  {
    r = sh->Ranges[i%10][i/10][i%10][i/10];
    r->Value = i;
    r->Rotation = i;
    r->VerticalAlignment = vtexlVAlignCenter;
    r->HorizontalAlignment = vtexlHAlignCenter;
  }
}

void __fastcall TFormMain::AddLargeTextSheet(TvteXLSWorkbook* wb)
{
#define LargeText "Welcome to vtkExport Library\r\nVtkExport library intended for export from your programs in the Excel and HTML formats.\r\nThe shaping XLS of the file happens without use DDE, OLE, i.e. to receive XLS the file necessarily, that on the computer Excel was installed!.\r\nThe method of export is very simple - you form object TvteXLSWorkBook, which has properties and methods similar to properties and methods OLE of the Excel server and call  him method SaveAsXLS or SaveAsHTML.\r\n(c) VtkTools, 2002"



TvteXLSWorksheet *sh;
TvteXLSRange *r;

sh = wb->AddSheet();
sh->Title = "LargeText";
r = sh->Ranges[0][0][0][0];
r->Value = LargeText;
r->WrapText = true;
sh->Cols[0]->Width = 80*256;
}

void af(TvteXLSWorksheet* sh, double number, char* format, int* y)
{
TvteXLSRange *r;

r = sh->Ranges[0][*y][0][*y];
r->Value = number;
r = sh->Ranges[1][*y][1][*y];
r->Value = number;
r->Format = format;
r = sh->Ranges[2][*y][2][*y];
r->Value = format;
r->HorizontalAlignment = vtexlHAlignRight;
*y = *y+1;
}

void __fastcall TFormMain::AddNumberFormatsSheet(TvteXLSWorkbook* wb)
{
TvteXLSWorksheet *sh;
TvteXLSRange *r;
int y;

sh = wb->AddSheet();
sh->Title = "NumberFormats";

r = sh->Ranges[0][0][0][0];
r->Value = "Number";
r->FillPattern = vtefpSolid;
r->BackgroundFillPatternColor = clWhite;
r->ForegroundFillPatternColor = (TColor)0x00FF00;
sh->Cols[0]->Width = 20*256;

r = sh->Ranges[1][0][1][0];
r->Value = "Format";
r->FillPattern = vtefpSolid;
r->BackgroundFillPatternColor = clWhite;
r->ForegroundFillPatternColor = (TColor)0x00FF00;
sh->Cols[1]->Width = 20*256;

r = sh->Ranges[2][0][2][0];
r->Value = "Formatted number";
r->FillPattern = vtefpSolid;
r->BackgroundFillPatternColor = clWhite;
r->ForegroundFillPatternColor = (TColor)0x00FF00;
sh->Cols[2]->Width = 20*256;

y = 1;
af(sh,10123.456,"# ##0.00",&y);
af(sh,10123.456,"#,0.00",&y);
af(sh,10123.456,"0",&y);
}
//---------------------------------------------------------------------------

