
{===============================================================}
{								}
{	Voice Communicator Demo II - Recording Setting module	}
{	a code by Lake Unanimated / unanimated@geocities.com	}
{								}
{								}
{	Copyright (c) 2000 Lake of Soft				}
{	All Rights Reserved					}
{								}
{===============================================================}
{$B-}

unit uVCDemoIIRecordSettings;

interface

uses
  Windows, Forms, StdCtrls, Controls, Classes, CheckLst, ExtCtrls, ComCtrls, Menus,
  MMSystem,
  AudioStreams, MsAcm;

type
  TformVCDemoIIRecordSettings = class(TForm)
    pmFormats: TPopupMenu;
    pmPCMFormats: TPopupMenu;
    gbPCMProps: TGroupBox;
    Label2: TLabel;
    Label3: TLabel;
    cbStereo: TCheckBox;
    cbRate: TComboBox;
    cbBPS: TComboBox;
    gbCodec: TGroupBox;
    Label1: TLabel;
    Label4: TLabel;
    laSuggestedFrm: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    cbCodecs: TComboBox;
    lbFormatTags: TListBox;
    clbPCMRestrictions: TCheckListBox;
    buPickCodecFormat: TButton;
    buPickPCMFormat: TButton;
    cbUseCodec: TCheckBox;
    gbPCMDevice: TGroupBox;
    cbDevices: TComboBox;
    Label5: TLabel;
    vcRec: TAudioInStream;
    laManuf: TLabel;
    laDevVersion: TLabel;
    laPID: TLabel;
    laDevStereo: TLabel;
    buOK: TButton;
    buCancel: TButton;
    gbDescription: TGroupBox;
    laDetails: TLabel;
    edCodecFullName: TEdit;
    Label8: TLabel;
    procedure cbCodecsChange(Sender: TObject);
    procedure cbUseCodecClick(Sender: TObject);
    procedure lbFormatTagsClick(Sender: TObject);
    procedure buPickCodecFormatClick(Sender: TObject);
    procedure cbStereoClick(Sender: TObject);
    procedure cbBPSChange(Sender: TObject);
    procedure cbRateChange(Sender: TObject);
    procedure buPickPCMFormatClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure cbDevicesChange(Sender: TObject);
  private
    { Private declarations }
    fPCMWaveFormat: tWaveFormatEx;
    fLastDrvIndex : Integer;
    fLastDevIndex : Integer;
    fLastFormatTag: Integer;
    procedure EnumCodecs;
    procedure EnumFormatTags;
    function  GetDriver: tMsAcmDriver;
    procedure SetDriverIndex(Value: Integer);
    function  GetUseCodec: Boolean;
    procedure SetUseCodec(Value: Boolean);
    function  GetPCMBPS: Byte;
    function  GetPCMRate: Integer;
    function  GetPCMStereo: Boolean;
    procedure SetPCMBPS(Value: Byte);
    procedure SetPCMRate(Value: Integer);
    procedure SetPCMStereo(Value: Boolean);
    procedure MakePCMWaveFormat;
    procedure SuggestFormat;
    procedure SetFormatTag(Value: Integer);
    procedure MyOnFormatPickClick(Sender: tObject);
    function  GetPCMBits: string;
    procedure SetPCMBits(const Value: string);
    procedure ShowDstFormat;
    procedure CreateSuggestPopup(aPopup: tPopupMenu; aFormatTag: DWORD; aHandler: tNotifyEvent; CheckConvert: Boolean = True);
    procedure MyOnPCMFormatPickClick(Sender: tObject);
    procedure RestoreSettings;
    procedure SaveSettings;
    procedure EnumDevices;
    procedure SetDevIndex(Value: Integer);
    procedure ShowDetails;
    property  InternalDriverIndex: Integer read fLastDrvIndex write SetDriverIndex;
    property  InternalDeviceIndex: Integer read fLastDevIndex write SetDevIndex;
  public
    { Public declarations }
    procedure Visit;
    function LocateDriver(aPid, aMid: Cardinal): Boolean;
    function LocateDevice(aPid, aMid: Cardinal): Boolean;
    //
    property CurDriver  : tMsAcmDriver read GetDriver;
    property FormatTag  : Integer read fLastFormatTag write SetFormatTag;
    property UseCodec   : Boolean read GetUseCodec write SetUseCodec;
    property pcmStereo  : Boolean read GetPCMStereo write SetPCMStereo;
    property pcmBPS     : Byte read GetPCMBPS write SetPCMBPS;
    property pcmRate    : Integer read GetPCMRate write SetPCMRate;
    property PCMBits    : string read GetPCMBits write SetPCMBits;
  end;

var
  formVCDemoIIRecordSettings: TformVCDemoIIRecordSettings;

implementation

uses
  SysUtils, CoreAPITools, uVCDemoIIMain;

{$R *.DFM}

procedure TformVCDemoIIRecordSettings.EnumCodecs;
var
  i: Integer;
begin
  with formVCDemoIIMain.MsAcm do begin
    EnumDrivers;
    with cbCodecs do begin
      Clear;
      for i := 0 to Drivers.Count - 1 do
	if Driver[i].Enabled then Items.Add(Driver[i].Details.szShortName)
			     else Items.Add('[dis.] - ' + Driver[i].Details.szShortName);
      if (Items.Count > 0) then with formVCDemoIIMain.Storage do begin
	LocateDriver(AsInteger['Record.Codec.Driver.PID'], AsInteger['Record.Codec.Driver.MID']);
	FormatTag := AsInteger['Record.Codec.FormatTag'];
      end;
    end;
  end;
end;

procedure TformVCDemoIIRecordSettings.EnumDevices;
var
  i: Integer;
begin
  with cbDevices.Items, vcRec do begin
    Clear;
    for i := 0 to DevCount - 1 do Add(DevName[i]);
  end;
end;

function TformVCDemoIIRecordSettings.GetDriver: tMsAcmDriver;
begin
  if (cbCodecs.ItemIndex >= 0) then Result := formVCDemoIIMain.MsAcm.Driver[cbCodecs.ItemIndex]
			       else Result := nil;
end;

procedure TformVCDemoIIRecordSettings.cbCodecsChange(Sender: TObject);
begin
  fLastFormatTag := -1;
  InternalDriverIndex := cbCodecs.ItemIndex;
end;

procedure TformVCDemoIIRecordSettings.SetDriverIndex(Value: Integer);
begin
  if (fLastDrvIndex <> Value) then begin
    fLastDrvIndex := Value;
    cbCodecs.ItemIndex := Min(cbCodecs.Items.Count -1, Value);
    EnumFormatTags;
    if Assigned(CurDriver) then edCodecFullName.Text := CurDriver.Details.szLongName
			   else edCodecFullName.Text := '';
  end;
end;

procedure TformVCDemoIIRecordSettings.EnumFormatTags;
var
  i: Integer;
begin
  if Assigned(CurDriver) then with CurDriver do begin
    EnumFormatTags;
    with lbFormatTags do begin
      Clear;
      for i := 0 to FormatTags.Count - 1 do
	if (FormatTag[i].Details.dwFormatTag <> WAVE_FORMAT_PCM) then Items.AddObject(FormatTag[i].Details.szFormatTag, Pointer(FormatTag[i].Details.dwFormatTag));
      if (Items.Count > 0) then Self.FormatTag := DWORD(Items.Objects[0]);
    end;
  end;
end;

procedure TformVCDemoIIRecordSettings.cbUseCodecClick(Sender: TObject);
begin
  UseCodec := cbUseCodec.Checked;
end;

function TformVCDemoIIRecordSettings.GetUseCodec: Boolean;
begin
  Result := cbUseCodec.Checked;
end;

procedure TformVCDemoIIRecordSettings.SetUseCodec(Value: Boolean);
begin
//  if (UseCodec <> Value) then begin
    cbUseCodec.Checked := Value;
    gbCodec.Visible := Value;
    if Value and (cbCodecs.Items.Count < 1) then EnumCodecs
					    else ShowDetails;
//  end;
end;

function TformVCDemoIIRecordSettings.GetPCMBPS: Byte;
begin
  Result := Str2Int(cbBPS.Text, 8);
end;

function TformVCDemoIIRecordSettings.GetPCMRate: Integer;
begin
  Result := Str2Int(cbRate.Text, 11025);
end;

function TformVCDemoIIRecordSettings.GetPCMStereo: Boolean;
begin
  Result := cbStereo.Checked;
end;

procedure TformVCDemoIIRecordSettings.SetPCMBPS(Value: Byte);
begin
  cbBPS.Text := IntToStr(Value);
end;

procedure TformVCDemoIIRecordSettings.SetPCMRate(Value: Integer);
begin
  cbRate.Text := IntToStr(Value);
end;

procedure TformVCDemoIIRecordSettings.SetPCMStereo(Value: Boolean);
begin
  cbStereo.Checked := Value;
end;

procedure TformVCDemoIIRecordSettings.lbFormatTagsClick(Sender: TObject);
begin
  with lbFormatTags do FormatTag := DWORD(Items.Objects[ItemIndex]);
end;

procedure TformVCDemoIIRecordSettings.MakePCMWaveFormat;
begin
  FillChar(fPCMWaveFormat, SizeOf(fPCMWaveFormat), #0);
  with fPCMWaveFormat do begin
    wFormatTag := WAVE_FORMAT_PCM;
    if pcmStereo then nChannels := 2
		 else nChannels := 1;
    nSamplesPerSec  := pcmRate;
    wBitsPerSample  := pcmBPS;
    nBlockAlign     := (wBitsPerSample * nChannels) shr 3;
    nAvgBytesPerSec := nSamplesPerSec * nBlockAlign;
    cbSize := 0;
  end;
end;

procedure TformVCDemoIIRecordSettings.CreateSuggestPopup(aPopup: tPopupMenu; aFormatTag: DWORD; aHandler: tNotifyEvent; CheckConvert: Boolean = True);
var
  i: Integer;
  lFlags: DWORD;
  lMI   : tMenuItem;
begin
  if Assigned(CurDriver) then with CurDriver, aPopup do begin
    {$IFDEF VER120}
    while (Items.Count > 0) do Items.Delete(0);
    {$ELSE}
    Items.Clear;
    {$ENDIF}
    lFlags := ACM_FORMATENUMF_WFORMATTAG;
    MakePCMWaveFormat;
    with WaveFormatForEnum^, clbPCMRestrictions do begin
      wFormatTag := aFormatTag;
      if Checked[0] then begin
	nChannels := fPCMWaveFormat.nChannels;
	lFlags := lFlags + ACM_FORMATENUMF_NCHANNELS;
      end;
      if Checked[1] then begin
	wBitsPerSample := fPCMWaveFormat.wBitsPerSample;
	lFlags := lFlags + ACM_FORMATENUMF_WBITSPERSAMPLE;
      end;
      if Checked[2] then begin
	nSamplesPerSec := fPCMWaveFormat.nSamplesPerSec;
	lFlags := lFlags + ACM_FORMATENUMF_NSAMPLESPERSEC;
      end;
    end;
    EnumFormats(aFormatTag, lFlags);
    for i := 0 to Formats.Count - 1 do begin
      lMI := tMenuItem.Create(pmFormats);
      lMI.Caption := Format[i].Details.szFormat;
      lMI.Tag     := DWORD(Format[i].Details.pwfx);
      lMI.OnClick := aHandler;
      if CheckConvert then lMI.Enabled := (acmStreamOpen(nil, CurDriver.OpenHandle, fPCMWaveFormat, Format[i].Details.pwfx^, nil, 0, 0, ACM_STREAMOPENF_QUERY + ACM_STREAMOPENF_NONREALTIME) = 0);
      Items.Add(lMI);
    end;
  end;
end;

procedure TformVCDemoIIRecordSettings.buPickCodecFormatClick(Sender: TObject);
begin
  CreateSuggestPopup(pmFormats, FormatTag, MyOnFormatPickClick);
  if (pmFormats.Items.Count > 0) then
    with buPickCodecFormat do pmFormats.Popup(ClientOrigin.x + Width shr 1, ClientOrigin.y + Height + 2)
  else InfoMessageBox('No codec format available', 'Information', MB_ICONINFORMATION + MB_OK, Handle);
end;

procedure TformVCDemoIIRecordSettings.ShowDetails;
var
  S: string;
begin
  if (InternalDeviceIndex >= 0) and Showing then begin
    S := Format('So, audio will be recordered via %s device as %s stream with %d samples per second and %d bits per sample',
		[vcRec.DevName[InternalDeviceIndex], BoolStr(pcmStereo, 'mono', 'stereo'), pcmRate, pcmBPS]);
    if UseCodec and Assigned(CurDriver) then
      if (FormatTag >= 0) then begin
	MakePCMWaveFormat;
	if (acmStreamOpen(nil, CurDriver.OpenHandle, fPCMWaveFormat, formVCDemoIIMain.CodecWaveFormat^, nil, 0, 0, ACM_STREAMOPENF_QUERY + ACM_STREAMOPENF_NONREALTIME) = 0) then
	     S := S + Format('. Then it will be passed to %s codec and converted into following %s.', [cbCodecs.Text, {LowerCase(}laSuggestedFrm.Caption{)}])
	else S := S + '. No codec will be used, because current one does not support conversion from selected PCM format to selected codec format.';
      end
      else S := S + '. No codec format selected, so codec will not be used.'
    else S := S + '. No codec will be used.';
    laDetails.Caption := S;
  end
  else laDetails.Caption := 'So, audio will not be recordered, due to lack of audio devices...'
end;

procedure TformVCDemoIIRecordSettings.ShowDstFormat;
begin
  laSuggestedFrm.Caption := 'Suggested Format: ' + GetFormatDescription(formVCDemoIIMain.CodecWaveFormat^, CurDriver.OpenHandle);
  ShowDetails;
end;

procedure TformVCDemoIIRecordSettings.SuggestFormat;
var
  lFlags: DWORD;
begin
  if Assigned(CurDriver) and (lbFormatTags.ItemIndex >= 0) then begin
    MakePCMWaveFormat;
    with formVCDemoIIMain, CodecWaveFormat^ do begin
      wFormatTag := FormatTag;
      cbSize     := CodecWFCBSize;
    end;
    lFlags := ACM_FORMATSUGGESTF_WFORMATTAG;
    with formVCDemoIIMain, CodecWaveFormat^, clbPCMRestrictions do begin
      if Checked[0] then begin
	nChannels := fPCMWaveFormat.nChannels;
	lFlags := lFlags + ACM_FORMATSUGGESTF_NCHANNELS;
      end;
      if Checked[1] then begin
	wBitsPerSample := fPCMWaveFormat.wBitsPerSample;
	lFlags := lFlags + ACM_FORMATSUGGESTF_WBITSPERSAMPLE;
      end;
      if Checked[2] then begin
	nSamplesPerSec := fPCMWaveFormat.nSamplesPerSec;
	lFlags := lFlags + ACM_FORMATSUGGESTF_NSAMPLESPERSEC;
      end;
      if CurDriver.SuggestCodecFormat(fPCMWaveFormat, CodecWaveFormat^, lFlags) then ShowDstFormat
      else begin
	laSuggestedFrm.Caption := 'Suggested format: <none>';
	ShowDetails;
      end;
    end;
  end
  else begin
    laSuggestedFrm.Caption  := 'No codec or format is selected..';
    buPickCodecFormat.Enabled := False;
    ShowDetails;
  end;  
end;

procedure TformVCDemoIIRecordSettings.SetFormatTag(Value: Integer);
begin
  if (fLastFormatTag <> Value) then begin
    fLastFormatTag := Value;
    lbFormatTags.ItemIndex := lbFormatTags.Items.IndexOfObject(Pointer(Value));
    if (lbFormatTags.ItemIndex < 0) then fLastFormatTag := -1;
    buPickCodecFormat.Enabled := (fLastFormatTag >= 0);
    SuggestFormat;
  end;
end;

procedure TformVCDemoIIRecordSettings.cbStereoClick(Sender: TObject);
begin
  SuggestFormat;
end;

procedure TformVCDemoIIRecordSettings.cbBPSChange(Sender: TObject);
begin
  SuggestFormat;
end;

procedure TformVCDemoIIRecordSettings.cbRateChange(Sender: TObject);
begin
  SuggestFormat;
end;

procedure TformVCDemoIIRecordSettings.MyOnFormatPickClick(Sender: tObject);
begin
  with (Sender as tMenuItem) do
    Move(Pointer(Tag)^, formVCDemoIIMain.CodecWaveFormat^, SizeOf(tWaveFormatEx) + pWaveFormatEx(Tag).cbSize);
  ShowDstFormat;
end;

function TformVCDemoIIRecordSettings.GetPCMBits: string;
var
  i: Integer;
begin
  Result := '';
  with clbPCMRestrictions do
    for i := 0 to Items.Count - 1 do
      if Checked[i] then Result := Result + '1'
		    else Result := Result + '0';
end;

procedure TformVCDemoIIRecordSettings.SetPCMBits(const Value: string);
var
  i: Integer;
begin
  for i := 1 to Length(Value) do
    clbPCMRestrictions.Checked[i - 1] := (Value[i] = '1');
end;

procedure TformVCDemoIIRecordSettings.buPickPCMFormatClick(Sender: TObject);
begin
  CreateSuggestPopup(pmPCMFormats, WAVE_FORMAT_PCM, MyOnPCMFormatPickClick, False);
  with buPickPCMFormat do pmPCMFormats.Popup(ClientOrigin.x + Width shr 1, ClientOrigin.y + Height + 2);
end;

procedure TformVCDemoIIRecordSettings.MyOnPCMFormatPickClick(Sender: tObject);
begin
  with (Sender as tMenuItem), pWaveFormatEx(Tag)^ do begin
    pcmStereo := (nChannels > 1);
    pcmBPS    := wBitsPerSample;
    pcmRate   := nSamplesPerSec;
    SuggestFormat;
  end;
end;

procedure TformVCDemoIIRecordSettings.Visit;
begin
  if (ShowModal = mrOK) then SaveSettings
			else RestoreSettings;
end;

procedure TformVCDemoIIRecordSettings.RestoreSettings;
begin
  fLastDrvIndex  := -1;
  fLastDevIndex  := -1;
  fLastFormatTag := -1;
  cbCodecs.Clear;
  lbFormatTags.Clear;
  with formVCDemoIIMain.Storage do begin
    LocateDevice(AsInteger['Record.Device.PID'], AsInteger['Record.Device.MID']);
    pcmStereo := AsBoolean['Record.Stereo'];
    pcmBPS    := Read_Integer('Record.BPS', 8);
    pcmRate   := Read_Integer('Record.Rate', 11025);
    PCMBits   := AsString ['Record.Codec.PCMBits'];
    UseCodec  := AsBoolean['Record.UseCodec'];
    Str2WaveFormatEx(AsString['Record.Codec.Format'], formVCDemoIIMain.CodecWaveFormat^, SizeOf(tWaveFormatEx) + formVCDemoIIMain.CodecWFCBSize);
  end;
  //ShowDetails;
end;

procedure TformVCDemoIIRecordSettings.SaveSettings;
var
  lDevCaps: WaveInCaps;
begin
  with formVCDemoIIMain.Storage do begin
    AsBoolean['Record.UseCodec']  := UseCodec;
    AsBoolean['Record.Stereo']    := pcmStereo;
    AsInteger['Record.BPS']       := pcmBPS;
    AsInteger['Record.Rate']      := pcmRate;
    if (vcRec.GetDevCaps(InternalDeviceIndex, lDevCaps) = MMSYSERR_NOERROR) then with lDevCaps do begin
      AsInteger['Record.Device.PID'] := wPid;
      AsInteger['Record.Device.MID'] := wMid;
    end;
    if Assigned(CurDriver) then with CurDriver.Details^ do begin
      AsInteger['Record.Codec.Driver.PID'] := wPid;
      AsInteger['Record.Codec.Driver.MID'] := wMid;
    end;
    AsInteger['Record.Codec.FormatTag'] := FormatTag;
    AsString ['Record.Codec.PCMBits']   := PCMBits;
    AsString ['Record.Codec.Format']    := WaveFormatEx2Str(formVCDemoIIMain.CodecWaveFormat^);
    // just for visual presentation
    if Assigned(CurDriver) then begin
      AsString ['Record.Codec.Driver.Name'] := cbCodecs.Text;
      with lbFormatTags do
	if (ItemIndex >= 0) then AsString ['Record.Codec.Format.Name'] := Items[ItemIndex];
    end;
  end;
end;

procedure TformVCDemoIIRecordSettings.SetDevIndex(Value: Integer);
var
  lDevCaps: WaveInCaps;
begin
  if (fLastDevIndex <> Value) then begin
    fLastDevIndex := Value;
    cbDevices.ItemIndex := Min(cbDevices.Items.Count - 1, Value);
    if (vcRec.GetDevCaps(Value, lDevCaps) = MMSYSERR_NOERROR) then with lDevCaps do begin
      laManuf.Caption   := 'Manufacturer: ' + MID2Str(wMid);
      laPID.Caption     := 'Product ID: ' + IntToStr(wPid);
      laDevVersion.Caption := 'Version: ' + IntToStr(vDriverVersion shr 8) + '.' + IntToStr(vDriverVersion and $FF);
      laDevStereo.Caption  := 'Stereo: ' + BoolStr(wChannels > 1, 'No', 'Yes');
    end;
  end;
end;

procedure TformVCDemoIIRecordSettings.FormCreate(Sender: TObject);
begin
  EnumDevices;
end;

procedure TformVCDemoIIRecordSettings.FormActivate(Sender: TObject);
begin
  RestoreSettings;
end;

function TformVCDemoIIRecordSettings.LocateDevice(aPid, aMid: Cardinal): Boolean;
begin
  InternalDeviceIndex := vcRec.DeviceIndexByPidMid(aPid, aMid);
  Result := (InternalDeviceIndex >= 0);
  if not Result then
    if (aPid + aMid = 0) then InternalDeviceIndex := 0
			 else InternalDeviceIndex := -1;
end;

function TformVCDemoIIRecordSettings.LocateDriver(aPid, aMid: Cardinal): Boolean;
begin
  InternalDriverIndex := formVCDemoIIMain.MsAcm.DriverIndexByPidMid(aPid, aMid);
  Result := (InternalDriverIndex >= 0);
  if not Result then
    if (aPid + aMid = 0) then InternalDriverIndex := 0
			 else InternalDriverIndex := -1;
end;

procedure TformVCDemoIIRecordSettings.cbDevicesChange(Sender: TObject);
begin
  InternalDeviceIndex := cbDevices.ItemIndex;
end;

end.

