
{===============================================================}
{								}
{	Voice Communicator Demo II - main module		}
{	a code by Lake Unanimated / unanimated@geocities.com	}
{								}
{								}
{	Copyright (c) 2000 Lake of Soft				}
{	All Rights Reserved					}
{								}
{===============================================================}
{$B-}

unit uVCDemoIIMain;

interface

uses
  Windows, Forms, StdCtrls, Classes, Controls, MMSystem,
  VoiceCenter, IniThorax, MsAcm, CheckLst, ExtCtrls, ComCtrls, AudioStreams;

type
  TformVCDemoIIMain = class(TForm)
    vcRecMain: TVoiceRecorder;
    vcIpTmsMain: TipVoiceTransmitter;
    vcIpRcvMain: TipVoiceReceiver;
    vcPlayMain: TVoicePlayer;
    vcInStreamCodec: TVoiceConverter;
    vcPtMain: TVoiceProtocolTransmitter;
    vcPrMain: TVoiceProtocolReceiver;
    vcOutStreamCodec: TVoiceConverter;
    tiMain: TTimer;
    sbMain: TStatusBar;
    paLeft: TPanel;
    gbAuIn: TGroupBox;
    buRecSettings: TButton;
    bRecActivate: TButton;
    bRecDeactivate: TButton;
    gbPCMInfo: TGroupBox;
    laPCMRecordFormat: TLabel;
    laPCM_Size: TLabel;
    gbRecCodecInfo: TGroupBox;
    laCodecFormat: TLabel;
    laCodec_Size: TLabel;
    laInRation: TLabel;
    gbipTrans: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    laipTransSize: TLabel;
    laTransCPS: TLabel;
    edTrPort: TEdit;
    edTrAddr: TEdit;
    bipvtActivate: TButton;
    bipvtDeactivate: TButton;
    paRight: TPanel;
    gbAuOut: TGroupBox;
    bvpMainActivate: TButton;
    bvpMainDeactivate: TButton;
    gbipRcv: TGroupBox;
    Label3: TLabel;
    laRecvdSize: TLabel;
    edRcvPort: TEdit;
    bipvrActivate: TButton;
    bipvrDeactivate: TButton;
    laInBufSize: TLabel;
    tbInBufSize: TTrackBar;
    lbStreamProv: TListBox;
    gbPCMOutInfo: TGroupBox;
    laPCMPlayFormat: TLabel;
    laPlayStream_Size: TLabel;
    gbDeCodec: TGroupBox;
    laOutCodecInSize: TLabel;
    Label5: TLabel;
    cbipRcvAA: TCheckBox;
    cbPlayMainAA: TCheckBox;
    cbPlayDevice: TComboBox;
    Label4: TLabel;
    vcAuDev: TAudioOutStream;
    Panel3: TPanel;
    stRegNow: TStaticText;
    laCodecDriverName: TLabel;
    laCodecFormatName: TLabel;
    buRegMoreInfo: TButton;
    laOutDriverName: TLabel;
    paCenter: TPanel;
    cbipTransAA: TCheckBox;
    procedure buRecSettingsClick(Sender: TObject);
    procedure vcRecMainActivate(Sender: TObject);
    procedure bRecActivateClick(Sender: TObject);
    procedure bRecDeactivateClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure vcRecMainNewData(Sender: TObject; aData: Pointer; aSize: Cardinal);
    procedure vcIpTmsMainNewData(Sender: TObject; aData: Pointer; aSize: Cardinal);
    procedure bipvtActivateClick(Sender: TObject);
    procedure vcIpTmsMainActivate(Sender: TObject);
    procedure bipvtDeactivateClick(Sender: TObject);
    procedure bipvrActivateClick(Sender: TObject);
    procedure bipvrDeactivateClick(Sender: TObject);
    procedure vcIpRcvMainActivate(Sender: TObject);
    procedure bvpMainActivateClick(Sender: TObject);
    procedure bvpMainDeactivateClick(Sender: TObject);
    procedure vcPlayMainActivate(Sender: TObject);
    procedure vcIpRcvMainNewData(Sender: TObject; aData: Pointer; aSize: Cardinal);
    procedure vcInStreamCodecNewData(Sender: TObject; aData: Pointer; aSize: Cardinal);
    procedure vcPlayMainNewData(Sender: TObject; aData: Pointer; aSize: Cardinal);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure vcPrMainError(Sender: TObject; aErrorCode: Integer; var aHandled: Boolean);
    procedure vcPrMainFormatSuggest(Sender: tObject; const aSrcFormat: string; var aDstFormat: string);
    procedure vcOutStreamCodecNewData(Sender: TObject; aData: Pointer; aSize: Cardinal);
    procedure vcOutStreamCodecActivate(Sender: TObject);
    procedure tiMainTimer(Sender: TObject);
    procedure tbInBufSizeChange(Sender: TObject);
    procedure vcPtMainNewData(Sender: TObject; aData: Pointer; aSize: Cardinal);
    procedure vcPrMainBeforeAcceptStream(Sender: TObject; const aStreamHdr, aDstFormat: string; var DoAccept: Boolean);
    procedure vcPrMainDeactivate(Sender: TObject);
    procedure stRegNowClick(Sender: TObject);
    procedure buRegMoreInfoClick(Sender: TObject);
  private
    { Private declarations }
    fStorage  : tIniStorage;
    fMsAcm    : tMsAcm;
    fPCMWaveFormat  : tWaveFormatEx;
    fCodecWaveFormat: pWaveFormatEx;
    fCodecWFCBSize  : DWORD;
    fTransTicks     : Cardinal;
    procedure ShowFormats;
    function  GetPCMWaveFormat: pWaveFormatEx;
    function  FeelOK: Boolean;
    procedure EnumPlayDevices;
    procedure ActivateReceiver;
    procedure ActivatePlayer;
    procedure ActivateRecorder;
    procedure ActivateTransmitter;
    function  GetPlayDevNum: Integer;
    procedure SetPlayDevNum(Value: Integer);
    function  GetInCodecUsed: Boolean;
    procedure DeactivatePlayer;
    procedure DeactivateRecorder;
  public
    { Public declarations }
    property Storage: tIniStorage read fStorage;
    property MsAcm  : tMsAcm read fMsAcm;
    property PCMWaveFormat  : pWaveFormatEx read GetPCMWaveFormat;
    property CodecWaveFormat: pWaveFormatEx read fCodecWaveFormat;
    property CodecWFCBSize  : DWORD read fCodecWFCBSize;
    property PlayDevNum     : Integer read GetPlayDevNum write SetPlayDevNum;
    property InCodecUsed    : Boolean read GetInCodecUsed;
  end;

var
  formVCDemoIIMain: TformVCDemoIIMain;

implementation

uses
  SysUtils, Graphics,
  CoreAPITools, uVCDemoIIRecordSettings, ShellAPI, uVCDemoIIInfo;

{$R *.DFM}

procedure TformVCDemoIIMain.buRecSettingsClick(Sender: TObject);
begin
  formVCDemoIIRecordSettings.Visit;
  ShowFormats;
end;

procedure TformVCDemoIIMain.vcRecMainActivate(Sender: TObject);
begin
  if not (csDestroying in ComponentState) then begin
    bRecActivate.Enabled   := not vcRecMain.Active;
    bRecDeactivate.Enabled := vcRecMain.Active;
  end;
end;

procedure TformVCDemoIIMain.bRecActivateClick(Sender: TObject);
begin
  ActivateRecorder;
end;

procedure TformVCDemoIIMain.bRecDeactivateClick(Sender: TObject);
begin
  DeactivateRecorder;
end;

procedure tformVCDemoIIMain.DeactivateRecorder;
begin
  vcRecMain.Close;
  vcPtMain.Close;
end;

procedure TformVCDemoIIMain.EnumPlayDevices;
var
  i: Integer;
begin
  with cbPlayDevice.Items, vcAuDev do begin
    Clear;
    for i := 0 to DevCount - 1 do Add(DevName[i]);
  end;
end;

procedure TformVCDemoIIMain.FormCreate(Sender: TObject);
begin
  fStorage := tIniStorage.CreateStorage('VCDemoII.ini');
  fStorage.Section := 'Settings';
  fMsAcm   := tMsAcm.Create;
  fCodecWFCBSize   := Max(MsAcm.MaxFormatSize, SizeOf(fCodecWaveFormat^)) - SizeOf(fCodecWaveFormat^);
  fCodecWaveFormat := AllocMem(SizeOf(fCodecWaveFormat^) + fCodecWFCBSize);
  vcPrMain.MsACM   := fMsAcm;
  EnumPlayDevices;
  with fStorage do begin
    edTrPort.Text  := Read_String('IP.Trans.Port', vcIpTmsMain.Port);
    edTrAddr.Text  := Read_String('IP.Trans.Addr', '127.0.0.1');
    edRcvPort.Text := Read_String('IP.Receiver.Port',    vcIpRcvMain.Port);
    tbInBufSize.Position := Read_Integer('Record.BufSizeMlt', 4);
    cbipRcvAA.Checked    := Read_Boolean('IP.Receiver.AA', True);
    cbPlayMainAA.Checked := Read_Boolean('Play.AA', True);
    cbipTransAA.Checked  := Read_Boolean('IP.Trans.AA', True);
    PlayDevNum     := vcPlayMain.Stream.DeviceIndexByPidMid(AsInteger['Play.Device.Pid'], AsInteger['Play.Device.Mid']);
    if (PlayDevNum < 0) then PlayDevNum := 0;
  end;
  ShowFormats;
  if cbipRcvAA.Checked then ActivateReceiver;
  //if cbPlayMainAA.Checked then ActivatePlayer;
  if cbipTransAA.Checked then ActivateTransmitter;
end;

procedure TformVCDemoIIMain.FormDestroy(Sender: TObject);
begin
  fMsAcm.Free;
  fStorage.Free;
  ReallocMem(fCodecWaveFormat, 0);
end;

procedure TformVCDemoIIMain.vcRecMainNewData(Sender: TObject; aData: Pointer; aSize: Cardinal);
begin
  if FeelOK then
    laPCM_Size.Caption := 'Stream: ' + Int2Str(vcRecMain.HandledSize, '`') + ' bytes';
end;

procedure TformVCDemoIIMain.ShowFormats;
begin
  if FeelOK then begin
    laPCMRecordFormat.Caption := 'Format: ' + GetFormatDescription(PCMWaveFormat^, 0);
    laPCMPlayFormat.Caption   := 'Format: ' + GetFormatDescription(vcPlayMain.Stream.WaveFormat^, 0);
    with fStorage, gbRecCodecInfo do begin
      Visible := InCodecUsed;
      if Visible then begin
	Str2WaveFormatEx(AsString['Record.Codec.Format'], CodecWaveFormat^, SizeOf(tWaveFormatEx) + CodecWFCBSize);
	laCodecFormat.Caption := 'Format: ' + GetFormatDescription(CodecWaveFormat^, 0, '<not supported>');
	laCodecDriverName.Caption := 'Driver: ' + Read_String('Record.Codec.Driver.Name', '<none>');
	laCodecFormatName.Caption := ' - ' + Read_String('Record.Codec.Format.Name', '<none>');
      end;
    end;
  end;
end;

function TformVCDemoIIMain.GetPCMWaveFormat: pWaveFormatEx;
var
  lCn: Integer;
begin
  with fStorage do begin
    if AsBoolean['Record.Stereo'] then lCn := 2
				  else lCn := 1;
    MakePCMWaveFormatEx(fPCMWaveFormat, Read_Integer('Record.Rate', 11025), Read_Integer('Record.BPS', 8), lCn);
  end;
  Result := @fPCMWaveFormat;
end;

procedure TformVCDemoIIMain.vcIpTmsMainNewData(Sender: TObject; aData: Pointer; aSize: Cardinal);
begin
  if FeelOK then
    laipTransSize.Caption := 'Trasmitted: ' + Int2Str(vcIpTmsMain.HandledSize, '`') + ' bytes';
end;

procedure TformVCDemoIIMain.bipvtActivateClick(Sender: TObject);
begin
  ActivateTransmitter;
end;

procedure TformVCDemoIIMain.vcIpTmsMainActivate(Sender: TObject);
begin
  if FeelOK then begin
    bipvtActivate.Enabled   := not vcIpTmsMain.Active;
    bipvtDeactivate.Enabled := vcIpTmsMain.Active;
    fTransTicks := 0;
  end;
end;

procedure TformVCDemoIIMain.bipvtDeactivateClick(Sender: TObject);
begin
  vcIpTmsMain.Close;
end;

procedure TformVCDemoIIMain.bipvrActivateClick(Sender: TObject);
begin
  ActivateReceiver;
end;

procedure TformVCDemoIIMain.bipvrDeactivateClick(Sender: TObject);
begin
  vcIpRcvMain.Close;
end;

procedure TformVCDemoIIMain.vcIpRcvMainActivate(Sender: TObject);
begin
  if FeelOK then begin
    bipvrActivate.Enabled   := not vcIpRcvMain.Active;
    bipvrDeactivate.Enabled := vcIpRcvMain.Active;
  end;
end;

function TformVCDemoIIMain.FeelOK: Boolean;
begin
  Result := not (csDestroying in ComponentState);
end;

procedure TformVCDemoIIMain.bvpMainActivateClick(Sender: TObject);
begin
  ActivatePlayer;
end;

procedure TformVCDemoIIMain.bvpMainDeactivateClick(Sender: TObject);
begin
  DeactivatePlayer;
end;

procedure tformVCDemoIIMain.DeactivatePlayer;
begin
  vcPlayMain.Close;
end;

procedure TformVCDemoIIMain.vcPlayMainActivate(Sender: TObject);
begin
  if FeelOK then begin
    bvpMainActivate.Enabled   := not vcPlayMain.Active;
    bvpMainDeactivate.Enabled := vcPlayMain.Active;
  end;
end;

procedure TformVCDemoIIMain.vcIpRcvMainNewData(Sender: TObject; aData: Pointer; aSize: Cardinal);
begin
  if FeelOK then
    laRecvdSize.Caption := 'Received: ' + Int2Str(vcIpRcvMain.HandledSize, '`') + ' bytes';
end;

procedure TformVCDemoIIMain.vcInStreamCodecNewData(Sender: TObject; aData: Pointer; aSize: Cardinal);
begin
  if FeelOk then with vcInStreamCodec do begin
    laCodec_Size.Caption := 'Stream: ' + Int2Str(OutStreamSize, '`') + ' bytes';
    laInRation.Caption   := 'Ratio: ' + IntToStr(100 - CurMaxToPercent(OutStreamSize, InStreamSize)) + '%';
  end;
end;

procedure TformVCDemoIIMain.vcPlayMainNewData(Sender: TObject; aData: Pointer; aSize: Cardinal);
begin
  if FeelOK then
    laPlayStream_Size.Caption := 'Stream: ' + Int2Str(vcPlayMain.HandledSize, '`') + ' bytes';
end;

procedure TformVCDemoIIMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var
  lShouldSleep: Boolean;
  lDevCaps    : WaveOutCaps;
begin
  if CanClose then begin
    lShouldSleep := vcRecMain.Active;
    bRecDeactivateClick(Self);
    bipvtDeactivateClick(Self);
    bipvrDeactivateClick(Self);
    bvpMainDeactivateClick(Self);
    if lShouldSleep then Sleep(1000);	// avoid random AVs on exit..
    with fStorage do begin
      AsString['IP.Trans.Port'] := edTrPort.Text;
      AsString['IP.Trans.Addr'] := edTrAddr.Text;
      AsString['IP.Receiver.Port'   ] := edRcvPort.Text;
      AsInteger['Record.BufSizeMlt']  := tbInBufSize.Position;
      AsBoolean['IP.Receiver.AA']     := cbipRcvAA.Checked;
      AsBoolean['Play.AA']            := cbPlayMainAA.Checked;
      AsBoolean['IP.Trans.AA']        := cbipTransAA.Checked;
      with vcPlayMain do tAudioOutStream(Stream).GetDevCaps(PlayDevNum, lDevCaps);
      AsInteger['Play.Device.Pid']    := lDevCaps.wPid;
      AsInteger['Play.Device.Mid']    := lDevCaps.wMid;
    end;
  end;
end;

procedure TformVCDemoIIMain.vcPrMainError(Sender: TObject; aErrorCode: Integer; var aHandled: Boolean);
begin
  aHandled := True;
  case aErrorCode of
    vpeOK		: ;
    vpeNoSuchDriver	: Label5.Caption := 'required driver (codec) was not found in system';
    vpeNoMsACM		: Label5.Caption := 'MsACM property required but not assigned';
    vpeNoConverter	: Label5.Caption := 'StreamCodec not assigned';
    vpeNotSupported	: Label5.Caption := 'stream convertion not supported by StreamCodec';
    else aHandled := False;
  end;
end;

procedure tformVCDemoIIMain.vcPrMainFormatSuggest(Sender: tObject; const aSrcFormat: string; var aDstFormat: string);
var
  Z: Integer;
  lSrcFrm,
  lDstFrm: pWaveFormatEx;
begin
  Z := fMsAcm.MaxFormatSize;
  lSrcFrm := AllocMem(SizeOf(tWaveFormatEx) + Z);
  lDstFrm := AllocMem(SizeOf(tWaveFormatEx));	// we do not need additional bytes
  try
    Str2WaveFormatEx(aSrcFormat, lSrcFrm^, SizeOf(tWaveFormatEx) + Z);
    lDstFrm.wFormatTag := WAVE_FORMAT_PCM;	// we need plain stream..
    if vcOutStreamCodec.Driver.SuggestCodecFormat(lSrcFrm^, lDstFrm^, ACM_FORMATSUGGESTF_WFORMATTAG) then aDstFormat := WaveFormatEx2Str(lDstFrm^);
  finally
    ReallocMem(lSrcFrm, 0);
    ReallocMem(lDstFrm, 0);
  end;
end;

procedure TformVCDemoIIMain.vcOutStreamCodecNewData(Sender: TObject; aData: Pointer; aSize: Cardinal);
begin
  if FeelOk then
    laOutCodecInSize.Caption := 'Stream: ' + Int2Str(vcOutStreamCodec.InStreamSize, '`') + ' bytes';
end;

procedure TformVCDemoIIMain.vcOutStreamCodecActivate(Sender: TObject);
begin
  if vcOutStreamCodec.Active then laPCMPlayFormat.Caption := 'Format: ' + GetFormatDescription(vcOutStreamCodec.Stream.DstFormat^, 0);
end;

procedure TformVCDemoIIMain.tiMainTimer(Sender: TObject);
begin
  if FeelOK then begin
    sbMain.Panels[0].Text := 'Mem: ' + Int2Str(AllocMemSize, '`');
    Inc(fTransTicks);
    if vcIpTmsMain.Active then laTransCPS.Caption := 'Required CPS: ' + Int2Str(((vcIpTmsMain.HandledSize shr 10) div fTransTicks), '`') + ' Kb/s'
			  else laTransCPS.Caption := 'Required CPS: n/a';
    tiMain.Tag := tiMain.Tag + 1;
    if ((tiMain.Tag and $7) = 0) then with stRegNow.Font do
      if (Color = clRed)   then Color := clGreen  else
      if (Color = clGreen) then Color := clBlue   else
      if (Color = clBlue)  then Color := clYellow else Color := clRed;
  end;
end;

procedure TformVCDemoIIMain.tbInBufSizeChange(Sender: TObject);
begin
  laInBufSize.Caption := 'Record buffer size: ' + Int2Str(4096 * tbInBufSize.Position, '`');
end;

procedure TformVCDemoIIMain.vcPrMainBeforeAcceptStream(Sender: tObject; const aStreamHdr, aDstFormat: string; var DoAccept: Boolean);
var
  lPCMWave  : tWaveFormatEx;
  lWasActive: Boolean;
begin
  if DoAccept then with vcPrMain, tStringList.Create do try
    Text := aStreamHdr;
    lbStreamProv.Items.AddObject(Values[shvStream_ProviderName], Sender);
    if UseCodec then laOutDriverName.Caption := vcOutStreamCodec.Driver.Details.szLongName;
    if UseCodec then OneConsumer := nil
		else vcPrMain.OneConsumer := vcPlayMain;
    Str2WaveFormatEx(aDstFormat, lPCMWave, SizeOf(lPCMWave));
    lWasActive := vcPlayMain.Active;
    DeactivatePlayer;
    with vcPlayMain.Stream, lPCMWave do begin
      Stereo        := (nChannels > 1);
      SamplesPerSec := nSamplesPerSec;
      BitsPerSample := wBitsPerSample;
    end;
    ShowFormats;
    if lWasActive or cbPlayMainAA.Checked then ActivatePlayer;
  finally
    Free;
  end;
end;

procedure TformVCDemoIIMain.ActivateReceiver;
begin
  with vcIpRcvMain do begin
    {if InCodecUsed then OneConsumer := vcPrMain
		   else OneConsumer := vcPlayMain;}
    Port := edRcvPort.Text;
    Open;
  end;
end;

procedure TformVCDemoIIMain.ActivatePlayer;
begin
  with vcPlayMain do begin
    {with Stream, PCMWaveFormat^ do begin
      Stereo        := (nChannels > 1);
      SamplesPerSec := nSamplesPerSec;
      BitsPerSample := wBitsPerSample;
    end;}
    DevNum := PlayDevNum;
    Open;
  end;
end;

procedure TformVCDemoIIMain.ActivateRecorder;
begin
  with fStorage, vcRecMain do begin
    vcRecMain.DevNum := tAudioInStream(vcRecMain.Stream).DeviceIndexByPidMid(AsInteger['Record.Device.PID'], AsInteger['Record.Device.MID']);
    with Stream, PCMWaveFormat^ do begin
      Stereo        := (nChannels > 1);
      SamplesPerSec := nSamplesPerSec;
      BitsPerSample := wBitsPerSample;
      BufSize       := 4096 * tbInBufSize.Position;
    end;
    if InCodecUsed then begin
      OneConsumer := vcInStreamCodec;  // send data to Stream Codec
      with vcInStreamCodec do begin
	fMsAcm.EnumDrivers;
	with fMsAcm do vcInStreamCodec.Driver := Driver[DriverIndexByPidMid(AsInteger['Record.Codec.Driver.PID'], AsInteger['Record.Codec.Driver.MID'])];
	SrcFormat := WaveFormatEx2Str(PCMWaveFormat^);
	DstFormat := WaveFormatEx2Str(CodecWaveFormat^);
      end;
      vcPtMain.UseCodec := True;
      vcPtMain.Open;
      if vcInStreamCodec.Active then Open
				else vcPtMain.Close;
    end
    else begin
      vcPtMain.PCMFormat := WaveFormatEx2Str(PCMWaveFormat^);
      vcPtMain.UseCodec  := False;
      OneConsumer := vcPtMain;	// send data to Protocol Transmitter
      vcPtMain.Open;
      Open;
    end;
  end;
end;

procedure TformVCDemoIIMain.ActivateTransmitter;
begin
  with vcIpTmsMain do begin
    Port := edTrPort.Text;
    Addr := edTrAddr.Text;
    Open;
  end;
end;

function TformVCDemoIIMain.GetPlayDevNum: Integer;
begin
  Result := cbPlayDevice.ItemIndex;
end;

procedure TformVCDemoIIMain.SetPlayDevNum(Value: Integer);
begin
  if (Value < cbPlayDevice.Items.Count) then cbPlayDevice.ItemIndex := Value;
end;

function TformVCDemoIIMain.GetInCodecUsed: Boolean;
begin
  Result := fStorage.AsBoolean['Record.UseCodec'];
end;

procedure TformVCDemoIIMain.vcPtMainNewData(Sender: TObject; aData: Pointer; aSize: Cardinal);
begin
  if Assigned(Sender) then Exit;
end;

procedure TformVCDemoIIMain.vcPrMainDeactivate(Sender: TObject);
var
  i: Integer;
begin
  // remove provider name
  with lbStreamProv.Items do begin
    i := IndexOfObject(vcPrMain);
    if (i >= 0) then Delete(i);
  end;
  if cbPlayMainAA.Checked then DeactivatePlayer;
end;

procedure TformVCDemoIIMain.stRegNowClick(Sender: TObject);
begin
  ShellExecute(0, 'open', 'http://lakeofsoft.hypermart.net/vc/vc_reginfo.html', nil, nil, SW_SHOWNORMAL);
end;

procedure TformVCDemoIIMain.buRegMoreInfoClick(Sender: TObject);
begin
  formVCDemoIIInfo.Show;
end;

end.

