unit TIBSQLkeplet;

interface

uses classes, sysutils;

const
  TIBIntegerSize = 4;
  TIBFloatSize = 8;
  TIBDateSize = 4;
  TIBLogicalSize = 1;

type

  // ******************************************************************
  // kplet elem lehet konstans vagy mveleti jel, relci, zrjel stb
  // ******************************************************************
  Ttoken =  (_PLUSZ, _MINUS, _SZOR, _PER, // num. mveletek
             _KONKAT,                     // str konkatenls
             _OR,_AND,_XOR,               // logikai mveletek
             _NOT,                        // negls
             _LT,_GT,_LE,_GE,_EQ,_NE,_LIKE, _NOTLIKE, // sszehasonlits
             _ISNULL, _ISNOTNULL,         // res adat vizsglat
             _IN, _BETWEEN, _NOTIN, _NOTBETWEEN, // spec. SQL sszehasonlitsok
             _INTEGER,                    // Integer adat
             _FLOAT,                      // Float adat
             _STRING,                     // string adat
             _LOGICAL,                    // boolean adat
             _DATE,                       // dtum adat
             _NYZ, _CSZ,                  // zrjelek
             _VESSZO,                     // lista hatrol
             _SUM, _MIN, _MAX, _AVG, _COUNT,  // agregt fv.-ek
             _SUBSTR, _ABS, _UPPER);      // fggvnyek

  Telem = class
  Private
    Function getInteger : Longint;
    Function getFloat : Double;
    Function getString : String;
    Function getDate : TDateTime;
    Function getBoolean : Boolean;
    Procedure setInteger(value : Longint);
    Procedure setFloat(value : Double);
    Procedure setString(value : String);
    Procedure setDate(value : TDateTime);
    Procedure setBoolean(value : Boolean);
  Public
    Token : TToken;
    Padat : Pchar;
    AdatMeret : Byte;
    SajatAlloc : Boolean;
    Nev : string[32];  // formtum:  [alias.]nv
    Alias: string[32]; // SQL -ben az oszlop alias
    Csfv : string[3];  // csoport fv. MIN,MAX,SUM,AVG,COU vagy res
    Keplet : TList;    // Telemek  kplet
    KErtekek : Tlist;  // Telemek  rtkek a kplethez
    ErtekID : Integer; // Ha Nev <> '' s ez -1 akkor
                       //   az rtket nv szerint kell keresni
                       //   az ERTEKEK kztt
                       // Ha Nev <> '' s ez >= 0 akkor
                       //   az rtket index szerint lehet olvasni
                       //   az ERTEKEK -bl
    constructor Create;
    destructor Free;
    property asString : string read GetString write SetString;
    property asInteger : LongInt read GetInteger write SetInteger;
    property asFloat : Double read GetFloat write SetFloat;
    property asDate : TDateTime read GetDate write SetDate;
    property asBoolean : Boolean read GetBoolean write SetBoolean;
    procedure SetKeplet(Be: string);
    Function gettext : String;
  end;

  Telemek = Tlist;  // of Telem

  Function Kiertekelo(Kifejezes : Telemek; var pozicio : Integer;
                      Ertekek : Telemek) : Telem;
  // be: pozicio: az els feldolgozand elem a kifejezsben,
  //     Ertekek : rtkek (a kifejezsben a vltozoknl Token=_STRING s
  //                                                     Nev <> '')
  // kilpsi felttel: kifejezs vge vagy ')' -hez vagy ',' r
  // ki: eredmnyt tartalmaz j krelt elem,
  // pozici a kvetkez mg feldolgozatlan elemre mutat (')' ',' utni elemre)

  Function Elemzo(Tokens: Tstrings) : Telemek;
  // tokenizlt (szavakra bontott) kpletet elemez.
  // be: Tokens : sz sorozat
  // ki: Kifejezes ( a vltozoknl Token:_STRING s NEV <> '')

  Procedure SetValue(A,W : Telem);
  // A := W   tipusnak megfelel adat tvitel
  
  var KepletError : Integer;  //  0 Nincs Hiba, > 0 hiba volt
                              //  11 ismeretlen azonost
                              //  12 oszts nullval
                              //  13 zrjelezsi hiba
                              //  19 egyb kplet hiba

  implementation

uses SQLElemzo, TIBSQLrutinok;

Procedure SetValue(A,W : Telem);
begin
     case W.Token of
       _INTEGER: A.asInteger := W.asInteger;
       _FLOAT:   A.asFloat := W.asFloat;
       _STRING:  A.asString := W.asString;
       _DATE:    A.asdate := W.asdate;
       _LOGICAL: A.asBoolean := W.asBoolean;
     end;
end;


// ***********************************************************
//                 Telem metodusai
// ***********************************************************

Procedure Telem.setkeplet(Be: string);
var T : Tstrings;  // Tokenek
begin
  T := Tokenizalo(Be);
  if T.count > 0 then begin
    if (T[0] = 'MIN') or (T[0] = 'MIN') or
       (T[0] = 'SUB') or (T[0] = 'AVG') or
       (T[0] = 'COUNT') then begin
       CsFv := T[0];
       T.delete(0);
       T.delete(T.count - 1);
    end;
    Keplet := Elemzo(T);
  end;
  T.Free;
end;

Function Telem.gettext : String;
var ki : string;
begin
  case Token of
    _PLUSZ    : ki := '+ ';
    _MINUS    : ki := '- ';
    _SZOR     : ki := '* ';
    _PER      : ki := '/ ';
    _KONKAT   : ki := '|| ';
    _OR       : ki := 'OR ';
    _AND      : ki := 'AND ';
    _XOR      : ki := 'XOR ';
    _NOT      : ki := 'NOT ';
    _LT       : ki := '< ';
    _GT       : ki := '> ';
    _LE       : ki := '<= ';
    _GE       : ki := '>= ';
    _EQ       : ki := '= ';
    _NE       : ki := '<> ';
    _LIKE     : ki := 'LIKE ';
    _NOTLIKE  : ki := 'NOT LIKE ';
    _ISNULL   : ki := 'IS NULL ';
    _ISNOTNULL : ki := 'IS NOT NULL ';
    _IN       : ki := 'IN ';
    _NOTIN    : ki := 'NOT IN ';
    _BETWEEN  : ki := 'BETWEEN ';
    _NOTBETWEEN  : ki := 'NOT BETWEEN ';
    _INTEGER  : ki := asString;
    _FLOAT    : ki := asString;
    _STRING   : ki := asString;
    _LOGICAL  : ki := asString;
    _DATE     : ki := asString;
    _NYZ      : ki := '(';
    _CSZ      : ki := ')';
    _VESSZO   : ki := ',';
    _SUM      : ki := 'SUM';
    _MIN      : ki := 'MIN';
    _MAX      : ki := 'MAX';
    _AVG      : ki := 'AVG';
    _COUNT    : ki := 'COUNT';
    _SUBSTR   : ki := 'SUBSTR';
    _ABS      : ki := 'ABS';
    _UPPER    : ki := 'UPPER';
  end;
  ki := ki + nev;
  result := ki;
end;


// A get rutinok kpesek tipus konverzira is, kplet kirtkelsre is
Function Telem.getInteger : Longint;
var ki : Longint;
    S : string;
    D : Double;
    B : Boolean;
    W : Telem;
    I : Integer;
begin
  if Keplet <> Nil then begin
     I := 0;
     W := Kiertekelo(Keplet,I,KErtekek);
     Result := W.asInteger;
     W.Free;
     Exit;
  end;
  if Padat = Nil then
     ki := 0
  else
    case Token of
      _STRING:  begin
                  S := Padat;
                  Try
                    ki := StrToInt(S);
                  Except
                    ki := 0;
                  end;
                end;
      _INTEGER: Move(PAdat^, ki, sizeof(Longint));
      _FLOAT:   begin
                  Move(PAdat^, D, sizeof(Double));
                  Try
                    ki := Round(D);
                  Except
                    ki := 0;
                  end;
                end;
      _DATE:    Move(PAdat^, ki, sizeof(Longint));
      _LOGICAL: begin
                  Move(pAdat^, B, 1);
                  if B then
                     ki := 1
                  else
                     ki := 0;
                end;
      else
        ki := 0;
    end;
  Result := ki;
end;

Function Telem.getFloat : Double;
var ki : Double;
    S : string;
    L : Longint;
    B : Boolean;
    H : Integer;
    W : Telem;
    I : Integer;
begin
  if Keplet <> Nil then begin
     I := 0;
     W := Kiertekelo(Keplet,I,KErtekek);
     Result := W.asFloat;
     W.Free;
     Exit;
  end;
  if Padat = Nil then
     ki := 0
  else
    case Token of
      _STRING:  begin
                  S := Padat;
                  val(S,ki,H);
                  if H > 0 then ki := 0;
                end;
      _INTEGER: begin
                  Move(PAdat^, L, sizeof(Longint));
                  ki := L;
                end;
      _FLOAT:   Move(PAdat^, ki, sizeof(Double));
      _DATE:    begin
                  Move(PAdat^, L, sizeof(Longint));
                  ki := L;
                end;
      _LOGICAL: begin
                  Move(pAdat^, B, 1);
                  if B then
                     ki := 1
                  else
                     ki := 0;
                end;
      else
        ki := 0;
    end;
  Result := ki;
end;

Function Telem.getString : String;
var ki : string;
    L : Longint;
    D : Double;
    Datum : TDateTime;
    B : Boolean;
    W : Telem;
    I : Integer;
begin
  if Keplet <> Nil then begin
     I := 0;
     W := Kiertekelo(Keplet,I,KErtekek);
     Result := W.asString;
     W.Free;
     Exit;
  end;
  if Padat = Nil then
     ki := ''
  else
    case Token of
      _STRING:  begin
                  ki := Padat;
                end;
      _INTEGER: begin
                  Move(PAdat^, L, sizeof(Longint));
                  Try
                    Str(L:14,ki);
                  Except
                    ki := '';
                  end;
                end;
      _FLOAT:   begin
                  Move(PAdat^, D, sizeof(Double));
                  Try
                    Str(D:17:2,ki);
                  Except
                    ki := '';
                  end;
                end;
      _DATE:    begin
                  Move(PAdat^, datum, sizeof(TDateTime));
                  Try
                    ki := copy(DateTostr(datum),1,10);
                  Except
                    ki := '';
                  end;
                end;
      _LOGICAL: begin
                  Move(pAdat^, B, 1);
                  if B then
                     ki := 'T'
                  else
                     ki := 'F';
                end;
      else
        ki := '';
    end;
  Result := ki;
end;

Function Telem.getDate : TDateTime;
var ki : TDateTime;
    L : Longint;
    D : Double;
    S : String;
    W : Telem;
    I : Integer;
begin
  if Keplet <> Nil then begin
     I := 0;
     W := Kiertekelo(Keplet,I,KErtekek);
     Result := W.asDate;
     W.Free;
     Exit;
  end;
  if Padat = Nil then
     ki := 0
  else
    case Token of
      _STRING:  begin
                  S := Padat;
                  Try
                    ki := StrTodateTime(S);
                  except
                    ki := 0;
                  end;
                end;
      _INTEGER: begin
                  Move(PAdat^, L, sizeof(Longint));
                end;
      _FLOAT:   begin
                  Move(PAdat^, D, sizeof(Double));
                  L := Round(D);
                  ki := L;
                end;
      _DATE:    begin
                  Move(PAdat^, ki, sizeof(TDateTime));
                end;
      _LOGICAL: begin
                  ki := 0;
                end;
      else
        ki := 0;
    end;
  Result := ki;
end;

Function Telem.getBoolean : Boolean;
var ki : Boolean;
    L : Longint;
    D : Double;
    S : String;
    W : Telem;
    I : Integer;
begin
  if Keplet <> Nil then begin
     I := 0;
     W := Kiertekelo(Keplet,I,KErtekek);
     Result := W.asBoolean;
     W.Free;
     Exit;
  end;
  if Padat = Nil then
     ki := False
  else
    case Token of
      _STRING:  begin
                  S := Padat;
                  ki := S = 'T';
                end;
      _INTEGER: begin
                  Move(PAdat^, L, sizeof(Longint));
                  ki := L = 1;
                end;
      _FLOAT:   begin
                  Move(PAdat^, D, sizeof(Double));
                  L := Round(D);
                  ki := L = 1;
                end;
      _DATE:    begin
                  ki := False;
                end;
      _LOGICAL: begin
                  Move(Padat^, ki, 1);
                end;
      else
        ki := False;
    end;
  Result := ki;
end;

// a set rutinok sajatalloc esetn tllitjk a tipust,
//    szksg esetn mretet vltoztatnak
// ellenkez esetben konvertlnak, csonkitanak
Procedure Telem.setInteger(value : Longint);
var S : string;
    L : Longint;
    D : Double;
    Datum : TDateTime;
begin
  if sajatAlloc then begin
    if Padat <> Nil then
      Freemem(pAdat, AdatMeret);
    AdatMeret := sizeof(Longint);
    Token := _INTEGER;
    getmem(pAdat, AdatMeret);
    L := Value;
    Move(L, pAdat^, Adatmeret);
  end else begin
    L := Value;
    case Token of
      _INTEGER: begin
                  Move(L, pAdat^, sizeof(Longint));
                end;
      _FLOAT:   begin
                  D := L;
                  Move(D, pAdat^, sizeof(Double));
                end;
      _STRING:  begin
                  Str(L:16,S);
                  S := S + #0;
                  while Length(S) < Adatmeret do
                    S := S + ' ';
                  while Length(S) > AdatMeret do
                    S := copy(S,2,Adatmeret);
                  Move(S[1], pAdat^, Adatmeret);
                end;
      _DATE:    begin
                  datum := L;
                  Move(datum, pAdat^, Adatmeret);
                end;
      _LOGICAL: begin
                  if L = 1 then
                    Boolean(pAdat^) := True
                  else
                    Boolean(pAdat^) := False;
                end;
    end;
  end;
end;

Procedure Telem.setFloat(value : Double);
var S : string;
    L : Longint;
    D : Double;
    Datum : TDateTime;
begin
  if sajatAlloc then begin
    if Padat <> Nil then
      Freemem(pAdat, AdatMeret);
    AdatMeret := sizeof(Double);
    Token := _FLOAT;
    getmem(pAdat, AdatMeret);
    D := Value;
    Move(D, pAdat^, Adatmeret);
  end else begin
    D := Value;
    case Token of
      _INTEGER: begin
                  L := Round(D);
                  Move(L, pAdat^, sizeof(Longint));
                end;
      _FLOAT:   begin
                  Move(D, pAdat^, sizeof(Double));
                end;
      _STRING:  begin
                  Str(D:16:2,S);
                  S := S + #0;
                  while Length(S) < Adatmeret do
                    S := S + ' ';
                  while Length(S) > AdatMeret do
                    S := copy(S,2,Adatmeret);
                  Move(S[1], pAdat^, Adatmeret);
                end;
      _DATE:    begin
                  L := Round(D);
                  datum := L;
                  Move(datum, pAdat^, Adatmeret);
                end;
      _LOGICAL: begin
                  L := Round(D);
                  if L = 1 then
                    Boolean(pAdat^) := True
                  else
                    Boolean(pAdat^) := False;
                end;
    end;
  end;
end;

Procedure Telem.setString(value : String);
var S : string;
    L : Longint;
    D : Double;
    Datum : TDateTime;
    H : Integer;
begin
  if sajatAlloc then begin
    if Padat <> Nil then
      Freemem(pAdat, AdatMeret);
    AdatMeret := Length(Value) + 1;
    Token := _STRING;
    getmem(pAdat, AdatMeret);
    S := Value + #0;
    Move(S[1], pAdat^, Adatmeret);
  end else begin
    S := Value;
    case Token of
      _INTEGER: begin
                  val(S,D,H);
                  if H > 0 then D := 0;
                  L := Round(D);
                  Move(L, pAdat^, sizeof(Longint));
                end;
      _FLOAT:   begin
                  val(S,D,H);
                  if H > 0 then D := 0;
                  Move(D, pAdat^, sizeof(Double));
                end;
      _STRING:  begin
                  S := S + #0;
                  while Length(S) < Adatmeret do
                    S := S + ' ';
                  while Length(S) > AdatMeret do
                    S := copy(S,2,Adatmeret);
                  Move(S[1], pAdat^, Adatmeret);
                end;
      _DATE:    begin
                  Try
                    datum := StrTodate(S)
                  except
                    datum := 0;
                  end;
                  Move(datum, pAdat^, Adatmeret);
                end;
      _LOGICAL: begin
                  if S = 'T' then
                    Boolean(pAdat^) := True
                  else
                    Boolean(pAdat^) := False;
                end;
    end;
  end;
end;

Procedure Telem.setDate(value : TDateTime);
var S : string;
    L : Longint;
    D : Double;
    Datum : TDateTime;
begin
  if sajatAlloc then begin
    if Padat <> Nil then
      Freemem(pAdat, AdatMeret);
    AdatMeret := sizeof(TdateTime);
    Token := _DATE;
    Datum := Value;
    getmem(pAdat, AdatMeret);
    Move(Datum, pAdat^, Adatmeret);
  end else begin
    Datum := Value;
    case Token of
      _INTEGER: begin
                  L := 0;
                  Move(L, pAdat^, sizeof(Longint));
                end;
      _FLOAT:   begin
                  D := 0;
                  Move(D, pAdat^, sizeof(Double));
                end;
      _STRING:  begin
                  S := dateTostr(Datum) + #0;
                  while Length(S) < Adatmeret do
                    S := S + ' ';
                  while Length(S) > AdatMeret do
                    S := copy(S,2,Adatmeret);
                  Move(S[1], pAdat^, Adatmeret);
                end;
      _DATE:    begin
                  Move(datum, pAdat^, Adatmeret);
                end;
      _LOGICAL: begin
                    Boolean(pAdat^) := False;
                end;
    end;
  end;
end;

Procedure Telem.setBoolean(value : Boolean);
var S : string;
    L : Longint;
    D : Double;
    B : Boolean;
    Datum : TDateTime;
begin
  if sajatAlloc then begin
    if Padat <> Nil then
      Freemem(pAdat, AdatMeret);
    AdatMeret := 1;
    Token := _LOGICAL;
    B := Value;
    getmem(pAdat, AdatMeret);
    Move(B, pAdat^, Adatmeret);
  end else begin
    B := Value;
    case Token of
      _INTEGER: begin
                  if B then L := 1
                       else L := 0;
                  Move(L, pAdat^, sizeof(Longint));
                end;
      _FLOAT:   begin
                  if B then L := 1
                       else L := 0;
                  D := L;
                  Move(D, pAdat^, sizeof(Double));
                end;
      _STRING:  begin
                  if B then S := 'T'
                       else S := 'F';
                  while Length(S) < Adatmeret do
                    S := S + ' ';
                  while Length(S) > AdatMeret do
                    S := copy(S,2,Adatmeret);
                  Move(S[1], pAdat^, Adatmeret);
                end;
      _DATE:    begin
                  datum := 0;
                  Move(datum, pAdat^, Adatmeret);
                end;
      _LOGICAL: begin
                    Boolean(pAdat^) := B;
                end;
    end;
  end;
end;

constructor Telem.Create;
begin
    Token := _STRING;
    Padat := Nil;
    AdatMeret := 0;
    SajatAlloc := True;
    Nev := '';
    ErtekID := -1;
    Alias := '';
    Csfv := '';
    Keplet := Nil;
    KErtekek := Nil;
end;

// a free sajatalloc esetn az adat terletet is felszabaditja
destructor Telem.Free;
var i : Integer;
begin
  if Keplet <> Nil then begin
    for i := 0 to Keplet.count - 1 do
      Telem(Keplet[i]).Free;
    Keplet.free;
  end;
  if sajatAlloc then begin
    if (pAdat <> Nil) and (Adatmeret > 0) then
       Freemem(pAdat, Adatmeret);
  end;
end;

Function Kiertekelo(Kifejezes : Telemek; var pozicio : Integer;
                    Ertekek : Telemek) : Telem;
  // be: pozicio: az els feldolgozand elem a kifejezsben, Ertekek : rtkek
  // kilpsi felttel: kifejezs vge vagy ')'  vagy nem vrt adathoz r
  // ki: eredmnyt tartalmaz j krelt elem,
  // pozici a ')' utn elemre mutat
var ki,A,B,W : Telem;
    muvelet : Ttoken;
    S : String;

      // 1. priorits mvelet?
      Function Muvelet1(Muvelet: TToken):Boolean;
      begin
        case Muvelet of
             _SZOR,_PER,
             _KONKAT,
             _LT,_GT,_LE,_GE,_EQ,_NE,_LIKE, _NOTLIKE,
             _ISNULL, _ISNOTNULL:
          Result := True
        else
          result := False;
        end;
      end;

      // 2. priorits mvelet?
      Function Muvelet2(Muvelet: TToken):Boolean;
      begin
        case Muvelet of
             _PLUSZ,_MINUS,
             _OR,_AND,_XOR:
          Result := True
        else
          result := False;
        end;
      end;

      // Csoport fv?
      Function CsoportFv(Muvelet: TToken):Boolean;
      begin
        case Muvelet of
             _MIN, _MAX, _SUM, _AVG, _COUNT:
          Result := True
        else
          result := False;
        end;
      end;

      // A := A mvelet B A tipust a mvelet s az
      // operandusok tipusai hatrozzk meg
      Procedure MuveletVegzo(var A,B : Telem; Muvelet : TToken);
      var S : string;
      begin
        case Muvelet of
          _PLUSZ:  begin
                     if (A.Token = _INTEGER) and (B.Token = _INTEGER) then
                       A.asInteger := A.asInteger + B.asInteger
                     else
                       A.asFloat := A.asFloat + B.asFloat;
                   end;
          _MINUS:  begin
                     if (A.Token = _INTEGER) and (B.Token = _INTEGER) then
                       A.asInteger := A.asInteger - B.asInteger
                     else
                       A.asFloat := A.asFloat - B.asFloat;
                   end;
          _SZOR:   begin
                     if (A.Token = _INTEGER) and (B.Token = _INTEGER) then
                       A.asInteger := A.asInteger * B.asInteger
                     else
                       A.asFloat := A.asFloat * B.asFloat;
                   end;
          _PER:    begin
                     Try
                       if (A.Token = _INTEGER) and (B.Token = _INTEGER) then
                         A.asInteger := A.asInteger div B.asInteger
                       else
                         A.asFloat := A.asFloat / B.asFloat;
                     except
                       kepletError := 12;
                     end;
                   end;
          _KONKAT: begin
                     A.asString := A.asString + B.asString;
                   end;
          _OR:     begin
                     A.asBoolean := A.asBoolean or B.asBoolean;
                   end;
          _AND:    begin
                     A.asBoolean := A.asBoolean and B.asBoolean;
                   end;
          _XOR:    begin
                     A.asBoolean := A.asBoolean xor B.asBoolean;
                   end;
          _LT:     begin
                     A.asBoolean := A.asString < B.asString;
                   end;
          _GT:     begin
                     A.asBoolean := A.asString > B.asString;
                   end;
          _LE:     begin
                     A.asBoolean := A.asString <= B.asString;
                   end;
          _GE:     begin
                     A.asBoolean := A.asString >= B.asString;
                   end;
          _EQ:     begin
                     A.asBoolean := A.asString = B.asString;
                   end;
          _NE:     begin
                     A.asBoolean := A.asString <> B.asString;
                   end;
          _LIKE:   begin
                     S := B.asString;
                     if S[length(S)] = '%' then begin
                        S := copy(S,1,Length(S)-1);
                        A.asBoolean := pos(S,A.asString) = 1
                     end else if S[1] = '%' then begin
                        S := copy(S,2,Length(S)-1);
                        A.asBoolean := (pos(S,A.asString) > 1) or
                                       (A.asString = S);
                     end else begin
                        A.asBoolean := False;
                     end;
                   end;
          _NOTLIKE: begin
                     S := B.asString;
                     if S[length(S)] = '%' then begin
                        S := copy(S,1,Length(S)-1);
                        A.asBoolean := pos(S,A.asString) = 1
                     end else if S[1] = '%' then begin
                        S := copy(S,2,Length(S)-1);
                        A.asBoolean := (pos(S,A.asString) > 1) or
                                       (A.asString = S);
                     end else begin
                        A.asBoolean := False;
                     end;
                     A.asBoolean := not A.asBoolean;
                   end;

        end;
      end;

      Function getErtek(Kifejezes:Telemek; var  pozicio:integer): Telem;
      // rtk kiemelse (lehet NOT ...,  (..), s fggvny(...)  is!
      // ki: j krelt elem ,
      // pozicio a kvetkez feldolgozatlan elemre mutat
      // az 1. priorits mveleteket is vgrehajtja
      var ki,W,B : Telem;
          S : String;
          p,L,k : Integer;

          Procedure Muvelet1vegrehajto;
          var muvelet : TToken;
          begin
            if Kepleterror > 0 then exit;
            // ha 1. prorits mvelet kvetkezik azt is vgre kell hajtani
            repeat
              if (pozicio < Kifejezes.count - 1) then begin
                 if Muvelet1( Telem(Kifejezes[pozicio]).Token) then begin
                    muvelet := Telem(Kifejezes[pozicio]).Token;
                    inc(pozicio);
                    if Muvelet = _ISNULL then begin
                       ki.asBoolean := ki.asString = '';
                    end else if Muvelet = _ISNOTNULL then begin
                       ki.asBoolean := ki.asString <> '';
                    end else begin
                       if pozicio >= kifejezes.count then begin
                          KepletError := 19;
                       end;
                       if Muvelet1( Telem(Kifejezes[pozicio]).Token) then begin
                          KepletError := 19;
                       end;
                       if Muvelet2( Telem(Kifejezes[pozicio]).Token) then begin
                          KepletError := 19;
                       end;
                       B := getErtek(Kifejezes,pozicio);
                       Muveletvegzo(ki,B,Muvelet);
                       B.free;
                    end;
                 end;
              end;
            until (pozicio >= Kifejezes.count - 1) or
                  (not (Muvelet1(Telem(Kifejezes[pozicio]).Token)));
          end;

      begin  // getErtek
        if Kepleterror > 0 then begin
           ki := Telem.create;
           result := ki;
           exit;
        end;
        if pozicio < Kifejezes.count then begin
          if Telem(Kifejezes[pozicio]).nev = 'NULL' then begin
             ki := Telem.create;
             ki.asstring := '';
             result := ki;
             exit;
          end;
          if Muvelet1( Telem(Kifejezes[Pozicio]).Token) then begin
             kepletError := 19;
             ki := Telem.create;
             result := ki;
             exit;
          end;
          if Muvelet2( Telem(Kifejezes[Pozicio]).Token) then begin
             kepletError := 19;
             ki := Telem.create;
             result := ki;
             exit;
          end;
          W := Kifejezes[pozicio];
          if W.Token = _NOT then begin
             inc(pozicio);
             ki := getErtek(Kifejezes,pozicio);
             if kepletError > 0 then begin
               Result := ki;
               Exit;
             end;
             ki.asBoolean := not ki.asBoolean;
             Muvelet1Vegrehajto;
          end else if W.Token = _NYZ then begin
             inc(pozicio);
             ki := Kiertekelo(Kifejezes,pozicio,Ertekek);
             if kepletError > 0 then begin
                Result := ki;
                Exit;
             end;
             Muvelet1Vegrehajto;
          end else if W.Token = _SUBSTR then begin
             ki := Telem.create;
             inc(pozicio);
             inc(pozicio); // (
             if pozicio < Kifejezes.count then begin
               W := Kiertekelo(Kifejezes,pozicio,Ertekek);
               if kepletError > 0 then begin
                  Result := W;
                  Exit;
               end;
               S := W.asString;
               W.free;
               if pozicio < Kifejezes.count then begin
                  W := Kiertekelo(Kifejezes,pozicio,Ertekek);
                  if kepletError > 0 then begin
                     Result := W;
                     Exit;
                  end;
                  p := W.asInteger;
                  if pozicio < Kifejezes.count then begin
                    W := Kiertekelo(Kifejezes,pozicio,Ertekek);
                    if kepletError > 0 then begin
                       Result := W;
                       Exit;
                    end;
                    L := W.asInteger;
                    ki.asString := copy(S,p,L);
                  end;
               end;
             end;
             Muvelet1Vegrehajto;
          end else if W.Token = _UPPER then begin
            ki := Telem.create;
            inc(pozicio);
            inc(pozicio); // (
            if pozicio< Kifejezes.count then begin
               W := Kiertekelo(Kifejezes,pozicio,Ertekek);
               if kepletError > 0 then begin
                  Result := W;
                  Exit;
               end;
               S := Uppercase(W.asString);
               W.free;
               ki.asString := S;
            end;
            Muvelet1Vegrehajto;
          end else if W.Token = _ABS then begin
            ki := Telem.create;
            inc(pozicio);
            inc(pozicio); // (
            if pozicio < Kifejezes.count then begin
               W := Kiertekelo(Kifejezes,pozicio,Ertekek);
               if kepletError > 0 then begin
                  Result := W;
                  Exit;
               end;
               if W.Token = _INTEGER then
                 ki.asInteger := abs(W.asInteger)
               else
                 ki.asFloat := abs(W.asFloat);
               W.Free;
            end;
            Muvelet1Vegrehajto;
          end else if CsoportFv( W.Token) then begin
            ki := Telem.create;
            inc(pozicio);
            inc(pozicio); // (
            if pozicio < Kifejezes.count then begin
               W := Kiertekelo(Kifejezes,pozicio,Ertekek);
               if kepletError > 0 then begin
                  Result := W;
                  Exit;
               end;
               if W.Token = _INTEGER then
                 ki.asInteger := abs(W.asInteger)
               else
                 ki.asFloat := abs(W.asFloat);
               W.Free;
            end;
            Muvelet1Vegrehajto;
          end else begin
            ki := Telem.create;
            if (W.nev <> '') and (Ertekek <> Nil) then begin
               k := 0;
               if W.ErtekID >= 0 then begin
                  B := Ertekek[W.ErtekID];
                  SetValue(ki, B);
               end else begin
                 S := Uppercase(W.nev);
                 while k < Ertekek.count do begin
                   if (Telem(Ertekek[k]).Nev = S) then begin
                      B := Ertekek[k];
                      SetValue(ki, B);
                      W.ErtekID := k;
                      k := Ertekek.count;  // kilps a ciklusbl
                   end;
                   inc(k);
                 end;
                 if W.ErtekID < 0 then begin
                    KepletError := 11;
                    TIBSQLErrorInfo := S;
                 end;
               end;
            end else
              SetValue(ki,W);

            inc(Pozicio);
            Muvelet1vegrehajto;
          end; // W.Tokens elgazs
        end; // pozicio < Kifejzes.count
        if (pozicio < Kifejezes.count) and
               (Telem(Kifejezes[pozicio]).Token = _VESSZO) then
              inc(pozicio);
        if (pozicio < Kifejezes.count) and
               (Telem(Kifejezes[pozicio]).Token = _CSZ) then
              inc(pozicio);
        Result := Ki;
      end; // getErtek rutin

begin   // Kiertekelo
    KepletError := 0;
    ki := Telem.create;
    Result := ki;
    if pozicio < Kifejezes.count then begin
      W := Kifejezes[pozicio];
      // COUNT(*) esetn a '*' nem szorzst jelent!
      if W.Token = _COUNT then begin
        if pozicio < Kifejezes.count - 2 then begin
           if Telem(Kifejezes[pozicio+2]).Token = _SZOR then begin
              Telem(Kifejezes[pozicio+2]).Token := _STRING;
              Telem(Kifejezes[pozicio+2]).nev := '*';
           end;
        end;
      end;
      if W.Token = _CSZ then begin
         inc(pozicio);  // ) tlpse
         exit;
      end else if W.Token = _VESSZO then begin
         inc(pozicio);  // , tlpse
         exit;
      end else if (W.Token = _INTEGER) or
                  (W.Token = _FLOAT) or
                  (W.Token = _STRING) or
                  (W.Token = _DATE) or
                  (W.Token = _LOGICAL) or
                  (W.Token = _NYZ) or

                  (W.Token = _MIN) or
                  (W.Token = _MAX) or
                  (W.Token = _SUM) or
                  (W.Token = _AVG) or
                  (W.Token = _COUNT) or

                  (W.Token = _SUBSTR) or
                  (W.Token = _UPPER) or
                  (W.Token = _NOT) or
                  (W.Token = _ABS) then begin
         A := getErtek(Kifejezes, pozicio);
         if kepletError > 0 then begin
                Result := A;
                Exit;
         end;
         if pozicio < Kifejezes.count then begin
           repeat
             if Kepleterror > 0 then begin
                 result := A;
                 exit;
             end;
             muvelet := Telem(Kifejezes[pozicio]).Token;
             if Muvelet2(Muvelet) then begin
               inc(pozicio);
               if pozicio < Kifejezes.count then begin
                 if Muvelet2(Telem(Kifejezes[pozicio]).Token) then
                   KepletError := 19;
                 B := getErtek(Kifejezes, pozicio);
                 if kepletError > 0 then begin
                   Result := B;
                   Exit;
                 end;
                 Muveletvegzo(A,B,Muvelet);
                 B.free;
               end; // van msodik operandus
             end else if muvelet = _IN then begin
               inc(pozicio);
               inc(pozicio); // (
               S := ',';
               while (pozicio < Kifejezes.count) and
                     (Telem(Kifejezes[pozicio]).Token <> _CSZ) do begin
                  S := S + Trim(Telem(Kifejezes[pozicio]).asString) + ',';
                  inc(pozicio);
                  if (Telem(Kifejezes[pozicio]).Token <> _CSZ) then
                    inc(pozicio); // vessz tlps
               end;
               inc(pozicio); // ) tlps
               A.asBoolean := pos(',' + Trim(A.asString) + ',', S) > 0;
               Muvelet := _PLUSZ; // azrt, hogy bentmaradjon a ciklusban
             end else if muvelet = _NOTIN then begin
               inc(pozicio);
               inc(pozicio); // (
               S := ',';
               while (pozicio < Kifejezes.count) and
                     (Telem(Kifejezes[pozicio]).Token <> _CSZ) do begin
                  S := S + Trim(Telem(Kifejezes[pozicio]).asString) + ',';
                  inc(pozicio);
                  if (Telem(Kifejezes[pozicio]).Token <> _CSZ) then
                    inc(pozicio); // vessz tlps
               end;
               inc(pozicio); // ) tlps
               A.asBoolean := pos(',' + Trim(A.asString) + ',', S) > 0;
               A.asBoolean := not A.asBoolean;
               Muvelet := _PLUSZ; // azrt, hogy bentmaradjon a ciklusban
             end else if muvelet = _BETWEEN then begin
               inc(pozicio);
               if pozicio < Kifejezes.count then begin
                  B := Kifejezes[pozicio];
                  inc(pozicio);
                  inc(pozicio); // and tlpse
                  if pozicio < Kifejezes.count then begin
                     W := Kifejezes[pozicio];
                     A.asBoolean := (A.asString >= B.asString) and
                                    (A.asString <= W.asString);
                  end else begin
                    A.asBoolean := False;
                  end;
                end else begin
                 A.asBoolean := False;
               end;
               Muvelet := _PLUSZ; // azrt, hogy bentmaradjon a ciklusban
             end else if muvelet = _NOTBETWEEN then begin
               inc(pozicio);
               if pozicio < Kifejezes.count then begin
                  B := Kifejezes[pozicio];
                  inc(pozicio);
                  inc(pozicio); // and tlpse
                  if pozicio < Kifejezes.count then begin
                     W := Kifejezes[pozicio];
                     A.asBoolean := (A.asString >= B.asString) and
                                    (A.asString <= W.asString);
                  end else begin
                    A.asBoolean := False;
                  end;
                end else begin
                 A.asBoolean := False;
               end;
               A.asBoolean := not A.asBoolean;
               Muvelet := _PLUSZ; // azrt, hogy bentmaradjon a ciklusban
             end else if muvelet = _ISNULL then begin
               inc(pozicio);
               A.asBoolean := A.asString = '';
               Muvelet := _PLUSZ; // azrt, hogy bentmaradjon a ciklusban
             end else if muvelet = _ISNOTNULL then begin
               inc(pozicio);
               A.asBoolean := A.asString <> '';
               Muvelet := _PLUSZ; // azrt, hogy bentmaradjon a ciklusban
             end; // mvelet szerinti elgazs
          until (pozicio >= Kifejezes.count) or
                (Telem(Kifejezes[pozicio]).Token = _CSZ) or
                (Telem(Kifejezes[pozicio]).Token = _VESSZO) or
                (not Muvelet2(muvelet));
          Setvalue(ki,A);
          A.free;
          if (pozicio < Kifejezes.count) and
             (Telem(Kifejezes[pozicio]).Token <> _CSZ) and
             (Telem(Kifejezes[pozicio]).Token = _VESSZO) and
             (not Muvelet2(muvelet)) then
             kepletError := 19;
         end else begin
           Setvalue(ki,A);
         end;
      end else begin
        // nem vrt elem
        kepletError := 19;
      end;
    end;
end;

Function Elemzo(Tokens: Tstrings) : Telemek;
// tokenizlt (szavakra bontott) kpletet elemez.
// be: Tokens : sz sorozat, Mezok : adat mezk
// ki: Kifejezes ( a vltozoknl Token:_STRING s NEV <> '')
var i : Integer;
    ki : Telemek;
    Elem : Telem;
    S : string;
    D : Double;
    H : Integer;
    Db : Integer;
begin
  ki := Telemek.create;
  // zrjelezs ellenrzse
  DB := 0;
  for i := 0 to Tokens.count - 1 do begin
    if Tokens[i] = '(' then inc(Db);
    if Tokens[i] = ')' then dec(Db);
  end;
  if DB <> 0 then begin
             TIBSQLstatus := TIBSQL_paratlanZarojel;
             S := '';
             for i := 0 to Tokens.count - 1 do
               S := S + Tokens[i];
             TIBSQLErrorInfo := S;
             Result := Ki;
             Exit;
  end;
  DB := 0;
  for i := 0 to Tokens.count - 1 do begin
    if Tokens[i] = '''' then inc(Db);
  end;
  if (DB mod 2) <> 0 then begin
             TIBSQLstatus := TIBSQL_paratlanIdezojel;
             S := '';
             for i := 0 to Tokens.count - 1 do
               S := S + Tokens[i];
             TIBSQLErrorInfo := S;
             Result := Ki;
             Exit;
  end;
  DB := 0;
  for i := 0 to Tokens.count - 1 do begin
    if Tokens[i] = '"' then inc(Db);
  end;
  if (DB mod 2) <> 0 then begin
             TIBSQLstatus := TIBSQL_paratlanIdezojel;
             S := '';
             for i := 0 to Tokens.count - 1 do
               S := S + Tokens[i];
             TIBSQLErrorInfo := S;
             Result := Ki;
             Exit;
  end;
  i := 0;
  while i < Tokens.count do begin
    Elem := Telem.create;
    if Tokens[i] = '+' then
       Elem.Token := _PLUSZ
    else if Tokens[i] = '-' then
       Elem.Token := _MINUS
    else if Tokens[i] = '*' then
       Elem.Token :=      _SZOR
    else if Tokens[i] = '/' then
       Elem.Token :=      _PER
    else if Tokens[i] = '||' then
       Elem.Token :=      _KONKAT
    else if Tokens[i] = 'OR' then
       Elem.Token :=      _OR
    else if Tokens[i] = 'AND' then
       Elem.Token :=      _AND
    else if Tokens[i] = 'XOR' then
       Elem.Token :=      _XOR
    else if Tokens[i] = 'NOT' then begin
       Elem.Token :=      _NOT;
       if i < Tokens.count - 1 then begin
          if Tokens[i+1] = 'LIKE' then begin
             Elem.Token := _NOTLIKE;
             inc(i);
          end else if Tokens[i+1] = 'IN' then begin
             Elem.Token := _NOTIN;
             inc(i);
          end else if Tokens[i+1] = 'BETWEEN' then begin
             Elem.Token := _NOTBETWEEN;
             inc(i);
          end;
       end;
    end else if Tokens[i] = '<' then
       Elem.Token :=      _LT
    else if Tokens[i] = '>' then
       Elem.Token :=      _GT
    else if Tokens[i] = '<=' then
       Elem.Token :=      _LE
    else if Tokens[i] = '>=' then
       Elem.Token :=      _GE
    else if Tokens[i] = '=' then
       Elem.Token :=      _EQ
    else if Tokens[i] = '<>' then
       Elem.Token :=      _NE
    else if Tokens[i] = 'LIKE' then
       Elem.Token :=      _LIKE
    else if Tokens[i] = 'IS' then begin
       inc(i);
       if i < Tokens.count then begin
         if Tokens[i] = 'NOT' then begin
            Elem.Token :=      _ISNOTNULL;
            inc(i);
         end else begin
            Elem.Token :=      _ISNULL;
         end;
       end;
    end else if Tokens[i] = 'IN' then
       Elem.Token :=      _IN
    else if Tokens[i] = 'BETWEEN' then
       Elem.Token :=      _BETWEEN
    else if Tokens[i] = '(' then
       Elem.Token :=      _NYZ
    else if Tokens[i] = ')' then
       Elem.Token :=  _CSZ
    else if Tokens[i] = ',' then
       Elem.Token :=      _VESSZO
    else if Tokens[i] = 'SUM' then
       Elem.Token :=      _SUM
    else if Tokens[i] = 'COUNT' then
       Elem.Token :=      _COUNT
    else if Tokens[i] = 'MIN' then
       Elem.Token :=      _MIN
    else if Tokens[i] = 'MAX' then
       Elem.Token :=      _MAX
    else if Tokens[i] = 'AVG' then
       Elem.Token :=      _AVG
    else if Tokens[i] = 'SUBSTR' then
       Elem.Token :=      _SUBSTR
    else if Tokens[i] = 'ABS' then
       Elem.Token :=      _ABS
    else if Tokens[i] = 'UPPER' then
       Elem.Token :=      _UPPER
    else begin
       S := Tokens[i];
       if S <> '' then begin
         if (S[1] = '''') then begin
           if S[length(S)] = '''' then
             Elem.asString := copy(S,2,Length(S)-2)
           else begin
             Elem.asstring := '';
             TIBSQLstatus := TIBSQL_paratlanidezojel;
             TIBSQLErrorInfo := S;
             Result := Ki;
             Exit;
           end;
         end else if (S[1] = '"') then begin
           if S[length(S)] = '"' then
             Elem.asString := copy(S,2,Length(S)-2)
           else begin
             Elem.asstring := '';
             TIBSQLstatus := TIBSQL_paratlanidezojel;
             TIBSQLErrorInfo := S;
             Result := Ki;
             Exit;
           end;
         end else if (S[1]  >= '0') and (S[1] <= '9') then begin
           Try
             if pos('.',S) > 0 then begin
               val(S,D,H);
               if H > 0 then D := 0;
               Elem.asFloat := D;
             end else begin
               Elem.asInteger := StrToint(S);
             end;
           Except
             Elem.asFloat := 0;
           end;
         end else begin
           if (i < Tokens.count - 2) and
              (Tokens[i+1] = '.') then begin
              S := S + '.' + Tokens[i+2];
              inc(i);
              inc(i);
           end;
           Elem.asstring := '';
           Elem.Nev := S;
         end;
       end else begin
         Elem.Token := _STRING;
         Elem.asString := '';
       end;
    end;
    ki.add(Elem);
    inc(i);
  end;
  Result := ki;
end;

end.
