unit TIBSQLDLL;
(* *****************************************************************

          Interface unit a TIBSQLDLL.dll filejoz

          FIGYELEM FONTOS !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
          A felhasznli programban a DPR file-ba javitani kell,
          a USES rszben ELSNEK a ShareMem -nek kell szerepelnie!

          A program futshoz kell:  TIBSQLDLL.dll
                                     BORLANDMM.dll

******************************************************************* *)

interface

uses
  Windows, WinProcs, WinTypes, SysUtils, Classes;

//TIBSQLError kodok
const
TIBSQL_OK = 0;
TIBSQL_ErtekDbHiba = 3;
TIBSQL_NincsEredmeny = 4;
TIBSQL_TablaNincsMeg = 5;
TIBSQL_ParatlanIdezojel = 6;
TIBSQL_HibasSQLutasitas = 7;
TIBSQL_ParatlanZarojel = 8;
TIBSQL_UnionHiba = 9;
// kpletError rtkek
TIBSQL_KepletHiba = 10;
TIBSQL_OszlopNincsmeg = 11;
TIBSQL_OsztasNullaval = 12;
TIBSQL_EgyebKepletHiba = 19;
// Elemzoerror rtkek
TIBSQL_VesszotVart = 31;
TIBSQL_ZorojeletVart = 32;
TIBSQL_Idezojeletvart = 33;
TIBSQL_SQLszintaktika = 39;

type
  TTIBSQLHandler = Pointer;
  TTIBSQLCursor = Pointer;

var

// Alap rutinok

TIBSQLconnect:  Function (DBDir, DBname : String) : TTIBSQLHandler;
TIBSQLDisconnect:  Procedure (var DBH : TTIBSQLHandler);
TIBSQLgettablenames:  Function (DBH : TTIBSQLHandler) : Tstrings;
TIBSQLExecSQL:  Function (DBH : TTIBSQLHandler; SQLstr : String) : TTIBSQLCursor;
TIBSQLExecElemzettSQL:  Function (DBH : TTIBSQLHandler; SQLElemzo : Pointer) : TTIBSQLCursor;

// Cursor feldoloz rutinok
TIBSQLRecordCount:  Function (DBC : TTIBSQLCursor) : Integer;
TIBSQLColumnCount:  Function (DBC : TTIBSQLCursor) : Integer;
TIBSQLGo:  Procedure (DBC : TTIBSQLCursor; RecNo : Integer); // az els rekord sorszma = 0
TIBSQLgetColumnType:  Function (DBC : TTIBSQLCursor; ColumnNo : Integer): String; // az els column sorszma = 0
               // kimenet: CHAR, INTEGER, FLOAT,DATE,LOGICAL
TIBSQLgetColumnName:  Function (DBC : TTIBSQLCursor; ColumnNo : Integer): String;
TIBSQLgetColumnSize:  Function (DBC : TTIBSQLCursor; ColumnNo : Integer): Integer;
TIBSQLgetString:  Function (DBC : TTIBSQLCursor; ColumnNo : Integer): String;
TIBSQLgetInteger:  Function (DBC : TTIBSQLCursor; ColumnNo : Integer): Integer;
TIBSQLgetFloat:  Function (DBC : TTIBSQLCursor; ColumnNo : Integer): Double;
TIBSQLgetDate:  Function (DBC : TTIBSQLCursor; ColumnNo : Integer): TDateTime;
TIBSQLgetLogical:  Function (DBC : TTIBSQLCursor; ColumnNo : Integer): Boolean;
TIBSQLCloseCursor:  Procedure (var DBC : TTIBSQLCursor);

// Hibakezels

TIBSQLgetStatus:  Function (DBH : TTIBSQLHandler) : Integer;
TIBSQLgetErrorInfo:  Function (DBH : TTIBSQLHandler) : String;
Function TIBSQLgetErrormsg : String;

// Dll betlts

Procedure TIBSQLLoadDll;

Implementation

var H : Thandle;

Function TIBSQLgetErrormsg : String;
var Status : Integer;
    TIBSQLErrorInfo : String;
begin
     status := TIBSQLgetStatus(Nil);
     TIBSQLErrorInfo := TIBSQLgetErrorInfo(Nil);
     case status of
       TIBSQL_OK: Result := 'OK';
       TIBSQL_OszlopNincsmeg : Result := 'Ismeretlen oszlop ' +
                                                   TIBSQLErrorInfo;
       TIBSQL_KepletHiba  : Result := 'Kifejezs hiba ' +
                                                   TIBSQLErrorInfo;
       TIBSQL_ErtekDbHiba   : Result := 'rtk darabstm hiba ' +
                                                   TIBSQLErrorInfo;
       TIBSQL_NincsEredmeny  : Result := 'Nincs eredmny oszlop ' +
                                                   TIBSQLErrorInfo;
       TIBSQL_TablaNincsMeg   : Result := 'Nincs ilyen tbla ' +
                                                   TIBSQLErrorInfo;
       TIBSQL_ParatlanIdezojel   : Result := 'Pratlan idzjelek ' +
                                                   TIBSQLErrorInfo;
       TIBSQL_HibasSQLutasitas  : Result := 'Hibs SQL utasits ' +
                                                   TIBSQLErrorInfo;
       TIBSQL_OsztasNullaval  : Result := 'Oszts nullval ' +
                                                   TIBSQLErrorInfo;
       TIBSQL_ParatlanZarojel : Result := 'Pratlan zrjelek ' +
                                                   TIBSQLErrorInfo;
       TIBSQL_Vesszotvart : Result := 'Vessz hinyzik ' +
                                                   TIBSQLErrorInfo;
       TIBSQL_ZorojeletVart : Result := 'Zrjel hinyzik ' +
                                                   TIBSQLErrorInfo;
       TIBSQL_Idezojeletvart : Result := 'Zr idzjel hinyzik ' +
                                                   TIBSQLErrorInfo;
       TIBSQL_SQLszintaktika : Result := 'SQL szintaktikai hiba ' +
                                                   TIBSQLErrorInfo;
       TIBSQL_EgyebKepletHiba : Result := 'Kplet hiba ' +
                                                   TIBSQLErrorInfo;
       TIBSQL_UnionHiba : Result := 'UNION hiba ' +
                                              TIBSQLErrorInfo;
     else
       Result := ' ERROR ' + inttostr(status) + ' ' +
                                                   TIBSQLErrorInfo;
     end;
end;

Procedure TIBSQLLoadDll;
begin
  if H >= 32 then Exit;
  H := LoadLibrary('TIBSQLDLL.DLL');
  if H >= 32 then begin
    TIBSQLconnect:=getprocAddress(H,'TIBSQLconnect');
    TIBSQLDisconnect:=getprocAddress(H,'TIBSQLDisconnect');
    TIBSQLgettablenames:=getprocAddress(H,'TIBSQLgettablenames');
    TIBSQLExecSQL:=getprocAddress(H,'TIBSQLExecSQL');
    TIBSQLExecElemzettSQL:=getprocAddress(H,'TIBSQLExecElemzettSQL');
    TIBSQLCloseCursor:=getprocAddress(H,'TIBSQLCloseCursor');
    TIBSQLRecordCount:=getprocAddress(H,'TIBSQLRecordCount');
    TIBSQLColumnCount:=getprocAddress(H,'TIBSQLColumnCount');
    TIBSQLGo:=getprocAddress(H,'TIBSQLGo');
    TIBSQLgetColumnType:=getprocAddress(H,'TIBSQLgetColumnType');
    TIBSQLgetColumnName:=getprocAddress(H,'TIBSQLgetColumnName');
    TIBSQLgetColumnSize:=getprocAddress(H,'TIBSQLgetColumnSize');
    TIBSQLgetString:=getprocAddress(H,'TIBSQLgetString');
    TIBSQLgetInteger:=getprocAddress(H,'TIBSQLgetInteger');
    TIBSQLgetFloat:=getprocAddress(H,'TIBSQLgetFloat');
    TIBSQLgetDate:=getprocAddress(H,'TIBSQLgetDate');
    TIBSQLgetLogical:=getprocAddress(H,'TIBSQLgetLogical');
    TIBSQLgetStatus:=getprocAddress(H,'TIBSQLgetStatus');
    TIBSQLgetErrorInfo:=getprocAddress(H,'TIBSQLgetErrorInfo');
  end;
end;

Initialization
  H := 0;
Finalization
  if H >= 32 then
     FreeLibrary(H);
end.


