library TIBSQLDLL;

(* **************************************************

         F I G Y E L E M       F O N T O S ! ! !

      A felhasznl programban a DPR file-ba kzzel
      be kell irni a uses rszbe ELSNEK a "ShareMem"
      unit -ot!

  ************************************************** *)

uses
  Sharemem, SysUtils,
  Classes, TIBSQL, TIBSQLTabla, TIBSQLRutinok, SQLElemzo, TIBSQLkeplet;


  // Alap funkcik
  Function TIBSQLconnect(DBDir, DBname : String) : Pointer;
    export;
  var ki : TTIBSQL;
  begin
    ki := TTIBSQL.create;
    ki.DBDir := DBDir;
    Ki.Databasename := DBName;
    ki.connect;
    Result := Ki;
  end;

  Procedure TIBSQLDisconnect(var DBH : Pointer);
    export;
  begin
    if DBH <> Nil then begin
       TTIBSQL(DBH).free;
       DBH := Nil;
    end;
  end;

  Function TIBSQLgettablenames(DBH : Pointer) : Tstrings;
    export;
  begin
    if DBH <> Nil then
       Result := TTIBSQL(DBH).Gettablenames
    else
       Result := TStringList.create;
  end;

  Function TIBSQLExecSQL(DBH : Pointer; SQLstr : String) : Pointer;
    export;
  begin
    if DBH <> Nil then
      Result := TTIBSQL(DBH).ExecSQL(SQLstr)
    else
      Result := Nil;
  end;

  Function TIBSQLExecElemzettSQL(DBH : Pointer; SQLElemzo : Pointer) : Pointer;
    export;
  begin
    if DBH <> Nil then
      Result := TTIBSQL(DBH).ExecElemzettSQL(SQLElemzo)
    else
      Result := Nil;
  end;

  Procedure TIBSQLCloseCursor(var DBC : Pointer);
    export;
  begin
     if DBC <> Nil then begin
       TTIBSQLTabla(DBC).Free;
       DBC := Nil;
     end;
  end;


  // SQL cursor feldolgoz funkcik
  Function TIBSQLRecordCount(DBC : Pointer) : Integer;
    export;
  begin
     if DBC <> Nil then
       result := TTIBSQLTabla(DBC).Rekordszam
     else
       result := 0;
  end;

  Function TIBSQLColumnCount(DBC : Pointer) : Integer;
    export;
  begin
     if DBC <> Nil then
       result := TTIBSQLTabla(DBC).Oszlopszam
     else
       result := 0;
  end;

  Procedure TIBSQLGo(DBC : Pointer; RecNo : Integer);
    export;
  begin
     if DBC <> Nil then
       TTIBSQLTabla(DBC).Go(recNo);
  end;

  Function TIBSQLgetColumnType(DBC : Pointer; ColumnNo : Integer): String;
    export;
  begin
     if DBC <> Nil then
       case TTIBSQLTabla(DBC).mezo(ColumnNo).Token of
         _STRING: result := 'CHAR';
         _INTEGER: result := 'INTEGER';
         _FLOAT:   result := 'FLOAT';
         _DATE:    result := 'DATE';
         _LOGICAL: result := 'LOGICAL';
         else      result := '?';
       end
     else
       result := '?';
  end;

  Function TIBSQLgetColumnName(DBC : Pointer; ColumnNo : Integer): String;
    export;
  begin
     if DBC <> Nil then
       result := TTIBSQLTabla(DBC).mezo(ColumnNo).Alias
     else
       result := '?';
  end;

  Function TIBSQLgetColumnSize(DBC : Pointer; ColumnNo : Integer): Integer;
    export;
  begin
     if DBC <> Nil then
       result := TTIBSQLTabla(DBC).mezo(ColumnNo).Adatmeret
     else
       result := 0;
  end;

  Function TIBSQLgetString(DBC : Pointer; ColumnNo : Integer): String;
    export;
  begin
     if DBC <> Nil then
       result := TTIBSQLTabla(DBC).mezo(ColumnNo).asString
     else
       result := '';
  end;

  Function TIBSQLgetInteger(DBC : Pointer; ColumnNo : Integer): Integer;
    export;
  begin
     if DBC <> Nil then
       result := TTIBSQLTabla(DBC).mezo(ColumnNo).asInteger
     else
       result := 0;
  end;

  Function TIBSQLgetFloat(DBC : Pointer; ColumnNo : Integer): Double;
    export;
  begin
     if DBC <> Nil then
       result := TTIBSQLTabla(DBC).mezo(ColumnNo).asFloat
     else
       result := 0;
  end;

  Function TIBSQLgetDate(DBC : Pointer; ColumnNo : Integer): TDateTime;
    export;
  begin
     if DBC <> Nil then
       result := TTIBSQLTabla(DBC).mezo(ColumnNo).asDate
     else
       result := StrToDate('1900.01.01');
  end;

  Function TIBSQLgetLogical(DBC : Pointer; ColumnNo : Integer): Boolean;
    export;
  begin
     if DBC <> Nil then
       result := TTIBSQLTabla(DBC).mezo(ColumnNo).asBoolean
     else
       result := false;
  end;


  // Hibakezels
  Function TIBSQLgetStatus(DBH : Pointer) : Integer;
    export;
  begin
    result := TIBSQLstatus;
  end;

  Function TIBSQLgetErrorInfo(DBH : Pointer) : String;
    export;
  begin
    result := TIBSQLErrorInfo;
  end;

exports
  TIBSQLconnect         Index 1,
  TIBSQLDisconnect      Index 2,
  TIBSQLgettablenames   Index 3,
  TIBSQLExecSQL         Index 4,
  TIBSQLExecElemzettSQL Index 5,
  TIBSQLCloseCursor     Index 6,
  TIBSQLRecordCount     Index 7,
  TIBSQLColumnCount     Index 8,
  TIBSQLGo              Index 9,
  TIBSQLgetColumnType   Index 10,
  TIBSQLgetColumnSize   Index 11,
  TIBSQLgetString       Index 12,
  TIBSQLgetInteger      Index 13,
  TIBSQLgetFloat        Index 14,
  TIBSQLgetDate         Index 15,
  TIBSQLgetLogical      Index 16,
  TIBSQLgetStatus       Index 17,
  TIBSQLgetColumnName   Index 18,
  TIBSQLgetErrorInfo    Index 19 resident;

begin
end.
