unit SQLElemzo;

interface

uses classes, sysutils;

(*
   TMOGATOTT SZINTAXIS
   ====================

sqlutasitas ::= updatesql | querysql
querysql ::= selectsql [UNION [ALL] selectsql]... [order]
order ::= oszlop|sorszam [,{oszlop|sorszam} ]....
selectsql ::= SELECT [DISTINCT] * | {kifejezes [,kifejezes]...}
              FROM tabla [,tabla]...
              [join]...
              [WHERE feltetel]
              [GROUP BY oszlop [,oszlop]...]
              [HAVING feltetel]
updatesql ::= {CREATE DATABASE DBnv [opciok]} |
              {DROP DATABASE DBnv} |
              {GRANT [opciok]} |
              {BEGIN [opciok]} |
              {END [opciok]} |
              {COMMIT [opciok]} |
              {ROLLBACK [opciok]} |
              {FLUSH [opciok]} |
              {LOCK [opciok]} |
              {UNLOCK [opciok]} |
              {CREATE [opciok] TABLE tblanv} (oszlopdef [,oszlopdef]... |
              {DROP [opcioki] TABLE tblanv} |
              {ALTER TABLE tblanv ADD oszlopdef [,oszlopdef]..} |
              {CREATE [UNIQUE] INDEX indexnv ON tblanv
                  (oszlopnv [,oszlopnv]... [DESC])} |
              {DROP INDEX nv ON nv} |
              {INSERT INTO tblanv
              [ (oszlopnv [,oszlopnv].. ) ]
              {VALUES ( rtk [,rtk] )} | query } |
              {UPDATE tblanv SET oszopnv = rtk
                                 [,oszlopnv = rtk]...} |
              {DELETE FROM tblanv [WHERE felttel]}

tbla ::=  [adatbzisnb.]tblanv [tblaAlias]
oszlop ::= [tblaAlias.]oszlopnv [oszlopAlias]
kifejezs ::= {(adat [ mvelet adat] ....)} | oszlop | konstans | fv1(oszlop)
mvelet ::= + | - | * | / | '||'
adat ::= oszlop | konstans  | fv2(oszlop)
felttel ::= feltteltag [{AND|OR} feltteltag]...
feltteltag ::= relci | (felttel)
relci ::=
  {{oszlop|fv1(oszlop)}
      { < | <= | > | >= | = | <> | != }
   {rtk|oszlop|kifejezs}} |

  {oszlop LIKE konstans} |

  {oszlop IN {(rtklista)|querysql}} |

  {oszlop IS [NOT] NULL } |

  {oszlop BEETWEN rtk AND rtk}

oszlopdef ::= oszlopnv tipus [(mret [,deciml])]
fv1 ::= MIN | MAX | SUM | AVG
fv2 ::= SUBSTRING(oszlop FROM pozici FOR hossz) |
        SUBSTR(oszlop,pozici,hossz)




*)

type

  TIndexDef = class
    unique : Boolean;
    desc : Boolean;
    columns : TStrings;
    constructor Create;
    destructor Free;
  end;
  TOszlopDef = class
    nev : String;
    tipus : String;
    meret : String;
    dec : String;
  end;
  Toszlop = class
    TablaAlias : string;
    kifejezes : string;
    Oszlopalias : string;
  end;
  Toszlopok = Tlist; // of Toszlop
  Ttabla = class
    adatbazis : string;
    nev : string;
    tablaalias : string;
    constructor Create;
    destructor Free;
  end;
  Tjoin = class
    opcio : (LEFTOUTER,INNER);
    tablanev : string;
    tablaalias : string;
    feltetel : Tstrings;
    constructor Create;
    destructor Free;
  end;
  Tjoinok = Tlist; // of Tjoin
  Tselect = class
    unionall : boolean;
    distinct : boolean;
    Oszlopok : TList; // Toszlop;
    Tablak : TList;   // TTabla;
    Joinok : TList;   // TJoino;
    Feltetel : Tstrings;
    Csoport : TList; // oszlopok
    CsoportFeltetel : Tstrings;
    constructor Create;
    destructor Free;
  end;
  Tselektek = Tlist; // of Tselect

  TSQLparser = class
    tipus : (_EGYEB,_QUERY, _CREATEDATABASE, _DROPDATABASE, _GRANT,
             _CREATETABLE,_DROPTABLE,_ALTERTABLE,
             _CREATEINDEX,_DROPINDEX,
             _FLUSH,_LOCK,_UNLOCK,_BEGIN,_END,
             _COMMIT,_ROLLBACK,_INSERT,_UPDATE,_DELETE);
    DBnev : string;      // create database s drop database -hez
    Tablanev : String;   // create table, drop table, alter table,
                         // create index, drop index -hez
    IndexNev : String;   // create index, drop index -hez
    OszlopDefek : TList; // TOszlopdef   create table,
                         // alter table -hoz
    IndexDef : TIndexdef;  // TIndexDef    create index -hez
    Opciok : TStrings;   // create database, grant, flush, lock,
                         // unlock, egyeb -hez opcionlis adatok
                         // create, drop table/index -hez 'IF EXIST' vagy 'IF NOT EXIST'
    Oszlopnevek : Tstrings; // update s insert -hez
    Ertekek : TStrings;     // update s insert -hez
    Feltetel : Tstrings;    // udpate s delete -hez
    Selektek : TList; //TSelect  Query s insert into select -hez
    Rendezes : Tlist; // oszlopok
    // opciok
    Substr : Boolean; // SUBSTRING(a FROM p FOR s)  -> SUBSTR(a,p,s) konverzio
    Likefv : Boolean; // a LIKE konstans -> like(a,konstans)  konverzio
    constructor create;
    destructor free;
    procedure LoadFromstr(Be : string);
    Function SaveTostr(sortores : Integer): string;
  end;

Function Tokenizalo(Be : String): Tstrings;

var ElemzoError : integer; // 0 . OK
                           // 31 - vesszt vrt
                           // 31 - zrjelet vrt
                           // 32 - idzjel hiba
                           // 39 - egyb SQL elemzsi hiba


Implementation

var Kulcsszavak : string; // lsd a unit initialize rszt is!

(* *****************************************************************************
                            tokenizl rutin
   ***************************************************************************** *)
// SQLstr -> Token sorozat
//           Token: szavak, irsjelek, kt karakteres mveleti jelek, konstansok
//                  sz: betkbl, szmokbl ll karakter sorozat
//           /* ... */ komment szrve, CRLF szrve, redundns szokzk szrve
//           kulcsszavak nagybetsitve.
Function Tokenizalo(Be : String): Tstrings;
const szamok = '0123456789';
      betuk = 'qwertzuiopasdfghjklyxcvbnmQWERTZUIOPASDFGHJKLYXCVBNM_';
var ki : Tstrings;
    i : Integer;
    S,US : String;
begin
   Be := Be + ' ';
   ki := TstringList.create;
   i := 1;
   while (i <= Length(Be)) do begin
     S := '';
     while (i <= length(be)) and (Be[i]=' ') do inc(i);
     while (i <= length(be)) and (Be[i]=#13) do inc(i);
     while (i <= length(be)) and (Be[i]=#10) do inc(i);
     if Be[i] = '''' then begin
       S := S + Be[i];
       inc(i);
       while (i <= Length(Be)) and (Be[i] <> '''') do begin
          S := S + Be[i];
          inc(i);
       end;
       S := S + be[i];
       inc(i);
       if (S <> '') and (S[length(S)] <> '''') then
          ElemzoError := 33;
     end else if Be[i] = '"' then begin
       S := S + Be[i];
       inc(i);
       while (i <= Length(Be)) and (Be[i] <> '"') do begin
          S := S + Be[i];
          inc(i);
       end;
       S := S + be[i];
       inc(i);
       if (S<>'') and (S[length(S)] <> '''') then
          ElemzoError := 33;
     end else if (be[i] = '/') and (be[i+1] = '*') then begin
       while (i <= Length(Be)) and
             ((Be[i] <> '*') or (Be[i+1] <> '/'))  do
             inc(i);
       inc(i);
       inc(i);
     end else begin
       while (i <= Length(Be)) and
          ((pos(Be[i],szamok)>0) or
           (pos(Be[i],betuk)>0)) or
           ((i < Length(Be)) and (Be[i] = '.') and (pos(Be[i+1],szamok)>0)) do begin
          S := S + Be[i];
          inc(i);
       end;
       if S = '' then begin
         S := S + be[I];
         inc(i);
       end else begin
         US := Uppercase(S);
         if pos(','+US+',',KulcsSzavak) > 0 then
            S := US;
       end;
       // kt karakteres kodok spec kezelse
       if i <= length(Be) then begin
          if (Be[i] = '>') and (S = '<') then begin
             S := S + Be[i];
             inc(i);
          end;
          if (Be[i] = '=') and (S = '<') then begin
             S := S + Be[i];
             inc(i);
          end;
          if (Be[i] = '=') and (S = '>') then begin
             S := S + Be[i];
             inc(i);
          end;
          if (Be[i] = '=') and (S = '!') then begin
             S := S + Be[i];
             inc(i);
          end;
          if (Be[i] = '|') and (S = '|') then begin
             S := S + Be[i];
             inc(i);
          end;
       end; // kt karakteres szimbolumok kezelsnek vge
     end;
     S := Trim(S);
     if (S <> '') and (S <> ''#13#10) and (S <> ''#13) and (S <> ''#10) then
          ki.add(S);
   end;
   Result := Ki;
end;

(* ************************ Tindexdef *************************************** *)

constructor TIndexDef.Create;
begin
    unique := False;
    desc := False;
    columns := TStringList.create;
end;

destructor TIndexDef.Free;
begin
  columns.free;
end;

(* ************************ Ttabla *************************************** *)

constructor Ttabla.Create;
begin
  adatbazis := '';
  nev := '';
  tablaalias := '';
end;

destructor Ttabla.Free;
begin
  ;
end;

(* ************************ Tjoin *************************************** *)

constructor Tjoin.Create;
begin
  opcio := LEFTOUTER;
  tablanev := '';
  tablaalias := '';
  Feltetel := TstringList.create;
end;

destructor Tjoin.Free;
begin
  feltetel.free;
end;

(* ************************ Tselect *************************************** *)

constructor Tselect.Create;
begin
    unionall := True;
    distinct := False;
    Oszlopok := TList.create; // Toszlop;
    Tablak := TList.create;   // TTabla;
    Joinok := TList.create;   // TJoino;
    Feltetel := TstringList.create;
    Csoport := TList.create;
    CsoportFeltetel := TstringList.create;
end;

destructor Tselect.Free;
begin
end;

(* ************************ Tsqlparser *************************************** *)

constructor Tsqlparser.create;
begin
    tipus := _EGYEB;
    DBnev := '';      // create database s drop database -hez
    Tablanev := '';   // create table, drop table, alter table,
    IndexNev := '';   // create index, drop index -hez
    OszlopDefek := TList.create; // TOszlopdef   create table,
    IndexDef := TIndexdef.create;  // create index -hez
    Opciok := TstringList.create;   // create database, grant, flush, lock,
    Oszlopnevek := TstringList.create; // update s insert -hez
    Ertekek := TStringList.create;     // update s insert -hez
    Feltetel := TstringList.create;   // udpate s delete -hez
    Selektek := TList.create; //TSelect  Query s insert into select -hez
    Rendezes := Tlist.create;
    Substr := True;
    LikeFv := False;
end;

destructor Tsqlparser.free;
var I : Integer;
begin
  for i := Selektek.count - 1 downto 0 do
    TSelect(Selektek[i]).Free;
  Selektek.Free;
  Feltetel.Free;
  Ertekek.Free;
  Oszlopnevek.Free;
  Opciok.Free;
  IndexDef.Free;
  for i := Rendezes.count - 1 downto 0 do
    TOszlop(Rendezes[i]).Free;
  Rendezes.Free;
  for i := Oszlopdefek.count - 1 downto 0 do
    Toszlopdef(Oszlopdefek[i]).Free;
  OszlopDefek.Free;
end;


procedure Tsqlparser.LoadFromstr(Be : string);
var Tokens : Tstrings;
    i : Integer;
    Oszlop : Toszlop;
    OD : Toszlopdef;
    Db : Integer;

    procedure ParseOszlopdefs(var Tokens : Tstrings;var i : Integer);
    begin
     while i < Tokens.count - 1 do begin
       OD := TOszlopdef.create;
       OD.nev := Tokens[i]; inc(i);
       OD.Tipus := Tokens[i]; inc(i);
       if i < Tokens.count - 2 then begin
         if Tokens[i] = '(' then begin
            inc(i);  // ( tlps
            OD.Meret := Tokens[i]; inc(i);
            if (i < Tokens.count) and (Tokens[i] = ',')  then begin
              inc(i);
              OD.dec := Tokens[i]; inc(i);
            end;
            inc(i); // ) tlps
         end;
       end;
       inc(i);  // vessz tlpse
       Oszlopdefek.add(OD);
     end;
    end;

    Procedure parseWhere(var Tokens : Tstrings;var i : Integer;var feltetel: Tstrings);
    begin
      inc(i); // WHERE, ON, HAVING
      while (i < Tokens.count) and
            (Tokens[i] <> 'UNION') and
            (Tokens[i] <> 'LEFT') and
            (Tokens[i] <> 'INNER') and
            (Tokens[i] <> 'ORDER') and
            (Tokens[i] <> 'GROUP') and
            (Tokens[i] <> 'WHERE') do begin
        feltetel.add(Tokens[i]);
        inc(i);
      end;
    end;

    Procedure SelectsParser(var Tokens: Tstrings;var i:Integer);
    // select sorozat feldolgozsa tokens vgig
    var Select : Tselect;
        oszlop : TOszlop;
        Tabla : TTabla;
        Join : Tjoin;
        Wkifejezes : Tstrings;
        WzarojelDb : Integer;
        j : Integer;
        Db : Integer;
    begin
      if (i < Tokens.count) and
         ((Tokens[i] <> 'SELECT') and (Tokens[i] <> 'UNION')) then begin
         ElemzoError := 39;
         Exit;
      end;
      while (i < Tokens.count) and
        ((Tokens[i] = 'SELECT') or (Tokens[i] = 'UNION')) do begin
        Select := Tselect.create;
        if Tokens[i] = 'UNION' then begin
          inc(i);
          if (i < Tokens.count) and (Tokens[i] = 'ALL') then begin
            Select.unionAll := True;
            inc(i);
          end else begin
            Select.unionall := False;
          end;
          inc(i); // SELECT
        end else begin
          Select.unionall := True;
          inc(i); // SELECT
        end;
        // oszloplista feldolgozsa
        if (i < Tokens.count) and (Tokens[i] = 'DISTINCT') then begin
          Select.distinct := True;
          inc(i);
        end;
        if (i < Tokens.count) and
           ((Tokens[i] = 'FROM') or
            (Tokens[i] = 'WHERE') or
            (Tokens[i] = 'GROUP') or
            (Tokens[i] = 'HAVING') or
            (Tokens[i] = 'ORDER') ) then begin
           ElemzoError := 39;
           Exit;
        end;
        while (i < Tokens.count) and (Tokens[i] <> 'FROM') do begin
          oszlop := Toszlop.create;
          WzarojelDb := 0;
          Wkifejezes := TstringList.create;
          while (i < Tokens.Count) and
                ((Tokens[i] <> ',') or (WZaroJelDB <> 0)) and
                (Tokens[i] <> 'FROM') do begin
             Wkifejezes.add(Tokens[i]);
             if Tokens[i] = '(' then inc(WZarojelDb);
             if Tokens[i] = ')' then dec(WZarojelDb);
             inc(i);
          end;
          if Wkifejezes.count = 1 then
             Oszlop.kifejezes := Wkifejezes[0]
          else if (Wkifejezes.count = 3) and (Wkifejezes[1] = '.') then begin
             oszlop.TablaAlias := Wkifejezes[0];
             Oszlop.kifejezes := Wkifejezes[2];
          end else if (Wkifejezes.count = 4) and (Wkifejezes[1] = '.') then begin
             oszlop.TablaAlias := Wkifejezes[0];
             Oszlop.kifejezes := Wkifejezes[2];
             oszlop.oszlopalias := Wkifejezes[3];
          end else if Wkifejezes.count > 1 then begin
             if (Wkifejezes[Wkifejezes.count - 1] <> ')') and
                (Wkifejezes[Wkifejezes.count - 2] <> '+') and
                (Wkifejezes[Wkifejezes.count - 2] <> '-') and
                (Wkifejezes[Wkifejezes.count - 2] <> '/') and
                (Wkifejezes[Wkifejezes.count - 2] <> '*') and
                (Wkifejezes[Wkifejezes.count - 2] <> ',') and
                (Wkifejezes[Wkifejezes.count - 2] <> '.') and
                (Wkifejezes[Wkifejezes.count - 2] <> '||') then begin
                oszlop.oszlopalias := Wkifejezes[Wkifejezes.count - 1];
                for j := 0 to Wkifejezes.count - 2 do
                    Oszlop.kifejezes := oszlop.kifejezes + Wkifejezes[j];
             end else begin;
               for j := 0 to Wkifejezes.count - 1 do
                  Oszlop.kifejezes := oszlop.kifejezes + Wkifejezes[j];
             end;
          end;
          Wkifejezes.free;
          Select.Oszlopok.add(oszlop);
          if (i < Tokens.count) and (Tokens[i] = ',') then
            inc(i);
        end;
        if (i < Tokens.count) and (Tokens[i] <> 'FROM') then begin
           ElemzoError := 39;
           Exit;
        end;
        inc(i); // FROM
        // from feldolgozsa
        while (i < Tokens.count) and
              (Tokens[i] <> 'LEFT') and
              (Tokens[i] <> 'INNER') and
              (Tokens[i] <> 'WHERE') and
              (Tokens[i] <> 'GROUP') and
              (Tokens[i] <> 'ORDER') and
              (Tokens[i] <> 'UNION') do begin
          tabla := Ttabla.create;
          if (i < Tokens.count - 2) and (Tokens[i+1] = '.') then begin
            tabla.Adatbazis := Tokens[i]; inc(i);
            inc(i); // pont
            tabla.nev := Tokens[i]; inc(i);
          end else begin
            tabla.nev := Tokens[i]; inc(i);
          end;
          if (i < Tokens.count - 2) and
             (Tokens[i] <> ',') and
             (Tokens[i] <> 'LEFT') and
             (Tokens[i] <> 'INNER') and
             (Tokens[i] <> 'WHERE') and
             (Tokens[i] <> 'GROUP') and
             (Tokens[i] <> 'ORDER') and
             (Tokens[i] <> 'UNION') then begin
             tabla.tablaalias := Tokens[i]; inc(i);
          end else if i = Tokens.count - 1 then begin
             tabla.tablaalias := Tokens[i]; inc(i);
          end;
          Select.tablak.add(tabla);
          if (i < Tokens.count) and (Tokens[i] = ',') then
            inc(i);
        end; // from feldolgozo ciklus
        // joins feldolgozsa
        while (i < Tokens.count) and
              ((Tokens[i] = 'LEFT') or (Tokens[i] = 'INNER')) do begin
          if (i < Tokens.count) and
             (Tokens[i] = 'LEFT') then begin
             inc(i);
             if (i < Tokens.count) and (Tokens[i] <> 'OUTER') then begin
                 ElemzoError := 39;
                 Exit;
             end;
             inc(i); // OUTER
             if (i < Tokens.count) and (Tokens[i] <> 'JOIN') then begin
                 ElemzoError := 39;
                 Exit;
             end;
             inc(i); // JOIN
             if i < Tokens.count then begin
                 join := Tjoin.create;
                 join.opcio := LEFTOUTER;
                 join.Tablanev := Tokens[i]; inc(i);
                 if (i < Tokens.count) and (Tokens[i] <> 'ON') then begin
                   join.Tablaalias := Tokens[i]; inc(i);
                 end;
                 if (i < Tokens.count) and (Tokens[i] = 'ON') then
                   parsewhere(Tokens,i,join.feltetel);
                 Select.Joinok.add(Join);
             end;
          end;
          if (i < Tokens.count) and
             (Tokens[i] = 'INNER') then begin
             inc(i);
             if (i < Tokens.count) and (Tokens[i] <> 'JOIN') then begin
                 ElemzoError := 39;
                 Exit;
             end;
             inc(i); // JOIN
             if i < Tokens.count then begin
                 join := Tjoin.create;
                 join.opcio := INNER;
                 join.Tablanev := Tokens[i]; inc(i);
                 if (i < Tokens.count) and (Tokens[i] <> 'ON') then begin
                   join.Tablaalias := Tokens[i]; inc(i);
                 end;
                 if (i < Tokens.count) and (Tokens[i] = 'ON') then
                   parsewhere(Tokens,i,join.feltetel);
                 Select.Joinok.add(Join);
             end;
          end;
        end; // joinok ciklus
        // where feldolgozsa
        if (i < Tokens.count) and
           ((Tokens[i] = 'FROM')  ) then begin
           ElemzoError := 39;
           Exit;
        end;
        if (i < Tokens.count) and (Tokens[i] = 'WHERE') then
           ParseWhere(Tokens,i,Select.feltetel);
        // group by feldolgozsa
        if (i < Tokens.count) and
           ((Tokens[i] = 'FROM') or
            (Tokens[i] = 'WHERE')) then begin
           ElemzoError := 39;
           Exit;
        end;
        if (i < Tokens.count) and (Tokens[i] = 'GROUP') then begin
            inc(i);
            if (i < Tokens.count) and (Tokens[i] <> 'BY') then begin
               ElemzoError := 39;
               Exit;
            end;
            inc(i); // BY
            while (i < Tokens.count) and
                  (Tokens[i] <> 'HAVING') and
                  (Tokens[i] <> 'UNION') and
                  (Tokens[i] <> 'ORDER') do begin
              Oszlop := Toszlop.create;
              if (i < Tokens.count - 1) and (Tokens[i+1] = '.') then begin
                Oszlop.tablaalias := Tokens[i];
                inc(i);
                inc(i);
              end;
              Oszlop.kifejezes := Tokens[i]; inc(i);
              Db := 0;
              while (i < Tokens.count) and
                    (Tokens[i] <> 'HAVING') and
                    (Tokens[1] <> 'UNION') and
                    (Tokens[i] <> 'ORDER') and
                    ((Tokens[i] <> ',') or (DB <> 0)) do begin
                 Oszlop.kifejezes := Oszlop.Kifejezes +
                    Tokens[i];
                 if Tokens[i] = '(' then inc(Db);
                 if Tokens[i] = ')' then dec(Db);
                 inc(i);
              end;
              Select.Csoport.add(Oszlop);
              if (i < Tokens.count) and (Tokens[i] = ',') then
                 inc(i);
            end;
        end;
        // having feldolgozsa
        if (i < Tokens.count) and
           ((Tokens[i] = 'FROM') or
            (Tokens[i] = 'WHERE') or
            (Tokens[i] = 'GROUP') ) then begin
           ElemzoError := 39;
           Exit;
        end;
        if (i < Tokens.count) and (Tokens[i] = 'HAVING') then
          ParseWhere(Tokens,i,Select.csoportfeltetel);
        Selektek.add(Select);
      end; // select vagy UNION
    end;

begin
  ElemzoError := 0;
  Tokens := Tokenizalo(Be);
  if ElemzoError > 0 then
     exit;
  if Tokens.count = 0 then begin
     ElemzoError := 39;
     Exit;
  end;
  if Substr then begin
    for i := 0 to Tokens.count - 7 do begin
      if Tokens[i] = 'SUBSTRING' then begin
         Tokens[i] := 'SUBSTR';
         Tokens[i+3] := ',';
         Tokens[i+5] := ',';
      end;
    end;
  end;
  if Likefv then begin
    for i := 1 to Tokens.count - 2 do begin
      if Tokens[i] = 'LIKE' then begin
         Tokens[i] := Tokens[i-1];
         Tokens[i-1] := 'LIKE(';
         Tokens[i+1] := ',' + Tokens[i+1] + ')';
      end;
    end;
  end;
  if Tokens[0] = 'ALTER' then begin
    Tipus := _ALTERTABLE;
    Tablanev := Tokens[2];
    i := 4;
    Parseoszlopdefs(Tokens,i);
  end else if Tokens[0] = 'BEGIN' then begin
    Tipus := _BEGIN;
    for i := 1 to Tokens.count - 1 do
      Opciok.add(Tokens[i]);
  end else if Tokens[0] = 'COMMIT' then begin
    Tipus := _COMMIT;
    for i := 1 to Tokens.count - 1 do
      Opciok.add(Tokens[i]);
  end else if Tokens[0] = 'CREATE' then begin
    i := 1;
    while (i < Tokens.count) and
          (Tokens[i] <> 'DATABASE') and
          (Tokens[i] <> 'TABLE') and
          (Tokens[i] <> 'INDEX') do begin
          Opciok.add(Tokens[i]);
          inc(i);
    end;
    if i < Tokens.count - 1 then begin
       if Tokens[i] = 'DATABASE' then begin
          Tipus := _CREATEDATABASE;
          inc(i);
          DBnev := Tokens[i]; inc(i);
          while i < Tokens.count do begin
            Opciok.add(Tokens[i]);
            inc(i);
          end;
       end else if Tokens[i] = 'TABLE' then begin
         Tipus := _CREATETABLE;
         inc(i);
         Tablanev := Tokens[i]; inc(i);
         if (i < Tokens.count) and (Tokens[i] <> '(') then begin
           ElemzoError := 39;
           Exit;
         end;
         inc(i); // (
         Parseoszlopdefs(Tokens,i);
       end else if Tokens[i] = 'INDEX' then begin
         Tipus := _CREATEINDEX;
         if Opciok.count > 0 then begin
           if Trim(Opciok[0]) = 'UNIQUE' then begin
             Indexdef.unique := True;
             Opciok.clear;
           end;
         end;
         inc(i);  //
         Indexnev := Tokens[i]; inc(i);
         if (i < Tokens.count) and (Tokens[i] <> 'ON') then begin
           ElemzoError := 39;
           Exit;
         end;
         inc(i); // ON
         if i < Tokens.count then begin
           Tablanev := Tokens[i]; inc(i);
         end;
         if (i < Tokens.count) and (Tokens[i] <> '(') then begin
           ElemzoError := 32;
           Exit;
         end;
         inc(i);  // (
         while (i < Tokens.count) and
               (Tokens[i] <> ')') do begin
           if Tokens[i] = 'DESC' then
             Indexdef.desc := True
           else
             Indexdef.columns.add(Tokens[i]);
           inc(i);
           if (i < Tokens.count) and (Tokens[i] <> ',') then begin
              ElemzoError := 31;
             Exit;
           end;
           inc(i); // vessz
         end;
       end else begin
         Opciok.clear;
       end;
    end else
      Opciok.clear;
  end else if Tokens[0] = 'DELETE' then begin
    Tipus := _DELETE;
    i := 1;
    if (i < Tokens.count) and (Tokens[i] <> 'FROM') then begin
           ElemzoError := 39;
           Exit;
    end;
    inc(i); // FROM
    if i < Tokens.count then begin
      TablaNev := Tokens[i]; inc(i);
      if (i < Tokens.count) and (Tokens[i] = 'WHERE') then
         ParseWhere(Tokens,i, Feltetel);
    end;
  end else if Tokens[0] = 'DROP' then begin
    i := 1;
    while (i < Tokens.count) and
          (Tokens[i] <> 'DATABASE') and
          (Tokens[i] <> 'TABLE') and
          (Tokens[i] <> 'INDEX') do begin
          Opciok.add(Tokens[i]);
          inc(i);
    end;
    if i < Tokens.count - 1 then begin
      if Tokens[i] = 'DATABASE' then begin
        Tipus := _DROPDATABASE;
        inc(i);
        DBnev := Tokens[i];
      end else if Tokens[i] = 'TABLE' then begin
        Tipus := _DROPTABLE;
        inc(i);
        Tablanev := Tokens[i];
      end else if Tokens[i] = 'INDEX' then begin
        Tipus := _DROPINDEX;
        inc(i);
        Indexnev := Tokens[i]; inc(i);
        if (i < Tokens.count) and (Tokens[i] <> 'ON') then begin
           ElemzoError := 39;
           Exit;
        end;
        inc(i); // ON
        if i < Tokens.count then
          Tablanev := Tokens[i];
      end;
    end;
  end else if Tokens[0] = 'GRANT' then begin
    Tipus := _GRANT;
    for i := 1 to Tokens.count - 1 do
      Opciok.add(Tokens[i]);
  end else if Tokens[0] = 'INSERT' then begin
    Tipus := _INSERT;
    i := 1;
    if (i < Tokens.count) and (Tokens[i] <> 'INTO') then begin
           ElemzoError := 39;
           Exit;
    end;
    inc(i); // INTO
    if i < Tokens.count then begin
      Tablanev := Tokens[i]; inc(i);
      if (i < Tokens.count) and (Tokens[i] = '(') then begin
        inc(i);
        // oszlopnv lista
        while (i < Tokens.count) and (Tokens[i] <> ')') do begin
          Oszlopnevek.add(Tokens[i]); inc(i);
          if (i < Tokens.count) and (Tokens[i] = ',') then begin
             if (i < Tokens.count) and (Tokens[i] <> ',') then begin
                 ElemzoError := 31;
                 Exit;
             end;
             inc(i); // vessz
          end;
        end;
        inc(i); // )
      end;
      if (i < Tokens.count) and (Tokens[i] = 'VALUES') then begin
        inc(i);
        if (i < Tokens.count) and (Tokens[i] <> '(') then begin
           ElemzoError := 32;
           Exit;
        end;
        inc(i); // (
        // rtk lista
        while (i < Tokens.count) and (Tokens[i] <> ')') do begin
          Ertekek.add(Tokens[i]); inc(i);
          if (i < Tokens.count) and (Tokens[i] = ',') then begin
             inc(i); // vessz
          end;
        end;
        inc(i);  // ) -jel
      end;
      if (i < Tokens.count) and (Tokens[i] = 'SELECT') then
         SelectsParser(Tokens,i);
    end;
  end else if Tokens[0] = 'ROLLBACK' then begin
    Tipus := _ROLLBACK;
    for i := 1 to Tokens.count - 1 do
      Opciok.add(Tokens[i]);
  end else if Tokens[0] = 'SELECT' then begin
    Tipus := _QUERY;
    i := 0;
    SelectsParser(Tokens,i);
    if (i < Tokens.count) and
       (Tokens[i] <> 'ORDER') then begin
           ElemzoError := 39;
           Exit;
    end;
    if (i < Tokens.count) and (Tokens[i] = 'ORDER') then begin
        inc(i); // ORDER
        if (i < Tokens.count) and (Tokens[i] <> 'BY') then begin
           ElemzoError := 39;
           Exit;
        end;
        inc(i);  // BY
        while i < Tokens.count do begin
          Oszlop := Toszlop.create;
          if (i < Tokens.count - 2) and (Tokens[i+1] = '.') then begin
             Oszlop.tablaalias := Tokens[i]; inc(i);
             inc(i); // pont
             Oszlop.kifejezes := Tokens[i]; inc(i);
          end else begin
             Oszlop.kifejezes := Tokens[i]; inc(i);
          end;
          DB := 0;
          while (i < Tokens.Count) and
                ((Tokens[i] <> ',') or (Db <> 0)) do begin
             Oszlop.kifejezes := Oszlop.kifejezes +
                                 Tokens[i];
             if Tokens[i] = '(' then inc(Db);
             if Tokens[i] = ')' then inc(Db);
             inc(i);
          end;
          rendezes.add(Oszlop);
          if (i < Tokens.count) and (Tokens[i] <> ',') then begin
             ElemzoError := 31;
             Exit;
          end;
          inc(i); // vessz
        end;
    end;
  end else if Tokens[0] = 'UPDATE' then begin
    Tipus := _UPDATE;
    i := 1;
    if (i < Tokens.count) then begin
      Tablanev := Tokens[i]; inc(i);
      if (i < Tokens.count) and (Tokens[i] <> 'SET') then begin
           ElemzoError := 39;
           Exit;
      end;
      inc(i); // SET
      while (i < Tokens.count) and (Tokens[i] <> 'WHERE') do begin
        Oszlopnevek.add(Tokens[i]); inc(i);
        if (i < Tokens.count) and (Tokens[i] <> '=') then begin
           ElemzoError := 39;
           Exit;
        end;
        inc(i); // =
        if i < Tokens.count then begin
          Ertekek.add(Tokens[i]); inc(i);
        end;
        if (i < Tokens.count) and (Tokens[i] = ',') then
           inc(i); // vessz
      end;
      if (i < Tokens.count) and (Tokens[i] = 'WHERE') then
         ParseWhere(Tokens,i, Feltetel);
    end;
  end else begin
    ElemzoError := 39;
  end;
  Tokens.free;
end;

Function Tsqlparser.SaveTostr(sortores : Integer): string;
const CRLF = #13#10;
var ki : string;
    S : String;  // aktulis sor
    j : Integer;

    Procedure saveselects;
    var i,j,k : Integer;
    begin
      for i := 0 to Selektek.count - 1 do begin
        with Tselect(Selektek[i]) do begin
          if i > 0 then begin
            if UnionAll then
               S := 'UNION ALL'
            else
               S := 'UNION';
            ki := ki + S + CRLF;
          end;
          S := 'SELECT ';
          if distinct then
             S := S + 'DISTINCT ';
          for j := 0 to Oszlopok.count - 1 do begin
             with Toszlop(Oszlopok[j]) do begin
               if tablaalias <> '' then
                 S := S + tablaalias + '.';
               S := S + kifejezes;
               if oszlopalias <> '' then
                 S := S + ' ' + oszlopalias;
             end;
             if j < Oszlopok.count - 1 then
                S := S + ',';
             if Length(S) > sortores then begin
                ki := ki + S + CRLF;
                S := '';
             end;
          end;
          ki := ki + S + CRLF;
          S := 'FROM ';
          for j := 0 to Tablak.count - 1 do begin
             with TTabla(Tablak[j]) do begin
               if adatbazis <> '' then
                 S := S + adatbazis + '.';
               S := S + nev;
               if tablaalias <> '' then
                 S := S + ' ' + tablaalias;
             end;
             if j < Tablak.count - 1 then
                S := S + ',';
             if Length(S) > sortores then begin
                ki := ki + S + CRLF;
                S := '';
             end;
          end;
          ki := ki + S + CRLF;
          S := '';
          if Joinok.count > 0 then begin
            S := '';
            for j := 0 to Joinok.count - 1 do begin
              with TJoin(Joinok[j]) do begin
                 if opcio = LEFTOUTER then
                   S := S + ' LEFT OUTER JOIN ' + tablanev + ' '
                 else
                   S := S + ' INNER JOIN ' + tablanev + ' ';
                 if tablaalias <> '' then
                   S := S + tablaAlias + ' ';
                 S := S + ' ON ';
                 if feltetel.count > 0 then begin
                    for k := 0 to Feltetel.count - 1 do begin
                       if k = Feltetel.count - 1 then
                          S := S + Feltetel[k] + ' '
                       else if (Feltetel[k] = '.') or (Feltetel[k+1] = '.') then
                          S := S + Feltetel[k]
                       else
                          S := S + Feltetel[k] + ' ';
                       if Length(S) > sortores then begin
                          ki := ki + S + CRLF;
                          S := '';
                       end;
                    end;
                    ki := ki + S + CRLF;
                    S := '';
                 end;
              end;
              ki := ki + S + CRLF;
              S := '';
            end; // joinok ciklus
            ki := ki + S + CRLF;
            S := '';
          end;
          if feltetel.count > 0 then begin
            S := 'WHERE ';
            for j := 0 to Feltetel.count - 1 do begin
               if j = Feltetel.count - 1 then
                  S := S + Feltetel[j] + ' '
               else if (Feltetel[j] = '.') or (Feltetel[j+1] = '.') then
                  S := S + Feltetel[j]
               else
                  S := S + Feltetel[j] + ' ';
               if Length(S) > sortores then begin
                  ki := ki + S + CRLF;
                  S := '';
               end;
            end;
            ki := ki + S + CRLF;
            S := '';
          end;
          if csoport.count > 0 then begin
            S := 'GROUP BY ';
            for j := 0 to Csoport.count - 1 do begin
               if Toszlop(Csoport[i]).tablaalias <> '' then
                 S := S + Toszlop(Csoport[i]).tablaalias + '.';
               S := S + Toszlop(Csoport[i]).kifejezes;
               if j < Csoport.count - 1 then
                  S := S + ',';
               if Length(S) > sortores then begin
                  ki := ki + S + CRLF;
                  S := '';
               end;
            end;
            ki := ki + S + CRLF;
            S := '';
          end;
          if csoportfeltetel.count > 0 then begin
            S := 'HAVING ';
            for j := 0 to CsoportFeltetel.count - 1 do begin
               if j = Feltetel.count - 1 then
                  S := S + Feltetel[j] + ' '
               else if (Feltetel[j] = '.') or (Feltetel[j+1] = '.') then
                  S := S + Feltetel[j]
               else
                  S := S + Feltetel[j] + ' ';
               if Length(S) > sortores then begin
                  ki := ki + S + CRLF;
                  S := '';
               end;
            end;
            ki := ki + S + CRLF;
            S := '';
          end;
        end;
        if S <> '' then
          ki := ki + S + CRLF;
        S := '';
      end; // selectek ciklus
      if rendezes.count > 0 then begin
        S := 'ORDER BY ';
        for j := 0 to Rendezes.count - 1 do
          with Toszlop(Rendezes[j]) do begin
            if Tablaalias <> '' then
              S := S + tablaalias + '.';
            S := S + kifejezes;
            if j < Rendezes.count - 1 then
              S := S + ',';
          end;
         ki := ki + S + CRLF;
         S := '';
      end;
    end;  // saveselects

    Procedure Savefeltetel;
    var j : Integer;
    begin
       if feltetel.count > 0 then begin
            S := S + 'WHERE ';
            for j := 0 to Feltetel.count - 1 do begin
               if j = Feltetel.count - 1 then
                  S := S + Feltetel[j] + ' '
               else if (Feltetel[j] <> '.') and (Feltetel[j+1] = '.') then
                  S := S + Feltetel[j]
               else
                  S := S + Feltetel[j] + ' ';
               if Length(S) > sortores then begin
                   ki := ki + S + CRLF;
                   S := '';
               end;
            end;
            ki := ki + S + CRLF;
            S := '';
       end;
   end;

   Function Opciokstr : String;
   var i : Integer;
       ki : string;
   begin
      ki := '';
      for i := 0 to Opciok.count - 1 do
        ki := opciok[i] + ' ';
      Result := ki;
   end;

begin
  ki := '';
  case Tipus of
   _EGYEB       : begin ki := opciokstr; end;
   _QUERY       : begin saveselects;  end;
   _CREATEDATABASE  : begin ki := 'CREATE DATABASE ' + DBnev + CRLF + Opciokstr; end;
   _DROPDATABASE    : begin ki := 'DROP DATABASE ' + DBnev + CRLF + Opciokstr; end;
   _GRANT       : begin ki := 'GRANT ' + Opciokstr; end;
   _CREATETABLE : begin
                    ki := 'CREATE ' + Opciokstr + ' TABLE ' + Tablanev +
                       CRLF + '(';
                    for j := 0 to Oszlopdefek.count - 1 do
                      with Toszlopdef(Oszlopdefek[j]) do begin
                        ki := ki + Nev + ' ' + Tipus;
                        if Meret <> '' then begin
                           ki := ki + '(' + Meret;
                           if Dec <> '' then
                              ki := ki + ',' + Dec;
                           ki := ki + ')';
                        end;
                        if j < Oszlopdefek.count - 1 then
                          ki := ki + ','+CRLF
                        else
                          ki := ki + ')'+CRLF;
                      end;
                  end;
   _DROPTABLE   : begin ki := 'DROP ' + Opciokstr + ' TABLE ' + Tablanev; end;
   _ALTERTABLE  : begin
                    ki := 'ALTER TABLE ' + tablanev + ' ';
                    if Oszlopdefek.count > 0 then
                       for j := 0 to Oszlopdefek.count - 1 do begin
                         with Toszlopdef(Oszlopdefek[j]) do begin
                           ki := ki + ' ADD ' + nev + ' ' + Tipus;
                           if Meret <> '' then begin
                              ki := ki + '(' + Meret;
                              if Dec <> '' then
                                 ki := ki + ',' + Dec;
                              ki := ki + ')';
                           end;
                         end;
                       end;
                       ki := ki + ' '+CRLF;
                 end;
   _CREATEINDEX : begin
                    ki := 'CREATE ';
                    if Indexdef.unique then
                      ki := ki + ' UNIQUE ';
                    ki := ki + 'INDEX ' + Indexnev + ' ON ' +
                          Tablanev + ' (';
                    for j := 0 to Indexdef.columns.count - 1 do begin
                      ki := ki + Indexdef.columns[j];
                      if j < indexdef.columns.count - 1 then
                         ki := ki + ','
                      else
                         ki := ki + ' ';
                    end;
                    if Indexdef.desc then
                      ki := ki + ' DESC)'
                    else
                      ki := ki + ')';
                  end;
   _DROPINDEX   : begin
                    ki := 'DROP INDEX ' + Indexnev + ' ON ' + Tablanev;
                  end;
   _FLUSH       : begin ki := 'FLUSH ' + Opciokstr; end;
   _LOCK        : begin ki := 'LOCK ' + Opciokstr; end;
   _UNLOCK      : begin ki := 'UNLOCK ' + Opciokstr; end;
   _BEGIN       : begin ki := 'BEGIN ' + Opciokstr; end;
   _END         : begin ki := 'END ' + Opciokstr; end;
   _COMMIT      : begin ki := 'COMMIT ' + Opciokstr; end;
   _ROLLBACK    : begin ki := 'ROLLBACK ' + Opciokstr; end;
   _INSERT      : begin
                    S := 'INSERT INTO ';
                    if DBNev <> '' then
                      S := S + DBNev + '.';
                    S := S + Tablanev + ' ';
                    ki := ki + S + CRLF;
                    S := '';
                    if OszlopNevek.count > 0 then begin
                       S := '(';
                       for j := 0 to Oszlopnevek.count - 1 do begin
                         S := S + Oszlopnevek[j];
                         if j < Oszlopnevek.count - 1 then
                           S := S + ','
                         else
                           S := S + ')';
                       end;
                       ki := ki + S + CRLF;
                       S := '';
                    end;
                    if Ertekek.count > 0 then begin
                      S := 'VALUES (';
                       for j := 0 to Ertekek.count - 1 do begin
                         S := S + Ertekek[j];
                         if j < Ertekek.count - 1 then
                           S := S + ','
                         else
                           S := S + ')';
                       end;
                       ki := ki + S + CRLF;
                       S := '';
                    end;
                    saveselects;
                  end;
   _UPDATE      : begin
                    ki := 'UPDATE ' + tablanev +  ' SET ';
                    for j := 0 to Oszlopnevek.count - 1 do begin
                      ki := ki + Oszlopnevek[j] + ' = ' + Ertekek[j];
                      if j = Oszlopnevek.count - 1 then
                         ki := ki + CRLF
                      else
                         ki := ki + ',' + CRLF;
                    end;
                    SaveFeltetel;
                    if S <> '' then
                      ki := ki + S + CRLF;
                    S := '';
                  end;
   _DELETE      : begin
                      S := 'DELETE FROM ';
                      if DBnev <> '' then
                         S := S + DBnev + '.';
                      S := S + Tablanev + ' ';
                      SaveFeltetel;
                      if S <> '' then
                        ki := ki + S + CRLF;
                  end;
  end; // Tipus
  Result := ki;
end;

initialization
  kulcsszavak := ',CREATE,DROP,ALTER,ADD,BEGIN,END,TRANSACTION,IF,EXIST,';
  kulcsszavak := Kulcsszavak + 'COMMIT,ROLLBACK,GRANT,LOCK,UNLOCK,FLUSH,TABLES,';
  kulcsszavak := Kulcsszavak + 'DATABASE,TABLE,INDEX,UNIQUE,ASC,DESC,TEMP,';
  kulcsszavak := Kulcsszavak + 'CHAR,VARCHAR,SMALLINT,INTEGER,DATE,LOGICAL,';
  kulcsszavak := Kulcsszavak + 'NUMERIC,DECIMAL,FLOAT,IS,NULL,NOT,IN,BETWEEN,';
  kulcsszavak := kulcsszavak + 'SELECT,UPDATE,INSERT,DELETE,';
  kulcsszavak := Kulcsszavak + 'FROM,WHERE,HAVING,UNION,INTO,HAVING,';
  kulcsszavak := Kulcsszavak + 'SUBSTRING,SUBSTR,AS,ON,ALL,DISTINCT,GROUP,ORDER,BY,LIKE,FROM,';
  kulcsszavak := Kulcsszavak + 'LEFT,RIGHT,OUTER,INNER,FULL,JOIN,ON,AND,OR,';
  kulcsszavak := Kulcsszavak + 'SUM,MIN,MAX,AVG,ABS,UPPER,COUNT,VALUES,SET,';
end.
