unit TIBSQLtabla;

interface

uses sysutils, classes, TIBSQLKeplet, TXTIORutin;

type
  Trekord = Array[0..2000] of Pointer;

  TTIBSQLTabla = class
  private
    RekordID : Longint;
    RekordSize : Integer; // mezok.count * sizeof(pointer)
    Addmezo_Save : Boolean; // ha az addmezo hivja a kiirFileba rutint
  public
    Wcount : Longint;    // a Count(*) fv-hez kell
    Valtozott : Boolean;
    Rekordok : Tlist; // of mezok.count mret pontertmb
    DISKTabla : Boolean; // True = DISC-rl olvasott tbla
                         //   Free -nl ha vltozott trolni kell, s
                         //   Free -nek az adatterleteket is fel kell
                         //   szabaditania
                         // False esetn nem kell trolni, Free-nek nem
                         //   kell adatterletet felszabaditani
    Konyvtar : ShortString; // '\' -el a vgn
    Nev : String[32];
    Mezok : TElemek;
    constructor Create;
    destructor Free;
    Procedure BeolvasFilebol;
    Procedure KiirFileba;
    Function RekordSzam : Integer;
    Function OszlopSzam : Integer;
    Function Eof : Boolean;
    Function Bof : Boolean;
    Function Rekordmeret : Integer;
         // rekBuf mrete (nem azonos a RekordSize -val!)
    Procedure AddMezo(Nev : string;
                      Tipus : string;
                      Meret : Byte); // nem res tblnl is hasznlhat
    Procedure Go(Rekordszam : Integer); // Mezok adat pointerei bellnak
                                        // az aktulis rekordra
    Procedure GoFirst;
    Procedure GoLast;
    Procedure GoPrior;
    Procedure GoNext;
    Procedure Append;                   // adatok init, mezok adat pointerei
                                        // bellnak az j rekordra
    procedure Edit;
    procedure Post;
    procedure Delete;   // Rekordok[rekordID] trlse
    Function GetToRekord : Pchar;       // Rekordok[RekordID] -> result
    Procedure SetFromRekord(Rekord : Pchar); // RekBuf -> Rekordok[RekordID]
    Function mezoByname(MezoNev : string) : Telem;
    Function mezo(MezoID : Integer) : Telem;
  end;
  // FIGYELEM! append,edit s delete csak DISKtabla -n engedlyezett.
  // append,edit utn Mezok[i].as... := ..... rtkadsok kellenek
  // go utn az adatok Mezok[i].as.... -en keresztl rhetek el.

implementation

type TIBrekord = Array[0..0] of Pointer;

constructor TTIBSQLTabla.Create;
begin
    Rekordok := Tlist.create;
    RekordID := -1;
    RekordSize := 0;
    Valtozott := False;
    DISKTabla := False;
    Nev := '';
    Mezok := TElemek.create;
    Addmezo_save := false;
end;

destructor TTIBSQLTabla.Free;
var i,j : Integer;
begin
  if DISKTabla and Valtozott then
    KiirFileba;
  for i := 0 to Rekordok.count - 1 do begin
    if DISKTabla then begin
       for j := 0 to mezok.count - 1 do
         Freemem( Trekord( Rekordok[i]^)[j],
                  Telem(Mezok[j]).AdatMeret);
    end;
    if RekordSize > 0 then
      Freemem(Rekordok[i], Rekordsize);
  end;
  Rekordok.free;
  for i := 0 to mezok.count - 1 do
    Telem(Mezok[i]).free;
  Mezok.free;
end;

Procedure TTIBSQLTabla.BeolvasFilebol;
var S : String;
    SL : TStringList;
    i : Integer;
    TF : TextFile;
begin
  Rekordok.clear;
  Mezok.clear;
  DISKTabla := True;
  if FileExists(Konyvtar + Nev + '.CSV') then begin
     SL := TstringList.create;
     system.assign(TF, Konyvtar + Nev + '.CSV');
     redefTXTfile(TF);
     system.reset(TF);
     if not system.eof(TF) then begin
        system.readLn(TF,S);
        SL.clear;
        SL.CommaText := S;
        for i := 0 to SL.count - 1 do
          AddMezo(SL[i], 'CHAR',10);
     end;
     if not system.eof(TF) then begin
        system.readLn(TF,S);
        SL.clear;
        SL.CommaText := S;
        for i := 0 to SL.count - 1 do
          if i < mezok.count then begin
            if SL[i] = 'CHAR' then
               Telem(Mezok[i]).Token := _STRING
            else if SL[i] = 'INTEGER' then
               Telem(Mezok[i]).Token := _INTEGER
            else if SL[i] = 'FLOAT' then
               Telem(Mezok[i]).Token := _FLOAT
            else if SL[i] = 'DATE' then
               Telem(Mezok[i]).Token := _DATE
            else if SL[i] = 'LOGICAL' then
               Telem(Mezok[i]).Token := _LOGICAL;
          end;
     end;
     if not system.eof(TF) then begin
        system.readLn(TF,S);
        SL.clear;
        SL.CommaText := S;
        for i := 0 to SL.count - 1 do
          if i < mezok.count then begin
            if SL[i] = 'CHAR' then
               Telem(Mezok[i]).AdatMeret := StrToInt(SL[i])
            else if SL[i] = 'INTEGER' then
               Telem(Mezok[i]).AdatMeret := sizeof(Longint)
            else if SL[i] = 'FLOAT' then
               Telem(Mezok[i]).AdatMeret := sizeof(Double)
            else if SL[i] = 'DATE' then
               Telem(Mezok[i]).AdatMeret := sizeof(TDateTime)
            else if SL[i] = 'LOGICAL' then
               Telem(Mezok[i]).AdatMeret := sizeof(Boolean);
          end;
     end;
     RekordSize := Mezok.count * sizeof(Pointer);
     while not system.eof(TF) do begin
       S := '';
       system.readln(TF,S);
       if S <> '' then begin
         Append;
         SL.clear;
         SL.CommaText := S;
         for i := 0 to mezok.count - 1  do begin
           if i < SL.count then begin
             Telem(Mezok[i]).asString := SL[i];
           end;
         end;
         Post;
       end; // nem res sor
     end; // while
     system.close(TF);
     SL.free;
     for i := 0 to mezok.count - 1 do begin
        Telem(Mezok[i]).SajatAlloc := False;
     end;
  end; // megvan a fjl
  Valtozott := false;
end;

Procedure TTIBSQLTabla.KiirFileba;
var SL : TStringList;
    i,j,k : Integer;
    TF : TextFile;
    S : String;
begin
  if DISKTabla then begin
     system.assign(TF, Konyvtar + nev + '.CSV');
     RedefTxtFile(TF);
     system.rewrite(TF);
     SL := TstringList.create;
     for i := 0 to Mezok.Count - 1 do
        Sl.add( Telem(Mezok[i]).Nev );
     system.WriteLn(TF, SL.Commatext);
     SL.clear;
     for i := 0 to Mezok.Count - 1 do begin
        if Telem(Mezok[i]).Token = _STRING then
           Sl.add('CHAR')
        else if Telem(Mezok[i]).Token = _INTEGER then
           Sl.add('INTEGER')
        else if Telem(Mezok[i]).Token = _FLOAT then
           Sl.add('FLOAT')
        else if Telem(Mezok[i]).Token = _DATE then
           Sl.add('DATE')
        else if Telem(Mezok[i]).Token = _LOGICAL then
           Sl.add('LOGICAL');
     end;
     system.WriteLn(TF, SL.Commatext);
     SL.clear;
     for i := 0 to Mezok.Count - 1 do begin
       Try
         S := IntTostr(Telem(Mezok[i]).AdatMeret);
       Except
         S := '';
       End;
       SL.add(S);
     end;
     system.WriteLn(TF, SL.Commatext);
     for i := 0 to Rekordok.count - 1 do begin
        Go(i);
        SL.clear;
        //
        // Ha az addmeto hivja akkor eggyel kevesebb
        // pointer van a rekordokban!
        //
        for j := 0 to mezok.count - 1 do begin
          if (j = mezok.count -1) and
             (Addmezo_save) then begin
            SL.add('');
          end else begin
            S := Trim(Telem(Mezok[j]).asString);
            k := pos('"',S);
            while k > 0 do begin
              S[k] := '''';
              k := pos('"',S);
            end;
            SL.add(S);
          end;
       end;
       system.WriteLn(TF, SL.Commatext);
     end;
     system.close(TF);
     SL.free;
  end;
  Valtozott := false;
end;

Function TTIBSQLTabla.RekordSzam : Integer;
begin
  Result := Rekordok.count;
end;

Function TTIBSQLTabla.OszlopSzam : Integer;
begin
  Result := Mezok.count;
end;

Function TTIBSQLTabla.Eof : Boolean;
begin
  Result := RekordID >= Rekordok.count;
end;

Function TTIBSQLTabla.Bof : Boolean;
begin
  Result := rekordID < 0;
end;

Function TTIBSQLTabla.Rekordmeret : Integer;
// rekBuf mrete (nem azonos a RekordSize -val!)
var i : Integer;
    L : Integer;
begin
  L := 0;
  for i := 0 to Mezok.count - 1 do
    L := L + Telem(Mezok[i]).AdatMeret;
  Result := L;
end;


Procedure TTIBSQLTabla.AddMezo(Nev : string;
                               Tipus : string;
                               Meret : Byte);
var E : Telem;
    i,j : Integer;
begin
  E := Telem.create;
  E.Nev := Nev;
  if Tipus = 'CHAR' then
     E.Token := _STRING
  else if Tipus = 'INTEGER' then
     E.Token := _INTEGER
  else if Tipus = 'FLOAT' then
     E.Token := _FLOAT
  else if Tipus = 'DATE' then
     E.Token := _DATE
  else if Tipus = 'LOGICAL' then
     E.Token := _LOGICAL;
  E.AdatMeret := Meret;
  E.Alias := Nev;
  E.SajatAlloc := False;
  Mezok.add(E);
  RekordSize := Mezok.count * sizeof(Pointer);
  if Rekordok.count > 0 then begin
    // rekord kitrols res utols mezvel
    Addmezo_save := True;
    KiirFileba;
    Addmezo_save := False;
    // rekord terlet s adat terletek felszabaditsa
    for i := 0 to Rekordok.count - 1 do begin
      if DISKTabla then begin
         for j := 0 to mezok.count - 2 do
           Freemem( Trekord( Rekordok[i]^)[j],
                    Telem(Mezok[j]).AdatMeret);
      end;
      if RekordSize > 0 then
        Freemem(Rekordok[i], Rekordsize - sizeof(Pointer));
    end;
    Rekordok.free;
    // mezok terlet felszabaditsa
    for i := 0 to mezok.count - 1 do
      Telem(Mezok[i]).Free;
    Mezok.free;
    // rekordok s adatok ujra beolvassa
    BeolvasFileBol;
  end;
end;

Procedure TTIBSQLTabla.Go(Rekordszam : Integer);
 // Mezok adat pointerei bellnak
 // az aktulis rekordra
var i : Integer;
    Prekord : ^Trekord;
begin
  if (RekordSzam >= 0) and (RekordSzam < Rekordok.Count) then begin
     RekordID := RekordSzam;
     Prekord := Rekordok[RekordID];
     for i := 0 to Mezok.Count -1 do
       TElem(Mezok[i]).pAdat := PRekord^[i];
  end;
end;

Procedure TTIBSQLTabla.GoFirst;
begin
  Go(0);
end;

Procedure TTIBSQLTabla.GoLast;
begin
  Go(Rekordok.Count - 1);
end;

Procedure TTIBSQLTabla.GoPrior;
begin
  Go(RekordID - 1);
end;

Procedure TTIBSQLTabla.GoNext;
begin
  Go(RekordID + 1);
end;

Procedure TTIBSQLTabla.Append; // adatok init, mezok adat pointerei
                               // bellnak az j rekordra
var Prekord : ^Trekord;
    i : Integer;
    S : String;
begin
  if DISKTabla then begin
     getmem(Prekord, RekordSize);
     for i := 0 to Mezok.count - 1 do
       Prekord^[i] := Nil;
     Rekordok.add(Prekord);
     GoLast;
     for i := 0 to mezok.count - 1 do begin
       Telem(Mezok[i]).pAdat := Nil;
       Telem(Mezok[i]).SajatAlloc := True;
       case Telem(Mezok[i]).Token of
         _STRING: begin
                    S := '';
                    while (Length(S) < Telem(Mezok[i]).Adatmeret - 1) do
                      S := S + ' ';
                    Telem(Mezok[i]).asString := S;
                  end;
         _INTEGER: Telem(Mezok[i]).asInteger := 0;
         _FLOAT: Telem(Mezok[i]).asFloat := 0.0;
         _DATE: Telem(Mezok[i]).asDate := StrTodate('1900.01.01');
         _LOGICAL: Telem(Mezok[i]).asBoolean := False;
       end;
       Prekord^[i] := Telem(Mezok[i]).pAdat;
       Telem(Mezok[i]).SajatAlloc := False;
     end;
     Valtozott := True;
  end;
end;

procedure TTIBSQLTabla.Edit;
var I : Integer;
begin
  if DISKTabla then begin
     for i := 0 to mezok.count - 1 do begin
       Telem(Mezok[i]).SajatAlloc := False;
     end;
    Valtozott := True;
  end;
end;

Procedure TTIBSQLTabla.post;
var i : Integer;
begin
  if DISKTabla then begin
     for i := 0 to mezok.count - 1 do begin
       Telem(Mezok[i]).SajatAlloc := False;
     end;
    Valtozott := True;
  end;
end;

procedure TTIBSQLTabla.Delete; // Rekordok[rekordID] trlse
var i : Integer;
    Prekord : ^Trekord;
begin
  if DISKTabla then begin
    if (RekordID >= 0) and (RekordID < Rekordok.Count) then begin
       Prekord := Rekordok[RekordID];
       for i := 0 to Mezok.count - 1 do
         Freemem(Prekord^[i], Telem(Mezok[i]).AdatMeret);
       Rekordok.delete(RekordID);
    end;
  end;
end;

Function TTIBSQLTabla.GetToRekord : Pchar;   // Rekordok[RekordID] -> result
var ki : Pchar;
    i : Integer;
    Prekord : ^Trekord;
begin
  if (RekordID >= 0) and (RekordID < Rekordok.count) then begin
    getmem(ki, Rekordmeret);
    Prekord := Rekordok[RekordID];
    for i := 0 to Mezok.count - 1 do begin
       Move( Prekord^[i]^, ki, Telem(Mezok[i]).AdatMeret);
       inc(ki, Telem(Mezok[i]).AdatMeret);
    end;
    result := ki;
  end else
    result := Nil;
end;

Procedure TTIBSQLTabla.SetFromRekord(Rekord : Pchar); // RekBuf -> Rekordok[RekordID]
var Be : Pchar;
    i : Integer;
    Prekord : ^Trekord;
begin
  if (RekordID >= 0) and (RekordID < Rekordok.count) then begin
    Be := Rekord;
    Prekord := Rekordok[RekordID];
    for i := 0 to Mezok.count - 1 do begin
       Move( Be, Prekord^[i]^, Telem(Mezok[i]).AdatMeret);
       inc(Be, Telem(Mezok[i]).AdatMeret);
    end;
  end;
end;

Function TTIBSQLTabla.MezoByname(MezoNev : string) : Telem;
var i : Integer;
begin
  result := Nil;
  for i := 0 to Mezok.count - 1 do
    if Mezonev = Telem(Mezok[i]).Nev then
       result := Mezok[i];
end;

Function TTIBSQLTabla.Mezo(MezoID : Integer) : Telem;
begin
  if (MezoID >= 0) and (MezoID < Mezok.Count) then
     Result := Mezok[MezoID]
  else
     Result := Nil;
end;

end.
