unit TIBSQLRutinok;

interface

uses SQLelemzo, TIBSQLKeplet, TIBSQLTabla,
     classes, sysutils;

//TIBSQLError kodok
const
TIBSQL_OK = 0;
TIBSQL_ErtekDbHiba = 3;
TIBSQL_NincsEredmeny = 4;
TIBSQL_TablaNincsMeg = 5;
TIBSQL_ParatlanIdezojel = 6;
TIBSQL_HibasSQLutasitas = 7;
TIBSQL_ParatlanZarojel = 8;
TIBSQL_UnionHiba = 9;
// kpletError rtkek
TIBSQL_KepletHiba = 10;
TIBSQL_OszlopNincsmeg = 11;
TIBSQL_OsztasNullaval = 12;
TIBSQL_EgyebKepletHiba = 19;
// Elemzoerror rtkek
TIBSQL_VesszotVart = 31;
TIBSQL_ZorojeletVart = 32;
TIBSQL_Idezojeletvart = 33;
TIBSQL_SQLszintaktika = 39;

var TIBSQLStatus : Byte;
    TIBSQLErrorInfo : String;

Procedure DistinctSzuro(be: TTIBSQLTabla); // csak virtulis tblra !
Procedure Szuro(be: TTIBSQLTabla; Feltetel : Telemek); // csak virtulis tblra !
Function Szelektalo(Be: TTIBSQLTabla; Oszlopok : TOszlopok;
                                      Csoport : TOszlopok) : TTIBSQLTabla;
// Szelektalo eredmnye DISKTabla, a kpletes oszlopok ki vannak rtkelve
Procedure Rendezo(Be: TTIBSQLTabla; Rendezes : TOszlopok);
Function Csoportosito(Be: TTIBSQLTabla; Csoport : Toszlopok): TTIBSQLTabla;
Procedure HozzaFuzo(A,B : TTIBSQLTabla);  // A := A + B
                                          // 'A' csak virtulis tbla lehet !
Function TablaMasolo(Be : TTIBSQLTabla): TTIBSQLTabla;
Function TablaOsszeKapcsolo(A,B : TTIBSQLTabla;
                            LEFTOUTER : Boolean;
                            JoinFeltetel : Telemek): TTIBSQLTabla;
Procedure SetTablaAlias(Be : TTIBSQLTabla; Alias : String);

implementation

const NULLERTEK : Double = 0.0;

Procedure Rekordmasolo(Be,Ki : TTIBSQLTabla; I : Integer);
var j : Integer;
        PRekord : ^Trekord;
begin
       Be.go(i);
       getmem(Prekord, Be.Oszlopszam * sizeof(Pointer));
       for j := 0 to be.Oszlopszam - 1 do
         Prekord^[j] := Be.Mezo(j).pAdat;
       ki.rekordok.add(Prekord);
end;

Function getKulcs(Be: TTIBSQLTabla; i : Integer;
         Rendezes : TElemek): string;
var Ki : String;
    S : String;
    j,k,j0 : Integer;
    M : Telem;
begin
  M := Nil;
  be.go(i);
  Ki := '';
  for j := 0 to Rendezes.count - 1 do begin
    S :=  Uppercase(TElem(Rendezes[j]).nev);
    if (S <> '') and (S[1] >= '0') and (S[1] <= '9') then begin
      Try
        k := StrToInt(S);
        M := Be.mezo(k-1);
      except
        TIBSQLStatus := TIBSQL_keplethiba;
        TIBSQLErrorInfo := S;
        Result := '';
        Exit;
      end;
    end else begin
       M := Be.MezoByname(S);
    end;
    if M <> Nil then
       Ki := Ki + M.asString
    else if (Telem(Rendezes[j]).Keplet <> Nil) then begin
       J0 := 0;
       M := Kiertekelo(Telem(Rendezes[j]).Keplet, j0, Be.mezok);
       if M <> Nil then begin
          Ki := Ki + M.asString;
          M.Free;
       end;
    end else begin
       TIBSQLStatus := TIBSQL_keplethiba;
       TIBSQLErrorInfo := S;
       Result := '';
       Exit;
    end;
    if kepletError > KepletError then begin
      TIBSQLStatus := KepletError;
      TIBSQLErrorInfo := S;
      Result := '';
      Exit;
    end;
  end;
  Result := Ki;
end;


Procedure DistinctSzuro(be: TTIBSQLTabla);
var i,j : Integer;

    Function getStrRekord(T : TTIBSQLTabla): string;
    var ki : String;
        j : Integer;
    begin
      ki := '';
      for j := 0 to T.Oszlopszam - 1 do
        ki := ki + T.mezo(j).asString;
      Result := ki;
    end;

    Function MegNincs(i : Integer) : Boolean;
    var kimenet : Boolean;
        K1,K2 : String;
    begin
      be.go(i);
      K2 := getStrRekord(be);
      kimenet := True;
      j := 0;
      while (j < i) and
            (kimenet = True) do begin
        be.go(j);
        K1 := getStrRekord(be);
        if K1 = K2 then
           kimenet := False;
        inc(j);
      end;
      K1 := '';
      K2 := '';
      result := kimenet;
    end;

begin
  if be.rekordszam > 0 then begin
     i := 1;
     while i < be.Rekordszam do begin
         if MegNincs(i) then
            inc(i)
         else begin
            Freemem( Be.Rekordok[i], Be.Oszlopszam * sizeof(Pointer));
            Be.rekordok.delete(i);
         end;
     end;
  end;
  TIBSQLstatus := TIBSQL_OK;
end;

Procedure Szuro(be: TTIBSQLTabla; Feltetel : Telemek);
var i,j : Integer;
    W : Telem;
begin
  TIBSQLstatus := TIBSQL_OK;
  TIBSQLErrorInfo := '';
  if feltetel = Nil then exit;
  if feltetel.count = 0 then exit;
  i := 0;
  while i < Be.Rekordok.Count do begin
    Be.go(i);
    J := 0;
    W := Kiertekelo(Feltetel,J,Be.Mezok);
    if not W.asBoolean then begin
       Freemem( Be.Rekordok[i], Be.Oszlopszam * sizeof(Pointer));
       Be.rekordok.delete(i);
    end else begin
       inc(i);
    end;
    W.Free;
    if KepletError > 0 then begin
      TIBSQLstatus := KepletError;
      TIBSQLErrorInfo := '';
      for j := 0 to Feltetel.count - 1 do
        TIBSQLErrorInfo := TIBSQLerrorInfo + Telem(Feltetel[j]).getText;
    end;
  end;
end;

Function OszlopListaElemzo(be: Toszlopok) : Telemek;
var ki : Telemek;
    i : Integer;
    E : Telem;
    T : Tstrings;  // Tokenizlt kplet
begin
  ki := TElemek.create;
  if be = nil then begin
     Result := Ki;
     Exit;
  end;
  for i := 0 to Be.count - 1 do begin
    with Toszlop(be[i]) do begin
      E := Telem.create;
      T := Tokenizalo(Kifejezes);
      if (T.count = 1) then begin
         E.Nev := Kifejezes;
         if tablaAlias <> '' then
            E.nev := TablaAlias + '.' + E.nev;
      end else begin
         E.keplet := Elemzo(T);
         E.Nev := '@';
      end;
    end;
    ki.add(E);
  end;
  Result := ki;
end;

Function Szelektalo(Be: TTIBSQLTabla; Oszlopok : TOszlopok;
                                      Csoport : TOszlopok) : TTIBSQLTabla;
// Az eredmny tbla DISKTabla, a kpletes oszlopok ki vannak rtkelve
var Ki : TTIBSQLTabla;
    KiKepletek : Array[0..200] of TElemek;
    i,j,k,j0,Db : Integer;
    Oszlop : Toszlop;
    S : String;
    T : Tstrings;
    PRekord : ^TRekord;
    W : TElem;
    CsElemek : Telemek;  // csoport lista elemezve
    ElozoKulcs,Kulcs : string;


    Function nevkepzo(Be: string):string;
    var j : Integer;
        ki : String[32];
    begin
      j := pos('(',S);
      if j > 0 then begin
        ki := Uppercase(copy(S,j+1, Length(S)-j-1))
      end else begin
        ki := uppercase(S);
      end;
      result := ki;
    end;

begin
  if TIBSQLstatus <> TIBSQL_OK then begin
     ki := Nil;
     Result := Ki;
     exit;
  end;
  Ki := TTIBSQLTabla.create;
  TIBSQLstatus := TIBSQL_OK;
  TIBSQLErrorinfo := '';
  CsElemek := OszlopListaElemzo(Csoport);
  //
  // Mezk definilsa
  //
  for j := 0 to 200 do
     Kikepletek[j] := Nil;
  if (Oszlopok.count = 1) and
     (Toszlop(Oszlopok[0]).kifejezes = '*') then begin
      for j := 0 to Be.OszlopSzam - 1 do begin
          Ki.AddMezo( Be.mezo(j).nev, 'CHAR', be.mezo(j).Adatmeret);
          ki.mezo(j).Token := Be.mezo(j).Token;
          ki.mezo(j).Alias := Be.mezo(j).nev;
      end;
  end else begin
    // Be.mezok elkszitse a kplet szmitsokhoz
    if Be.rekordszam > 0 then
       Be.Go(0)
    else begin
       for j := 0 to Be.Oszlopszam - 1 do
         be.mezo(j).pAdat := Nil;
    end;
    // Mezk definilsa ciklusban
    for i := 0 to Oszlopok.count - 1 do begin
      Oszlop := Oszlopok[i];
      if Oszlop.TablaAlias <> '' then
        S :=  oszlop.TablaAlias + '.' + Oszlop.kifejezes
      else
        S := Oszlop.kifejezes;
      S := Uppercase(S);
      // ami norml input tbla mez, annak tipust tveszem az inputbl,
      // ami nem az; ott kpletes mezt alakitok ki
      for j := 0 to Be.OszlopSzam - 1 do
        if Telem(Be.Mezok[j]).Nev = S then begin
          Ki.AddMezo( S, 'CHAR', 10);
          Telem(Ki.Mezok[Ki.Mezok.count - 1]).Token :=
              Telem(Be.Mezok[j]).Token;
          Telem(Ki.Mezok[Ki.Mezok.count - 1]).AdatMeret :=
              Telem(Be.Mezok[j]).AdatMeret;
           if Oszlop.Oszlopalias = '' then
              Oszlop.OszlopAlias := S;
          Telem(Ki.Mezok[Ki.Mezok.count - 1]).Alias :=
              Oszlop.OszlopAlias;
          S := '@';  // ez jelzi, hogy feldolgoztam
        end;
      if S <> '@' then begin
        // kpletes mez
        if Oszlop.OszlopAlias = '' then
           oszlop.OszlopAlias := 'COLUMN_'+inttostr(i);
        Ki.AddMezo( NevKepzo(S), 'CHAR', 10);
        Telem(Ki.Mezok[Ki.Mezok.count - 1]).Kertekek := nil;

        T := Tokenizalo(S);
        if T.count > 0 then begin
          if T[0] = 'SUM' then begin
             Telem(Ki.Mezok[Ki.Mezok.count - 1]).CsFv := 'SUM';
             T.delete(0);
             T.delete(0);
             T.delete(T.count - 1);
          end;
          if T[0] = 'AVG' then begin
             Telem(Ki.Mezok[Ki.Mezok.count - 1]).CsFv := 'AVG';
             T.delete(0);
             T.delete(0);
             T.delete(T.count - 1);
          end;
          if T[0] = 'MIN' then begin
             Telem(Ki.Mezok[Ki.Mezok.count - 1]).CsFv := 'MIN';
             T.delete(0);
             T.delete(0);
             T.delete(T.count - 1);
          end;
          if T[0] = 'MAX' then begin
             Telem(Ki.Mezok[Ki.Mezok.count - 1]).CsFv := 'MAX';
             T.delete(0);
             T.delete(0);
             T.delete(T.count - 1);
          end;
          if T[0] = 'COUNT' then begin
             Telem(Ki.Mezok[Ki.Mezok.count - 1]).CsFv := 'COU';
             T.delete(0);
             T.delete(0);
             T.delete(T.count - 1);
          end;
        end;
        Telem(Ki.Mezok[Ki.Mezok.count - 1]).Alias :=
              Oszlop.OszlopAlias;
        Kikepletek[Ki.Mezok.count - 1] := Elemzo(T);

        J0 := 0;
        W := Kiertekelo( Kikepletek[Ki.Mezok.count - 1],
                         J0,
                         Be.Mezok);
        Telem(Ki.Mezok[Ki.Mezok.count - 1]).Token := W.Token;
        W.free;
        case Telem(Ki.Mezok[Ki.Mezok.count - 1]).Token of
          _STRING :  Telem(Ki.Mezok[Ki.Mezok.count - 1]).AdatMeret := 20;
          _INTEGER:  Telem(Ki.Mezok[Ki.Mezok.count - 1]).AdatMeret := sizeof(Longint);
          _FLOAT:    Telem(Ki.Mezok[Ki.Mezok.count - 1]).AdatMeret := sizeof(Double);
          _DATE:     Telem(Ki.Mezok[Ki.Mezok.count - 1]).AdatMeret := sizeof(TdateTime);
          _LOGICAL:  Telem(Ki.Mezok[Ki.Mezok.count - 1]).AdatMeret := sizeof(Boolean);
        end;
        T.Free;
        if kepleterror > 0 then begin
            TIBSQLstatus := kepleterror;
            TIBSQLErrorInfo := S;
        end;
      end; // kpletes oszlop
    end; // oszlopok ciklus
  end; // van tteles oszlop definici
  Ki.DISKTabla := True;
  if TIBSQLstatus <> TIBSQL_OK then begin
     Result := Ki;
     exit;
  end;

  if Csoport.count = 0 then begin
    //
    // Adatok tvtele ha nincs csoportosits
    //
    for i := 0 to Be.Rekordok.count - 1 do begin  // rekord ciklus
      be.go(i);
      ki.Append;
      // norml  mezk tvtele
      for j := 0 to Be.Mezok.Count - 1 do begin  // Be.oszlop ciklus
        for k := 0 to Ki.Mezok.Count - 1 do begin  // oszlop keres ciklus
          if Telem(Be.Mezok[j]).Nev = Telem(Ki.Mezok[k]).Nev then begin
              SetValue(ki.mezo(k), Be.mezo(j));
          end;
        end; // oszlop keres ciklus
      end; // Be.oszlop ciklus
      // kpletes mezk rtknek szmitsa s beirsa az output tblba
      for j := 0 to ki.Oszlopszam - 1 do begin
        if kikepletek[j] <> Nil then begin
           k := 0;
           W := Kiertekelo(kikepletek[j], k, be.mezok);
           SetValue( ki.mezo(j), W);
           W.free;
        end;
      end;
      Ki.post;
    end; // rekord ciklus
  end else begin
    //
    // Adatok tvtele ha van csoportosits
    //
    Rendezo(be,csoport);
    ElozoKulcs := '@';
    Db := 0;
    for i := 0 to Be.Rekordok.count - 1 do begin
       if Csoport = nil then begin
          Kulcs := '@_@';
          Be.go(i);
       end else
          Kulcs := getKulcs(Be, i, CsElemek);
       if Kulcs <> ElozoKulcs then begin
         if ElozoKulcs <> '@' then begin
            // tlag szmits rekordbuffer kiirsa az outputba
            for j := 0 to Ki.Oszlopszam - 1 do begin
              with Telem(Ki.Mezok[j]) do begin
                if (csFv = 'AVG') and (Db > 1) then
                   Ki.Mezo(j).asFloat :=
                     Ki.Mezo(j).asFloat / Db;
              end;
            end;
            ki.Post;
         end;
         // j rekord buffer lefoglalsa, s ennek feltltse
         ki.append;
         Db := 0;
         for j := 0 to Ki.oszlopszam - 1 do
           with Telem(Ki.Mezok[j]) do begin
             if CsFv = 'COU' then
                ki.mezo(j).asInteger := 1
             else begin
                if kikepletek[j] <> Nil then begin
                   k := 0;
                   W := Kiertekelo(kikepletek[j], k, be.mezok);
                   SetValue( ki.mezo(j), W);
                   W.free;
                end else begin
                  for k := 0 to Be.Mezok.Count - 1 do begin  // oszlop keres ciklus
                    if Telem(Be.Mezok[k]).Nev = Telem(Ki.Mezok[j]).Nev then begin
                        SetValue(ki.mezo(j), Be.mezo(k));
                    end;
                  end; // oszlop keres ciklus
                end;
             end;
           end;
       end else begin
         // rekord puffer modositsa
         inc(Db);
         W := Nil;
         for j := 0 to Ki.Oszlopszam - 1 do begin
           if kikepletek[j] <> Nil then begin
               k := 0;
               W := Kiertekelo(kikepletek[j], k, be.mezok);
           end else begin
              for k := 0 to Be.Mezok.Count - 1 do begin  // oszlop keres ciklus
                if Telem(Be.Mezok[k]).Nev = Telem(Ki.Mezok[j]).Nev then begin
                   W := Be.mezo(k);
                end;
              end; // oszlop keres ciklus
           end;
           // W = be.mezo
           with Telem(Ki.Mezok[j]) do begin
             if CsFv = 'SUM' then begin
                ki.Mezo(j).asFloat :=
                  ki.Mezo(j).asFloat + W.asFloat;
             end else if CsFv = 'AVG' then begin
                ki.Mezo(j).asFloat :=
                  ki.Mezo(j).asFloat + W.asFloat;
             end else if CsFv = 'MAX' then begin
                if W.asString > ki.Mezo(j).asString then
                   Ki.Mezo(j).asString := W.asString;
             end else if CsFv = 'MIN' then begin
                if (W.asString < ki.Mezo(j).asString) or
                   (Trim(ki.Mezo(j).asString) = '') then
                   Ki.Mezo(j).asString := W.asString;
             end else if CsFv = 'COU' then begin
                   Ki.Mezo(j).asInteger := Db;
             end else begin
               Ki.Mezo(j).asString := W.asString;
             end;
           end;
           if kikepletek[j] <> Nil then
              W.Free;
         end; // ki.mezo ciklus
       end; // uj csoport?
       ElozoKulcs := Kulcs;
    end;
    // tlag szmits, rekordbuffer kiirsa az outputba
    for j := 0 to Ki.Oszlopszam - 1 do begin
        with Telem(Ki.Mezok[j]) do begin
           if (csFv = 'AVG') and (Db > 1) then
              Ki.Mezo(j).asFloat :=
                 Ki.Mezo(j).asFloat / Db;
        end;
    end;
    ki.Post;
  end; // csoport / nem csoport
  // kpletes mezk kpleteinek trlse
  for j := 0 to ki.Oszlopszam - 1 do begin
       W := ki.mezo(j);
       if W.Keplet <> Nil then begin
          for k := 0 to W.Keplet.count - 1 do
            Telem(W.keplet[k]).free;
          W.keplet.free;
          W.keplet := Nil;
       end;
  end;
  for j := 200 downto 0 do
    if Kikepletek[j] <> Nil then begin
       for i := Telemek(Kikepletek[j]).count - 1 downto 0 do begin
         W := Telemek(Kikepletek[j])[i];
         W.free;
       end;
       Telemek(Kikepletek[j]).free;
    end;
  ki.Valtozott := false;
  for j := CsElemek.count - 1 downto 0 do
    Telem(Cselemek[j]).free;
  CsElemek.Free;
  Result := Ki;
end;

Procedure Rendezo(Be: TTIBSQLTabla; Rendezes : TOszlopok);
var i,j : Integer;
    Kulcs1, Kulcs2 : String;
    W1,W2 : Pointer;
    RElemek : TElemek;  // Oszloplista elemezve

begin
  if TIBSQLstatus <> TIBSQL_OK then
     exit;
  TIBSQLErrorinfo := '';
  TIBSQLstatus := TIBSQL_OK;
  RElemek := OszlopListaElemzo(Rendezes);
  // bubork rendezs
  for j := Be.Rekordok.count - 2 downto 0 do begin
    for i := 0 to j do begin
        W1 := Be.Rekordok[i];
        W2 := Be.Rekordok[i+1];
        Kulcs1 := getKulcs(Be, i, RElemek);
        Kulcs2 := getKulcs(Be, i+1, RElemek);
        if Kulcs1 > Kulcs2 then begin
           Be.Rekordok[i] := W2;
           Be.Rekordok[i+1] := W1;
        end;
    end;
  end;
  for j := 0 to RElemek.count - 1 do
    Telem(Relemek[j]).Free;
  RElemek.free;
end;

Function Csoportosito(Be: TTIBSQLTabla; Csoport : Toszlopok): TTIBSQLTabla;
// Ha Csoport = Nil akkor az egsz inputbl egyetlen csoport rekord kszl
var ki : TTIBSQLTabla;
    i,j : Integer;
    Kulcs : string;
    ElozoKulcs : String;
    Db : Integer;
    CsElemek : TElemek;  // Elemzett Csoport lista
begin
  if TIBSQLstatus <> TIBSQL_OK then begin
     ki := TTIBSQLTabla.create;
     Result := Ki;
     exit;
  end;
  TIBSQLErrorinfo := '';
  TIBSQLstatus := TIBSQL_OK;
  CsElemek := OszlopListaElemzo(Csoport);
  Db := 0;
  if Csoport <> Nil then
     Rendezo(Be, Csoport);
  ki := TTIBSQLTabla.create;
  for j := 0 to Be.Oszlopszam - 1 do begin
     Ki.addmezo( TElem(Be.Mezok[j]).Nev, 'CHAR', Telem(Be.Mezok[j]).AdatMeret);
     Telem(ki.Mezok[j]).Token := TElem(Be.Mezok[j]).Token;
     Telem(ki.Mezok[j]).Keplet := TElem(Be.Mezok[j]).Keplet;
     Telem(ki.Mezok[j]).Alias := TElem(Be.Mezok[j]).Alias;
     Telem(ki.Mezok[j]).CsFv := TElem(Be.Mezok[j]).CsFv;
     Telem(ki.Mezok[j]).Kertekek := ki.mezok;
  end;
  Ki.DISKTabla := True;
  ElozoKulcs := '@';
  for i := 0 to Be.Rekordok.count - 1 do begin
     if Csoport = nil then begin
        Kulcs := '@_@';
        Be.go(i);
     end else
        Kulcs := getKulcs(Be, i, CsElemek);
     if Kulcs <> ElozoKulcs then begin
       if ElozoKulcs <> '@' then begin
          // tlag szmits rekordbuffer kiirsa az outputba
          for j := 0 to Be.Oszlopszam - 1 do begin
            with Telem(Be.Mezok[j]) do begin
              if (csFv = 'AVG') and (Db > 1) then
                 Ki.Mezo(j).asFloat :=
                   Ki.Mezo(j).asFloat / Db;
            end;
          end;
          ki.Post;
       end;
       // j rekord buffer lefoglalsa, s ennek feltltse
       ki.append;
       Db := 0;
       for j := 0 to Be.oszlopszam - 1 do
         with Telem(Be.Mezok[j]) do begin
           if CsFv = 'COU' then
              ki.mezo(j).asInteger := 1
           else
              SetValue(ki.mezo(j), Be.mezo(j) );
         end;
     end else begin
       // rekord puffer modositsa
       inc(Db);
       for j := 0 to Be.Oszlopszam - 1 do begin
         with Telem(Be.Mezok[j]) do begin
           if CsFv = 'SUM' then begin
              ki.Mezo(j).asFloat :=
                ki.Mezo(j).asFloat + be.Mezo(j).asFloat;
           end else if CsFv = 'AVG' then begin
              ki.Mezo(j).asFloat :=
                ki.Mezo(j).asFloat + be.Mezo(j).asFloat;
           end else if CsFv = 'MAX' then begin
              if Be.Mezo(j).asString > ki.Mezo(j).asString then
                 Ki.Mezo(j).asString := Be.Mezo(j).asString;
           end else if CsFv = 'MIN' then begin
              if (Be.Mezo(j).asString < ki.Mezo(j).asString) or
                 (Trim(ki.Mezo(j).asString) = '') then
                 Ki.Mezo(j).asString := Be.Mezo(j).asString;
           end else if CsFv = 'COU' then begin
                 Ki.Mezo(j).asInteger := Db;
           end else begin
             Ki.Mezo(j).asString := Be.Mezo(j).asString;
           end;
         end;
       end;
     end; // uj csoport?
     ElozoKulcs := Kulcs;
  end;
  // tlag szmits, rekordbuffer kiirsa az outputba
  for j := 0 to Be.Oszlopszam - 1 do begin
      with Telem(Be.Mezok[j]) do begin
         if (csFv = 'AVG') and (Db > 1) then
            Ki.Mezo(j).asFloat :=
               Ki.Mezo(j).asFloat / Db;
      end;
  end;
  ki.Post;
  for j := 0 to Cselemek.count - 1 do
    Telem(Cselemek[j]).Free;
  Result := Ki;
end;

Procedure HozzaFuzo(A,B : TTIBSQLTabla);  // A := A + B
var Prekord : ^Trekord;
    i,j : Integer;
begin
  if TIBSQLstatus <> TIBSQL_OK then
     exit;
  if A.Oszlopszam = B.Oszlopszam then begin
    A.DISKTabla := False;
    for i := 0 to B.RekordSzam - 1 do begin
      Getmem(Prekord, A.Oszlopszam * sizeof(Pointer));
      for j := 0 to A.OszlopSzam - 1 do
        Prekord^[j] :=  Trekord(B.Rekordok[i]^)[j];
      A.Rekordok.add(Prekord);
    end;
  end;
end;

Function TablaMasolo(Be : TTIBSQLTabla): TTIBSQLTabla;
var ki : TTIBSQLTabla;
    i,j : Integer;
    Prekord : ^Trekord;
begin
  ki := TTIBSQLTabla.create;
  for j := 0 to Be.Oszlopszam - 1 do begin
     Ki.addmezo( TElem(Be.Mezok[j]).Nev, 'CHAR', Telem(Be.Mezok[j]).AdatMeret);
     Telem(ki.Mezok[j]).Token := TElem(Be.Mezok[j]).Token;
     Telem(ki.Mezok[j]).Keplet := TElem(Be.Mezok[j]).Keplet;
     Telem(ki.Mezok[j]).Alias := TElem(Be.Mezok[j]).Alias;
     Telem(ki.Mezok[j]).CsFv := TElem(Be.Mezok[j]).CsFv;
     Telem(ki.Mezok[j]).Kertekek := Ki.Mezok
  end;
  Ki.DISKTabla := False;
  for i := 0 to Be.RekordSzam - 1 do begin
      Getmem(Prekord, Be.Oszlopszam * sizeof(Pointer));
      for j := 0 to Be.OszlopSzam - 1 do
        Prekord^[j] :=  Trekord(Be.Rekordok[i]^)[j];
      Ki.Rekordok.add(Prekord);
  end;
  Result := Ki;
end;

Function TablaOsszeKapcsolo(A,B : TTIBSQLTabla;
                            LEFTOUTER : Boolean;
                            JoinFeltetel : Telemek): TTIBSQLTabla;
var ki : TTIBSQLTabla;
    i,j,k,j0 : Integer;
    Prekord : ^Trekord;
    W : Telem;
    VanParja : Boolean;
begin
  if TIBSQLstatus <> TIBSQL_OK then begin
     Result := A;
     exit;
  end;
  Ki := TTIBSQLTabla.create;
  for j := 0 to A.Oszlopszam - 1 do begin
     Ki.addmezo( TElem(A.Mezok[j]).Nev, 'CHAR', Telem(A.Mezok[j]).AdatMeret);
     Telem(ki.Mezok[j]).Token := TElem(A.Mezok[j]).Token;
     Telem(ki.Mezok[j]).Keplet := TElem(A.Mezok[j]).Keplet;
     Telem(ki.Mezok[j]).Alias := TElem(A.Mezok[j]).Alias;
     Telem(ki.Mezok[j]).CsFv := TElem(A.Mezok[j]).CsFv;
     Telem(ki.Mezok[j]).Kertekek := Ki.Mezok;
  end;
  i := A.Oszlopszam;
  for j := 0 to B.Oszlopszam - 1 do begin
     Ki.addmezo( TElem(B.Mezok[j]).Nev, 'CHAR', Telem(B.Mezok[j]).AdatMeret);
     Telem(ki.Mezok[j+i]).Token := TElem(A.Mezok[j]).Token;
     Telem(ki.Mezok[j+i]).Keplet := TElem(A.Mezok[j]).Keplet;
     Telem(ki.Mezok[j+i]).Alias := TElem(A.Mezok[j]).Alias;
     Telem(ki.Mezok[j+i]).CsFv := TElem(A.Mezok[j]).CsFv;
     Telem(ki.Mezok[j+i]).Kertekek := Ki.Mezok;
  end;
  Ki.DISKTabla := False;
  for i := 0 to A.Rekordszam - 1 do begin
    Vanparja := False;
    for k := 0 to B.RekordSzam - 1 do begin
       // j rekord ltrehozsa feltltse
       getmem(Prekord, ki.Oszlopszam * sizeof(Pointer));
       for j := 0 to A.Oszlopszam - 1 do
         Prekord^[j] := TRekord(A.Rekordok[i]^)[j];
       j0 := A.Oszlopszam;
       for j := 0 to B.Oszlopszam - 1 do
         Prekord^[j + j0] := TRekord(B.Rekordok[k]^)[j];
       J0 := 0;
       if Joinfeltetel <> Nil then begin
         for j := 0 to ki.Oszlopszam - 1 do
            ki.mezo(j).PAdat := Prekord^[j];
         W := Kiertekelo(JoinFeltetel, J0, ki.Mezok);
         if W.asBoolean then begin
           ki.Rekordok.add(Prekord);
           Vanparja := True;
         end else
           Freemem(Prekord, ki.Oszlopszam * sizeof(Pointer));
         W.Free;
       end else begin
           ki.Rekordok.add(Prekord);
           Vanparja := True;
       end;
    end;
    if LEFTOUTER and (not Vanparja) then begin
        // pratlan rekord kialakitsa s kiirsa
       getmem(Prekord, ki.Oszlopszam * sizeof(Pointer));
       for j := 0 to A.Oszlopszam - 1 do
         Prekord^[j] := TRekord(A.Rekordok[i]^)[j];
       j0 := A.Oszlopszam;
       for j := 0 to B.Oszlopszam - 1 do
         Prekord^[j + j0] := addr(NULLERTEK);
       ki.Rekordok.add(Prekord);
    end;
  end;
  Result := Ki;
end;

Procedure SetTablaAlias(Be : TTIBSQLTabla; Alias : String);
var i,j : Integer;
    S,S1 : String;
begin
  for i := 0 to Be.Oszlopszam - 1 do begin
    S := Be.Mezo(i).Nev;
    S1 := S;
    j := pos('.',S);
    if j > 0 then
       S :=  copy(S,j+1, Length(S));
    if Alias <> '' then
       S := Uppercase(Alias) + '.' + S;
    Be.mezo(i).Nev := S;
    if Be.mezo(i).Alias = S1 then
       Be.mezo(i).Alias := S;
  end;
end;

initialization
  TIBSQLErrorinfo := '';
  TIBSQLstatus := TIBSQL_OK;
end.
