unit TIBSQLDEMO2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    EditDBDir: TEdit;
    BtnDBConnect: TButton;
    BtnDisconnect: TButton;
    Label2: TLabel;
    MemoSQL: TMemo;
    BtnRUN: TButton;
    StringGrid1: TStringGrid;
    Label3: TLabel;
    EditStatus: TEdit;
    Label4: TLabel;
    EditDB: TEdit;
    LabelDB: TLabel;
    procedure FormActivate(Sender: TObject);
    procedure BtnDBConnectClick(Sender: TObject);
    procedure BtnDisconnectClick(Sender: TObject);
    procedure BtnRUNClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    TIBSQL : Pointer;
    WTabla : Pointer;
    TIBSQLstatus : Integer;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses TIBSQLDLL;

Procedure TForm1.FormActivate(Sender: TObject);
begin
  EditDBDir.text := extractFilepath(paramstr(0));
  BtnDisconnect.Enabled := false;
  BtnRun.Enabled := false;
  BtnDBConnect.setfocus;
  LabelDB.caption := '';
  if Fileexists('TIBSQLDEMO.INI') then
     MemoSQL.Lines.LoadFromfile('TIBSQLDEMO.INI');
end;

procedure TForm1.BtnDBConnectClick(Sender: TObject);
begin
  BtnDBConnect.Enabled := false;
  BtnDisconnect.Enabled := True;
  BtnRun.Enabled := True;
  TIBSQL := TIBSQLConnect(EditDBDir.text,EditDB.text);
  EditStatus.text := '';
  LabelDB.caption := '';
  StringGrid1.Visible := false;
end;

procedure TForm1.BtnDisconnectClick(Sender: TObject);
begin
  if Wtabla <> Nil then
     TIBSQLCloseCursor(Wtabla);
  WTabla := Nil;
  StringGrid1.Visible := false;
  TIBSQLdisconnect(TIBSQL);
  TIBSQL := Nil;
  BtnDBConnect.Enabled := True;
  BtnDisconnect.Enabled := False;
  BtnRun.Enabled := False;
  EditStatus.text := '';
  LabelDB.caption := '';
end;

procedure TForm1.BtnRUNClick(Sender: TObject);
var i,j : Integer;
begin
  MemoSQL.Lines.savetofile('TIBSQLDEMO.INI');
  StringGrid1.Rowcount := 0;
  StringGrid1.Colcount := 0;
  if WTabla <> Nil then
     TIBSQLcloseCursor(WTabla);
  WTabla := Nil;
  WTabla := TIBSQLExecSQL(TIBSQL, MemoSQL.Lines.text );
  TIBSQLstatus := TIBSQLgetStatus(TIBSQL);
  if TIBSQLstatus = 0 then
     EditStatus.text := 'OK'
  else begin
       EditStatus.text := TIBSQLgetErrormsg;
  end;
  if (Wtabla <> Nil) and
     (TIBSQLstatus = 0) then begin
    StringGrid1.RowCount := TIBSQLRecordCount(Wtabla) + 3;
    StringGrid1.ColCount := TIBSQLColumnCount(Wtabla);
    StringGrid1.FixedCols := 0;
    // mez adatok beirsa
    for j := 0 to TIBSQLColumnCount(Wtabla) - 1 do
      StringGrid1.ColWidths[j] := 100;
    for j := 0 to TIBSQLColumnCount(WTabla) - 1 do
      StringGrid1.Cells[j,0] := TIBSQLgetColumnName(WTabla,j);
    for j := 0 to TIBSQLColumnCount(Wtabla) - 1 do begin
      StringGrid1.Cells[j,1] :=
         TIBSQLgetColumnType(WTabla,j);
    end;
    for j := 0 to TIBSQLColumnCount(Wtabla) - 1 do
      StringGrid1.Cells[j,2] :=
        IntTostr(TIBSQLgetColumnSize(WTabla,j));
    // adatok beirsa
    for i := 0 to TIBSQLColumnCount(Wtabla) - 1 do begin
      TIBSQLGo(Wtabla,i);
      for j := 0 to TIBSQLColumnCount(Wtabla) - 1 do
        StringGrid1.Cells[j,i+3] :=
          TIBSQLgetString(Wtabla,j);
    end;
    LabelDb.caption := Inttostr(TIBSQLRecordCount(Wtabla));
  end; // van eredmny tbla
  if StringGrid1.rowcount = 3 then begin
     StringGrid1.rowcount := 4;
     for j := 0 to TIBSQLColumnCount(Wtabla) - 1 do
        StringGrid1.Cells[j,3] := '';
  end;
  if StringGrid1.RowCount > 3 then
     StringGrid1.FixedRows := 3;
  StringGrid1.Visible := True;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   if Wtabla <> Nil then
     TIBSQLCloseCursor(WTabla);
   WTabla := Nil;
   if TIBSQL <> Nil then
     TIBSQLDisconnect(TIBSQL);
   TIBSQL := Nil;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  TIBSQL := Nil;
  WTabla := Nil;
  TIBSQLLoadDll;
end;

end.
