unit TIBSQL;

interface

uses SQLElemzo, TIBSQLkeplet, TIBSQLTabla, TIBSQLRutinok,
     classes, sysutils, Filectrl;

type

  // Status: TIBSQLStatus                       (TIBSQLRutinok unitban)
  // Hiba informcis string : TIBSQLErrorInfo  (TIBSQLRutinok unitban)

  TTIBSQL = class
  private
    DISKTablak : Tlist; // of TTIBSQLTabla;
    // DISK tblt keres a DISKTablak -ban, ha megvan visszadja annak cimt,
    // Ha nincs meg akkor beolvassa s az j DISKTabla cimt adja vissza
    Function LoadDISKTabla(tablanev:String): TTIBSQLTabla;
    Function UnionsVegrehajto(Selektek : Tselektek;
                               Rendezes : Toszlopok) : TTIBSQLTabla;
    Function SelectVegrehajto(Select : Tselect;
                              Rendezes : Toszlopok) : TTIBSQLTabla;
    Procedure Insertvegrehajto(Tablanev : String;
                               OszlopNevek, Ertekek : Tstrings;
                               Selektek : Tselektek;
                               Rendezes : TOszlopok);

    Procedure Updatevegrehajto(Tablanev : String;
                                OszlopNevek, Ertekek : Tstrings;
                                Feltetel : Tstrings);
    Procedure DeleteVegrehajto(Tablanev : String;
                                Feltetel : Tstrings);
    Procedure CreatetableVegrehajto(Tablanev : String;
                                    Oszlopdefek : Tlist);
    Procedure AlterTableVegrehajto(Tablanev : String;
                                    Oszlopdefek : Tlist);
    Procedure DropTableVegrehajto(tablanev : String);
    Procedure RollBackvegrehajto;
  public
    DBDIR : String;
    Databasename : String;
    Connected : Boolean;
    constructor Create;
    destructor Free;
    Procedure Connect;
    Procedure Disconnect;
    Procedure Createdatabase;
    Procedure DropDatabase;
    Function getTableNames : Tstrings;
    Procedure Flush; // a megvltozott DISKTabla-kat lemezre menti
    // a kvetkez kt rutin query -nl egy j krelt TIBSQLtabla-t ad vissza
    //                       egybknt Nil -t ad vissza
    Function ExecSQL(SQLstr : String) : TTIBSQLTabla;
    Function ExecElemzettSQL(SQLParser : TSQLParser) : TTIBSQLTabla;
  end;

implementation

constructor TTIBSQL.Create;
begin
    DiskTablak := Tlist.create; // of TTIBSQLTabla
    Databasename := '';
    Connected := false;
end;

destructor TTIBSQL.Free;
var i : Integer;
begin
  for i := 0 to DISKTablak.count - 1 do
    TTIBSQLTabla(DISKTablak[i]).Free;
end;

Procedure TTIBSQL.Connect;
begin
  if DBdir <> '' then begin
     if DBdir[Length(DBDir)] <> '\' then
        DBDir := DBDir + '\';
  end;
  Connected := True;
end;

Procedure TTIBSQL.Disconnect;
var i : Integer;
begin
  for i := 0 to DISKTablak.count - 1 do
    TTIBSQLTabla(DISKTablak[i]).Free;
  DISKTablak.clear;
  Connected := False;
end;

Procedure TTIBSQL.Createdatabase;
begin
  if DBdir <> '' then begin
     if DBdir[Length(DBDir)] <> '\' then
        DBDir := DBDir + '\';
  end;
  if not Directoryexists(DBDIR + databasename) then
    MkDir(DBDIR + databasename);
end;

Procedure TTIBSQL.DropDatabase;
var i : Integer;
    SR : Tsearchrec;
begin
  if DBdir <> '' then begin
     if DBdir[Length(DBDir)] <> '\' then
        DBDir := DBDir + '\';
  end;
  if Directoryexists(DBDIR + databasename) then begin
     i := FindFirst(DBdir + Databasename + '\*.csv',faAnyFile,SR);
     while i = 0 do begin
        deleteFile(DBDir + databasename + '\' + SR.name);
        i := Findnext(SR);
     end;
     FindClose(SR);
     RmDir(DBDir + databasename);
  end;
end;

Function TTIBSQL.getTableNames : Tstrings;
var i : Integer;
    SR : Tsearchrec;
    ki : Tstrings;
    S : string;
begin
  ki := TstringList.create;
  if DBdir <> '' then begin
     if DBdir[Length(DBDir)] <> '\' then
        DBDir := DBDir + '\';
  end;
  if Directoryexists(DBDIR + databasename) then begin
     i := FindFirst(DBdir + Databasename + '\*.csv',faAnyFile,SR);
     while i = 0 do begin
        S := SR.name;
        i := pos('.',S);
        if i > 0 then
           S := copy(S,1,i-1);
        ki.add(S);
        i := Findnext(SR);
     end;
     FindClose(SR);
  end;
  Result := Ki;
end;

Function TTIBSQL.ExecSQL(SQLstr : String) : TTIBSQLTabla;
var SQLparser : TSQLParser;
begin
  SQLParser := TSQLparser.create;
  SQLParser.LoadFromstr(SQLstr);
  if ElemzoError > 0 then begin
    TIBSQLstatus := ElemzoError;
    Result := Nil;
    Exit;
  end;
  Result := ExecElemzettSQL(SQLparser);
  SQLParser.free;
end;

Function TTIBSQL.ExecElemzettSQL(SQLParser : TSQLParser) : TTIBSQLTabla;
var ki : TTIBSQLTabla;
    DFmento : String[20];
    DFSmento : Char;
begin
  DFMento := ShortdateFormat;
  DFsmento := DateSeparator;
  ShortdateFormat := 'yyyy/mm/dd';
  DateSeparator := '.';
  ki := Nil;
  case SQLParser.Tipus  of
    _QUERY :  ki := UnionsVegrehajto(SQLParser.Selektek,
                                     SQLParser.rendezes);
    _CREATEDATABASE : begin
                        databasename := SQLParser.DBnev;
                        CreateDatabase;
                      end;
    _DROPDATABASE   : begin
                        databasename := SQLParser.DBnev;
                        DropDatabase;
                      end;
    _CREATETABLE    : begin
                        CreatetableVegrehajto(SQLParser.Tablanev,
                                              SQLParser.Oszlopdefek);
                      end;
    _DROPTABLE      : begin
                        DropTableVegrehajto(SQLParser.Tablanev);
                      end;
    _ALTERTABLE     : begin
                        AlterTableVegrehajto(SQLParser.Tablanev,
                                              SQLParser.Oszlopdefek);
                      end;
    _FLUSH          : begin
                        Flush;
                      end;
    _COMMIT         : begin
                        Flush;
                      end;
    _ROLLBACK:        begin
                        RollBackVegrehajto;
                      end;
    _BEGIN:          begin
                        Flush; 
                      end;
    _END:            begin
                        Flush; 
                      end;
    _CREATEINDEX,_DROPINDEX : begin
                                ;
                              end;
    _INSERT         : begin
                        Insertvegrehajto(SQLParser.Tablanev,
                                         SQLParser.OszlopNevek,
                                         SQLParser.Ertekek,
                                         SQLParser.Selektek,
                                         SQLParser.rendezes);
                      end;
    _UPDATE         : begin
                        Updatevegrehajto(SQLParser.Tablanev,
                                         SQLParser.OszlopNevek,
                                         SQLParser.Ertekek,
                                         SQLParser.feltetel);
                      end;
    _DELETE         : begin
                        DeleteVegrehajto(SQLParser.Tablanev,
                                         SQLParser.feltetel);
                      end;
  else
     TIBSQLstatus := TIBSQL_HibasSQLutasitas;
     TIBSQLErrorInfo := '';
  end;
  ShortdateFormat := DFMento;
  DateSeparator := DFsmento;
  Result := ki;
end;

Procedure TTIBSQL.Flush; // a megvltozott DISKTabla-kat lemezre menti
var i : Integer;
begin
  for i := 0 to DISKTablak.count - 1 do begin
    if TTIBSQLTabla(DISKTablak[i]).Valtozott then
       TTIBSQLTabla(DISKTablak[i]).KiirFileba;
  end;
end;

// ***********************************************************************

Function TTIBSQL.LoadDISKTabla(tablanev:String): TTIBSQLTabla;
var ki : TTIBSQLTabla;
    i : Integer;
begin
  tablanev := uppercase(tablanev);
  ki := Nil;
  for i := 0 to DISKTablak.count - 1 do begin
    if TTIBSQLTabla(DISKTablak[i]).Nev = tablanev then
      ki := DISKTablak[i];
  end;
  if ki = Nil then begin
    ki := TTIBSQLTabla.create;
    ki.Nev := tablanev;
    ki.Konyvtar := DBDIR + Databasename + '\';
    ki.BeolvasFilebol;
    DISKTablak.add(ki);
  end;
  Result := ki;
end;


Function TTIBSQL.SelectVegrehajto(Select : Tselect;
                                  Rendezes : Toszlopok) : TTIBSQLTabla;
var Work1,Work2,Work3 : TTIBSQLTabla;
    i : Integer;
    Feltetel : Telemek;
    Rendezes0 : string[2];

    Function DefaultCsoportkell(W : TTIBSQLTabla) : Boolean;
    // True ha minden oszlopban csoport fv. szerepel
    var j : Integer;
    begin
      Result := True;
      for j := 0 to W.Oszlopszam - 1 do
        if W.mezo(j).Csfv = '' then
           Result := False;
    end;

begin
  if TIBSQLstatus <> TIBSQL_OK then begin
     Work1 := TTIBSQLTabla.create;
     Result := Work1;
     Exit;
  end;
  if (Select.Tablak.count > 0) and
     (Select.Oszlopok.count > 0) then begin

     // tabla[0] -> Work1
     Work2 := LoadDisktabla(Ttabla(Select.tablak[0]).nev);
     if Work2 <> Nil then
        Work1 := Tablamasolo(Work2)
     else begin
       TIBSQLstatus := TIBSQL_TablaNincsMeg;
       TIBSQLErrorInfo := Ttabla(Select.tablak[0]).nev;
       result := Nil;
       Exit;
     end;

     if Work1.Oszlopszam = 0 then begin
       TIBSQLstatus := TIBSQL_TablaNincsMeg;
       TIBSQLErrorInfo := Ttabla(Select.tablak[0]).nev;
       result := Nil;
       Exit;
     end;
     SetTablaAlias(Work1, Ttabla(Select.tablak[0]).TablaAlias);

     // ciklusban hozzkapcsolom a tovbbi tblkat
     // Work1 := Work1 x kapcsolttbla
     for i := 1 to Select.Tablak.count - 1 do begin
       if TIBSQLstatus <> TIBSQL_OK then begin
         Result := Work1;
         Exit;
       end;
       Work2 := LoadDisktabla(Ttabla(Select.tablak[i]).nev);
       if Work2 = Nil then begin
         TIBSQLstatus := TIBSQL_TablaNincsMeg;
         TIBSQLErrorInfo := Ttabla(Select.tablak[i]).nev;
         Result := Work1;
         Exit;
       end;
       if Work2.Oszlopszam = 0 then begin
         TIBSQLstatus := TIBSQL_TablaNincsMeg;
         TIBSQLErrorInfo := Ttabla(Select.tablak[i]).nev;
         Result := Work1;
         Exit;
       end;
       SetTablaAlias(Work2, Ttabla(Select.tablak[i]).TablaAlias);
       Work3 := tablaOsszekapcsolo( Work1, Work2,
                                    False,
                                    Nil);

       SetTablaAlias(Work2,'');
       Work1.Free;
       Work1 := Work3;
     end;

     // ciklusban hozzkapcsolom a joinokat
     // Work1 := Work1 + joinolttbla
     for i := 0 to Select.Joinok.count - 1 do begin
       if TIBSQLstatus <> TIBSQL_OK then begin
         Result := Work1;
         Exit;
       end;
       Work2 := LoadDisktabla(TJoin(Select.Joinok[i]).Tablanev);
       if Work2 = Nil then begin
         TIBSQLstatus := TIBSQL_TablaNincsMeg;
         TIBSQLErrorInfo := Ttabla(Select.tablak[i]).nev;
         Result := Work1;
         Exit;
       end;
       if Work2.Oszlopszam = 0 then begin
         TIBSQLstatus := TIBSQL_TablaNincsMeg;
         TIBSQLErrorInfo := TJoin(Select.Joinok[i]).Tablanev;
         Result := Nil;
         Exit;
       end;
       SetTablaAlias(Work2, TJoin(Select.Joinok[i]).TablaAlias);
       Feltetel := Elemzo(Tjoin(Select.Joinok[i]).Feltetel);
       if TIBSQLstatus <> TIBSQL_OK then begin
          Work2.free;
          Result := Work1;
          Exit;
       end;
       Work3 := tablaOsszekapcsolo( Work1, Work2,
                                    Tjoin(Select.Joinok[i]).Opcio = LEFTOUTER,
                                    Feltetel);
       Feltetel.free;
       SetTablaAlias(Work2,'');
       Work1.Free;
       Work1 := Work3;
     end;

     // felttel szrs  Work1 -ben
     if TIBSQLstatus <> TIBSQL_OK then begin
       Result := Work1;
       Exit;
     end;
     if Select.feltetel <> Nil then begin
        Feltetel := Elemzo(Select.Feltetel);
        if TIBSQLstatus <> TIBSQL_OK then begin
            result := Work1;
            Exit;
        end;
        Szuro(Work1, Feltetel);
        Feltetel.Free;
     end;

     // Ha van rendezes s nem GROUP akkor rendezem a Work1 -et
     Rendezes0 := '';
     if (rendezes <> Nil) and (Rendezes.count > 0) then begin
        Rendezes0 := Toszlop(Rendezes[0]).kifejezes + 'X';
        if (Select.Csoport.count = 0) and (rendezes0[1] > '9') then
        Rendezo(Work1, Rendezes);
     end;

     // oszlop szelektls, csoportosits   Work1 -> Work2
     if TIBSQLstatus <> TIBSQL_OK then begin
       Result := Work1;
       Exit;
     end;
     Work2 := Szelektalo(Work1,
                        Select.Oszlopok,
                        Select.Csoport);
     Work1.Free;

     // ha kell distinct szrs  Work2 -ben
     if TIBSQLstatus <> TIBSQL_OK then begin
       Result := Work2;
       Exit;
     end;
     if select.Distinct then
        DistinctSzuro(Work2);

     // ha kell default csoportosits  Work2 -> Work3
     // ha minden oszlop csfv -t tartalmaz s nincs megadva
     // csoportosits akkor default csoportosits
     if TIBSQLstatus <> TIBSQL_OK then begin
       Result := Work2;
       Exit;
     end;
     if (Select.Csoport.count = 0) and
        DefaultCsoportkell(Work2) then begin
        Work3 := Csoportosito(Work2, Nil);
        Work2.free;
     end else begin
        Work3 := Work2;
     end;

     // ha kell csoport szrs  Work3 -ben
     if TIBSQLstatus <> TIBSQL_OK then begin
       Result := Work3;
       Exit;
     end;
     if Select.Csoportfeltetel.count > 0 then begin
        Feltetel := Elemzo(Select.CsoportFeltetel);
        if TIBSQLstatus <> TIBSQL_OK then begin
            Result := Work3;
            Exit;
        end;
        Szuro(Work3, feltetel);
        Feltetel.Free;
     end;

     // Ha kell rendezs
     // Ha van rendezes s nem GROUP
     // vagy ha a rendezs oszlop sorszmokkal van megadva
     // akkor rendezem a Work3 -at
     if (rendezes <> Nil) and (Rendezes.count > 0) then begin
        if (Select.CsoportFeltetel.count = 0) or
           ( Rendezes0[1] <= '9' ) then
        Rendezo(Work3, Rendezes);
     end;
     result := Work3;
  end else begin
     TIBSQLstatus := TIBSQL_NincsEredmeny;
     TIBSQLErrorInfo := '';
     Work2 := TTIBSQLTabla.create;
     result := Work2;
  end; // van oszlopdef s tabla
end;

Function TTIBSQL.UnionsVegrehajto(Selektek : Tselektek;
                               Rendezes : Toszlopok) : TTIBSQLTabla;
var W1,W2 : TTIBSQLTabla;
    var i : Integer;

    Function UnionEllenorzo(W1,W2 : TTIBSQLTabla):Boolean;
    var j : Integer;
    begin
      if W1.Oszlopszam <> W2.oszlopszam then
         result := false
      else begin
        result := True;
        for j := 0 to W1.Oszlopszam - 1 do
          if W1.Mezo(j).Token <> W2.mezo(j).Token then
             result := false;
      end;
    end;

begin
  TIBSQLstatus := TIBSQL_OK;
  TIBSQLErrorInfo := '';
  W1 := Nil;
  if Selektek.count > 0 then begin
    if selektek.count = 1 then
       W1 := SelectVegrehajto(Selektek[0], Rendezes)
    else
       W1 := SelectVegrehajto(Selektek[0], Nil);
    for i := 1 to Selektek.count - 1 do begin
      W2 := Selectvegrehajto(Selektek[i],Nil);
      if UnionEllenorzo(W1,W2) then begin
         HozzaFuzo(W1,W2);
         W2.DISKTabla := false;
      end else begin
        TIBSQLstatus := TIBSQL_unionhiba;
        TIBSQLErrorInfo := '';
        Result := W1;
        exit;
      end;
      if not Tselect(Selektek[i]).UnionAll then
         DistinctSzuro(W1);
      W2.free;
    end;
    if (Rendezes.count > 0) and (selektek.count > 1) then
       Rendezo(W1, Rendezes);
  end; // vannak selektek
  Result := W1;
end;

Function csupaszito(be : string) : String;
begin
  if Be = '' then
     Result := Be
  else begin
    if be[1] <> '''' then
       Result := Be
    else
       result := copy(be,2, length(be)-2);
  end;
end;

Procedure TTIBSQL.Insertvegrehajto(Tablanev : String;
                                   OszlopNevek, Ertekek : Tstrings;
                                   Selektek : Tselektek;
                                   Rendezes : TOszlopok);
var W,W1 : TTIBSQLTabla;
    i,j : Integer;
    M,M1 : Telem;
begin
  TIBSQLstatus := TIBSQL_OK;
  TIBSQLErrorInfo := '';
  W := LoadDISKTabla(tablanev);
  if W.Oszlopszam = 0 then begin
         TIBSQLstatus := TIBSQL_TablaNincsMeg;
         TIBSQLErrorInfo := tablanev;
         Exit;
  end;
  if Oszlopnevek.count = 0 then begin
     // oszlopnevek a tblbl
     for j := 0 to W.Oszlopszam - 1 do
       Oszlopnevek.add( W.mezo(j).Nev);
  end;
  if Selektek.count > 0 then begin
     //
     // Insert select -bl
     //
     W1 := UnionsVegrehajto(Selektek,Rendezes);
     if (W1 <> Nil) and (TIBSQLstatus = TIBSQL_OK) then begin
       if W1.Oszlopszam = Oszlopnevek.count then begin
         for j := 0 to W1.Rekordszam - 1 do begin
           W1.Go(j);
           W.append;
           for i := 0 to Oszlopnevek.count - 1 do begin
              M := W.mezoByname(OszlopNevek[i]);
              M1 := W1.mezoByname(OszlopNevek[i]);
              if (M <> Nil) and (M1 <> Nil) then
                M.asString := M1.asString
              else begin
                TIBSQLstatus := TIBSQL_OszlopNincsmeg;
                TIBSQLErrorInfo := OszlopNevek[i];
              end;
           end;
           W.post;
         end;
       end else begin
         TIBSQLstatus := TIBSQL_ErtekDbHiba;
         TIBSQLErrorInfo := '';
       end;
       W1.free;
     end;
     Exit;
  end;
  if Oszlopnevek.count = Ertekek.Count then begin
    //
    //  insert rtklistbl
    //
    W.Append;
    for i := 0 to Oszlopnevek.count - 1 do begin
      M := W.mezoByname(OszlopNevek[i]);
      if M <> Nil then
        M.asString := Csupaszito(Ertekek[i])
      else begin
        TIBSQLstatus := TIBSQL_OszlopNincsmeg;
        TIBSQLErrorInfo := OszlopNevek[i];
      end;
    end;
    W.post;
  end else begin
    TIBSQLstatus := TIBSQL_ErtekDbHiba;
    TIBSQLErrorInfo := '';
  end;
end;

Procedure TTIBSQL.Updatevegrehajto(Tablanev : String;
                                OszlopNevek, Ertekek : Tstrings;
                                Feltetel : Tstrings);
var Feltetel2 : Telemek;
    i,j : Integer;
    W : TTIBSQLTabla;
    W2 : Telem;
    M : Telem;
begin
  TIBSQLstatus := TIBSQL_OK;
  TIBSQLErrorInfo := '';
  W := LoadDISKTabla(tablanev);
  if W.Oszlopszam = 0 then begin
         TIBSQLstatus := TIBSQL_TablaNincsMeg;
         TIBSQLErrorInfo := tablanev;
         Exit;
  end;
  if feltetel.count > 0 then
     Feltetel2 := Elemzo(Feltetel)
  else
     feltetel2 := Nil;   
  if TIBSQLstatus <> TIBSQL_OK then
      Exit;
  for i := 0 to W.rekordszam - 1 do begin
    W.go(i);
    J := 0;
    if Feltetel.count > 0 then
       W2 := Kiertekelo(Feltetel2,J,W.Mezok)
    else begin
       W2 := Telem.create;
       W2.asBoolean := True;
    end;
    if W2.asBoolean then begin
       W.Edit;
       for j := 0 to Oszlopnevek.count - 1 do begin
          M := W.mezoByname(OszlopNevek[j]);
          if M <> Nil then
            M.asString := Csupaszito(Ertekek[j])
          else begin
            TIBSQLstatus := TIBSQL_OszlopNincsmeg;
            TIBSQLErrorInfo := OszlopNevek[j];
          end;
       end;
       W.Post;
    end;
    W2.free;
  end;
  if feltetel.count > 0 then
    feltetel2.free;
end;

Procedure TTIBSQL.DeleteVegrehajto(Tablanev : String;
                                Feltetel : Tstrings);
var Feltetel2 : Telemek;
    i,j : Integer;
    W : TTIBSQLTabla;
    W2 : Telem;
begin
  TIBSQLstatus := TIBSQL_OK;
  TIBSQLErrorInfo := '';
  W := LoadDISKTabla(tablanev);
  if W.Oszlopszam = 0 then begin
         TIBSQLstatus := TIBSQL_TablaNincsMeg;
         TIBSQLErrorInfo := tablanev;
         Exit;
  end;
  Feltetel2 := Elemzo(Feltetel);
  if TIBSQLstatus <> TIBSQL_OK then
          Exit;
  i := 0;
  while  i < W.Rekordok.count do begin
    W.go(i);
    J := 0;
    W2 := Kiertekelo(Feltetel2,J,W.Mezok);
    if (W2.asBoolean) or (Feltetel2.count = 0) then begin
       W.delete;
    end else begin
      inc(i);
    end;
    W2.free;
  end;
  feltetel2.free;
  W.Valtozott := True;
end;


Procedure TTIBSQL.CreatetableVegrehajto(Tablanev : String;
                                    Oszlopdefek : Tlist);
var W : TTIBSQLTabla;
    i : Integer;
    OD : Toszlopdef;
    Meret : Byte;
begin
  TIBSQLstatus := TIBSQL_OK;
  TIBSQLErrorInfo := '';
  W := TTIBSQLTabla.create;
  W.DISKTabla := True;
  W.Konyvtar := DBDIR + databasename + '\';
  W.nev := Tablanev;
  for i := 0 to Oszlopdefek.count - 1 do begin
    OD := Oszlopdefek[i];
    OD.Nev := uppercase(OD.Nev);
    OD.Tipus := uppercase(OD.Tipus);
    if OD.Tipus = 'CHAR' then
      Meret := strtoint(OD.Meret) + 1
    else begin
      if OD.Tipus = 'INTEGER' then
          Meret := sizeof(Longint)
      else if OD.Tipus = 'FLOAT' then
          Meret := sizeof(Double)
      else if OD.Tipus = 'DATE' then
          Meret := sizeof(TDateTime)
      else if OD.Tipus = 'BOOLEAN' then
          Meret := sizeof(Boolean)
      else
          Meret := 4;    
    end;
    W.addmezo( OD.Nev, OD.Tipus, Meret);
  end;
  W.KiirFileba;
  W.free;
end;

Procedure TTIBSQL.AlterTableVegrehajto(Tablanev : String;
                                       Oszlopdefek : Tlist);
var W : TTIBSQLTabla;
    i : Integer;
    OD : ToszlopDef;
    Meret : Byte;
begin
  TIBSQLstatus := TIBSQL_OK;
  TIBSQLErrorInfo := '';
  W := LoadDISKTabla(tablanev);
  if W.Oszlopszam = 0 then begin
         TIBSQLstatus := TIBSQL_TablaNincsMeg;
         TIBSQLErrorInfo := tablanev;
         Exit;
  end;
  for i := 0 to Oszlopdefek.count - 1 do begin
    OD := Oszlopdefek[i];
    OD.Nev := uppercase(OD.Nev);
    OD.Tipus := uppercase(OD.Tipus);
    if OD.Tipus = 'CHAR' then
      Meret := strtoint(OD.Meret) + 1
    else
      meret := strtoint(OD.Meret);
    W.addmezo( OD.Nev, OD.Tipus, Meret);
  end;
  W.KiirFileba;
end;

Procedure TTIBSQL.DropTableVegrehajto(tablanev : String);
var W : TTIBSQLTabla;
begin
  if FileExists(DBDir + databasename + '\' + tablanev + '.csv') then begin
     deleteFile(DBDir + databasename + '\' + tablanev + '.csv');
  end;
  W := LoadDISKTabla(Tablanev);
  if W.Oszlopszam > 0 then begin
     W.valtozott := False;
     W.nev := '@';
  end;
end;

Procedure TTIBSQL.RollbackVegrehajto;
var i : Integer;
begin
  for i := 0 to DISKTABLAK.count - 1 do begin
    TTIBSQLTabla(DISKTablak[i]).Valtozott := False;
    TTIBSQLTabla(DISKTablak[i]).Free;
  end;
  DISKTablak.clear;  
end;


end.
