{$A+,B-,C+,D+,E-,F-,G+,H-,I-,J+,K-,L+,M-,N+,O-,P+,Q-,R-,S-,T-,U-,V+,W-,X+,Y+,Z1}
unit TrdBase;

{--------------------------------------------------------------------}
{ FtpBase module. Basic objects for all the FTP components.          }
{ 11/15/1999 Drt.                                                    }
{--------------------------------------------------------------------}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  WinSock, FtpObj, CBuf, GetWrd;

const
  CM_START   = 1001;  { Main control thread has started }
  CM_LISTEN  = 1002;  { Main control thread is in the LISTEN state }
  CM_STOP    = 1003;  { Main control thread has forced to stop }
  CM_TERM    = 1004;  { Main control thread has terminated }

  SS_START   = 1101;
  SS_STOP    = 1102;

  CS_START   = 1201;  { Control thread has started }
  CS_TERM    = 1202;  { Control thread has terminated }
  CS_COMMAND = 1203;  { Control thread has received a command }
  CS_LOGIN   = 1204;
  CS_LOGOUT  = 1205;
  CS_CHDIR   = 1206;
  CS_DLOAD   = 1207;
  CS_ULOAD   = 1208;

  DS_LISTEN  = 1501;  { Data thread is in the LISTEN state }
  DS_SOCKET  = 1502;  { Data thread has created a socket }
  DS_CONNECT = 1503;  { Data thread has opened a connection }
  DS_ACCEPT  = 1504;  { Data thread has accepted incoming connection }
  DS_FOPEN   = 1505;  { Error open file }
  DS_FREAD   = 1506;  { File read error }
  DS_SWRITE  = 1507;  { Socket write error }
  DS_FCREATE = 1508;  { Error creating file }
  DS_FWRITE  = 1509;  { File write error }
  DS_CLOSE   = 1510;  { Data connection closed }
  DS_BADMRK  = 1511;  { Bad restart marker }

  ES_NOMEM   = 2201;  { Control thread is out of memory }
  ES_DRUN    = 2202;  { Can't stop data process }
  ES_STOUT   = 2203;  { The sending takes too much time }

const
 tt_Main     = 2001;
 tt_Control  = 2002;
 tt_Data     = 2003;
 tt_Read     = 2004;

 MaxConn = 1000;

type
  TMode = (md_ASCII, md_EBCDIC, md_IMAGE, md_LOCAL);
  TLsFmt = (lf_UNIX, lf_DOS, lf_Custom);
  TStream = (dt_STREAM);
  TDirection = (di_SEND, di_RECEIVE, di_APPEND, di_LIST, di_NLST,
    di_IDLE, di_EOJ);
  TDataState = (ds_Start, ds_Progress, ds_Finished, ds_NoFile);
  TAddr = array [1..4] of byte;
  TDirFile = set of (df_Directory, df_GrRead, df_GrWrite, df_GrExec,
    df_Read, df_Write, df_Exec);

  TFtpComponent = class (TComponent)
  protected
    FDirRestrict   : Boolean;
    FListFormat    : TLsFmt;
    FCustomList    : String;
    FMaxConn       : Integer;
    FFtpPort       : Integer;
    FDataPort      : Integer;
    FShowHidden    : Boolean;
    FShowReadOnly  : Boolean;
    FMode          : TMode;
    FAllowRedirect : Boolean;
    FAllowAnonymous: Boolean;
    FBannerMsg     : TStringList;
    FPasswordMsg   : string;
    FFreePasswdMsg : string;
    FNoAnonymousMsg: string;
    FCaseSensitive : Boolean;
  private
    procedure WBannerMsg(ABannerMsg : TStringList);
    procedure WListFormat(Value : TLsFmt);
    procedure WCustomList(Value : string);
  published
    { Properties }
    property DirRestrict   : Boolean read FDirRestrict write FDirRestrict;
    property ListFormat    : TLsFmt read FListFormat write WListFormat;
    property CustomList    : String read FCustomList write WCustomList;
    property MaxConn       : Integer read FMaxConn write FMaxConn;
    property FtpPort       : Integer read FFtpPort write FFtpPort;
    property DataPort      : Integer read FDataPort write FDataPort;
    property ShowHidden    : Boolean read FShowHidden write FShowHidden;
    property ShowReadOnly  : Boolean read FShowReadonly write FShowReadonly;
    property Mode          : TMode read FMode write FMode;
    property AllowRedirect : Boolean read FAllowRedirect write FAllowRedirect;
    property AllowAnonymous: Boolean read FAllowAnonymous write FAllowAnonymous;
    property BannerMsg     : TStringList read FBannerMsg write WBannerMsg;
    property PasswordMsg   : string read FPasswordMsg write FPasswordMsg;
    property FreePasswdMsg : string read FFreePasswdMsg write FFreePasswdMsg;
    property NoAnonymousMsg: string read FNoAnonymousMsg write FNoAnonymousMsg;
    property CaseSensitive : Boolean read FCaseSensitive write FCaseSensitive;
  public
    UserList : TUserList;
    GrpList  : TGrpList;
    DirList  : TDirList;
    end;

  TFtpThreades = class (TThread)
  public
    PID     : word;
    PType   : integer;
    Run     : boolean;
    CSocket : integer;
    Port    : word;
    Error   : integer;
    Messg   : integer;
    Parent  : TFtpComponent;
    sin     : TSockAddrIn;
    cmd     : string[130];
    par     : string[130];
    Usr     : string[30];
    Pwd     : string[30];
    CDir    : string[130];
    FName   : string[130];
    State   : integer;
    RAddr   : TAddr;
    end;

  TCallLogEvent = procedure(AThreade : TFtpThreades; var Result : boolean) of object;

  TReadThread = class (TFtpThreades)
  private
    CB : TCB;
    procedure Execute; override;
  public
    constructor Create(ASocket : integer; ACB : TCB);
    procedure Terminate;
    end;

  TListFiller = class (TStringList)
  public
    constructor Create;
    procedure FillFrom(Dir : string; LType : TDirection; User : string;
      Ftp : TFtpComponent);
  private
    function FormatLine(Name : string; NType : TDirFile; PDir : integer;
      Ftp : TFtpComponent; user,group : string; FDate : TFileTime;
      FSize : longint; UID,GID : word) : string;
    end;

procedure bzero(var b; n : word);

implementation

type
 tb = array [0..$fff0] of byte;

procedure bzero(var b; n : word);
begin
while n > 0 do
  begin
  tb(b)[n-1]:=0;
  dec(n);
  end;
end;

{ ---------- TFtpComponent ---------- }

procedure TFtpComponent.WBannerMsg(ABannerMsg : TStringList);
begin
FBannerMsg.Assign(ABannerMsg);
end;

procedure TFtpComponent.WListFormat(Value : TLsFmt);
begin
FListFormat:=Value;
case FListFormat of
  lf_UNIX: FCustomList:='%r %I:3 %g:9 %s:10 %d:12 %f';
  lf_DOS: FCustomList:='%F:14 %s:8 %d';
  lf_CUSTOM: FCustomList:='%r %u:8 %g:8 %s:8 %d:12 %F';
  end;
end;

procedure TFtpComponent.WCustomList(Value : string);
begin
FCustomList:=Value;
FListFormat:=lf_Custom;
end;

{ ---------- TReadThread ---------- }

constructor TReadThread.Create;
begin
inherited Create(true);
CB:=ACB;
CSocket:=ASocket;
FreeOnTerminate:=true;
Resume;
end;

procedure TReadThread.Terminate;
begin
Shutdown(CSocket,2);
CloseSocket(CSocket);
inherited Terminate;
end;

procedure TReadThread.Execute;
var
 s : string;
begin
while not terminated do
  begin
  Error:=recv(CSocket,s[1],255,0);
  if (Error = SOCKET_ERROR) or (Error = 0) then
    begin
    shutdown(CSocket,2);
    closesocket(CSocket);
    terminate;
    exit;
    end;
  if terminated then exit;
  s[0]:=chr(Error);
  Error:=0;
  if not CB.AddCB(s) then
    begin
    terminate;
    exit;
    end;
  end;
end;

{ ---------- TListFiller ---------- }

constructor TListFiller.Create;
begin
inherited Create;
Sorted:=true;
Duplicates:=dupIgnore;
end;

procedure TListFiller.FillFrom(Dir : string; LType : TDirection; User : string;
  Ftp : TFtpComponent);
var
 i   : integer;
 j   : integer;
 p   : integer;
 s   : string[130];
 r   : TDirFile;
 r1  : TDirFile;
 ft  : TFileTime;
 SR  : TSearchRec;
 l   : longint;
 lnm : string[130];
 TDir: string[130];
 iusr: integer;
begin
clear;
Dir:=NormalizePath(Dir);
TDir:='';
p:=Ftp.DirList.IndexOf(Dir);
iusr:=Ftp.UserList.IndexOf(User);
if (iusr < 0) and not Ftp.AllowAnonymous then exit;
if p >= 0 then
  begin
  if iusr < 0 then
    begin
    if (Ftp.DirList.UID[p] = $ffff) and not (da_ReadList in Ftp.DirList.Attrib[p]) then exit;
    end
  else
    begin
    if (Ftp.DirList.UID[p] <> Ftp.UserList.UIDByName(User)) and not Ftp.UserList.RootByName(User) then
      begin
      if Ftp.UserList.InGroupByName(User,Ftp.DirList.GID[p]) then
        begin
        if not (da_GrReadList in Ftp.DirList.Attrib[p]) then exit;
        end
      else
        if not (da_ReadList in Ftp.DirList.Attrib[p]) then exit;
      end;
    end;
  end
else
  begin
  if Dir[length(Dir)] <> '/' then
    begin
    i:=length(Dir);
    while (i > 0) and (Dir[i] <> '/') do dec(i);
    if i > 0 then
      begin
      TDir:=copy(Dir,i+1,255);
      Dir[0]:=chr(i);
      end
    else
      begin
      TDir:=Dir;
      Dir:='/';
      end;
    p:=Ftp.DirList.IndexOf(Dir);
    if p >= 0 then
      begin
      if iusr < 0 then
        begin
        if (Ftp.DirList.UID[p] = $ffff) and not (da_ReadList in Ftp.DirList.Attrib[p]) then exit;
        end
      else
        begin
        if (Ftp.DirList.UID[p] <> Ftp.UserList.UIDByName(User)) and not Ftp.UserList.RootByName(User) then
          begin
          if Ftp.UserList.InGroupByName(User,Ftp.DirList.GID[p]) then
            begin
            if not (da_GrReadList in Ftp.DirList.Attrib[p]) then exit;
            end
          else
            if not (da_ReadList in Ftp.DirList.Attrib[p]) then exit;
          end;
        end;
      end
    else
      exit;
    end;
  end;
l:=2;
if Ftp.FListFormat = lf_DOS then l:=-1;
if (TDir = '') and (LType <> di_NLST) then
  begin
  if (Dir = '') or (Dir[byte(Dir[0])] <> '/') then Dir:=Dir+'/';
  for i:=0 to Ftp.DirList.Count-1 do
    begin
    if (Dir = copy(Ftp.DirList.Path[i],1,length(Dir))) or
       ((stupcase(Dir) = stupcase(copy(Ftp.DirList.Path[i],1,length(Dir)))) and not Ftp.FCaseSensitive) then
      begin
      s:=copy(Ftp.DirList.Path[i],length(Dir)+1,255);
      j:=pos('/',s);
      if (j > 0) and (length(s)-j > 0) then
        continue;
      s:=copy(s,1,pos('/',s)-1);
      r:=[df_Directory];
      if da_Enter in Ftp.DirList.Attrib[i] then r:=r+[df_Exec];
      if da_ReadList in Ftp.DirList.Attrib[i] then r:=r+[df_Read];
      if da_WriteFiles in Ftp.DirList.Attrib[i] then r:=r+[df_Write];
      if da_GrEnter in Ftp.DirList.Attrib[i] then r:=r+[df_GrExec];
      if da_GrReadList in Ftp.DirList.Attrib[i] then r:=r+[df_GrRead];
      if da_GrWriteFiles in Ftp.DirList.Attrib[i] then r:=r+[df_GrWrite];
      ft.dwLowDateTime:=0;
      ft.dwHighDateTime:=0;
      add(FormatLine(s,r,p,Ftp,Ftp.UserList.NameByUID[Ftp.DirList.UID[i]],
        Ftp.GrpList.NameByGID[Ftp.DirList.GID[i]],ft,l,Ftp.DirList.UID[i],Ftp.DirList.GID[i]));
      end;
    end;
  end;
Dir:=Ftp.DirList.Alias[p];
if Alltrim(Dir) = '' then exit;
i:=faArchive;
if Ftp.ShowHidden then i:=i+faHidden;
if Ftp.ShowReadOnly then i:=i+faReadOnly;
if TDir = '' then
  i:=FindFirst(addslash(Dir)+'*.*',i,SR)
else
  i:=FindFirst(addslash(Dir)+TDir,i,SR);
r:=[];
if p >= 0 then
  begin
  if da_ReadFiles in Ftp.DirList.Attrib[p] then r:=r+[df_Read];
  if da_GrReadFiles in Ftp.DirList.Attrib[p] then r:=r+[df_GrRead];
  if da_WriteFiles in Ftp.DirList.Attrib[p] then r:=r+[df_Write];
  if da_GrWriteFiles in Ftp.DirList.Attrib[p] then r:=r+[df_GrWrite];
  end
else
  r:=[df_Read, df_GrRead];
r1:=[];
if p >= 0 then
  begin
  if da_ReadFiles in Ftp.DirList.Attrib[p] then r1:=r1+[df_Read];
  if da_GrReadFiles in Ftp.DirList.Attrib[p] then r1:=r1+[df_GrRead];
  end
else
  r1:=[df_Read, df_GrRead];
while i = 0 do
  begin
  if (Ftp.FListFormat = lf_DOS) and not IsName8_3(SR.NAME) then
    begin
    lnm:='';
    for j:=0 to 13 do
      if SR.FindData.cAlternateFileName[j] in [#0,' '] then
        break
      else
        lnm:=lnm+SR.FindData.cAlternateFileName[j];
    end
  else
    lnm:=SR.Name;
  if LType <> di_NLST then
    begin
    if (SR.Attr and faReadOnly) <> 0 then
      add(FormatLine(lnm,r1,p,Ftp,Ftp.UserList.NameByUID[Ftp.DirList.UID[p]],
        Ftp.GrpList.NameByGID[Ftp.DirList.GID[p]],SR.FindData.ftCreationTime,SR.Size,Ftp.DirList.UID[p],Ftp.DirList.GID[p]))
    else
      add(FormatLine(lnm,r,p,Ftp,Ftp.UserList.NameByUID[Ftp.DirList.UID[p]],
        Ftp.GrpList.NameByGID[Ftp.DirList.GID[p]],SR.FindData.ftCreationTime,SR.Size,Ftp.DirList.UID[p],Ftp.DirList.GID[p]));
    end
  else
    add(SR.Name);
  i:=FindNext(SR);
  end;
FindClose(SR);
end;

const
 mt : array [1..12] of string[3] = ('Jan','Feb','Mar','Apr','May','Jun','Jul',
                                    'Aug','Sep','Oct','Nov','Dec');

function TListFiller.FormatLine(Name : string; NType : TDirFile; PDir : integer;
      Ftp : TFtpComponent; user,group : string; FDate : TFileTime;
      FSize : longint; UID,GID : word) : string;
var
 i : integer;
 c : char;
 s : string;
 s1: string;
 m : integer;
 w : integer;
 a : TDirAttrib;
 st: TSystemTime;
 ms: string;
 al: boolean;
begin
if name = '' then
  begin
  result:='';
  exit;
  end;
FileTimeToSystemTime(FDate,st);
i:=1;
s:='';
s1:='';
m:=0;
w:=0;
al:=false;
a:=Ftp.DirList.Attrib[PDir];
ms:=Ftp.FCustomList;
while i <= length(ms) do
  begin
  c:=ms[i];
  case c of
    '\' :
      begin
      case m of
        1: s1:=s1+'%';
        2: s1:=s1+s;
        3: if w > length(s) then
             if al then
               s1:=s1+space(w-length(s))+s
             else
               s1:=s1+s+space(w-length(s));
        end;
      m:=0;
      inc(i);
      if i <= length(ms) then
        s1:=s1+ms[i];
      end;
    '%' : m:=1;
    else
      begin
      case m of
        0: s1:=s1+c;
        1:
          begin
          case c of
            'r' :
              begin
              if df_Directory in NType then
                s:='drwx------'
              else
                s:='-rw-------';
              if df_GrRead in NType then s[5]:='r';
              if df_GrWrite in NType then s[6]:='w';
              if df_GrExec in NType then s[7]:='x';
              if df_Read in NType then s[8]:='r';
              if df_Write in NType then s[9]:='w';
              if df_Exec in NType then s[10]:='x';
              m:=2;
              al:=false;
              end;
            'R' :
              begin
              if df_Directory in NType then
                s:='DRWX------'
              else
                s:='-RW-------';
              if df_GrRead in NType then s[5]:='R';
              if df_GrWrite in NType then s[6]:='W';
              if df_GrExec in NType then s[7]:='X';
              if df_Read in NType then s[8]:='R';
              if df_Write in NType then s[9]:='W';
              if df_Exec in NType then s[10]:='X';
              m:=2;
              al:=false;
              end;
            'u' :
              begin
              s:=user;
              m:=2;
              al:=false;
              end;
            'U' :
              begin
              s:=stupcase(user);
              m:=2;
              al:=false;
              end;
            'g' :
              begin
              s:=group;
              m:=2;
              al:=false;
              end;
            'G' :
              begin
              s:=stupcase(group);
              m:=2;
              al:=false;
              end;
            'I' :
              begin
              s:=format('%3u',[UID]);
              m:=2;
              al:=true;
              end;
            'i' :
              begin
              s:=format('%3u',[GID]);
              m:=2;
              al:=true;
              end;
            's','S' :
              begin
              if FSize < 0 then
                s:='<DIR>'
              else
                str(FSize,s);
              m:=2;
              al:=true;
              end;
            'd','D' :
              begin
              s:=format('%s %2u  %4u',[mt[st.wMonth],st.wDay,st.wYear]);
              m:=2;
              al:=false;
              end;
            'f' :
              begin
              s:=Name;
              m:=2;
              al:=false;
              end;
            'F' :
              begin
              s:=stupcase(Name);
              m:=2;
              al:=false;
              end;
            else
              begin
              s1:=s1+'%'+c;
              m:=0;
              al:=false;
              end;
            end;
          end;
        2:
          begin
          case c of
            ':' : w:=0;
            '0'..'9' : w:=(w*10)+(byte(c)-$30);
            else
              begin
              if w > length(s) then
                begin
                if al then
                  s1:=s1+space(w-length(s))+s+c
                else
                  s1:=s1+s+space(w-length(s))+c;
                end
              else
                s1:=s1+s+c;
              m:=0;
              w:=0;
              end;
            if w > 200 then
              begin
              m:=0;
              w:=0;
              end;
            end;
          end;
        end;
      end;
    end;
  inc(i);
  end;
if s <> '' then
  if al then
    s1:=s1+space(w-length(s))+s
  else
    s1:=s1+s;
result:=s1;
end;

end.
