{$A+,B-,C+,D+,E-,F-,G+,H-,I-,J+,K-,L+,M-,N+,O-,P+,Q-,R-,S-,T-,U-,V+,W-,X+,Y+,Z1}
unit SrvCtrl;

{--------------------------------------------------------------------}
{ SrvCtrl module. FTP command processor.                             }
{ 11/15/1999 Drt.                                                    }
{--------------------------------------------------------------------}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  WinSock, TrdBase, CBuf, GetWrd, FtpObj, FtpData, Timer;

const
 st_LOGIN  = 1;
 st_AUTH   = 2;
 st_DIALOG = 3;
 st_DATA   = 4;

type
  TSrvCtrlThread = class (TFtpThreades)
  private
    CB    : TCB;
    RdTrd : TReadThread;
    DTrd  : TDataThread;
    CMode : TMode;
    CData : TStream;
    LPort : integer;
    DPort : integer;
    HName : string[100];
    HAddr : TAddr;
    Pasv  : boolean;
    DCon  : boolean;
    TOut  : TTimeout;
    Brk   : boolean;
    Res   : boolean;
    Marker: string[20];
    procedure Execute; override;
    procedure SendString(s : string);
    function CmdSwitch(Cmd : string) : integer;
    function ExpandMacros(s : string) : string;
    procedure RdExit(Sender : TObject);
    procedure DConExit(Sender : TObject);
    procedure HandleError(ErrNo : integer);
    procedure LogMessage(MsgNo : integer);
    procedure Synchronized;
    function InsertProcess : boolean;
  public
    ControlLog : TCallLogEvent;
    constructor create(ASocket : integer; ACallLogEvent : TCallLogEvent; AParent : TFtpComponent;
      ARAddr : TAddr);
    destructor Destroy; override;
    procedure Terminate;
    end;

 TProcessList = array [1..MaxConn] of TSrvCtrlThread;

var
 ProcessList  : TProcessList;

implementation

constructor TSrvCtrlThread.create;
var
 HE : phostent;
 c  : string[5];
begin
inherited create(true);
PID:=0;
CSocket:=ASocket;
ControlLog:=ACallLogEvent;
State:=st_LOGIN;
Parent:=AParent;
PType:=tt_Control;
CDir:='';
FName:='';
CMode:=Parent.Mode;
CData:=dt_STREAM;
DPort:=Parent.DataPort;
Pasv:=false;
DCon:=false;
Marker:='0';
CB:=TCB.Create;
FreeOnTerminate:=true;
if CB = nil then
  begin
  HandleError(ES_NOMEM);
  terminate;
  exit;
  end;
RdTrd:=TReadThread.Create(CSocket,CB);
RdTrd.OnTerminate:=RdExit;
GetHostName(@HName[1],99);
HName[0]:=char(strlen(@HName[1]));
HE:=GetHostByName(@HName[1]);
c:=copy(strpas(HE^.h_addr_list^),1,4);
HAddr[1]:=byte(c[1]);
HAddr[2]:=byte(c[2]);
HAddr[3]:=byte(c[3]);
HAddr[4]:=byte(c[4]);
RAddr:=ARAddr;
if not InsertProcess then
  begin
  SendString('421 Max. number of connection exceeded'#13#10);
  sleep(200);
  terminate;
  exit;
  end;
Res:=true;
LogMessage(CS_START);
if not Res then
  begin
  terminate;
  exit;
  end;
Resume;
end;

destructor TSrvCtrlThread.Destroy;
begin
LogMessage(CS_TERM);
sleep(200);
if PID > 0 then ProcessList[PID]:=nil;
CB.Destroy;
inherited Destroy;
end;

procedure TSrvCtrlThread.Terminate;
begin
Shutdown(CSocket,2);
CloseSocket(CSocket);
RdTrd.Terminate;
if DCon then
  DTrd.Terminate;
inherited Terminate;
end;

procedure TSrvCtrlThread.DConExit;
begin
DCon:=false;
Marker:='0';
LogMessage(DS_CLOSE);
end;

function TSrvCtrlThread.InsertProcess : boolean;
var
 i : word;
begin
result:=false;
for i:=1 to parent.MaxConn do
  begin
  if ProcessList[i] = nil then
    begin
    ProcessList[i]:=self;
    PID:=i;
    result:=true;
    exit;
    end;
  end;
end;

procedure TSrvCtrlThread.RdExit;
begin
terminate;
end;

function TSrvCtrlThread.ExpandMacros(s : string) : string;
var
 i,j : integer;
 n,l : integer;
 str : string[130];
 caps: boolean;
begin
caps:=false;
i:=pos('%u',s);
if i = 0 then
  begin
  i:=pos('%U',s);
  caps:=true;
  end;
while i > 0 do
  begin
  n:=0;
  l:=2;
  if i > 0 then
    begin
    if s[i+2] = ':' then
      begin
      l:=3;
      for j:=3 to 5 do
        begin
        if s[i+j] in ['0'..'9'] then
          begin
          n:=n*10+(byte(s[i+j])-$30);
          inc(l);
          end
        else
          break;
        end;
      end;
    delete(s,i,l);
    if Caps then
      insert(stupcase(Usr)+space(n-length(Usr)),s,i)
    else
      insert(Usr+space(n-length(Usr)),s,i);
    end;
  caps:=false;
  i:=pos('%u',s);
  if i = 0 then
    begin
    i:=pos('%U',s);
    caps:=true;
    end;
  end;
caps:=false;
i:=pos('%h',s);
if i = 0 then
  begin
  i:=pos('%H',s);
  caps:=true;
  end;
if i > 0 then
  begin
  j:=Parent.UserList.IndexOf(Usr);
  str:='';
  if (j >=0) and (j < Parent.UserList.Count) then str:=Parent.UserList.Home[j];
  end;
while i > 0 do
  begin
  n:=0;
  l:=2;
  if i > 0 then
    begin
    if s[i+2] = ':' then
      begin
      l:=3;
      for j:=3 to 5 do
        begin
        if s[i+j] in ['0'..'9'] then
          begin
          n:=n*10+(byte(s[i+j])-$30);
          inc(l);
          end
        else
          break;
        end;
      end;
    delete(s,i,l);
    if caps then
      insert(stupcase(str)+space(n-length(str)),s,i)
    else
      insert(str+space(n-length(str)),s,i);
    end;
  caps:=false;
  i:=pos('%h',s);
  if i = 0 then
    begin
    i:=pos('%H',s);
    caps:=true;
    end;
  end;
result:=s;
end;

function TSrvCtrlThread.CmdSwitch(Cmd : string) : integer;
begin
result:=-1;
if Cmd = 'NOOP' then result:=0;
if Cmd = 'USER' then result:=1;
if Cmd = 'PASS' then result:=2;
if Cmd = 'ACCT' then result:=3;
if Cmd = 'CWD'  then result:=4;
if Cmd = 'XCWD' then result:=4;
if Cmd = 'CDUP' then result:=5;
if Cmd = 'XCUP' then result:=5;
if Cmd = 'SMNT' then result:=6;
if Cmd = 'QUIT' then result:=7;
if Cmd = 'REIN' then result:=8;
if Cmd = 'PORT' then result:=9;
if Cmd = 'PASV' then result:=10;
if Cmd = 'TYPE' then result:=11;
if Cmd = 'STRU' then result:=12;
if Cmd = 'MODE' then result:=13;
if Cmd = 'RETR' then result:=14;
if Cmd = 'STOR' then result:=15;
if Cmd = 'STOU' then result:=16;
if Cmd = 'APPE' then result:=17;
if Cmd = 'ALLO' then result:=18;
if Cmd = 'REST' then result:=19;
if Cmd = 'RNFR' then result:=20;
if Cmd = 'RNTO' then result:=21;
if Cmd = 'ABOR' then result:=22;
if Cmd = 'DELE' then result:=23;
if Cmd = 'RMD'  then result:=24;
if Cmd = 'XRMD' then result:=24;
if Cmd = 'MKD'  then result:=25;
if Cmd = 'XMKD' then result:=25;
if Cmd = 'PWD'  then result:=26;
if Cmd = 'XPWD' then result:=26;
if Cmd = 'LIST' then result:=27;
if Cmd = 'NLST' then result:=28;
if Cmd = 'SITE' then result:=29;
if Cmd = 'SYST' then result:=30;
if Cmd = 'STAT' then result:=31;
if Cmd = 'HELP' then result:=32;
if Cmd = 'SIZE' then result:=33;
if Cmd = 'MDTM' then result:=34;
end;

procedure TSrvCtrlThread.SendString;
begin
s:=s+#13#10;
send(CSocket,s[1],byte(s[0]),0);
end;

var
 extint : longint;

procedure TSrvCtrlThread.Execute;
var
 i,i1: integer;
 s,s1: string[130];
 Ent : boolean;
 addr: TAddr;
 tprt: integer;
 tp2 : integer;
 lst : TListFiller;
 SR  : TSearchRec;
 lto : longint;
 rnfr: string[130];
 f   : file;
 ftm : FILETIME;
 lftm: FILETIME;
 stm : SYSTEMTIME;
begin
usr:='';
for i:=0 to Parent.BannerMsg.Count-2 do
  begin
  SendString('220-'+Parent.BannerMsg[i]);
  end;
SendString('220 '+Parent.BannerMsg[Parent.BannerMsg.Count-1]);
while not terminated do
  begin
  if CB.GetCB(cmd) then
    begin
    par:=trim(getend(cmd,2));
    cmd:=trim(stupcase(getword(cmd,1)));
    while (cmd <> '') and not (cmd[1] in ['a'..'z','A'..'Z','0'..'9']) do cmd:=copy(cmd,2,255);
    while (cmd <> '') and not (cmd[length(cmd)] in ['a'..'z','A'..'Z','0'..'9']) do dec(byte(cmd[0]));
    Res:=true;
    LogMessage(CS_COMMAND);
    if not Res then
      begin
      SendString('500 Prohibited by FtpMaster');
      continue;
      end;
    case CmdSwitch(cmd) of
      0 : { NOOP }
        begin
        SendString('200 Hi, how are you?');
        end;
      1 : { USER }
        begin
        usr:=alltrim(par);
        State:=st_AUTH;
        if (stupcase(usr) = 'FTP') or (stupcase(usr) = 'ANONYMOUS') then
          begin
          if Parent.AllowAnonymous then
            SendString('331 '+ExpandMacros(parent.FreePasswdMsg))
          else
            begin
            SendString('421 '+ExpandMacros(parent.NoAnonymousMsg));
            Terminate;
            exit;
            end;
          end
        else
          SendString('331 '+ExpandMacros(parent.PasswordMsg));
        end;
      2 : { PASS }
        begin
        if State <> st_AUTH then
          begin
          SendString('503 Expected USER');
          continue;
          end;
        i:=Parent.UserList.IndexOf(Usr);
        s:=#0#0;
        if (i >= 0) and (i < Parent.UserList.Count) then
          s:=Parent.UserList.Password[i];
        if (stupcase(usr) <> 'FTP') and (stupcase(usr) <> 'ANONYMOUS') then
          begin
          if par <> s then
            begin
            SendString(ExpandMacros('421 Authentification for user %u failed. Connection closed.'));
            Terminate;
            exit;
            end;
          end
        else
          Usr:='ftp';
        { Setting up the user environment }
        CDir:=Parent.UserList.HomeByName(Usr);
        if CDir = '' then
          begin
          if (stupcase(usr) = 'FTP') or (stupcase(usr) = 'ANONYMOUS') then
            CDir:='/'
          else
            begin
            SendString('421 No home directory.');
            Terminate;
            exit;
            end;
          end;
        SendString('230 Welcome');
        Pwd:=par;
        State:=st_DIALOG;
        LogMessage(CS_LOGIN);
        end;
      3 : { ACCT }
        begin
        SendString('200 ACCT was not needed');
        end;
      4 : { CWD  }
        begin
        if (State <> st_DIALOG) and (State <> st_DATA) then
          begin
          SendString('530 Not logged in');
          Continue;
          end;
        if par[1] in ['/','\'] then
          s1:='/'
        else
          s1:=CDir;
        while BitPath(par,s) do
          begin
          if s <> '.' then
            begin
            if s = '..' then
              s1:=UpDir(s1)
            else
              s1:=DownDir(s1,s);
            end;
          end;
        i:=Parent.DirList.IndexOf(s1);
        if i >= 0 then
          begin
          Ent:=false;
          if Parent.UserList.RootByName(Usr) then
            Ent:=true;
          if Parent.DirList.UID[i] = Parent.UserList.UIDByName(Usr) then
            Ent:=true;
          if Parent.UserList.InGroupByName(Usr,Parent.DirList.GID[i]) then
            begin
            if da_GrEnter in Parent.DirList.Attrib[i] then
              Ent:=true;
            end;
          if da_Enter in Parent.DirList.Attrib[i] then
            Ent:=true;
          if Ent then
            begin
            CDir:=s1;
            SendString('250 Entering "'+CDir+'"');
            LogMessage(CS_CHDIR);
            end
          else
            SendString('550 Access denied');
          end
        else
          SendString('550 Directory not found');
        end;
      5 : { CDUP }
        begin
        if (State <> st_DIALOG) and (State <> st_DATA) then
          begin
          SendString('530 Not logged in');
          Continue;
          end;
        s1:=UpDir(CDir);
        i:=Parent.DirList.IndexOf(s1);
        if i >= 0 then
          begin
          Ent:=false;
          if Parent.UserList.RootByName(Usr) then
            Ent:=true;
          if Parent.DirList.UID[i] = Parent.UserList.UIDByName(Usr) then
            Ent:=true;
          if Parent.UserList.InGroupByName(Usr,Parent.DirList.GID[i]) then
            begin
            if da_GrEnter in Parent.DirList.Attrib[i] then
              Ent:=true;
            end;
          if da_Enter in Parent.DirList.Attrib[i] then
            Ent:=true;
          if Ent then
            begin
            CDir:=s1;
            SendString('250 Entering "'+CDir+'"');
            LogMessage(CS_CHDIR);
            end
          else
            SendString('550 Access denied');
          end
        else
          SendString('550 Directory not found');
        end;
      6 : { SMNT }
        begin
        SendString('502 Command not implemented');
        end;
      7 : { QUIT }
        begin
        SendString('200 See you later.');
        LogMessage(CS_LOGOUT);
        Terminate;
        exit;
        end;
      8 : { REIN }
        begin
        CDir:='';
        State:=st_LOGIN;
        SendString('220 Service ready for new user.');
        LogMessage(CS_LOGOUT);
        end;
      9 : { PORT }
        begin
        if State <> st_DIALOG then
          begin
          SendString('503 Not now (not logged in or data connection already open)');
          Continue;
          end;
        ent:=false;
        for i:=1 to 4 do
          begin
          val(copy(par,1,pos(',',par)-1),addr[i],i1);
          if i1 > 0 then
            begin
            ent:=true;
            break;
            end;
          par:=copy(par,pos(',',par)+1,255);
          end;
        if ent then
          begin
          SendString('501 Parameter syntax error');
          continue;
          end;
        val(copy(par,1,pos(',',par)-1),tprt,i1);
        if i1 > 0 then
          begin
          SendString('501 Parameter syntax error');
          continue;
          end;
        val(copy(par,pos(',',par)+1,255),tp2,i1);
        if i1 > 0 then
          begin
          SendString('501 Parameter syntax error');
          continue;
          end;
        tprt:=tprt*256+tp2;
        if not Parent.AllowRedirect then
          begin
          for i:=1 to 4 do
            if addr[i] <> RAddr[i] then
              begin
              ent:=true;
              break;
              end;
          if ent then
            begin
            SendString('501 Parameter syntax error');
            continue;
            end;
          end;
        RAddr:=addr;
        DPort:=tprt;
        Pasv:=false;
        SendString('200 PORT command ok.');
        end;
      10: { PASV }
        begin
        if State <> st_DIALOG then
          begin
          SendString('503 Not now (not logged in or data connection already open)');
          Continue;
          end;
        LPort:=random(15000)+999;
        if DCon then
          begin
          DTrd.Terminate;
          TOut:=TTimeout.create(50,@Brk);
          while DCon and not Brk do;
          if Brk then
            HandleError(ES_DRUN)
          else
            TOut.terminate;
          end;
        Pasv:=true;
        DTrd:=TDataThread.Create('IDLE',RAddr,Pasv,di_IDLE,CMode,CData,LPort,
          Parent,nil,Marker,DConExit,ControlLog,Usr,Pwd,CDir);
        DCon:=true;
        sleep(100);
        SendString('227 Entering Passive Mode ('+format('%d,%d,%d,%d,%d,%d',
          [HAddr[1],HAddr[2],HAddr[3],HAddr[4],hi(LPort),lo(LPort)])+')');
        end;
      11: { TYPE }
        begin
        if (State <> st_DIALOG) and (State <> st_DATA) then
          begin
          SendString('530 Not logged in');
          Continue;
          end;
        if par <> '' then
          case par[1] of
            'A','a':
              begin
              CMode:=md_ASCII;
              SendString('200 Mode changed to ASCII');
              end;
            'I','i':
              begin
              CMode:=md_IMAGE;
              SendString('200 Mode changed to BINARY');
              end;
            else
              begin
              SendString('504 Command not implemented for this type');
              end;
            end
          else
            SendString('501 Syntax error');
        end;
      12: { STRU }
        begin
        SendString('502 Command not implemented');
        end;
      13: { MODE }
        begin
        if (State <> st_DIALOG) and (State <> st_DATA) then
          begin
          SendString('530 Not logged in');
          Continue;
          end;
        if par <> '' then
          case par[1] of
            'S','s':
              begin
              CData:=dt_STREAM;
              SendString('200 Data type changed to STREAM');
              end;
            else
              begin
              SendString('504 Command not implemented for this type');
              end;
            end
          else
            SendString('501 Syntax error');
        end;
      14: { RETR }
        begin
        if (State <> st_DIALOG) and (State <> st_DATA) then
          begin
          SendString('530 Not logged in');
          Continue;
          end;
        { Checking file permissions }
        par:=alltrim(par);
        if par[length(par)] in ['/','\'] then
          begin
          SendString('450 No file name specified');
          continue;
          end;
        s:=par;
        while (s <> '') and not (s[length(s)] in ['\','/']) do dec(byte(s[0]));
        s1:=copy(par,length(s)+1,255);
        if s = '' then
          s:=CDir
        else
          if not (s[1] in ['/','\']) then
            s:=addslash(CDir)+s;
        s:=NormalizePath(s);
        i:=Parent.DirList.IndexOf(s);
        if i < 0 then
          begin
          SendString('450 Directory not found');
          continue;
          end;
        if not Parent.UserList.RootByName(Usr) then
          begin
          if Parent.DirList.UID[i] <> Parent.UserList.UIDByName(Usr) then
            begin
            if Parent.UserList.InGroupByName(Usr,Parent.DirList.GID[i]) then
              begin
              if not (da_GrReadFiles in Parent.DirList.Attrib[i]) then
                begin
                SendString('550 Permission denied');
                continue;
                end;
              end
            else
              if not (da_ReadFiles in Parent.DirList.Attrib[i]) then
                begin
                SendString('550 Permission denied');
                continue;
                end;
            end;
          end;
        s:=addslash(Parent.DirList.Alias[i])+s1;
        { Calculating timeout }
        if FindFirst(s,faArchive+faHidden+faReadOnly,SR) <> 0 then
          begin
          SendString('450 File not found');
          continue;
          end;
        lto:=trunc(SR.Size/10);
        { Run the data process }
        s1:='';
        case CMode of
          md_ASCII: s1:='ASCII';
          md_IMAGE: s1:='BINARY';
          end;
        if DCon then
          begin
          DTrd.GotWork(s,di_SEND,CMode,CData,nil,Marker);
          SendString('125 Sending file "'+par+'" in '+s1+' mode');
          end
        else
          begin
          DTrd:=TDataThread.Create(s,RAddr,Pasv,di_SEND,CMode,CData,DPort,Parent
            ,nil,Marker,DConExit,ControlLog,Usr,Pwd,CDir);
          DCon:=true;
          SendString('150 Sending file "'+par+'" in '+s1+' mode');
          end;
        if DTrd.Error = 0 then
          begin
          State:=st_DATA;
          TOut:=TTimeout.create(lto,@Brk);
          LogMessage(CS_ULOAD);
          end
        else
          begin
          DTrd.Terminate;
          SendString('425 Can''t open data connection.');
          end;
        end;
      15: { STOR }
        begin
        if (State <> st_DIALOG) and (State <> st_DATA) then
          begin
          SendString('530 Not logged in');
          Continue;
          end;
        { Checking the directory permissions }
        par:=alltrim(par);
        if par[length(par)] in ['/','\'] then
          begin
          SendString('450 No file name specified');
          continue;
          end;
        s:=par;
        while (s <> '') and not (s[length(s)] in ['\','/']) do dec(byte(s[0]));
        s1:=copy(par,length(s)+1,255);
        if s = '' then
          s:=CDir
        else
          if not (s[1] in ['/','\']) then
            s:=addslash(CDir)+s;
        s:=NormalizePath(s);
        i:=Parent.DirList.IndexOf(s);
        if i < 0 then
          begin
          SendString('450 Directory not found');
          continue;
          end;
        if not Parent.UserList.RootByName(Usr) then
          begin
          if Parent.DirList.UID[i] <> Parent.UserList.UIDByName(Usr) then
            begin
            if Parent.UserList.InGroupByName(Usr,Parent.DirList.GID[i]) then
              begin
              if not (da_GrWriteFiles in Parent.DirList.Attrib[i]) then
                begin
                SendString('550 Permission denied');
                continue;
                end;
              end
            else
              if not (da_WriteFiles in Parent.DirList.Attrib[i]) then
                begin
                SendString('550 Permission denied');
                continue;
                end;
            end;
          end;
        { Run the data process }
        s:=addslash(Parent.DirList.Alias[i])+s1;
        s1:='';
        case CMode of
          md_ASCII: s1:='ASCII';
          md_IMAGE: s1:='BINARY';
          end;
        if DCon then
          begin
          DTrd.GotWork(s,di_RECEIVE,CMode,CData,nil,Marker);
          SendString('125 Gonna receive file in '+s1+' mode');
          end
        else
          begin
          DTrd:=TDataThread.Create(s,RAddr,Pasv,di_RECEIVE,CMode,CData,DPort,
            Parent,nil,Marker,DConExit,ControlLog,Usr,Pwd,CDir);
          DCon:=true;
          SendString('150 Gonna receive file in '+s1+' mode');
          end;
        if DTrd.Error = 0 then
          begin
          State:=st_DATA;
          TOut:=TTimeout.create(72000,@Brk);
          LogMessage(CS_DLOAD);
          end
        else
          begin
          DTrd.Terminate;
          SendString('425 Can''t open data connection.');
          end;
        end;
      16: { STOU }
        begin
        if (State <> st_DIALOG) and (State <> st_DATA) then
          begin
          SendString('530 Not logged in');
          Continue;
          end;
        { Checking the directory permissions }
        if s = '' then
          s:=CDir
        else
          if not (s[1] in ['/','\']) then
            s:=addslash(CDir)+s;
        s:=NormalizePath(s);
        i:=Parent.DirList.IndexOf(s);
        randomize;
        s1:=format('%4.4u%4.4u.TMP',[random(9999),random(9999)]);
        if i < 0 then
          begin
          SendString('450 Directory not found');
          continue;
          end;
        if not Parent.UserList.RootByName(Usr) then
          begin
          if Parent.DirList.UID[i] <> Parent.UserList.UIDByName(Usr) then
            begin
            if Parent.UserList.InGroupByName(Usr,Parent.DirList.GID[i]) then
              begin
              if not (da_GrWriteFiles in Parent.DirList.Attrib[i]) then
                begin
                SendString('550 Permission denied');
                continue;
                end;
              end
            else
              if not (da_WriteFiles in Parent.DirList.Attrib[i]) then
                begin
                SendString('550 Permission denied');
                continue;
                end;
            end;
          end;
        { Run the data process }
        s:=addslash(Parent.DirList.Alias[i])+s1;
        if DCon then
          begin
          DTrd.GotWork(s,di_RECEIVE,CMode,CData,nil,Marker);
          SendString('125 '+s1);
          end
        else
          begin
          DTrd:=TDataThread.Create(s,RAddr,Pasv,di_RECEIVE,CMode,CData,DPort,
            Parent,nil,Marker,DConExit,ControlLog,Usr,Pwd,CDir);
          DCon:=true;
          SendString('150 '+s1);
          end;
        if DTrd.Error = 0 then
          begin
          State:=st_DATA;
          TOut:=TTimeout.create(72000,@Brk);
          LogMessage(CS_DLOAD);
          end
        else
          begin
          DTrd.Terminate;
          SendString('425 Can''t open data connection.');
          end;
        end;
      17: { APPE }
        begin
        if (State <> st_DIALOG) and (State <> st_DATA) then
          begin
          SendString('530 Not logged in');
          Continue;
          end;
        { Checking the directory permissions }
        par:=alltrim(par);
        if par[length(par)] in ['/','\'] then
          begin
          SendString('450 No file name specified');
          continue;
          end;
        s:=par;
        while (s <> '') and not (s[length(s)] in ['\','/']) do dec(byte(s[0]));
        s1:=copy(par,length(s)+1,255);
        if s = '' then
          s:=CDir
        else
          if not (s[1] in ['/','\']) then
            s:=addslash(CDir)+s;
        s:=NormalizePath(s);
        i:=Parent.DirList.IndexOf(s);
        if i < 0 then
          begin
          SendString('450 Directory not found');
          continue;
          end;
        if not Parent.UserList.RootByName(Usr) then
          begin
          if Parent.DirList.UID[i] <> Parent.UserList.UIDByName(Usr) then
            begin
            if Parent.UserList.InGroupByName(Usr,Parent.DirList.GID[i]) then
              begin
              if not (da_GrWriteFiles in Parent.DirList.Attrib[i]) then
                begin
                SendString('550 Permission denied');
                continue;
                end;
              end
            else
              if not (da_WriteFiles in Parent.DirList.Attrib[i]) then
                begin
                SendString('550 Permission denied');
                continue;
                end;
            end;
          end;
        { Run the data process }
        s:=addslash(Parent.DirList.Alias[i])+s1;
        s1:='';
        case CMode of
          md_ASCII: s1:='ASCII';
          md_IMAGE: s1:='BINARY';
          end;
        if DCon then
          begin
          DTrd.GotWork(s,di_APPEND,CMode,CData,nil,Marker);
          SendString('125 Gonna receive file in '+s1+' mode');
          end
        else
          begin
          DTrd:=TDataThread.Create(s,RAddr,Pasv,di_APPEND,CMode,CData,DPort,
            Parent,nil,Marker,DConExit,ControlLog,Usr,Pwd,CDir);
          DCon:=true;
          SendString('150 Gonna receive file in '+s1+' mode');
          end;
        if DTrd.Error = 0 then
          begin
          State:=st_DATA;
          TOut:=TTimeout.create(72000,@Brk);
          LogMessage(CS_DLOAD);
          end
        else
          begin
          DTrd.Terminate;
          SendString('425 Can''t open data connection.');
          end;
        end;
      18: { ALLO }
        begin
        SendString('502 Command "'+cmd+'" not implemented');
        end;
      19: { REST }
        begin
        if (State <> st_DIALOG) and (State <> st_DATA) then
          begin
          SendString('530 Not logged in');
          Continue;
          end;
        val(par,extint,i1);
        if i1 > 0 then
          SendString('501 Syntax error (bad marker)')
        else
          begin
          Marker:=par;
          SendString('350 Ready for transfer');
          end;
        end;
      20: { RNFR }
        begin
        rnfr:='';
        if (State <> st_DIALOG) and (State <> st_DATA) then
          begin
          SendString('530 Not logged in');
          Continue;
          end;
        { Checking file permissions }
        par:=alltrim(par);
        if (pos('\',par) > 0) or (pos('/',par) > 0) then
          begin
          SendString('501 Path is not allowed');
          continue;
          end;
        s:=NormalizePath(CDir);
        i:=Parent.DirList.IndexOf(s);
        if i < 0 then
          begin
          SendString('450 Directory not found');
          continue;
          end;
        if not Parent.UserList.RootByName(Usr) then
          begin
          if Parent.DirList.UID[i] <> Parent.UserList.UIDByName(Usr) then
            begin
            if Parent.UserList.InGroupByName(Usr,Parent.DirList.GID[i]) then
              begin
              if not (da_GrReadFiles in Parent.DirList.Attrib[i]) then
                begin
                SendString('550 Permission denied');
                continue;
                end;
              end
            else
              if not (da_ReadFiles in Parent.DirList.Attrib[i]) then
                begin
                SendString('550 Permission denied');
                continue;
                end;
            end;
          end;
        s:=addslash(Parent.DirList.Alias[i])+par;
        if FindFirst(s,faArchive+faHidden+faReadOnly,SR) <> 0 then
          begin
          SendString('450 File not found');
          continue;
          end;
        rnfr:=par;
        SendString('350 Send RNTO');
        end;
      21: { RNTO }
        begin
        if (State <> st_DIALOG) and (State <> st_DATA) then
          begin
          SendString('530 Not logged in');
          Continue;
          end;
        if rnfr = '' then
          begin
          SendString('503 No RNFR was given');
          continue;
          end;
        s:=NormalizePath(CDir);
        i:=Parent.DirList.IndexOf(s);
        if i < 0 then
          begin
          SendString('450 Directory not found');
          continue;
          end;
        if not Parent.UserList.RootByName(Usr) then
          begin
          if Parent.DirList.UID[i] <> Parent.UserList.UIDByName(Usr) then
            begin
            if Parent.UserList.InGroupByName(Usr,Parent.DirList.GID[i]) then
              begin
              if not (da_GrReadFiles in Parent.DirList.Attrib[i]) then
                begin
                SendString('550 Permission denied');
                continue;
                end;
              end
            else
              if not (da_ReadFiles in Parent.DirList.Attrib[i]) then
                begin
                SendString('550 Permission denied');
                continue;
                end;
            end;
          end;
        s:=addslash(Parent.DirList.Alias[i]);
        assignfile(f,s+par);
        erase(f);
        ioresult;
        assignfile(f,s+rnfr);
        rename(f,s+par);
        if ioresult = 0 then
          begin
          SendString('250 Done');
          end
        else
          begin
          SendString('553 Requested action not taken');
          end;
        end;
      22: { ABOR }
        begin
        if State <> st_DATA then
          begin
          SendString('226 Command ok.');
          Continue;
          end;
        if DCon then
          begin
          DTrd.Terminate;
          TOut:=TTimeout.create(50,@Brk);
          while DCon and not Brk do;
          if Brk then
            HandleError(ES_DRUN)
          else
            TOut.terminate;
          State:=st_DIALOG;
          SendString('426 Data connection closed');
          SendString('226 Command ok.');
          end;
        end;
      23: { DELE }
        begin
        if (State <> st_DIALOG) and (State <> st_DATA) then
          begin
          SendString('530 Not logged in');
          Continue;
          end;
        { Checking the directory permissions }
        par:=alltrim(par);
        if par[length(par)] in ['/','\'] then
          begin
          SendString('450 No file name specified');
          continue;
          end;
        s:=par;
        while (s <> '') and not (s[length(s)] in ['\','/']) do dec(byte(s[0]));
        s1:=copy(par,length(s)+1,255);
        if s = '' then
          s:=CDir
        else
          if not (s[1] in ['/','\']) then
            s:=addslash(CDir)+s;
        s:=NormalizePath(s);
        i:=Parent.DirList.IndexOf(s);
        if i < 0 then
          begin
          SendString('450 Directory not found');
          continue;
          end;
        if not Parent.UserList.RootByName(Usr) then
          begin
          if Parent.DirList.UID[i] <> Parent.UserList.UIDByName(Usr) then
            begin
            if Parent.UserList.InGroupByName(Usr,Parent.DirList.GID[i]) then
              begin
              if not (da_GrWriteFiles in Parent.DirList.Attrib[i]) then
                begin
                SendString('550 Permission denied');
                continue;
                end;
              end
            else
              if not (da_WriteFiles in Parent.DirList.Attrib[i]) then
                begin
                SendString('550 Permission denied');
                continue;
                end;
            end;
          end;
        { Run the data process }
        s:=addslash(Parent.DirList.Alias[i])+s1;
        assignfile(f,s);
        erase(f);
        if ioresult = 0 then
          begin
          SendString('250 Done');
          end
        else
          begin
          SendString('553 Requested action not taken');
          end;
        end;
      24: { RMD  }
        begin
        { Removes a virtual directory }
        if (State <> st_DIALOG) and (State <> st_DATA) then
          begin
          SendString('530 Not logged in');
          Continue;
          end;
        { Checking the directory permissions }
        par:=alltrim(par);
        if par[length(par)] in ['/','\'] then setlength(par,length(par)-1);
        s:=par;
        while (s <> '') and not (s[length(s)] in ['\','/']) do dec(byte(s[0]));
        s1:=copy(par,length(s)+1,255);
        if s = '' then
          s:=CDir
        else
          if not (s[1] in ['/','\']) then
            s:=addslash(CDir)+s;
        s:=NormalizePath(s);
        i:=Parent.DirList.IndexOf(s);
        if i < 0 then
          begin
          SendString('450 Parent directory not found');
          continue;
          end;
        if not Parent.UserList.RootByName(Usr) then
          begin
          if Parent.DirList.UID[i] <> Parent.UserList.UIDByName(Usr) then
            begin
            if Parent.UserList.InGroupByName(Usr,Parent.DirList.GID[i]) then
              begin
              if not (da_GrWriteFiles in Parent.DirList.Attrib[i]) then
                begin
                SendString('550 Permission denied');
                continue;
                end;
              end
            else
              if not (da_WriteFiles in Parent.DirList.Attrib[i]) then
                begin
                SendString('550 Permission denied');
                continue;
                end;
            end;
          end;
        s:=addslash(Parent.DirList[i])+s1;
        i:=Parent.DirList.IndexOf(s);
        if i < 0 then
          begin
          SendString('450 Directory not found');
          continue;
          end;
        rmdir(Parent.DirList.Alias[i]);
        if ioresult <> 0 then
          begin
          SendString('550 Not empty');
          continue;
          end;
        Parent.DirList.Delete(i);
        SendString('250 Directory removed');
        end;
      25: { MKD  }
        begin
        { Creates a virtual directory }
        if (State <> st_DIALOG) and (State <> st_DATA) then
          begin
          SendString('530 Not logged in');
          Continue;
          end;
        { Checking the directory permissions }
        par:=alltrim(par);
        if par[length(par)] in ['/','\'] then setlength(par,length(par)-1);
        s:=par;
        while (s <> '') and not (s[length(s)] in ['\','/']) do dec(byte(s[0]));
        s1:=copy(par,length(s)+1,255);
        if s = '' then
          s:=CDir
        else
          if not (s[1] in ['/','\']) then
            s:=addslash(CDir)+s;
        s:=NormalizePath(s);
        i:=Parent.DirList.IndexOf(s);
        if i < 0 then
          begin
          SendString('450 Parent directory not found');
          continue;
          end;
        if not Parent.UserList.RootByName(Usr) then
          begin
          if Parent.DirList.UID[i] <> Parent.UserList.UIDByName(Usr) then
            begin
            if Parent.UserList.InGroupByName(Usr,Parent.DirList.GID[i]) then
              begin
              if not (da_GrWriteFiles in Parent.DirList.Attrib[i]) then
                begin
                SendString('550 Permission denied');
                continue;
                end;
              end
            else
              if not (da_WriteFiles in Parent.DirList.Attrib[i]) then
                begin
                SendString('550 Permission denied');
                continue;
                end;
            end;
          end;
        s:=addslash(Parent.DirList.Alias[i])+s1;
        mkdir(s);
        if ioresult <> 0 then
          begin
          SendString('550 Can''t create directory');
          continue;
          end;
        s1:=addslash(Parent.DirList[i])+s1;
        if Parent.DirList.AddDir(s1,s,
           [da_GrReadList,da_GrReadFiles,da_GrEnter],Parent.UserList.UIDByName(usr),
           Parent.UserList.GIDByName(usr,1)) = -1 then
          SendString('550 Can''t create directory')
        else
          SendString('257 Directory has been created');
        end;
      26: { PWD  }
        begin
        SendString('257 "'+CDir+'"');
        end;
      27: { LIST }
        begin
        if (State <> st_DIALOG) and (State <> st_DATA) then
          begin
          SendString('530 Not logged in');
          Continue;
          end;
        lst:=TListFiller.Create;
        if par = '' then
          lst.FillFrom(CDir,di_LIST,Usr,Parent)
        else
          begin
          if par[1] in ['/','\'] then
            lst.FillFrom(par,di_LIST,Usr,Parent)
          else
            if CDir[byte(CDir[0])] in ['/','\'] then
              lst.FillFrom(CDir+par,di_LIST,Usr,Parent)
            else
              lst.FillFrom(CDir+'/'+par,di_LIST,Usr,Parent);
          end;
        if DCon then
          begin
          DTrd.GotWork('DIR',di_LIST,CMode,CData,lst,'0');
          if par[1] in ['/','\'] then
            SendString('125 Sending list for "'+par+'"')
          else
            if CDir[byte(CDir[0])] in ['/','\'] then
              SendString('125 Sending list for "'+CDir+par+'"')
            else
              SendString('125 Sending list for "'+CDir+'/'+par+'"');
          end
        else
          begin
          DTrd:=TDataThread.Create('DIR',RAddr,Pasv,di_LIST,CMode,CData,DPort,
            Parent,lst,'0',DConExit,ControlLog,Usr,Pwd,CDir);
          DCon:=true;
          if par[1] in ['/','\'] then
            SendString('150 Sending list for "'+par+'"')
          else
            if CDir[byte(CDir[0])] in ['/','\'] then
              SendString('150 Sending list for "'+CDir+par+'"')
            else
              SendString('150 Sending list for "'+CDir+'/'+par+'"');
          end;
        if DTrd.Error = 0 then
          begin
          State:=st_DATA;
          TOut:=TTimeout.create(600,@Brk);
          end
        else
          begin
          DTrd.Terminate;
          SendString('425 Can''t open data connection.');
          end;
        end;
      28: { NLST }
        begin
        if (State <> st_DIALOG) and (State <> st_DATA) then
          begin
          SendString('530 Not logged in');
          Continue;
          end;
        lst:=TListFiller.Create;
        if par = '' then
          lst.FillFrom(CDir,di_LIST,Usr,Parent)
        else
          begin
          if par[1] in ['/','\'] then
            lst.FillFrom(par,di_NLST,Usr,Parent)
          else
            if CDir[byte(CDir[0])] in ['/','\'] then
              lst.FillFrom(CDir+par,di_NLST,Usr,Parent)
            else
              lst.FillFrom(CDir+'/'+par,di_NLST,Usr,Parent);
          end;
        if DCon then
          begin
          DTrd.GotWork('DIR',di_LIST,CMode,CData,lst,'0');
          if par[1] in ['/','\'] then
            SendString('125 Sending list for "'+par+'"')
          else
            if CDir[byte(CDir[0])] in ['/','\'] then
              SendString('125 Sending list for "'+CDir+par+'"')
            else
              SendString('125 Sending list for "'+CDir+'/'+par+'"');
          end
        else
          begin
          DTrd:=TDataThread.Create('DIR',RAddr,Pasv,di_LIST,CMode,CData,DPort,
            Parent,lst,'0',DConExit,ControlLog,Usr,Pwd,CDir);
          DCon:=true;
          if par[1] in ['/','\'] then
            SendString('150 Sending list for "'+par+'"')
          else
            if CDir[byte(CDir[0])] in ['/','\'] then
              SendString('150 Sending list for "'+CDir+par+'"')
            else
              SendString('150 Sending list for "'+CDir+'/'+par+'"');
          end;
        if DTrd.Error = 0 then
          begin
          State:=st_DATA;
          TOut:=TTimeout.create(600,@Brk);
          end
        else
          begin
          DTrd.Terminate;
          SendString('425 Can''t open data connection.');
          end;
        end;
      29: { SITE }
        begin
        SendString('502 Command "'+cmd+'" not implemented');
        end;
      30: { SYST }
        begin
        SendString('215 IBM-PC (Windows95/98/NT based system)');
        end;
      31: { STAT }
        begin
        SendString('502 Command "'+cmd+'" not implemented');
        continue;
        end;
      32: { HELP }
        begin
        SendString('214-The following commands are recognized:');
        SendString('   ABOR     DELE     NOOP     REIN     SITE     SYST     XRMD');
        SendString('   ACCT     HELP     PASS     REST     SMNT     TYPE     SIZE');
        SendString('   ALLO     LIST     PASV     RETR     STAT     USER');
        SendString('   APPE     MKD      PORT     RMD      STOR     XCWD');
        SendString('   CDUP     MODE     PWD      RNFR     STOU     XMKD');
        SendString('   CWD      NLST     QUIT     RNTO     STRU     XPWD');
        SendString('214 Send comments to drtinus@yahoo.com');
        end;
      33: { SIZE }
        begin
        if (State <> st_DIALOG) and (State <> st_DATA) then
          begin
          SendString('530 Not logged in');
          Continue;
          end;
        { Checking directory permissions }
        par:=alltrim(par);
        if par[length(par)] in ['/','\'] then
          begin
          SendString('450 No file name specified');
          continue;
          end;
        s:=par;
        while (s <> '') and not (s[length(s)] in ['\','/']) do dec(byte(s[0]));
        s1:=copy(par,length(s)+1,255);
        if s = '' then s:=CDir;
        s:=NormalizePath(s);
        i:=Parent.DirList.IndexOf(s);
        if i < 0 then
          begin
          SendString('450 Directory not found');
          continue;
          end;
        if not Parent.UserList.RootByName(Usr) then
          begin
          if Parent.DirList.UID[i] <> Parent.UserList.UIDByName(Usr) then
            begin
            if Parent.UserList.InGroupByName(Usr,Parent.DirList.GID[i]) then
              begin
              if not (da_GrReadList in Parent.DirList.Attrib[i]) then
                begin
                SendString('450 Permission denied');
                continue;
                end;
              end
            else
              if not (da_ReadList in Parent.DirList.Attrib[i]) then
                begin
                SendString('450 Permission denied');
                continue;
                end;
            end;
          end;
        { Processing command }
        s:=addslash(Parent.DirList.Alias[i])+s1;
        if FindFirst(s,faArchive+faHidden+faReadOnly,SR) <> 0 then
          begin
          FindClose(SR);
          SendString('450 File not found');
          continue;
          end;
        FindClose(SR);
        SendString(format('213 %u',[SR.Size]));
        end;
      34: { MDTM }
        begin
        if (State <> st_DIALOG) and (State <> st_DATA) then
          begin
          SendString('530 Not logged in');
          Continue;
          end;
        { Checking directory permissions }
        par:=alltrim(par);
        if par[length(par)] in ['/','\'] then
          begin
          SendString('450 No file name specified');
          continue;
          end;
        s:=par;
        while (s <> '') and not (s[length(s)] in ['\','/']) do dec(byte(s[0]));
        s1:=copy(par,length(s)+1,255);
        if s = '' then s:=CDir;
        s:=NormalizePath(s);
        i:=Parent.DirList.IndexOf(s);
        if i < 0 then
          begin
          SendString('450 Directory not found');
          continue;
          end;
        if not Parent.UserList.RootByName(Usr) then
          begin
          if Parent.DirList.UID[i] <> Parent.UserList.UIDByName(Usr) then
            begin
            if Parent.UserList.InGroupByName(Usr,Parent.DirList.GID[i]) then
              begin
              if not (da_GrReadList in Parent.DirList.Attrib[i]) then
                begin
                SendString('450 Permission denied');
                continue;
                end;
              end
            else
              if not (da_ReadList in Parent.DirList.Attrib[i]) then
                begin
                SendString('450 Permission denied');
                continue;
                end;
            end;
          end;
        { Processing command }
        s:=addslash(Parent.DirList.Alias[i])+s1;
        if FindFirst(s,faArchive+faHidden+faReadOnly,SR) <> 0 then
          begin
          FindClose(SR);
          SendString('450 File not found');
          continue;
          end;
        FindClose(SR);
        ftm:=SR.FindData.ftLastWriteTime;
        FileTimeToLocalFileTime(ftm,lftm);
        FileTimeToSystemTime(lftm,stm);
        SendString(format('213 %4.4u%2.2u%2.2u%2.2u%2.2u%2.2u',[stm.wYear,stm.wMonth,stm.wDay,stm.wHour,stm.wMinute,stm.wSecond]));
        end;
      else
        begin
        SendString('502 Command "'+cmd+'" not implemented');
        end;
      end;
    end
  else
    begin
    if State = st_DATA then
      begin
      if CData = dt_STREAM then
        begin
        if not DCon then
          begin
          SendString('226 Transfer complete');
          State:=st_DIALOG;
          if not Brk then TOut.terminate;
          end
        else if Brk then
          begin
          if DCon then DTrd.terminate;
          handleerror(ES_STOUT);
          State:=st_DIALOG;
          end;
        end
      else
        begin
        if DTrd.Dir = di_IDLE then
          begin
          SendString('250 Transfer complete');
          State:=st_DIALOG;
          if not Brk then TOut.terminate;
          Marker:='0';
          end
        else if Brk then
          begin
          if DCon then DTrd.terminate;
          handleerror(ES_STOUT);
          State:=st_DIALOG;
          Marker:='0';
          end;
        end;
      end;
    sleep(100);
    end;
  end;
end;

procedure TSrvCtrlThread.HandleError(ErrNo : integer);
begin
Error:=ErrNo;
LogMessage(ErrNo);
end;

procedure TSrvCtrlThread.Synchronized;
begin
if assigned(ControlLog) then ControlLog(self,Res);
end;

procedure TSrvCtrlThread.LogMessage(MsgNo : integer);
begin
Messg:=MsgNo;
Synchronize(Synchronized);
Error:=0;
Messg:=0;
end;

var
 i : word;

begin
for i:=1 to MaxConn do
  ProcessList[i]:=nil;
end.
