{$A+,B-,C+,D+,E-,F-,G+,H-,I-,J+,K-,L+,M-,N+,O-,P+,Q-,R-,S-,T-,U-,V+,W-,X+,Y+,Z1}
unit FtpObj;

{--------------------------------------------------------------------}
{ FtpObj module. Support for the User, Group and Directory objects.  }
{ 11/15/1999 Drt.                                                    }
{--------------------------------------------------------------------}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  GetWrd;

type
 TDirAttrib = set of
   (da_ReadList,      { Anyone can read the directory  }
    da_GrReadList,    { Directory group members can read the directory }
    da_ReadFiles,     { Anyone can read the directory files }
    da_WriteFiles,    { Anyone can write the directory files }
    da_GrReadFiles,   { Directory group members can read the directory files }
    da_GrWriteFiles,  { Directory group members can write the directory files }
    da_Enter,         { Anyone can enter the directory }
    da_GrEnter);      { Directory group members can enter the directory }

type
  TDirItem = class (TObject)
  public
    Alias    : string[130];
    Attrib   : TDirAttrib;
    UID      : word;
    GID      : word;
    end;

  TDirList = class (TStringList)
  private
    function RdPath(Index : integer) : string;
    procedure WrPath(Index : integer; Value : string);
    function RdAlias(Index : integer) : string;
    procedure WrAlias(Index : integer; Value : string);
    function RdUID(Index : integer) : word;
    procedure WrUID(Index : integer; Value : word);
    function RdGID(Index : integer) : word;
    procedure WrGID(Index : integer; Value : word);
    function RdAttrib(Index : integer) : TDirAttrib;
    procedure WrAttrib(Index : integer; Value : TDirAttrib);
  public
    constructor create;
    function AddDir(Path,Alias : string; Attrib : TDirAttrib; UID,GID : word) : integer;
    function Load : boolean; virtual;
    function Save : boolean; virtual;
    {$H+}
    function IndexOf(const S : String) : integer; override;
    {$H-}
    property Path[Index : integer] : string read RdPath write WrPath;
    property Alias[Index : integer] : string read RdAlias write WrAlias;
    property UID[Index : integer] : word read RdUID write WrUID;
    property GID[Index : integer] : word read RdGID write WrGID;
    property Attrib[Index : integer] : TDirAttrib read RdAttrib write WrAttrib;
    end;

  TGroupList = array [1..20] of word;

  TUserItem = class (TObject)
  public
    UID      : word;
    GID      : TGroupList;
    Password : string[30];
    Root     : boolean;
    Home     : string[130];
    end;

  TUserList = class (TStringList)
  private
    function RdUID(Index : integer) : word;
    function RdGID(Index,GIndex : integer) : word;
    procedure WrGID(Index,GIndex : integer; Value : word);
    function RdName(Index : integer) : string;
    function RdPassword(Index : integer) : string;
    procedure WrPassword(Index : integer; Value : string);
    function RdRoot(Index : integer) : boolean;
    procedure WrRoot(Index : integer; Value : boolean);
    function RdHome(Index : integer) : string;
    procedure WrHome(Index : integer; Value : string);
    function RdNameUID(UID : word) : string;
    function RdGIDUID(UID : word;GIndex : integer) : word;
    procedure WrGIDUID(UID : word; GIndex : integer; Value : word);
    function RdPassUID(UID : word) : string;
    procedure WrPassUID(UID : word; Value : string);
    function RdRootUID(UID : word) : boolean;
    procedure WrRootUID(UID : word; Value : boolean);
    function RdHomeUID(UID : word) : string;
    procedure WrHomeUID(UID : word; Value : string);
    function GetUID : word;
    procedure AddEntry(Name : string; UID : word; GID : TGroupList;
      Password : string; Root : boolean; Home : string);
  public
    constructor create;
    function AddUser(Name : string; GID : TGroupList; Password : string;
      Root : boolean; Home : string) : integer;
    function Load : boolean; virtual;
    function Save : boolean; virtual;
    function AddGroup(AUID,AGID : word) : boolean;
    function GroupsCount(AUID : word) : integer;
    function UIDByName(AName : string) : word;
    function GIDByName(AName : string;GIndex : integer) : word;
    function PassByName(AName : string) : string;
    function RootByName(AName : string) : boolean;
    function HomeByName(AName : string) : string;
    function InGroupByName(AName : string; AGID : word) : boolean;
    procedure GroupsClear(AUID : word);
    property UID[Index : integer] : word read RdUID;
    property GID[Index : integer;GIndex : integer] : word read RdGID write WrGID;
    property Name[Index : integer] : string read RdName;
    property Password[Index : integer] : string read RdPassword write WrPassword;
    property Root[Index : integer] : boolean read RdRoot write WrRoot;
    property Home[Index : integer] : string read RdHome write WrHome;
    property GIDByUID[UID : word;GIndex : integer] : word read RdGIDUID write WrGIDUID;
    property NameByUID[UID : word] : string read RdNameUID;
    property PassByUID[UID : word] : string read RdPassUID write WrPassUID;
    property RootByUID[UID : word] : boolean read RdRootUID write WrRootUID;
    property HomeByUID[UID : word] : string read RdHomeUID write WrHomeUID;
    end;

  TGrpItem = class (TObject)
  public
    GID       : word;
    end;

  TGrpList = class (TStringList)
  private
    function RdName(Index : integer) : string;
    function RdGID(Index : integer) : word;
    function RdNameGID(GID : word) : string;
    function GetGID : word;
    procedure AddEntry(Name : string; GID : word);
  public
    constructor create;
    function AddGrp(Name : string) : integer;
    function Load : boolean; virtual;
    function Save : boolean; virtual;
    function GIDByName(Name : string) : word;
    property Name[Index : integer] : string read RdName;
    property GID[Index : integer] : word read RdGID;
    property NameByGID[GID : word] : string read RdNameGID;
    end;

procedure SetStringSize(var s : string; n : word);
procedure DeleteSubkeys(k : hKey);

implementation

procedure SetStringSize(var s : string; n : word);
var
 i : word;
begin
for i:=1 to n do
  if s[i] = #0 then
    begin
    s[0]:=char(i-1);
    exit;
    end;
s[0]:=#0;
end;

type
 pTree = ^tTree;
 tTree = record
   s : string[100];
   n : pTree;
   end;

procedure DeleteSubkeys(k : hKey);
var
 t,t1 : pTree;
 i : integer;
 s : string;
 h : hKey;
begin
t:=nil;
t1:=nil;
i:=0;
while RegEnumKey(k,i,@s[1],253) = ERROR_SUCCESS do
  begin
  SetStringSize(s,253);
  inc(byte(s[0]));
  if t = nil then
    begin
    new(t);
    t1:=t;
    end
  else
    begin
    new(t1^.n);
    t1:=t1^.n;
    end;
  t1^.n:=nil;
  t1^.s:=s;
  inc(i);
  end;
while t <> nil do
  begin
  RegOpenKey(k,@t^.s[1],h);
  DeleteSubkeys(h);
  RegCloseKey(h);
  RegDeleteKey(k,@t^.s[1]);
  t1:=t^.n;
  dispose(t);
  t:=t1;
  end;
end;

{ ---------- TDirList ---------- }

constructor TDirList.create;
begin
inherited create;
sorted:=true;
end;

function TDirList.AddDir(Path,Alias : string; Attrib : TDirAttrib; UID,GID : word) : integer;
var
 i : integer;
 o : TDirItem;
begin
Path:=NormalizePath(trim(Path));
if (Path <> '') and (Path[byte(Path[0])] <> '/') then Path:=Path+'/';
o:=TDirItem.create;
o.Alias:=Alias;
o.Attrib:=Attrib;
o.UID:=UID;
o.GID:=GID;
i:=IndexOf(Path);
if i = -1 then
  begin
  result:=AddObject(Path,o);
  exit;
  end;
Objects[i].destroy;
Objects[i]:=o;
result:=i;
end;

{$H+}
function TDirList.IndexOf(const S : String) : integer;
var
 i : integer;
 s1: shortstring;
begin
s1:=s;
i:=inherited indexof(s1);
if i < 0 then
  begin
  if s <> '' then
    begin
    if s1[byte(s1[0])] = '/' then
      dec(byte(s1[0]))
    else
      s1:=s+'/';
    result:=inherited indexof(s1);
    end
  else
    begin
    result:=inherited indexof('/');
    end;
  end
else
  result:=i;
end;
{$H-}

function TDirList.Load;
var
 h,h1 : hKey;
 i : word;
 w : dword;
 Al : string;
 At : TDirAttrib;
 ID1,ID2 : word;
 sk : string[100];
begin
Clear;
result:=false;
{ -- Opening Main Key Path -- }
RegOpenKey(HKEY_LOCAL_MACHINE,'SOFTWARE',h1);
if RegOpenKey(h1,'Drt.',h) <> ERROR_SUCCESS then
  begin
  RegCloseKey(h1);
  exit;
  end;
RegCloseKey(h1);
if RegOpenKey(h,'TFTP',h1) <> ERROR_SUCCESS then
  begin
  RegCloseKey(h);
  exit;
  end;
RegCloseKey(h);
if RegOpenKey(h1,'Dirs',h) <> ERROR_SUCCESS then
  begin
  RegCloseKey(h1);
  exit;
  end;
RegCloseKey(h1);
i:=0;
while RegEnumKey(h,i,@sk[1],99) = ERROR_SUCCESS do
  begin
  if RegOpenKey(h,@sk[1],h1) = ERROR_SUCCESS then
    begin
    w:=253;
    if RegQueryValueEx(h1,'Alias',nil,nil,@al[1],@w) <> ERROR_SUCCESS then
      Al:=''
    else
      SetStringSize(Al,253);
    w:=sizeof(At);
    if RegQueryValueEx(h1,'Attrib',nil,nil,@at,@w) <> ERROR_SUCCESS then
      At:=[];
    w:=sizeof(ID1);
    if RegQueryValueEx(h1,'UID',nil,nil,@ID1,@w) <> ERROR_SUCCESS then
      ID1:=0;
    if RegQueryValueEx(h1,'GID',nil,nil,@ID2,@w) <> ERROR_SUCCESS then
      ID2:=0;
    SetStringSize(sk,100);
    AddDir(sk,Al,At,ID1,ID2);
    RegCloseKey(h1);
    end;
  inc(i);
  end;
RegCloseKey(h);
result:=true;
end;

function TDirList.Save;
var
 h,h1 : hKey;
 w : word;
 n : word;
 i : word;
 Pt,Al : string;
 At : TDirAttrib;
 ID1,ID2 : word;
begin
{ -- Opening Main Key Path -- }
RegOpenKey(HKEY_LOCAL_MACHINE,'SOFTWARE',h1);
RegCreateKey(h1,'Drt.',h);
RegCloseKey(h1);
RegCreateKey(h,'TFTP',h1);
RegCloseKey(h);
RegCreateKey(h1,'Dirs',h);
RegCloseKey(h1);
DeleteSubkeys(h);
n:=Count;
for i:=1 to n do
  begin
  Pt:=Path[i-1]+#0;
  Al:=Alias[i-1]+#0;
  At:=Attrib[i-1];
  ID1:=UID[i-1];
  ID2:=GID[i-1];
  RegCreateKey(h,@Pt[1],h1);
  w:=length(Al);
  RegSetValueEx(h1,'Alias',0,REG_SZ,@Al[1],w);
  w:=sizeof(At);
  RegSetValueEx(h1,'Attrib',0,REG_BINARY,@At,w);
  w:=sizeof(ID1);
  RegSetValueEx(h1,'UID',0,REG_BINARY,@ID1,w);
  w:=sizeof(ID2);
  RegSetValueEx(h1,'GID',0,REG_BINARY,@ID2,w);
  RegCloseKey(h1);
  end;
RegCloseKey(h);
result:=true;
end;

function TDirList.RdPath(Index : integer) : string;
begin
if (Index < 0) or (Index >= count) then
  begin
  result:='';
  exit;
  end;
result:=Strings[Index];
end;

procedure TDirList.WrPath(Index : integer; Value : string);
var
 s : string[130];
begin
if (Index < 0) or (Index >= count) then exit;
s:=NormalizePath(Value);
if (s = '') or (s[byte(s[0])] <> '/') then s:=s+'/';
Strings[Index]:=s;
end;

function TDirList.RdAlias(Index : integer) : string;
begin
if (Index < 0) or (Index >= count) then
  begin
  result:='';
  exit;
  end;
result:=TDirItem(objects[Index]).Alias;
end;

procedure TDirList.WrAlias(Index : integer; Value : string);
begin
if (Index < 0) or (Index >= count) then exit;
TDirItem(objects[Index]).Alias:=Value;
end;

function TDirList.RdUID(Index : integer) : word;
begin
if (Index < 0) or (Index >= count) then
  begin
  result:=$ffff;
  exit;
  end;
result:=TDirItem(objects[Index]).UID;
end;

procedure TDirList.WrUID(Index : integer; Value : word);
begin
if (Index < 0) or (Index >= count) then exit;
TDirItem(objects[Index]).UID:=Value;
end;

function TDirList.RdGID(Index : integer) : word;
begin
if (Index < 0) or (Index >= count) then
  begin
  result:=$ffff;
  exit;
  end;
result:=TDirItem(objects[Index]).GID;
end;

procedure TDirList.WrGID(Index : integer; Value : word);
begin
if (Index < 0) or (Index >= count) then exit;
TDirItem(objects[Index]).GID:=Value;
end;

function TDirList.RdAttrib(Index : integer) : TDirAttrib;
begin
if (Index < 0) or (Index >= count) then
  begin
  result:=[];
  exit;
  end;
result:=TDirItem(objects[Index]).Attrib;
end;

procedure TDirList.WrAttrib(Index : integer; Value : TDirAttrib);
begin
if (Index < 0) or (Index >= count) then exit;
TDirItem(objects[Index]).Attrib:=Value;
end;

{ ---------- TUserList ---------- }

function TUserList.GetUID : word;
var
 a : array [0..8191] of byte;
 i : word;
 j : word;
 w : word;
begin
if Count = 0 then
  begin
  result:=0;
  exit;
  end;
for i:=0 to 8191 do
  a[i]:=0;
for i:=0 to Count-1 do
  begin
  w:=UID[i];
  a[w shr 3]:=a[w shr 3] or ($80 shr (w and 7));
  end;
for i:=0 to 8191 do
  begin
  if a[i] <> $ff then
    begin
    j:=0;
    while (a[i] and $80) <> 0 do
      begin
      inc(j);
      a[i]:=a[i] shl 1;
      end;
    result:=((i shl 3) and $fff8) or j;
    exit;
    end
  end;
result:=$fff0;
end;

constructor TUserList.create;
begin
inherited create;
sorted:=true;
end;

function TUserList.AddUser;
var
 i : integer;
 o : TUserItem;
begin
Name:=trim(Name);
o:=TUserItem.create;
o.UID:=GetUID;
o.GID:=GID;
o.Password:=Password;
o.Root:=Root;
o.Home:=Home;
i:=IndexOf(Name);
if i = -1 then
  begin
  result:=AddObject(Name,o);
  exit;
  end;
o.UID:=TUserItem(Objects[i]).UID;
Objects[i].destroy;
Objects[i]:=o;
result:=i;
end;

procedure TUserList.AddEntry;
var
 o : TUserItem;
begin
Name:=trim(Name);
o:=TUserItem.create;
o.UID:=UID;
o.GID:=GID;
o.Password:=Password;
o.Root:=Root;
o.Home:=Home;
AddObject(Name,o);
end;

function TUserList.AddGroup(AUID,AGID : word) : boolean;
var
 i : integer;
begin
result:=false;
for i:=1 to 20 do
  if GID[AUID,i] = AGID then exit;
for i:=1 to 20 do
  if GID[AUID,i] = $FFF0 then
    begin
    GID[AUID,i]:=AGID;
    result:=true;
    end;
end;

function TUserList.Load;
var
 h,h1 : hKey;
 i : word;
 w : dword;
 s : string[20];
 n : word;
 j,k : word;
 Nm,Pw,Hm  : string;
 ID1 : word;
 Rt : boolean;
 l : TGroupList;
begin
Clear;
result:=false;
{ -- Opening Main Key Path -- }
RegOpenKey(HKEY_LOCAL_MACHINE,'SOFTWARE',h1);
if RegOpenKey(h1,'Drt.',h) <> ERROR_SUCCESS then
  begin
  RegCloseKey(h1);
  exit;
  end;
RegCloseKey(h1);
if RegOpenKey(h,'TFTP',h1) <> ERROR_SUCCESS then
  begin
  RegCloseKey(h);
  exit;
  end;
RegCloseKey(h);
if RegOpenKey(h1,'Users',h) <> ERROR_SUCCESS then
  begin
  RegCloseKey(h1);
  exit;
  end;
RegCloseKey(h1);
i:=0;
while RegEnumKey(h,i,@Nm[1],253) = ERROR_SUCCESS do
  begin
  if RegOpenKey(h,@Nm[1],h1) = ERROR_SUCCESS then
    begin
    w:=253;
    if RegQueryValueEx(h1,'Password',nil,nil,@Pw[1],@w) <> ERROR_SUCCESS then
      Pw:='~~<<<>>>~~'
    else
      SetStringSize(Pw,253);
    w:=253;
    if RegQueryValueEx(h1,'Home',nil,nil,@Hm[1],@w) <> ERROR_SUCCESS then
      Hm:='/'
    else
      SetStringSize(Hm,253);
    w:=sizeof(ID1);
    if RegQueryValueEx(h1,'UID',nil,nil,@ID1,@w) <> ERROR_SUCCESS then
      ID1:=$FFF0;
    w:=sizeof(Rt);
    if RegQueryValueEx(h1,'Root',nil,nil,@Rt,@w) <> ERROR_SUCCESS then
      Rt:=false;
    k:=1;
    for j:=1 to 20 do
      begin
      s:=format('Group%u',[j])+#0;
      w:=sizeof(n);
      if RegQueryValueEx(h1,@s[1],nil,nil,@n,@w) = ERROR_SUCCESS then
        begin
        l[k]:=n;
        inc(k);
        end;
      end;
    while k <= 20 do
      begin
      l[k]:=$FFF0;
      inc(k);
      end;
    SetStringSize(Nm,100);
    AddEntry(Nm,ID1,l,Pw,Rt,Hm);
    RegCloseKey(h1);
    end;
  inc(i);
  end;
RegCloseKey(h);
result:=true;
end;

function TUserList.Save;
var
 h,h1 : hKey;
 w : word;
 n : word;
 i,j : word;
 Nm,Pw,Hm  : string;
 ID1 : word;
 Rt : boolean;
 s : string[20];
begin
{ -- Opening Main Key Path -- }
RegOpenKey(HKEY_LOCAL_MACHINE,'SOFTWARE',h1);
RegCreateKey(h1,'Drt.',h);
RegCloseKey(h1);
RegCreateKey(h,'TFTP',h1);
RegCloseKey(h);
RegCreateKey(h1,'Users',h);
RegCloseKey(h1);
DeleteSubkeys(h);
n:=Count;
for i:=1 to n do
  begin
  Nm:=Name[i-1]+#0;
  ID1:=UID[i-1];
  Pw:=Password[i-1]+#0;
  Rt:=Root[i-1];
  Hm:=Home[i-1]+#0;
  RegCreateKey(h,@Nm[1],h1);
  w:=length(Pw);
  RegSetValueEx(h1,'Password',0,REG_SZ,@Pw[1],w);
  w:=length(Hm);
  RegSetValueEx(h1,'Home',0,REG_SZ,@Hm[1],w);
  w:=sizeof(ID1);
  RegSetValueEx(h1,'UID',0,REG_BINARY,@ID1,w);
  w:=sizeof(Rt);
  RegSetValueEx(h1,'Root',0,REG_BINARY,@Rt,w);
  for n:=1 to 20 do
    begin
    s:=format('Group%u',[n])+#0;
    j:=GID[i-1,n];
    if j <> $FFF0 then
      begin
      w:=sizeof(j);
      RegSetValueEx(h1,@s[1],0,REG_BINARY,@j,w);
      end;
    end;
  RegCloseKey(h1);
  end;
RegCloseKey(h);
result:=true;
end;

function TUserList.RdUID(Index : integer) : word;
begin
if (Index < 0) or (Index >= count) then
  begin
  result:=$fff0;
  exit;
  end;
result:=TUserItem(Objects[Index]).UID;
end;

function TUserList.RdGID(Index,GIndex : integer) : word;
begin
if (Index < 0) or (Index >= count) then
  begin
  result:=$fff0;
  exit;
  end;
result:=TUserItem(Objects[Index]).GID[GIndex];
end;

procedure TUserList.WrGID(Index,GIndex : integer; Value : word);
begin
if (Index < 0) or (Index >= count) then exit;
TUserItem(Objects[Index]).GID[GIndex]:=Value;
end;

function TUserList.RdName(Index : integer) : string;
begin
if (Index < 0) or (Index >= count) then
  begin
  result:='';
  exit;
  end;
result:=Strings[Index];
end;

function TUserList.RdPassword(Index : integer) : string;
begin
if (Index < 0) or (Index >= count) then
  begin
  result:='';
  exit;
  end;
result:=TUserItem(Objects[Index]).Password;
end;

procedure TUserList.WrPassword(Index : integer; Value : string);
begin
if (Index < 0) or (Index >= count) then exit;
TUserItem(Objects[Index]).Password:=Value;
end;

function TUserList.RdRoot(Index : integer) : boolean;
begin
if (Index < 0) or (Index >= count) then
  begin
  result:=false;
  exit;
  end;
result:=TUserItem(Objects[Index]).Root;
end;

procedure TUserList.WrRoot(Index : integer; Value : boolean);
begin
if (Index < 0) or (Index >= count) then exit;
TUserItem(Objects[Index]).Root:=Value;
end;

function TUserList.RdHome(Index : integer) : string;
begin
if (Index < 0) or (Index >= count) then
  begin
  result:='';
  exit;
  end;
result:=TUserItem(Objects[Index]).Home;
end;

procedure TUserList.WrHome(Index : integer; Value : string);
begin
if (Index < 0) or (Index >= count) then exit;
TUserItem(Objects[Index]).Home:=Value;
end;

function TUserList.RdGIDUID(UID : word; GIndex : integer) : word;
var
 i : integer;
begin
result:=$fff0;
if Count = 0 then exit;
for i:=0 to Count-1 do
  begin
  if TUserItem(Objects[i]).UID = UID then
    begin
    result:=TUserItem(Objects[i]).GID[GIndex];
    end;
  end;
end;

procedure TUserList.WrGIDUID(UID : word; GIndex : integer; Value : word);
var
 i : integer;
begin
if Count = 0 then exit;
for i:=0 to Count-1 do
  begin
  if TUserItem(Objects[i]).UID = UID then
    begin
    TUserItem(Objects[i]).GID[GIndex]:=Value;
    end;
  end;
end;

function TUserList.RdNameUID(UID : word) : string;
var
 i : integer;
begin
result:='';
if Count = 0 then exit;
for i:=0 to Count-1 do
  begin
  if TUserItem(Objects[i]).UID = UID then
    begin
    result:=Strings[i];
    end;
  end;
end;

function TUserList.RdPassUID(UID : word) : string;
var
 i : integer;
begin
result:='';
if Count = 0 then exit;
for i:=0 to Count-1 do
  begin
  if TUserItem(Objects[i]).UID = UID then
    begin
    result:=TUserItem(Objects[i]).Password;
    end;
  end;
end;

procedure TUserList.WrPassUID(UID : word; Value : string);
var
 i : integer;
begin
if Count = 0 then exit;
for i:=0 to Count-1 do
  begin
  if TUserItem(Objects[i]).UID = UID then
    begin
    TUserItem(Objects[i]).Password:=Value;
    end;
  end;
end;

function TUserList.RdRootUID(UID : word) : boolean;
var
 i : integer;
begin
result:=false;
if Count = 0 then exit;
for i:=0 to Count-1 do
  begin
  if TUserItem(Objects[i]).UID = UID then
    begin
    result:=TUserItem(Objects[i]).Root;
    end;
  end;
end;

procedure TUserList.WrRootUID(UID : word; Value : boolean);
var
 i : integer;
begin
if Count = 0 then exit;
for i:=0 to Count-1 do
  begin
  if TUserItem(Objects[i]).UID = UID then
    begin
    TUserItem(Objects[i]).Root:=Value;
    end;
  end;
end;

function TUserList.RdHomeUID(UID : word) : string;
var
 i : integer;
begin
result:='';
if Count = 0 then exit;
for i:=0 to Count-1 do
  begin
  if TUserItem(Objects[i]).UID = UID then
    begin
    result:=TUserItem(Objects[i]).Home;
    end;
  end;
end;

procedure TUserList.WrHomeUID(UID : word; Value : string);
var
 i : integer;
begin
if Count = 0 then exit;
for i:=0 to Count-1 do
  begin
  if TUserItem(Objects[i]).UID = UID then
    begin
    TUserItem(Objects[i]).Home:=Value;
    end;
  end;
end;

function TUserList.UIDByName(AName : string) : word;
var
 i : integer;
begin
result:=$FFF0;
i:=IndexOf(AName);
if i >= 0 then
  result:=UID[i];
end;

function TUserList.GIDByName(AName : string;GIndex : integer) : word;
var
 i : integer;
begin
result:=$FFF0;
i:=IndexOf(AName);
if i >= 0 then
  result:=GID[i,GIndex];
end;

function TUserList.PassByName(AName : string) : string;
var
 i : integer;
begin
result:='';
i:=IndexOf(AName);
if i >= 0 then
  result:=Password[i];
end;

function TUserList.RootByName(AName : string) : boolean;
var
 i : integer;
begin
result:=false;
i:=IndexOf(AName);
if i >= 0 then
  result:=Root[i];
end;

function TUserList.HomeByName(AName : string) : string;
var
 i : integer;
begin
result:='';
i:=IndexOf(AName);
if i >= 0 then
  result:=Home[i];
end;

function TUserList.InGroupByName(AName : string; AGID : word) : boolean;
var
 i,j : integer;
begin
result:=false;
if AGID = $FFF0 then
  exit;
i:=IndexOf(AName);
if i >= 0 then
  for j:=1 to 20 do
    if AGID = GID[i,j] then
      begin
      result:=true;
      exit;
      end;
end;

procedure TUserList.GroupsClear(AUID : word);
var
 i : integer;
begin
for i:=1 to 20 do
  GID[AUID,i]:=$FFF0;
end;

function TUserList.GroupsCount(AUID : word) : integer;
var
 i,j : integer;
begin
j:=0;
for i:=1 to 20 do
  if GID[AUID,i] <> $FFF0 then inc(j);
result:=j;
end;

{ ---------- TGrpList ---------- }

function TGrpList.GetGID : word;
var
 a : array [0..8191] of byte;
 i : word;
 j : word;
 w : word;
begin
if Count = 0 then
  begin
  result:=0;
  exit;
  end;
for i:=0 to 8191 do
  a[i]:=0;
for i:=0 to Count-1 do
  begin
  w:=GID[i];
  a[w shr 3]:=a[w shr 3] or ($80 shr (w and 7));
  end;
for i:=0 to 8191 do
  begin
  if a[i] <> $ff then
    begin
    j:=0;
    while (a[i] and $80) <> 0 do
      begin
      inc(j);
      a[i]:=a[i] shl 1;
      end;
    result:=((i shl 3) and $fff8) or j;
    exit;
    end
  end;
result:=$ffff;
end;

constructor TGrpList.create;
begin
inherited create;
sorted:=true;
end;

function TGrpList.AddGrp(Name : string) : integer;
var
 i : integer;
 o : TGrpItem;
begin
Name:=trim(Name);
o:=TGrpItem.create;
o.GID:=GetGID;
i:=IndexOf(Name);
if i = -1 then
  begin
  result:=AddObject(Name,o);
  exit;
  end;
o.destroy;
result:=-1;
end;

procedure TGrpList.AddEntry(Name : string; GID : word);
var
 o : TGrpItem;
begin
Name:=trim(Name);
o:=TGrpItem.create;
o.GID:=GID;
AddObject(Name,o);
end;

function TGrpList.Load;
var
 h,h1 : hKey;
 i : word;
 w : dword;
 ID : word;
 sk : string[100];
begin
Clear;
result:=false;
{ -- Opening Main Key Path -- }
RegOpenKey(HKEY_LOCAL_MACHINE,'SOFTWARE',h1);
if RegOpenKey(h1,'Drt.',h) <> ERROR_SUCCESS then
  begin
  RegCloseKey(h1);
  exit;
  end;
RegCloseKey(h1);
if RegOpenKey(h,'TFTP',h1) <> ERROR_SUCCESS then
  begin
  RegCloseKey(h);
  exit;
  end;
RegCloseKey(h);
if RegOpenKey(h1,'Groups',h) <> ERROR_SUCCESS then
  begin
  RegCloseKey(h1);
  exit;
  end;
RegCloseKey(h1);
i:=0;
while RegEnumKey(h,i,@sk[1],99) = ERROR_SUCCESS do
  begin
  if RegOpenKey(h,@sk[1],h1) = ERROR_SUCCESS then
    begin
    w:=sizeof(ID);
    if RegQueryValueEx(h1,'GID',nil,nil,@ID,@w) = ERROR_SUCCESS then
      begin
      SetStringSize(sk,100);
      AddEntry(sk,ID);
      end;
    RegCloseKey(h1);
    end;
  inc(i);
  end;
RegCloseKey(h);
result:=true;
end;

function TGrpList.Save;
var
 h,h1 : hKey;
 w : word;
 n : word;
 i : word;
 Nm : string;
 ID : word;
begin
{ -- Opening Main Key Path -- }
RegOpenKey(HKEY_LOCAL_MACHINE,'SOFTWARE',h1);
RegCreateKey(h1,'Drt.',h);
RegCloseKey(h1);
RegCreateKey(h,'TFTP',h1);
RegCloseKey(h);
RegCreateKey(h1,'Groups',h);
RegCloseKey(h1);
DeleteSubkeys(h);
n:=Count;
for i:=1 to n do
  begin
  Nm:=Name[i-1]+#0;
  ID:=GID[i-1];
  RegCreateKey(h,@Nm[1],h1);
  w:=sizeof(ID);
  RegSetValueEx(h1,'GID',0,REG_BINARY,@ID,w);
  RegCloseKey(h1);
  end;
RegCloseKey(h);
result:=true;
end;

function TGrpList.RdName(Index : integer) : string;
begin
if (Index < 0) or (Index >= Count) then
  begin
  result:='';
  exit;
  end;
result:=Strings[Index];
end;

function TGrpList.RdGID(Index : integer) : word;
begin
if (Index < 0) or (Index >= Count) then
  begin
  result:=$ffff;
  exit;
  end;
result:=TGrpItem(Objects[Index]).GID;
end;

function TGrpList.RdNameGID(GID : word) : string;
var
 i : integer;
begin
result:='';
if Count = 0 then exit;
for i:=0 to Count-1 do
  begin
  if TGrpItem(Objects[i]).GID = GID then
    begin
    result:=Strings[i];
    end;
  end;
end;

function TGrpList.GIDByName(Name : string) : word;
begin
result:=GID[IndexOf(Name)];
end;

end.
