{$A+,B-,C+,D+,E-,F-,G+,H-,I-,J+,K-,L+,M-,N+,O-,P+,Q-,R-,S-,T-,U-,V+,W-,X+,Y+,Z1}

{------------------------------------------------------------------------}
{ CntrlTrd - Main control thread. Listens for incoming connections and   }
{            creates a control tread for each connection.                }
{ 11/15/1999 Drt.                                                        }
{------------------------------------------------------------------------}

unit CntrlTrd;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  WinSock, TrdBase, SrvCtrl;

type
  TControlThread = class (TFtpThreades)
  private
    Res : boolean;
    procedure Execute; override;
    procedure Terminate;
    procedure HandleError(ErrNo : integer);
    procedure LogMessage(MsgNo : integer);
    procedure Synchronized;
  public
    ControlLog : TCallLogEvent;
    constructor Create(Suspend : boolean; APort : word; AParent : TFtpComponent; AControlLog : TCallLogEvent);
    procedure Stop;
    end;

implementation

constructor TControlThread.Create;
begin
inherited create(Suspend);
cmd:='';
par:='';
Usr:='';
Pwd:='';
CDir:='';
FName:='';
RAddr[1]:=0;
RAddr[2]:=0;
RAddr[3]:=0;
RAddr[4]:=0;
Error:=0;
PType:=tt_Main;
Run:=false;
Port:=APort;
Parent:=AParent;
ControlLog:=AControlLog;
Run:=true;
FreeOnTerminate:=true;
LogMessage(CM_START);
Resume;
end;

procedure TControlThread.Execute;
var
 prt : word;
 P   : pProtoEnt;
 sin : TSockAddrIn;
 len : integer;
 tsc : integer;
begin
prt:=htons(Port);
P:=GetProtoByName('TCP');
if P = nil then
  begin
  HandleError(WSAENOPROTOOPT);
  terminate;
  exit;
  end;
bzero(sin,sizeof(sin));
sin.sin_family:=AF_INET;
sin.sin_port:=prt;
CSocket:=socket(AF_INET,SOCK_STREAM,P^.p_proto);
if CSocket = INVALID_SOCKET then
  begin
  HandleError(WSAGetLastError);
  terminate;
  exit;
  end;
if bind(CSocket,tsockaddr(sin),sizeof(sin)) = SOCKET_ERROR then
  begin
  HandleError(WSAGetLastError);
  terminate;
  exit;
  end;
if listen(CSocket,10) = SOCKET_ERROR then
  begin
  HandleError(WSAGetLastError);
  terminate;
  exit;
  end;
LogMessage(CM_LISTEN);
Error:=0;
len:=sizeof(sin);
while not terminated do
  begin
  tsc:=accept(CSocket,@tsockaddr(sin),@len);
  if tsc <> INVALID_SOCKET then
    begin
    TSrvCtrlThread.Create(tsc,ControlLog,Parent,TAddr(sin.sin_addr.s_un_b));
    end;
  end;
end;

procedure TControlThread.Stop;
begin
LogMessage(CM_STOP);
sleep(200);
if Run then
  begin
  Shutdown(CSocket,2);
  CloseSocket(CSocket);
  Run:=false;
  end;
terminate;
end;

procedure TControlThread.HandleError(ErrNo : integer);
begin
Error:=ErrNo;
LogMessage(ErrNo);
end;

procedure TControlThread.Synchronized;
begin
if assigned(ControlLog) then ControlLog(self,Res);
end;

procedure TControlThread.LogMessage(MsgNo : integer);
begin
Messg:=MsgNo;
Synchronize(Synchronized);
end;

procedure TControlThread.Terminate;
begin
Shutdown(CSocket,2);
CloseSocket(CSocket);
inherited Terminate;
end;

end.
