unit Unit4;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, FtpObj;

type
  TForm4 = class(TForm)
    Edit1: TEdit;
    Label1: TLabel;
    ComboBox1: TComboBox;
    ComboBox2: TComboBox;
    GroupBox1: TGroupBox;
    Label2: TLabel;
    Label3: TLabel;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    CheckBox7: TCheckBox;
    CheckBox8: TCheckBox;
    Label4: TLabel;
    Label5: TLabel;
    Button1: TButton;
    Button2: TButton;
    Edit2: TEdit;
    Label6: TLabel;
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Path : string;
  end;

var
  Form4: TForm4;

implementation

uses Unit1;

{$R *.DFM}

procedure TForm4.Button2Click(Sender: TObject);
begin
close;
end;

procedure TForm4.Button1Click(Sender: TObject);
var
 UID,GID : word;
 Attr    : TDirAttrib;
 i       : integer;
 Alias   : string[130];
begin
if trim(edit2.text) = '' then
  begin
  MessageBox(0,'Alias can NOT be an empty string','Error',16);
  exit;
  end;
Alias:=edit2.text;
if Path = '' then Path:=edit1.text;
i:=Form1.FtpSrvr1.UserList.IndexOf(ComboBox1.Items[ComboBox1.ItemIndex]);
if (i < 0) or (i >= Form1.FtpSrvr1.UserList.Count) then
  UID:=$ffff
else
  UID:=Form1.FtpSrvr1.UserList.UID[i];
i:=Form1.FtpSrvr1.GrpList.IndexOf(ComboBox2.Items[ComboBox2.ItemIndex]);
if (i < 0) or (i >= Form1.FtpSrvr1.GrpList.Count) then
  GID:=$ffff
else
  GID:=Form1.FtpSrvr1.GrpList.GID[i];
Attr:=[];
if CheckBox1.Checked then Attr:=Attr + [da_GrEnter];
if CheckBox2.Checked then Attr:=Attr + [da_GrReadList];
if CheckBox3.Checked then Attr:=Attr + [da_GrReadFiles];
if CheckBox4.Checked then Attr:=Attr + [da_GrWriteFiles];
if CheckBox5.Checked then Attr:=Attr + [da_Enter];
if CheckBox6.Checked then Attr:=Attr + [da_ReadList];
if CheckBox7.Checked then Attr:=Attr + [da_ReadFiles];
if CheckBox8.Checked then Attr:=Attr + [da_WriteFiles];
Form1.FtpSrvr1.DirList.AddDir(trim(Path),trim(Alias),Attr,UID,GID);
Form1.Reload;
close;
end;

procedure TForm4.FormActivate(Sender: TObject);
var
 i : integer;
begin
ComboBox1.Clear;
for i:=0 to Form1.FtpSrvr1.UserList.Count-1 do
  ComboBox1.Items.Add(Form1.FtpSrvr1.UserList.Name[i]);
ComboBox2.Clear;
for i:=0 to Form1.FtpSrvr1.GrpList.Count-1 do
  ComboBox2.Items.Add(Form1.FtpSrvr1.GrpList.Name[i]);
CheckBox1.Checked:=false;
CheckBox2.Checked:=false;
CheckBox3.Checked:=false;
CheckBox4.Checked:=false;
CheckBox5.Checked:=false;
CheckBox6.Checked:=false;
CheckBox7.Checked:=false;
CheckBox8.Checked:=false;
if Path = '' then
  begin
  edit1.text:='';
  edit2.text:='';
  ComboBox1.ItemIndex:=-1;
  ComboBox2.ItemIndex:=-1;
  end
else
  begin
  i:=Form1.FtpSrvr1.DirList.IndexOf(Path);
  if (i >= 0) and (i < Form1.FtpSrvr1.DirList.Count) then
    begin
    Edit1.text:=Path;
    Edit2.text:=Form1.FtpSrvr1.DirList.Alias[i];
    ComboBox1.ItemIndex:=Form1.FtpSrvr1.UserList.IndexOf(Form1.FtpSrvr1.UserList.NameByUID[Form1.FtpSrvr1.DirList.UID[i]]);
    ComboBox2.ItemIndex:=Form1.FtpSrvr1.GrpList.IndexOf(Form1.FtpSrvr1.GrpList.NameByGID[Form1.FtpSrvr1.DirList.GID[i]]);
    if da_GrEnter      in Form1.FtpSrvr1.DirList.Attrib[i] then CheckBox1.Checked:=true;
    if da_GrReadList   in Form1.FtpSrvr1.DirList.Attrib[i] then CheckBox2.Checked:=true;
    if da_GrReadFiles  in Form1.FtpSrvr1.DirList.Attrib[i] then CheckBox3.Checked:=true;
    if da_GrWriteFiles in Form1.FtpSrvr1.DirList.Attrib[i] then CheckBox4.Checked:=true;
    if da_Enter        in Form1.FtpSrvr1.DirList.Attrib[i] then CheckBox5.Checked:=true;
    if da_ReadList     in Form1.FtpSrvr1.DirList.Attrib[i] then CheckBox6.Checked:=true;
    if da_ReadFiles    in Form1.FtpSrvr1.DirList.Attrib[i] then CheckBox7.Checked:=true;
    if da_WriteFiles   in Form1.FtpSrvr1.DirList.Attrib[i] then CheckBox8.Checked:=true;
    end
  else
    begin
    edit1.text:='';
    edit2.text:='';
    ComboBox1.ItemIndex:=-1;
    ComboBox2.ItemIndex:=-1;
    end;
  end;
edit1.setfocus;
end;

end.
