unit step;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Menus, CheckLst, Buttons, StepControls;

type
  TStepDemo = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Edit1: TMenuItem;
    Tools1: TMenuItem;
    Help1: TMenuItem;
    Panel1: TPanel;
    Panel2: TPanel;
    CheckListBox1: TCheckListBox;
    GroupBox1: TPanel;
    StepArrow1: TStepArrow;
    StepPanel1: TStepPanel;
    StepLabel5: TStepLabel;
    StepLabel6: TStepLabel;
    StepLabel7: TStepLabel;
    StepPanel2: TStepPanel;
    StepLabel8: TStepLabel;
    StepLabel9: TStepLabel;
    StepLabel10: TStepLabel;
    StepPanel3: TStepPanel;
    StepLabel11: TStepLabel;
    StepLabel12: TStepLabel;
    StepLabel13: TStepLabel;
    StepPanel5: TStepPanel;
    StepLabel14: TStepLabel;
    StepLabel15: TStepLabel;
    StepLabel16: TStepLabel;
    StepPanel4: TStepPanel;
    StepLabel17: TStepLabel;
    StepLabel18: TStepLabel;
    StepLabel19: TStepLabel;
    Panel3: TPanel;
    StepListBox1: TStepListBox;
    ComboBox1: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    Bevel1: TBevel;
    Label3: TLabel;
    procedure StepPanel1Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    //procedure StepLabel1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure StepPanel1Expand(Sender: TObject);
    procedure StepArrow1Click(Sender: TObject);
  private
    { Private declarations }
    procedure WMSize(var Message: TWMSize); message WM_SIZE;
    Procedure SizeSteps;
  public
    { Public declarations }
  end;

var
  StepDemo: TStepDemo;
  Arrowsize : integer;
  FLoaded : Boolean;

implementation

{$R *.DFM}

procedure TStepDemo.StepPanel1Click(Sender: TObject);
begin
  CheckBox1Click(TCheckBox((Sender as TStepPanel).Controls[0]));
end;

procedure TStepDemo.CheckBox1Click(Sender: TObject);
var
  I, J: Integer;
  Child: TControl;
begin
  // uncheck all parent checks
  ((Sender as TStepLabel).Parent as TStepPanel).Checked := True;
  for I := 0 to GroupBox1.ControlCount - 1 do
  begin
    Child := GroupBox1.Controls[I];
    if (Child is TStepPanel) then begin
     TStepLabel((Child as TStepPanel).Controls[0]).Font.Color := clBlack;
     TStepLabel((Child as TStepPanel).Controls[0]).ColorRollOver := clBlack;
     TStepLabel((Child as TStepPanel).Controls[1]).Font.Color := clBlack;
     TStepLabel((Child as TStepPanel).Controls[1]).ColorRollOver := clBlack;
     TStepLabel((Child as TStepPanel).Controls[2]).Font.Color := clBlack;
     TStepLabel((Child as TStepPanel).Controls[2]).ColorRollOver := clBlack;
    end;
  end;

    (Sender as TStepLabel).Font.Color := clWhite;
    (Sender as TStepLabel).ColorRollOver := clWhite;

end;

procedure TStepDemo.WMSize(var Message: TWMSize);
Var
  Xinc : Integer;
begin
  inherited;
  if FLoaded then
    SizeSteps;
end;

procedure TStepDemo.SizeSteps;
Var
  PWidths : Integer;
begin
  // space and size the step buttons
  PWidths := StepDemo.Width;
  PWidths := Round(PWidths / 5);

  // account for rounding error
  if StepPanel1.expanded = False then
    PWidths := PWidths - StepPanel1.CollapseOffset + 1;
    
  StepPanel1.Width := PWidths;

  StepPanel2.left := StepPanel1.Left + StepPanel1.Width - StepPanel1.ArrowOffset + 1;
  StepPanel2.Width := PWidths;

  StepPanel3.left := StepPanel2.Left + StepPanel2.Width - StepPanel2.ArrowOffset + 1;
  StepPanel3.Width := PWidths;

  StepPanel5.left := StepPanel3.Left + StepPanel3.Width - StepPanel3.ArrowOffset + 1;
  StepPanel5.Width := PWidths;

  StepPanel4.left := StepPanel5.Left + StepPanel5.Width - StepPanel5.ArrowOffset + 1;
  StepPanel4.Width := PWidths;

  StepArrow1.Left := StepPanel4.Left + StepPanel4.Width;
end;

procedure TStepDemo.FormActivate(Sender: TObject);
begin
  FLoaded := True;
end;

procedure TStepDemo.FormCreate(Sender: TObject);
begin
  Arrowsize := 0;
  FLoaded := False;
end;

procedure TStepDemo.StepPanel1Expand(Sender: TObject);
begin
  If (Sender as TStepPanel).Expanded then begin
    (Sender as TStepPanel).StepFont.Size := (Sender as TStepPanel).StepFont.Size + 7
  end
  else begin
    (Sender as TStepPanel).StepFont.Size := (Sender as TStepPanel).StepFont.Size - 7
  end;
end;

procedure TStepDemo.StepArrow1Click(Sender: TObject);
begin
  StepPanel1.Expanded := (Not StepPanel1.Expanded);
  StepPanel2.Expanded := (Not StepPanel2.Expanded);
  StepPanel3.Expanded := (Not StepPanel3.Expanded);
  StepPanel4.Expanded := (Not StepPanel4.Expanded);
  StepPanel5.Expanded := (Not StepPanel5.Expanded);
  groupbox1.Height := StepPanel1.Height + 10;
end;

end.


