unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, inovaGIS_TLB;
(*
  INSTALLATION
    To compile this project you MUST first import the inovaGIS
    type library (the unit inovaGIS_TLB), by doing

    MENU
    PROJECT | IMPORT TYPE LIBRARY ...
    and choose the inovagis library creating the file in the
    same directory you place this project.
    Please remember that for any update of the inovagis library
    you repeat this import.
  *)
type
  TForm1 = class(TForm)
    Button1: TButton;
    ScrollBox1: TScrollBox;
    Panel1: TPanel;
    Image1: TImage;
    OpenDialog1: TOpenDialog;
    ComboBox1: TComboBox;
    Button2: TButton;
    Button3: TButton;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Edit5: TEdit;
    ListBox1: TListBox;
    Button4: TButton;
    Panel2: TPanel;
    Label3: TLabel;
    Label7: TLabel;
    Label2: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Memo1: TMemo;
    Label4: TLabel;
    Bevel1: TBevel;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
  private
    { Private declarations }
    map: iImg;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
var bit:tbitmap;
begin

     if OpenDialog1.Execute then
        begin
             map.Terminate;
             map.Document.Name := OpenDialog1.FileName;
             if map.Open then
                begin
                     bit:=TBitMap.Create;
                     bit.Width:=map.Cols;
                     bit.Height:=map.Rows;
                     map.Legend.Palette.Name:= ComboBox1.ItemIndex+1;
                     map.Draw(0,0,100,bit.canvas.handle);
                     image1.Stretch:=false;
                     Image1.width:=bit.Width;
                     Image1.Height:=bit.Height;
                     Image1.Picture.Graphic := Bit;
                     image1.Stretch:=true;

                     // and now to have an automatic zoom using the stretch property
                     // of Timage
                     if (Image1.Width<ScrollBox1.Width) and
                         (Image1.Height<ScrollBox1.Height) then
                          begin
                               Image1.Width:=ScrollBox1.Width;
                               Image1.Height:=ScrollBox1.Height;
                          end;

                     Image1.Canvas.Refresh;
                     Bit.Destroy;
                     bit:=nil;
                end
             else
                 MessageDlg('Unable to open File.', mtError,[mbOk], 0);
        end;
     
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
     map:= CoiImg.Create;
     map.Document.Extension:='IMG';
     map.Document.HeaderExtension:='DOC';
     ComboBox1.ItemIndex:=0;
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
     map.Terminate;
     map:=nil;
end;

procedure TForm1.Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);

  var nx, ny : integer;
      nZ: Single;
      Xstr: String;

begin
     //first calculate the X and Y equivalent in the Idrisi raster image
     if not map.Empty then
        begin
             nX:=1+Trunc(X * ( map.Cols /Image1.Width ));
             nY:=1+Trunc(Y * ( map.Rows /Image1.Height ));

             nZ:= map.pointXY[nx,ny];
             Str(nZ:0:2,Xstr);
             Panel1.Caption := 'X: '+IntToStr(nx)+
                               ';  Y: '+IntToStr(ny)+
                               '; Value:'+Xstr;
        end;
end;




procedure TForm1.Button2Click(Sender: TObject);
var bit: tbitmap;
begin
     if not map.Empty then
        begin
             bit:=TBitMap.Create;
             bit.Width:=map.Cols;
             bit.Height:=map.Rows;
             map.Legend.Palette.Name:= ComboBox1.ItemIndex+1;
             map.Refresh;
             map.Draw(0,0,100,bit.canvas.handle);
             image1.Stretch:=false;
             Image1.width:=bit.Width;
             Image1.Height:=bit.Height;
             Image1.Picture.Graphic := Bit;
             image1.Stretch:=true;

                // and now to have an automatic zoom using the stretch property
                // of Timage
             if (Image1.Width<ScrollBox1.Width) and
                         (Image1.Height<ScrollBox1.Height) then
                          begin
                               Image1.Width:=ScrollBox1.Width;
                               Image1.Height:=ScrollBox1.Height;
                          end;

             Image1.Canvas.Refresh;
             Bit.Destroy;
             bit:=nil;
        end;
end;

procedure TForm1.Button3Click(Sender: TObject);
var step: integer;
    Opened:boolean;
begin
     Button3.Enabled:=false;
     if not map.Empty then
        map.terminate;

     map.Document.Extension:='IMG';
     map.Document.HeaderExtension:='DOC';

     Map.Document.UseHTTPFILE := true;
     Map.Document.HTTPServer :=edit4.text+':'+edit5.text+'@'+edit1.text;
     Map.Document.HTTPServer:=edit1.text;
     Map.Document.Name := edit3.text;
     Map.Document.Directory := edit2.text;

     Panel1.Caption := 'Please Wait...';
     refresh;
     step:=1;
     Opened:=false;
     if map.OpenHeader then
        begin
             if (map.cols>300) or (map.rows>300) then
                begin
                     if map.cols<map.rows then
                        step:=trunc(map.cols/300)
                     else
                         step:=trunc(map.rows/300)

                end;
             Opened:=true;

        end;

     if Opened then
        begin
             if step=1 then
                Opened:=map.Open
             else
                 Opened:=map.OpenSample(Step);

             if opened then
                begin
             Panel1.Caption := 'Host Contacted. Processing Data...';
             refresh;
             Button2Click(self);
             Panel1.Caption := 'File Opened.';
             refresh;
             end
        end;
     if not opened then
         begin
              Panel1.Caption := 'File Not Opened.';
              Image1.Picture.Graphic := nil;
         end;
     Button3.Enabled:=true;
end;





procedure TForm1.Button4Click(Sender: TObject);
var n: integer;
begin
     Panel1.Caption := '';
     refresh;
     Panel1.Caption := 'Host Contacted. Please Wait ...';
     refresh;
     Map.Document.UseHTTPFILE := true;
     if (edit4.text<>'') and (edit5.text<>'') then
        Map.Document.HTTPServer :=edit4.text+':'+edit5.text+'@'+edit1.text
     else
         Map.Document.HTTPServer :=edit1.text;
     map.Document.Directory := Edit2.Text;
     map.Document.GetFiles;

     ListBox1.Items.Clear;
     Memo1.Lines.Clear;
     edit3.text:='';
     Panel1.Caption := 'Data Processed.';
     for n:=0 to map.document.files.Count-1 do
         listbox1.Items.Add(map.document.files.Name[n]);
     if (map.document.files.Count-1)<1 then
              Panel1.Caption := 'No Data Retrieved.';
     refresh;
end;

procedure TForm1.ListBox1DblClick(Sender: TObject);
begin
     edit3.text:=listbox1.Items.Strings[listbox1.ItemIndex];

end;


procedure TForm1.ListBox1Click(Sender: TObject);
var dtxt: Olevariant;
    nlines, n: integer;
begin
     Panel1.Caption := 'Host Contacted. Please Wait ...';
     refresh;

     if listbox1.ItemIndex>-1 then
        begin
             edit3.text:=listbox1.Items.Strings[listbox1.ItemIndex];
             Map.Document.Name := edit3.text;
             dTxt := VarArrayCreate([0, 0], varOleStr );
             Memo1.Lines.Clear;

             nLines:=map.document.GetHeader(Dtxt);
             for n:= 0 to nLines-1 do
                         Memo1.Lines.Add(dtxt[n]);
             dTxt:=unassigned;
        end;
     Panel1.Caption := 'Data Processed.';
     if (nLines-1)<1 then
              Panel1.Caption := 'No Data Retrieved.';
     refresh;
end;


procedure TForm1.ComboBox1Change(Sender: TObject);
begin
     Button2click(self);
end;

end.
