{

===========================================================
TSystemInfo2000X, Version 1.10 1999 (Build 24.07)

(C) Copyright 1999, Baldemaier Florian
Email: Baldemaier.Florian@gmx.net

FREEWARE

===========================================================
Supports:

 Windows 98
 only for Delphi 4

===========================================================
Testet on:

 Intel Pentium II, 300 Mhz and 450 Mhz, Windows 98
 Intel Pentium III, 500 Mhz, Windows 98
 Intel Pentium 200 Mhz, Windows98
 D4 Service Pack 3

===========================================================
Thanks for helping:

 Andreas Windisch (wist@gmx.de)  AW
 Greg Nixon (greg@nzcs.co.nz)    GN

===========================================================

}

unit SystemInfo2000X;

interface

uses Windows, SysUtils, {WinTypes, WinProcs,} Messages, Classes, Graphics,
     Controls, Forms, Dialogs, Registry, DsgnIntf, ExtCtrls, StdCtrls, ShellAPI;

const
  cSystemRes = 0;
  cGDIRes = 1;
  cUSERRes = 2;

  Root1=HKEY_LOCAL_MACHINE;
  Root2=HKEY_CURRENT_USER;

  //Win98 Keys
  WIN98_CPU_Key          ='Hardware\Description\System\CentralProcessor\0';
  WIN98_Display_Key1     ='Config\0001\Display\Settings';
  WIN98_Display_Key2     ='System\CurrentControlSet\Services\Class\Display\0000';
  WIN98_Printer_Key      ='Config\0001\System\CurrentControlSet\Control\Print\Printers';
  WIN98_Bios_Key         ='Enum\Root\*PNP0C01\0000';
  WIN98_Name_Key         ='System\CurrentControlSet\Services\VxD\VNETSUP';
  WIN98_Win_Key          ='SOFTWARE\Microsoft\Windows\CurrentVersion';
  WIN98_DirectX_KEY      ='SOFTWARE\Microsoft\DirectX';
  WIN98_Monitor_Key      ='System\CurrentControlSet\Services\Class\Monitor\0000';
  WIN98_Mouse_Key1       ='System\CurrentControlSet\Services\Class\Mouse\0000';
  WIN98_Mouse_Key2       ='Control Panel\Mouse';
  WIN98_Keyboard_Key     ='System\CurrentControlSet\Services\Class\Keyboard\0000';
  WIN98_Media_Key1       ='System\CurrentControlSet\Services\Class\Media';
  WIN98_Media_Key2       ='System\CurrentControlSet\Control\MediaResources';
  WIN98_Modem_Key        ='System\CurrentControlSet\Services\Class\Modem';
  WIN98_Path_Key         ='SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders';
  WIN98_CoProcessor_Key  ='Enum\Bios\*PNP0C04\0B';
  WIN98_IDE_KEY1         ='System\CurrentControlSet\Services\Class\hdc\0000';
  WIN98_IDE_KEY2         ='System\CurrentControlSet\Services\Class\hdc\0001';
  WIN98_USB_Key          ='System\CurrentControlSet\Services\Class\USB\0000';
  WIN98_SCSI_Key         ='System\CurrentControlSet\Services\Class\SCSIAdapter\0000';
  WIN98_System_Key       ='System\CurrentControlSet\Services\Class\System';
  WIN98_Net_Key1         ='System\CurrentControlSet\Services\Class\Net';
  WIN98_Net_Key2         ='System\CurrentControlSet\Services\Class\NetClient';
  WIN98_Net_Key3         ='System\CurrentControlSet\Services\Class\NetService';
  WIN98_NetProtocol_Key  ='System\CurrentControlSet\Services\Class\NetTrans';
  WIN98_Email_Key        ='Software\Microsoft\Internet Account Manager\Accounts';
  WIN98_Proxy_Key        ='Software\Microsoft\Windows\CurrentVersion\Internet Settings';
  WIN98_UnInstall_Key    ='SOFTWARE\Microsoft\Windows\CurrentVersion\UnInstall';
  WIN98_Fonts_Key        ='SOFTWARE\Microsoft\Windows\CurrentVersion\Fonts';
  WIN98_Direct3D_Key     ='SOFTWARE\Microsoft\Direct3D\Drivers';
  WIN98_DirectMusic_Key  ='SOFTWARE\Microsoft\DirectMusic';
  WIN98_DirectPlay_Key   ='SOFTWARE\Microsoft\DirectPlay\Service Providers';


  //NT Keys (This keys a never used in this component, because i have only 2 keys for NT)
  WINNT_Win_Key          ='SOFTWARE\Microsoft\Windows NT\CurrentVersion';
  WINNT_Bios_Key         ='HARDWARE\DESCRIPTION\System';


type string1 = string[1];
type string30 = string[30];
type

 TAbout=class(TPropertyEditor)
 public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
 end;

 //=== THARDWAREX Classes ==================================================
 	 TMotherboardX=class (TPersistent)
	  private
	     FBiosDate, FBiosName, FBiosVer:string;
	     FBusType, FMachineType:string;
	  published
	     property BiosDate: string read FBiosDate write FBiosDate;
	     property BiosName: string read FBiosName write FBiosName;
	     property BiosVer: string read FBiosVer write FBiosVer;
	     property BusType: string read FBusType write FBusType; // AW - 12/07/1999
	     property MachineType: string read FMachineType write FMachineType; // AW - 12/07/1999
	  end;

	  TControllerX=class (TPersistent)
	  private
	    FControll:TStrings;
	    FSysC:TStrings;
	  published
	    property Controller: TStrings read FControll write FControll; // AW - 14/07/1999
	    property System_Components: TStrings read FSysC write FSysC; // AW - 14/07/1999
	  end;

	  TCpuX=class (TPersistent)
	  private
	     FProcessorSpeed, FNumberOfProcessors, FActiveProcessor, FProcessor, FProcessorVendor, FProcessorMMX:string;
	     FProcessorRevision:string; // AW - 13/07/1999
	     FCoPro:string;
	  published
	     property Processor: string read FProcessor write FProcessor;
	     property ProcessorSpeed: string read FProcessorSpeed write FProcessorSpeed; // AW - 12/07/1999
	     property ProcessorVendor: string read FProcessorVendor write FProcessorVendor;
	     property ProcessorRevision: string read FProcessorRevision write FProcessorRevision; // AW - 13/07/1999
	     property ProcessorMMX: string read FProcessorMMX write FProcessorMMX;
	     property NumberOfProcessors: String read FNumberOfProcessors write FNumberOfProcessors; // AW - 12/07/1999
	     property ActiveProcessor: String read FActiveProcessor write FActiveProcessor; // AW - 12/07/1999
	     property CoProcessor: String read FCoPro write FCoPro;
	  end;

	  TCapabilitiesX=class (TPersistent)
	  private
             FRasterCapabilities    :TStrings;
             FCurveCapabilities     :TStrings;
             FLineCapabilities      :TStrings;
             FPolygonalCapabilities :TStrings;
             FTextCapabilities      :TStrings;
          published
             property RasterCapabilities    :TStrings read FRasterCapabilities;
             property CurveCapabilities     :TStrings read FCurveCapabilities;
             property LineCapabilities      :TStrings read FLineCapabilities;
             property PolygonalCapabilities :TStrings read FPolygonalCapabilities;
             property TextCapabilities      :TStrings read FTextCapabilities;
          end;

	  TDisplayX=class (TPersistent)
	  private
	     FDisplayDrv, FDisplayVXD, FDisplayDPI, FDisplayResolution, FDisplayBpp, FMonitor:string;
	     FModes:TStrings; // AW - 15/07/1999
           FCapabilities:TCapabilitiesX;
	  published
	     property Display_Driver_Description: string read FDisplayDrv write FDisplayDrv;
	     property Display_Driver: string read FDisplayVXD write FDisplayVXD;
	     property DisplayDPI: string read FDisplayDPI write FDisplayDPI;
	     property DisplayResolution: string read FDisplayResolution write FDisplayResolution;
	     property DisplayBpp: string read FDisplayBpp write FDisplayBpp;
	     property Monitor: String read FMonitor write FMonitor;
	     property Modes: TStrings read FModes write FModes; // AW - 15/07/1999
	     property Capabilities: TCapabilitiesX read FCapabilities write FCapabilities;
	  end;

	  TKernelX=class(TPersistent)
	  private
	     FCPUUsage, FNumberOfThreads, FNumberOfDOSVirtualMachines : LongInt;
	  published
	     property CPUUsage : LongInt read FCPUUsage write FCPUUsage; // AW - 13/07/1999
	     property NumberOfThreads : LongInt read FNumberOfThreads write FNumberOfThreads; // AW - 13/07/1999
	     property NumberOfDOSVirtualMachines : LongInt read FNumberOfDOSVirtualMachines write FNumberOfDOSVirtualMachines; // AW - 13/07/1999
	  end;

	  TVFATX=class(TPersistent)
	  private
	     FBytesReadPerSecond, FBytesWrittenPerSecond, FDirty, FReadsPerSecond, FWritesPerSecond : LongInt;
	  published
	     property BytesReadPerSecond : LongInt read FBytesReadPerSecond write FBytesReadPerSecond; // AW - 13/07/1999
	     property BytesWrittenPerSecond : LongInt read FBytesWrittenPerSecond write FBytesWrittenPerSecond; // AW - 13/07/1999
	     property Dirty : LongInt read FDirty write FDirty; // AW - 13/07/1999
	     property ReadsPerSecond : LongInt read FReadsPerSecond write FReadsPerSecond; // AW - 13/07/1999
	     property WritesPerSecond : LongInt read FWritesPerSecond write FWritesPerSecond; // AW - 13/07/1999
	  end;

	  TCOMInterfaceX=class(TPersistent)
	  private
	     FAvailable : Boolean;
	     FBaudrate  : String;
	     FMaxOutputBuffer, FMaxInputBuffer, FPacketLength, FPacketVersion : LongInt;
	  published
	     property Available : Boolean read FAvailable write FAvailable; // AW - 13/07/1999
	     property Baudrate : String read FBaudrate write FBaudrate; // AW - 13/07/1999
	     property MaxOutputBuffer : LongInt read FMaxOutputBuffer write FMaxOutputBuffer; // AW - 13/07/1999
	     property MaxInputBuffer : LongInt read FMaxInputBuffer write FMaxInputBuffer; // AW - 13/07/1999
	     property PacketLength : LongInt read FPacketLength write FPacketLength; // AW - 13/07/1999
	     property PacketVersion : LongInt read FPacketVersion write FPacketVersion; // AW - 13/07/1999
	  end;

	  TInterfacesX=class(TPersistent)
	  private
	     FCOM1, FCOM2, FCOM3, FCOM4 : TCOMInterfaceX;
	     FLPT1Available, FLPT2Available, FLPT3Available, FLPT4Available : Boolean;
	  published
	     property COM1 : TCOMInterfaceX read FCOM1 write FCOM1; // AW - 13/07/1999
	     property COM2 : TCOMInterfaceX read FCOM2 write FCOM2; // AW - 13/07/1999
	     property COM3 : TCOMInterfaceX read FCOM3 write FCOM3; // AW - 13/07/1999
	     property COM4 : TCOMInterfaceX read FCOM4 write FCOM4; // AW - 13/07/1999
	     property LPT1_Available : Boolean read FLPT1Available write FLPT1Available; // AW - 13/07/1999
	     property LPT2_Available : Boolean read FLPT2Available write FLPT2Available; // AW - 13/07/1999
	     property LPT3_Available : Boolean read FLPT3Available write FLPT3Available; // AW - 13/07/1999
	     property LPT4_Available : Boolean read FLPT4Available write FLPT4Available; // AW - 13/07/1999
	  end;
	
	  TMouseX=class(TPersistent)
	  private
	     FAvailable, FButtonsExchanged, FMouseWheelAvailable : Boolean;
	     FMouseSpeed, FDoubleClickSpeed, FDescription : String;
	     FNumberOfButtons : Integer;
	  published
	     property Available   : Boolean read FAvailable write FAvailable; // AW - 13/07/1999
	     property Description : String read FDescription write FDescription; // AW - 13/07/1999
	     property NumberOfButtons : Integer read FNumberOfButtons write FNumberOfButtons; // AW - 13/07/1999
	     property ButtonsExchanged : Boolean read FButtonsExchanged write FButtonsExchanged; // AW - 13/07/1999
	     property MouseWheelAvailable : Boolean read FMouseWheelAvailable write FMouseWheelAvailable; // AW - 13/07/1999
	     property DoubleClickSpeed: String read FDoubleClickSpeed write FDoubleClickSpeed;  
	     property MouseSpeed: String read FMouseSpeed write FMouseSpeed; 
	  end;

	  TKeyBoardX=class(TPersistent)
	  private
	     FKey, FNumberOfFunctionKeys:string;
	  published
	     property Keyboard: String read FKey write FKey;
	     property NumberOfFunctionKeys: String read FNumberOfFunctionKeys write FNumberOfFunctionKeys; // AW - 12/07/1999
	  end;

	  TInputX=class(TPersistent)
	  private
             FKeyBoard: TKeyBoardX;
	     FMouse : TMouseX;
	  published
	     property Mouse: TMouseX read FMouse write FMouse;
	     property KeyBoard: TKeyBoardX read FKeyBoard write FKeyBoard;
	  end;

	  TMultiMediaX=class(TPersistent)
	  private
	     FModem, FMixer:string;
	     FMedia, FMediaControll, FAudioCompress, FImageCompress, FWave, FMidi:TStrings;
	  published
	     property Modem: String read FModem write FModem;
	     property Media: TStrings read FMedia write FMedia;

	     property Media_Controll: TStrings read FMediaControll write FMediaControll;
	     property Audio_Compress: TStrings read FAudioCompress write FAudioCompress;
	     property Image_Compress: TStrings read FImageCompress write FImageCompress;
	     property Wave: TStrings read FWave write FWave;
	     property Midi: TStrings read FMidi write FMidi;
	     property Mixer: String read FMixer write FMixer;
	  end;

	  TPrinterX=class(TPersistent)
	  private
	     FPrinter:string;
	  published
	     property Printer: String read FPrinter write FPrinter;
	  end;

	  TProxyX=class(TPersistent)
	  private
	    FFTP, FGopher, FHTTP, FHTTPS, FSOCKS, FProxyOverride:string;
	  published
	    property FTP: String read FFTP write FFTP; 
	    property GOPHER: String read FGOPHER write FGOPHER; 
	    property HTTP: String read FHTTP write FHTTP;
	    property HTTPS: String read FHTTPS write FHTTPS; 
	    property SOCKS: String read FSOCKS write FSOCKS; 
	    property ProxyOverride: String read FProxyOverride write FProxyOverride;
	  end;

	  TNetX=class(TPersistent)
	  private
	     FNet:Tstrings;
	     FNetP:Tstrings;
	     FEmail:Tstrings;
	     FProxy:TProxyX;
	  published
	     property Net: TStrings read FNet write FNet;
	     property NetProtocol: TStrings read FNetP write FNetP;
	     property Email_Accounts: TStrings read FEmail write FEmail; 
	     property ProxyServer: TProxyX read FProxy write FProxy; 
	  end;

	  THardwareX=class(TPersistent)
	  private
	     MotherB:TMotherboardX;
	     FCpu: TCpuX;
	     FDisplay:TDisplayX;
	     FInput:TInputX;
	     FMulti:TMultiMediaX;
	     FPrinter:TPrinterX;
	     FKernel:TKernelX; // AW - 13/07/1999
	     FVFAT:TVFATX; // AW - 13/07/1999
	     FInt:TInterfacesX; // AW - 14/07/1999
	     FController:TControllerX;
	     FNetwork:TNetX;
	  published
	     property Motherboard: TMotherboardX read MotherB write MotherB; 
	     property CPU: TCpuX read FCpu write FCpu;
	     property Display: TDisplayX read FDisplay write FDisplay; 
	     property Input: TInputX read FInput write FInput; 
	     property MultiMedia: TMultiMediaX read FMulti write FMulti; 
	     property Printer: TPrinterX read FPrinter write FPrinter; 
	     property Kernel: TKernelX read FKernel write FKernel; // AW - 13/07/1999
	     property VFAT: TVFATX read FVFAT write FVFAT; // AW - 13/07/1999
	     property Interfaces: TInterfacesX read FInt write FInt; // AW - 14/07/1999
	     property Controller: TControllerX read FController write FController; // AW - 14/07/1999
	     property Network: TNetX read FNetwork write FNetwork; // AW - 14/07/1999
	  end;
 //=== End THARDWAREX Classes ==============================================


 //=== TMemory Classes =====================================================
	  TMemoryX=class(TPersistent)
    	  private
 	    FTotalV, FTotalP, FTotalS, FAvailP, FAvailS, FAvailV:longint;
	    function GetAvailVirtualMemory:longint;
	    function GetTotalVirtualMemory:longint;
	    function GetTotalPhysMemory:longint;
	    function GetAvailPhysMemory:longint;
	    function GetTotalSwapMemory:longint;
	    function GetAvailSwapMemory:longint;
	    function GetSystemRes: Byte;
	    function GetGDIRes: Byte;
	    function GetUSERRes: Byte;
	    procedure SetNone(Value: Byte);
	 published
	    property ResourcesSystem: Byte read GetSystemRes write SetNone; 
	    property ResourcesGDI: Byte read GetGDIRes write SetNone; 
	    property ResourcesUser: Byte read GetUserRes write SetNone;
	    property PhysicalMemory_Total:longint read FTotalP write FTotalP; 
	    property PhysicalMemory_Available:longint read FAvailP write FAvailP;
	    property VirtualMemory_Total:longint read FTotalV write FTotalV; 
	    property VirtualMemory_Available:longint read FAvailV write FAvailV; 
	    property SwapMemory_Total:longint read FTotalS write FTotalS; 
	    property SwapMemory_Available:longint read FAvailS write FAvailS; 
	 end;
 //=== End TMemory Classes ==================================================


 //=== TSystemX Classes =====================================================
 	 TSystemPathX=class(TPersistent)
	 private
	    FWallPaperDir, FSystemRoot, FCommonFilesDir, FConfigPath:string;
	    FDevicePath, FMediaPath, FOtherDevicePath, FProgramFilesPath:string;
	    FSendTo, FDesktop, FTemplates, FAppData, FStartMenu, FPrograms, FStartup, FFonts:string;
	    FRecent, FFavorites, FNetHood, FPersonal, FCache, FCookies, FHistory: string;
	 published
	    property OtherDevicePath: string read FOtherDevicePath write FOtherDevicePath; 
	    property MediaPath: string read FMediaPath write FMediaPath;
	    property DevicePath: string read FDevicePath write FDevicePath;
	    property ConfigPath: string read FConfigPath write FConfigPath; 
	    property CommonFilesDir: string read FCommonFilesDir write FCommonFilesDir; 
	    property SystemRoot: string read FSystemRoot write FSystemRoot; 
	    property ProgramFilesPath: string read FProgramFilesPath write FProgramFilesPath;
	    property WallPaperDir: string read FWallPaperDir write FWallPaperDir;
	    property Desktop: string read FDesktop write FDesktop;
	    property Templates: string read FTemplates write FTemplates;
	    property AppData: string read FAppData write FAppData;
	    property Start_Menu: string read FStartMenu write FStartMenu;
	    property Programs: string read FPrograms write FPrograms;
	    property StartUp: string read FStartup write FStartup;
	    property Fonts: string read FFonts write FFonts;
	    property SendTo: string read FSendTo write FSendTo;
	    property Recent: string read FRecent write FRecent;
	    property Favorites: string read FFavorites write FFavorites;
	    property NetHood: string read FNetHood write FNethood;
	    property Personal: string read FPersonal write FPersonal;
	    property Cache: string read FCache write FCache;
	    property Cookies: string read FCookies write FCookies;
	    property History: string read FHistory write FHistory;
	 end;

         TFontsX=class(TPersistent)
         private
           FFontname, FFontType, FFontFile : TStrings;
         published
           property Fontname : TStrings read FFontname write FFontname; // AW - 22/07/1999
           property FontType : TStrings read FFontType write FFontType; // AW - 22/07/1999
           property FontFile : TStrings read FFontFile write FFontFile; // AW - 22/07/1999
         end;

         TSystemMetricsX=class(TPersistent)
         private
           FBootInfo, FBorderSizes, FCursorSize, FDefaultIconSize, FDialogFrameSize,
           FSizableFrameSize, FThickFrameSize, FUsableFullScreen, FMenuDropAlignment : String;
           FPenwindowsSupport : Boolean;
         published
           property BootInfo : String read FBootInfo write FBootInfo; // AW - 22/07/1999
           property BorderSizes : String read FBorderSizes write FBorderSizes; // AW - 22/07/1999
           property CursorSize : String read FCursorSize write FCursorSize; // AW - 22/07/1999
           property DefaultIconSize : String read FDefaultIconSize write FDefaultIconSize; // AW - 22/07/1999
           property DialogFrameSize : String read FDialogFrameSize write FDialogFrameSize; // AW - 22/07/1999
           property SizableFrameSize : String read FSizableFrameSize write FSizableFrameSize; // AW - 22/07/1999
           property ThickFrameSize : String read FThickFrameSize write FThickFrameSize; // AW - 22/07/1999
           property UsableFullScreen : String read FUsableFullScreen write FUsableFullScreen; // AW - 22/07/1999
           property PenwindowsSupport : Boolean read FPenwindowsSupport write FPenwindowsSupport; // AW - 22/07/1999
           property MenuDropAlignment : String read FMenuDropAlignment write FMenuDropAlignment; // AW - 22/07/1999
         end;

         TEnvironmentX=class(TPersistent)
         private
            FFonts : TFontsX;
            FSystemMetrics : TSystemMetricsX;
         published
            property Fonts: TFontsX read FFonts write FFonts; // AW - 22/07/1999
            property SystemMetrics: TSystemMetricsX read FSystemMetrics write FSystemMetrics; // AW - 22/07/1999
         end;

         TDirectX=class(TPersistent)
         private
            FDirectX, FDMusic:string;
            FD3D, FDPlay:Tstrings;
         published
	    property Version: String read FDirectX write FDirectX;
	    property DirectMusic: String read FDMusic write FDMusic;
	    property Direct3D: TStrings read FD3D write FD3D;
	    property DirectPlay: TStrings read FDPlay write FDPlay;
         end;

	 TOperatingSystemX=class(TPersistent)
	 private
	    FProductName, FProductType, FProductId, FProductKey, FVersion, FVersionNumber:string;
	    FRuntime : string;
          FEnvironment : TEnvironmentX;
          FUnInstall:TStrings;
          FDirect:TDirectX;
	 published
	    property ProductType: string read FProductType write FProductType;
	    property ProductName: string read FProductName write FProductName;
	    property ProductId: string read FProductId write FProductId;
	    property ProductKey: string read FProductKey write FProductKey;
	    property VersionNumber: string read FVersionNumber write FVersionNumber;
	    property Version: string read FVersion write FVersion;
	    property Runtime: string read FRuntime write FRuntime; // AW - 12/07/1999
          property Environment: TEnvironmentX read FEnvironment write FEnvironment; // AW 22/07/1999
          property DirectX: TDirectX read FDirect write FDirect;
	    property UnInstall: TStrings read FUnInstall write FUnInstall;
	 end;

	 TUserX=class (TPersistent)
	 private
	    FWorkgroup, FComputerName, FComment, FRegisteredOwner, FRegisteredOrganization:string;
	 published
	    property Workgroup: string read FWorkgroup write FWorkgroup;
	    property ComputerName: string read FComputerName write FComputerName;
	    property Comment: string read FComment write FComment;
	    property RegisteredOrganization: string read FRegisteredOrganization write FRegisteredOrganization;
	    property RegisteredOwner: string read FRegisteredOwner write FRegisteredOwner;
	 end;

	 TSystemX=class(TPersistent)
	 private
	    FSP:TSystemPathX;
	    FOS:TOperatingSystemX;
	    FUser:TUserX;
	    FSM_AccessoriesName, FBootCount, FPF_AccessoriesName: string;
	 published
	    property System_Path: TSystemPathX read FSP write FSP;
	    property Operating_System: TOperatingSystemX read FOS write FOS;
	    property User: TUserX read FUser write FUser;
	    property SM_AccessoriesName: string read FSM_AccessoriesName write FSM_AccessoriesName;
	    property PF_AccessoriesName: string read FPF_AccessoriesName write FPF_AccessoriesName;
	    property BootCount: string read FBootCount write FBootCount;
	 end;
 //=== End TSystemX Classes ==================================================


 //=== TDiskInfoX Classes ====================================================
	 TDiskInfoX = class(TPersistent)
	 private
	    FSectorsPerCluster  :DWord;
	    FBytesPerSector     :DWord;
	    FFreeClusters       :DWord;
	    FClusters           :DWord;
	    FDiskFreeSpace      :string;
	    FTotalDiskSpace     :string;
	    FDrive              :string1;
	    FVolumeName         :string;
	    FSerialNumber       :string;
	    FFileSystemType     :string;
	    FDrvTyp:string;
	    function GetDriveTyp :string30;
	    procedure SetDrive(value:string1);
	 published
	    property Drive :string1 read FDrive write setdrive;
	    property SectorsPerCluster :DWord read FSectorsPerCluster write FSectorsPerCluster; 
	    property BytesPerSector :DWord read FBytesPerSector write FBytesPerSector; 
	    property FreeClusters :DWord read FFreeClusters write FFreeClusters; 
	    property Clusters :DWord read FClusters write FClusters;
	    property DiskFreeSpace :string read FDiskFreeSpace write FDiskFreeSpace;
	    property TotalDiskSpace :string read FTotalDiskSpace write FTotalDiskSpace;
	    property DriveType :string read FDrvTyp write FDrvtyp;
	    property VolumeName :string read FVolumeName write FVolumeName;
	    property SerialNumber :string read FSerialNumber write FSerialNumber;
	    property FileSystemType :string read FFileSystemType write FFileSystemType;
	 end;
 //=== End TDiskInfoX Classes =================================================


 //=== TSystemInfo2000X Classes ===============================================
 TSystemInfo2000X = class(TComponent)
 private
    FHard: THardwareX;
    FMem: TMemoryX;
    FAbout: TAbout;
    FDisk: TDiskInfoX;
    FSys: TSystemX;
    Procedure GetWin98_Infos_Refresh;
 public
    Procedure Refresh;
    Procedure InitSystem;
    procedure ReadFontData; // AW - 22/07/1999
    function FileOrDirExists(FileName : String): Boolean;
    function DirExists(Dir : String): Boolean; OverLoad;
    function DirExists(Dir : String; Var Attrs : Integer): Boolean; OverLoad;
    function AddSlash(S : String): String;
    function RemoveSlash(S : String): String;
    function DiskInDrive(Drive: Char): Boolean;
 published
    constructor Create(AOwner:TComponent); override;
    destructor Destroy; override;
    property About: TAbout read FAbout write FAbout;
    property Hardware:THardwareX read Fhard write Fhard;
    property Memory: TMemoryX read FMem write FMem;
    property System: TSystemX read FSys write FSys;
    property DiskInfo: TDiskInfoX read FDisk write FDisk;
 end;
 //=== End TSystemInfo2000X Classes ============================================

var
  LReg: TRegistry;
  hInst16: THandle;
  SR: Pointer;

procedure Register;

{$M+}
{$F+}

implementation

uses About;

Function LoadLibrary16(LibraryName: PChar): THandle; stdcall; external kernel32 index 35;
Function GetProcAddress16(Hinstance: THandle; ProcName: PChar): Pointer; stdcall; external kernel32 index 37;

Procedure FreeLibrary16(HInstance: THandle); stdcall; external kernel32 index 36;
Procedure QT_Thunk; cdecl; external kernel32 name 'QT_Thunk'; // only Win98 no support for WinNT

procedure Register;
begin
  RegisterComponents('SystemInfo',[TSystemInfo2000X]);
  RegisterPropertyEditor(TypeInfo(TAbout), TSystemInfo2000X, 'ABOUT', TAbout);
end;


//= Begin : GN - 14/07/1999 ==================================================================
function CheckNT: Boolean;
var
  aVersion: TOSVersionInfo;
begin
  aVersion.dwOSVersionInfoSize:= SizeOf(aVersion);
  Result:= GetVersionEx(aVersion) and (aVersion.dwPLatformId = VER_PLATFORM_WIN32_NT);
end;
//= END ======================================================================================


//= Begin : AW - 12/07/1999 ==================================================================
function GetCPUSpeed: Double;
const
  DelayTime = 500;
var
  TimerHi, TimerLo: DWORD;
  PriorityClass, Priority: Integer;
begin
  PriorityClass := GetPriorityClass(GetCurrentProcess);
  Priority := GetThreadPriority(GetCurrentThread);

  SetPriorityClass(GetCurrentProcess, REALTIME_PRIORITY_CLASS);
  SetThreadPriority(GetCurrentThread, THREAD_PRIORITY_TIME_CRITICAL);

  Sleep(10);
  asm
    dw 310Fh // rdtsc
    mov TimerLo, eax
    mov TimerHi, edx
  end;
  Sleep(DelayTime);
  asm
    dw 310Fh // rdtsc
    sub eax, TimerLo
    sbb edx, TimerHi
    mov TimerLo, eax
    mov TimerHi, edx
  end;

  SetThreadPriority(GetCurrentThread, Priority);
  SetPriorityClass(GetCurrentProcess, PriorityClass);

  Result := TimerLo / (1000.0 * DelayTime);
end;


//=== Begin: AW - 22/07/1999 ==================================================
procedure TSystemInfo2000X.ReadFontData;
var
  Reg    : TRegistry;
  s,
  S_Name,
  S_Type,
  S_File : TStringList;
  s1     : string;
  i, j   : integer;
  a, b   : integer;
begin
  Reg := TRegistry.Create;
  with Reg do begin
    RootKey := Root1;
    OpenKey(WIN98_FONTS_KEY, false);

    s      := TStringList.Create;
    S_Name := TStringList.Create;
    S_Type := TStringList.Create;
    S_File := TStringList.Create;

    Reg.GetValueNames(s);
    j  := s.count;
    for i := 1 to j do begin
      s1 := s[Pred(i)];
      if (Pos('(', s1) > 0) and (Pos(')', s1) > 0) then begin
         a := Pos(')', s1);
         b := Pos('(', s1);
         S_Type.Add(Copy(s1, Succ(b), Pred(a - b)));
         Delete(s1, b, Succ(a -  b));
      end else
         S_Type.Add('???-Font');

      S_Name.Add(s1);
      S_File.Add(Reg.ReadString(s[Pred(i)]));
    end;

    with Fsys.FOS.Environment.Fonts do begin
      FontName.Assign(S_Name);  // AW - 22/07/1999
      FontType.Assign(S_Type);  // AW - 22/07/1999
      FontFile.Assign(S_File);  // AW - 22/07/1999
    end;

    Free;
    s.Free;
    S_Name.Free;
    S_Type.Free;
    S_File.Free;
  end;
end;
//= END ======================================================================================


//= Baldemaier Florian =======================================================================
constructor TSystemInfo2000X.Create(AOwner:TComponent);
begin
  inherited create(AOwner);
  Refresh;
end;
//============================================================================================

//= Baldemaier Florian =======================================================================
destructor TSystemInfo2000X.Destroy;
begin
  inherited Destroy;
end;
//============================================================================================


//= Baldemaier Florian =======================================================================
procedure TSystemInfo2000X.Refresh;
begin
  Inherited;
  InitSystem;
  If not CheckNT then GetWin98_Infos_Refresh;
  If CheckNT then begin
     Application.MessageBox('Sorry, at this time TSystemInfo2000X supports only Win98. (please read the help or readme file)','Error',0);
     Destroy;
  end;
end;
//============================================================================================


//= Baldemaier Florian =======================================================================
procedure TSystemInfo2000X.InitSystem;
begin
  inherited;

  //Create
  FHard:= THardwareX.Create;
  FMem:= TMemoryX.Create;
  FDisk:=TDiskInfoX.Create;

  FSys:=TSystemX.Create;
  FSys.FSP:=TSystemPathX.create;
  FSys.FOS:=TOperatingSystemX.create;
  FSys.FOS.Environment := TEnvironmentX.Create;    // AW - 22/07/1999
  FSys.FOS.Environment.Fonts := TFontsX.Create;    // AW - 22/07/1999
  FSys.FOS.Environment.SystemMetrics := TSystemMetricsX.Create; // AW - 22/07/1999
  FSys.FUser:=TUserX.create;
  FSys.FOS.DirectX:=TDirectX.Create;

  FSys.FOS.FUnInstall:=TStringlist.create;
  FSys.FOS.DirectX.DirectPlay:=TStringlist.create;

  FHard.MotherB:=TMotherboardX.create;
  FHard.FCpu:=TCpux.create;
  FHard.FDisplay:=TDisplayX.create;
  Fhard.FDisplay.FCapabilities:=TCapabilitiesX.create;
  FHard.FInput:=TInputX.create;
  FHard.FMulti:=TMultiMediaX.create;
  FHard.FController:=TControllerX.create;
  FHard.FPrinter:=TPrinterX.create;

  FHard.Kernel:= TKernelX.Create;                 // AW - 13/07/1999
  FHard.VFAT:= TVFATX.Create;                     // AW - 13/07/1999
  FHard.Interfaces:= TInterfacesX.Create;         // AW - 14/07/1999
  FHard.Interfaces.COM1 := TCOMInterfaceX.Create; // AW - 14/07/1999
  FHard.Interfaces.COM2 := TCOMInterfaceX.Create; // AW - 14/07/1999
  FHard.Interfaces.COM3 := TCOMInterfaceX.Create; // AW - 14/07/1999
  FHard.Interfaces.COM4 := TCOMInterfaceX.Create; // AW - 14/07/1999
  FHard.Input.Mouse := TMouseX.Create;            // AW - 15/07/1999

  FHard.Input.FKeyBoard := TKeyBoardX.Create;
  FHard.FController.System_components:=TStringList.Create;
  FHard.FController.Controller:=TStringList.create;
  FHard.FNetwork:=TNetX.create;
  FHard.Network.Net:=TStringList.create;
  FHard.Network.NetProtocol:=TStringList.create;
  FHard.Network.Email_Accounts:=TStringList.create;
  FHard.Network.FProxy:=TProxyX.create;

  FHard.FMulti.FMixer:='(unavailable)';
  FHard.FMulti.FMediaControll:=TStringList.create;
  FHard.FMulti.FAudioCompress:=TStringList.create;
  FHard.FMulti.FImageCompress:=TStringList.create;
  FHard.FMulti.FWave:=TStringList.create;
  FHard.FMulti.FMidi:=TStringList.create;

  //Init
  with Fhard.Kernel do
  begin
   CPUUsage           :=0;            // AW - 14/07/1999
   NumberOfThreads    :=0;            // AW - 14/07/1999
   NumberOfDOSVirtualMachines :=0;    // AW - 14/07/1999
  end;

  with Fhard.VFAT do
  begin
   BytesReadPerSecond   :=0;          // AW - 14/07/1999
   BytesWrittenPerSecond := 0;        // AW - 14/07/1999
   Dirty                :=0;          // AW - 14/07/1999
   ReadsPerSecond       :=0;          // AW - 14/07/1999
   WritesPerSecond      :=0;          // AW - 14/07/1999
  end;

  with FHard.Interfaces do
  begin
   COM1.Available  :=false;           // AW - 14/07/1999
   COM2.Available  :=false;           // AW - 14/07/1999
   COM3.Available  :=false;           // AW - 14/07/1999
   COM4.Available  :=false;           // AW - 14/07/1999
   LPT1_Available  :=false;           // AW - 14/07/1999
   LPT2_Available  :=false;           // AW - 14/07/1999
   LPT3_Available  :=false;           // AW - 14/07/1999
   LPT4_Available  :=false;           // AW - 14/07/1999
   COM1.Baudrate   :='(unavailable)'; // AW - 14/07/1999
   COM2.Baudrate   :='(unavailable)'; // AW - 14/07/1999
   COM3.Baudrate   :='(unavailable)'; // AW - 14/07/1999
   COM4.Baudrate   :='(unavailable)'; // AW - 14/07/1999
   COM1.MaxOutputBuffer :=0;          // AW - 14/07/1999
   COM2.MaxOutputBuffer :=0;          // AW - 14/07/1999
   COM3.MaxOutputBuffer :=0;          // AW - 14/07/1999
   COM4.MaxOutputBuffer :=0;          // AW - 14/07/1999
   COM1.MaxInputBuffer :=0;           // AW - 14/07/1999
   COM2.MaxInputBuffer :=0;           // AW - 14/07/1999
   COM3.MaxInputBuffer :=0;           // AW - 14/07/1999
   COM4.MaxInputBuffer :=0;           // AW - 14/07/1999
   COM1.PacketLength :=0;             // AW - 14/07/1999
   COM2.PacketLength :=0;             // AW - 14/07/1999
   COM3.PacketLength :=0;             // AW - 14/07/1999
   COM4.PacketLength :=0;             // AW - 14/07/1999
   COM1.PacketVersion :=0;            // AW - 14/07/1999
   COM2.PacketVersion :=0;            // AW - 14/07/1999
   COM3.PacketVersion :=0;            // AW - 14/07/1999
   COM4.PacketVersion :=0;            // AW - 14/07/1999
  end;

  with Fhard.FNetWork.ProxyServer do
  begin
   FFTP                 :='(unavailable)';
   FGOPHER              :='(unavailable)';
   FHTTP                :='(unavailable)';
   FHTTPS               :='(unavailable)';
   FSOCKS               :='(unavailable)';
   FProxyOverride       :='(unavailable)';
  end;

  with Fhard.Motherboard do
  begin
   BiosDate                  :='(unavailable)';
   BiosName                  :='(unavailable)';
   BiosVer                   :='(unavailable)';
   BusType                   :='(unavailable)';     // AW - 12/07/1999
   MachineType               :='(unavailable)';     // AW - 12/07/1999
  end;

  with Fhard.Cpu do
  begin
   Processor                 :='(unavailable)';
   ProcessorSpeed            :='(unavailable)';     // AW - 12/07/1999
   ProcessorVendor           :='(unavailable)';
   ProcessorMMX              :='(unavailable)';
   NumberOfProcessors        :='(unavailable)';     // AW - 12/07/1999
   ActiveProcessor           :='(unavailable)';     // AW - 12/07/1999
   CoProcessor               :='(unavailable)';
  end;

  with Fhard.Display do
  begin
   DisplayDPI                :='(unavailable)';
   DisplayResolution         :='(unavailable)';
   DisplayBPP                :='(unavailable)';
   Display_Driver_Description:='(unavailable)';
   Display_Driver            :='(unavailable)';
   Monitor                   :='(unavailable)';
   Modes                     :=TStringList.Create;  // AW - 15/07/1999
  end;

  with Fhard.Display.Capabilities do begin
   FRasterCapabilities:=tstringlist.create;
   FCurveCapabilities:=tstringlist.create;
   FLineCapabilities:=tstringlist.create;
   FPolygonalCapabilities:=tstringlist.create;
   FTextCapabilities:=tstringlist.create;
  end;

  with Fhard do
  begin
   MultiMedia.Media          := TStringList.Create; // AW - 15/07/1999
   MultiMedia.Modem          :='(unavailable)';
   Printer.FPrinter           :='(unavailable)';
   Input.Mouse.Available     :=false;               // AW - 15/07/1999
   Input.Mouse.Description   :='(unavailable)';     // AW - 15/07/1999
   Input.Mouse.NumberOfButtons :=0;                 // AW - 15/07/1999
   Input.Mouse.ButtonsExchanged :=false;            // AW - 15/07/1999
   Input.Mouse.MouseWheelAvailable := false;        // AW - 15/07/1999
   Input.Mouse.FDoubleClickSpeed:='(unavailable)';
   Input.Mouse.MouseSpeed:='(unavailable)';
   Input.KeyBoard.Keyboard            :='(unavailable)';
   Input.KeyBoard.NumberOfFunctionKeys:='(unavailable)';     // AW - 12/07/1999
  end;

  with Fmem do
  begin
   PhysicalMemory_Total      :=0;
   PhysicalMemory_Available  :=0;
   SwapMemory_Total          :=0;
   SwapMemory_Available      :=0;
   VirtualMemory_Total       :=0;
   VirtualMemory_Available   :=0;
  end;

  with FSys.User do
  begin
   Workgroup                 :='(unavailable)';
   ComputerName              :='(unavailable)';
   Comment                   :='(unavailable)';
   RegisteredOwner           :='(unavailable)';
   RegisteredOrganization    :='(unavailable)';
  end;

  with FSys do
  begin
   BootCount                 :='(unavailable)';
   PF_AccessoriesName        :='(unavailable)';
   SM_AccessoriesName        :='(unavailable)';
  end;

  with Fsys.Fsp do
  begin
    WallPaperDir             :='(unavailable)';
    CommonFilesDir           :='(unavailable)';
    ConfigPath               :='(unavailable)';
    DevicePath               :='(unavailable)';
    MediaPath                :='(unavailable)';
    OtherDevicePath          :='(unavailable)';
    SystemRoot               :='(unavailable)';
    ProgramFilesPath         :='(unavailable)';
    Desktop                  :='(unavailable)';
    Templates                :='(unavailable)';
    AppData                  :='(unavailable)';
    Start_Menu               :='(unavailable)';
    Programs                 :='(unavailable)';
    Startup                  :='(unavailable)';
    Fonts                    :='(unavailable)';
    SendTo                   :='(unavailable)';
    Recent                   :='(unavailable)';
    Favorites                :='(unavailable)';
    NetHood                  :='(unavailable)';
    Personal                 :='(unavailable)';
    Cache                    :='(unavailable)';
    Cookies                  :='(unavailable)';
    History                  :='(unavailable)';
  end;

  with FSys.FOS.FDirect do begin
    Version          :='(unavailable)';
    DirectMusic      :='(unavailable)';
    Direct3D:=TStringlist.create;
  end;

  with Fsys.FOS do
  begin
    ProductName              :='(unavailable)';
    ProductType              :='(unavailable)';
    ProductId                :='(unavailable)';
    ProductKey               :='(unavailable)';
    Version                  :='(unavailable)';
    VersionNumber            :='(unavailable)';
    Runtime                  :='(unavailable)';     // AW - 12/07/1999
    with Environment do begin
       with Fonts do begin
          FontName := TStringList.Create;  // AW - 22/07/1999
          FontType := TStringList.Create;  // AW - 22/07/1999
          FontFile := TStringList.Create;  // AW - 22/07/1999
       end;
       with SystemMetrics do begin
          BootInfo          :='(unavailable)';     // AW - 22/07/1999
          BorderSizes       :='(unavailable)';     // AW - 22/07/1999
          CursorSize        :='(unavailable)';     // AW - 22/07/1999
          DefaultIconSize   :='(unavailable)';     // AW - 22/07/1999
          DialogFrameSize   :='(unavailable)';     // AW - 22/07/1999
          SizableFrameSize  :='(unavailable)';     // AW - 22/07/1999
          ThickFrameSize    :='(unavailable)';     // AW - 22/07/1999
          UsableFullScreen  :='(unavailable)';     // AW - 22/07/1999
          PenwindowsSupport :=false;               // AW - 22/07/1999
          MenuDropAlignment :='(unavailable)';     // AW - 22/07/1999
       end;
    end;
  end;
end;
//============================================================================================


//= Baldemaier Florian =======================================================================
function GetFreeSysRes(SysRes: Word): Word;
var
  Thunks: Array[0..$20] of Word;
begin
  Thunks[0] := hInst16;
  hInst16 := LoadLibrary16('user.exe');
  if hInst16 < 32 then
    raise Exception.Create('Can''t load USER.EXE!');
  FreeLibrary16(hInst16);
  SR := GetProcAddress16(hInst16, 'GetFreeSystemResources');
  if SR = nil then
    raise Exception.Create('Can''t get address of GetFreeSystemResources!');
  asm
    push SysRes
    mov edx, SR
    call QT_Thunk
    mov Result, ax
  end;
end;
//============================================================================================


//= Baldemaier Florian =======================================================================
function TMemoryX.GetSystemRes: Byte;
begin
  Result := GetFreeSysRes(cSystemRes);
end;
//============================================================================================


//= Baldemaier Florian =======================================================================
function TMemoryX.GetGDIRes: Byte;
begin
  Result := GetFreeSysRes(cGDIRes);
end;
//============================================================================================


//= Baldemaier Florian =======================================================================
function TMemoryX.GetUSERRes: Byte;
begin
  Result := GetFreeSysRes(cUSERRes);
end;
//============================================================================================


//= Baldemaier Florian =======================================================================
procedure TMemoryX.SetNone(Value: Byte);
begin
end;
//============================================================================================


//= Baldemaier Florian =======================================================================
function TMemoryX.GetTotalPhysMemory :longint;
var
  MemInfo : TMemoryStatus;
begin
  MemInfo.dwLength := Sizeof (MemInfo);
  GlobalMemoryStatus (MemInfo);
  result:=MemInfo.dwTotalPhys div 1024;
end;
//============================================================================================


//= Baldemaier Florian =======================================================================
function TMemoryX.GetAvailPhysMemory :longint;
var
  MemInfo : TMemoryStatus;
begin
  MemInfo.dwLength := Sizeof (MemInfo);
  GlobalMemoryStatus (MemInfo);
  result:=MemInfo.dwAvailPhys div 1024;
end;
//============================================================================================


//= Baldemaier Florian =======================================================================
function TMemoryX.GetTotalSwapMemory :longint;
var
  MemInfo : TMemoryStatus;
begin
  MemInfo.dwLength := Sizeof (MemInfo);
  GlobalMemoryStatus (MemInfo);
  result:=MemInfo.dwTotalPageFile div 1024;
end;
//============================================================================================


//= Baldemaier Florian =======================================================================
function TMemoryX.GetAvailSwapMemory :longint;
var
  MemInfo : TMemoryStatus;
begin
  MemInfo.dwLength := Sizeof (MemInfo);
  GlobalMemoryStatus (MemInfo);
  result:=MemInfo.dwAvailPageFile div 1024;
end;
//============================================================================================


//= Baldemaier Florian =======================================================================
function TMemoryX.GetTotalVirtualMemory :longint;
var
  MemInfo : TMemoryStatus;
begin
  MemInfo.dwLength := Sizeof (MemInfo);
  GlobalMemoryStatus (MemInfo);
  result:=MemInfo.dwTotalVirtual div 1024;
end;
//============================================================================================


//= Baldemaier Florian =======================================================================
function TMemoryX.GetAvailVirtualMemory :longint;
var
  MemInfo : TMemoryStatus;
begin
  MemInfo.dwLength := Sizeof (MemInfo);
  GlobalMemoryStatus (MemInfo);
  result:=MemInfo.dwAvailVirtual div 1024;
end;
//============================================================================================


//= Baldemaier Florian =======================================================================
procedure TAbout.Edit;
begin
 with TAboutForm.Create(Application) do
  try
    ShowModal;
  finally
    Free;
  end;
end;
//============================================================================================


//= Baldemaier Florian =======================================================================
function TAbout.GetAttributes: TPropertyAttributes;
begin
    Result := [paMultiSelect, paDialog, paReadOnly];
end;

function TAbout.GetValue: string;
begin
    Result := '(About)';
end;
//============================================================================================


//= Baldemaier Florian =======================================================================
procedure TDiskInfoX.SetDrive(value:string1);
var fulldrive  :string[3];
    tmp_drive         :array[0..2] of char;
    Tmp_SectorsPerCluster,
    Tmp_BytesPerSector,
    Tmp_FreeClusters,
    Tmp_Clusters      :DWORD;
    VolName           :array[0..255] of Char;
    SerialNumber      :DWORD;
    MaxCLength        :DWORD;
    FileSysFlag       :DWORD;
    FileSysName       :array[0..255] of Char;
    Tmp_1:LONGLONG;
    Tmp_2:LONGLONG;
    Tmp_3:LONGLONG;
begin
  fdrive:=value;
  fulldrive:=value + ':\';
  strpcopy(tmp_drive,fulldrive);

  DriveType:=GetDriveTyp;

  GetVolumeInformation(tmp_drive, VolName, 255, @SerialNumber, MaxCLength,
     FileSysFlag, FileSysName, 255);

  FVolumeName:=VolName;
  FSerialNumber:=IntToHex(SerialNumber,8);
  FFileSystemType:=FileSysName;

  if GetDiskFreeSpace(tmp_drive,Tmp_SectorsPerCluster,Tmp_BytesPerSector,
                       Tmp_FreeClusters,Tmp_Clusters) then
  begin
     FSectorsPerCluster:=Tmp_SectorsPerCluster;
     FBytesPerSector:=Tmp_BytesPerSector;
     FFreeClusters:=Tmp_FreeClusters;
     FClusters:=Tmp_Clusters;
  end;

  if uppercase(FileSysName)='FAT32' then
  begin
      GetDiskFreeSpaceEx(Tmp_drive, TMP_1, TMP_2, @TMP_3);
      if TMP_1>1048576 then FDiskFreeSpace:=inttostr(TMP_1 div 1048576)+' MB';
      if TMP_2>1048576 then FTotalDiskSpace:=inttostr(TMP_2 div 1048576)+' MB';
      if TMP_1<1048576 then FDiskFreeSpace:=inttostr(TMP_1)+' MB';
      if TMP_2<1048576 then FTotalDiskSpace:=inttostr(TMP_2)+' MB';
  end;
  if uppercase(FileSysName)<>'FAT32' then
  begin
     FDiskFreeSpace:=inttostr((Tmp_FreeClusters*Tmp_BytesPerSector*Tmp_SectorsPerCluster) div 1048576)+' MB';
     FTotalDiskSpace:=inttostr((Tmp_Clusters*Tmp_BytesPerSector*Tmp_SectorsPerCluster) div 1048576)+' MB';
  end;

end;
//============================================================================================


//= Baldemaier Florian =======================================================================
Function TSystemInfo2000X.FileOrDirExists(FileName : String) : Boolean;
Var SRec : TSearchRec;
Begin
  Result := FindFirst(FileName, faAnyFile, SRec) = 0;
  SysUtils.FindCLose(SRec);
End;
//============================================================================================


//= Baldemaier Florian =======================================================================
Function TSystemInfo2000X.DirExists(Dir : String; Var Attrs : Integer) : Boolean;
Var SRec : TSearchRec;
Begin
  Result := ((Length(Dir) <= 3) And (Length(Dir) >= 2))And (Dir[2] = ':');
  IF Result Then
   Attrs := 0
  Else
  Begin
    IF FindFirst(Dir, faAnyFile, SRec) = 0 Then
    Begin
      Result := (Srec.Attr and faDirectory <> 0);
      Attrs := Srec.Attr;
    End;
    SysUtils.FindCLose(SRec);
  End;
End;
//============================================================================================


//= Baldemaier Florian =======================================================================
Function TSystemInfo2000X.DirExists(Dir : String) : Boolean;
Var Dummy : Integer;
Begin
  Result := DirExists(Dir, Dummy);
End;
//============================================================================================


//= Baldemaier Florian =======================================================================
Function TSystemInfo2000X.AddSlash(S : String) : String;
Begin
  IF (Length(S) > 0) And (S[Length(s)] <> '\') Then
  Result := S + '\'
  else
  Result := S;
End;
//============================================================================================


//= Baldemaier Florian =======================================================================
Function TSystemInfo2000X.RemoveSlash(S : String) : String;
Begin
  IF (Length(S) > 0) And (S[Length(s)] = '\') Then
  Result := Copy(S, 1, Pred(Length(S)))
  else
  Result := S;
End;
//============================================================================================


//= Baldemaier Florian =======================================================================
function TSystemInfo2000X.DiskInDrive(Drive: char): Boolean;
var  ErrorMode: word;
begin
  Drive := UpCase(Drive);
  if not (Drive in ['A'..'Z']) then
    raise EConvertError.Create('Not a valid drive ID');
  ErrorMode := SetErrorMode(SEM_FailCriticalErrors or SEM_NOOPENFILEERRORBOX);
  try
    if DiskSize(Ord(Drive) - $40) = -1 then
    Result := False
    else
      Result := True;
  finally
    SetErrorMode(ErrorMode);
  end;
end;
//============================================================================================


//= Baldemaier Florian =======================================================================
function TDiskInfoX.GetDriveTyp :string30;
var fulldrive  :string[3];
    tmp_drive         :array[0..2] of char;
begin
  fulldrive:=fdrive + ':\';
  strpcopy(tmp_drive,fulldrive);
  case GetDriveType(tmp_drive) of
    DRIVE_UNKNOWN     :result:='No Type Information';
    DRIVE_NO_ROOT_DIR :result:='Root Directory does not exist';
    DRIVE_REMOVABLE   :result:='Removable';
    DRIVE_FIXED       :result:='Fixed';
    DRIVE_REMOTE      :result:='Remote';
    DRIVE_CDROM       :result:='CDROM';
    DRIVE_RAMDISK     :result:='RamDisk';
  end;
end;
//============================================================================================


//= Baldemaier Florian =======================================================================
procedure TSystemInfo2000X.GetWin98_Infos_Refresh;
  // Begin : AW - 14/07/1999
  procedure SetCOMProps(Cmp : TCOMInterfaceX; CP : TCOMMPROP);
  var
     s : String;
  begin
     case CP.dwMaxBaud of
       BAUD_075    : s := '75 bps';
       BAUD_110    : s := '110 bps';
       BAUD_134_5  : s := '134,5 bps';
       BAUD_150    : s := '150 bps';
       BAUD_300    : s := '300 bps';
       BAUD_600    : s := '600 bps';
       BAUD_1200   : s := '1200 bps';
       BAUD_1800   : s := '1800 bps';
       BAUD_2400   : s := '2400 bps';
       BAUD_4800   : s := '4800 bps';
       BAUD_7200   : s := '7200 bps';
       BAUD_9600   : s := '9600 bps';
       BAUD_14400  : s := '14400 bps';
       BAUD_19200  : s := '19200 bps';
       BAUD_38400  : s := '38400 bps';
       BAUD_56K    : s := '56K bps';
       BAUD_57600  : s := '57600 bps';
       BAUD_115200 : s := '115200 bps';
       BAUD_128K   : s := '128K bps';
       BAUD_USER   : s := 'user-specified';
       else          s := 'unknown/not defined: ' + IntToStr(CP.dwMaxBaud);
     end;
     Cmp.Baudrate := s;
     Cmp.MaxOutputBuffer := CP.dwMaxTxQueue;
     Cmp.MaxInputBuffer := CP.dwMaxRxQueue;
     Cmp.PacketLength := CP.wPacketLength;
     Cmp.PacketVersion := CP.wPacketVersion;
  end;
  // End : AW - 12/07/1999
var
  SI : TSystemInfo; // AW - 12/07/1999
  lData : Longint; // AW - 13/07/1999
  COMM  : pChar; // AW - 14/07/1999
  comms : string; // AW - 14/07/1999
  h     : THandle; // AW - 14/07/1999
  c     : integer; // AW - 14/07/1999
  CP    : TCOMMPROP; // AW - 14/07/1999
  CC    : TCOMMCONFIG; // AW - 14/07/1999
  devmode : TDEVMODE; // AW - 15/07/1999
  k, i  : integer;
  EmailTemp, Temp, Temp2, Provider, DrvDate, VXD, AccountName, r:string;
  POP3Server, POP3User, SMTPServer, SMTPName, SMTPEmailAdress, ProxyTemp:string;
  Emails, UnInstalllist, D3DTemp, DPlayTemp, MediaTemp:TStrings;
  dc : HDC; // Instead of TForm

Label
 2;

begin

  //Init

  LReg:= TRegistry.Create;
  LReg.RootKey := Root1;
  LReg.LazyWrite := false;

  Emails:=TStringlist.create;
  UnInstalllist:=TStringlist.create;
  D3DTemp:=TStringlist.create;
  DPlayTemp:=TStringlist.create;
  MediaTemp:=TStringlist.create;
  dc := GetDC(0);   // Device-Caps - instead of line before

  //Reset
  FHard.Controller.Controller.clear;
  FHard.Display.Modes.clear;
  FHard.MultiMedia.Media.Clear;
  FHard.Controller.System_Components.Clear;
  FHard.Network.Net.Clear;
  FHard.Network.NetProtocol.Clear;
  FHard.Network.Email_Accounts.Clear;
  FHard.MultiMedia.Media_Controll.Clear;
  FHard.MultiMedia.Audio_Compress.Clear;
  FHard.MultiMedia.Image_Compress.Clear;
  FHard.MultiMedia.Wave.Clear;
  FHard.MultiMedia.Midi.Clear;
  FSys.FOS.FDirect.Direct3D.Clear;
  D3DTemp.Clear;
  UnInstallList.Clear;
  Emails.Clear;
  DPlayTemp.Clear;


  //Hardware
  with Lreg do begin
   with Fhard.Motherboard do begin
     OpenKey(WIN98_Bios_Key, False);
     if ReadString('BIOSDate')<>'' then          BiosDate        := ReadString('BIOSDate');
     if ReadString('BIOSName')<>'' then          BiosName        := ReadString('BIOSName');
     if ReadString('BIOSVersion')<>'' then       BiosVer         := ReadString('BIOSVersion');
     if ReadString('BusType')<>'' then           BusType         := ReadString('BusType');     // AW - 12/07/1999
     if ReadString('MachineType')<>'' then       MachineType     := ReadString('MachineType'); // AW - 12/07/1999
     CloseKey;
   end;
   with FHard.CPU do begin
     OpenKey(WIN98_Cpu_Key, False);
     if ReadString('Identifier')<>'' then         Processor       := ReadString('Identifier');
     if ReadString('VendorIdentifier')<>'' then   ProcessorVendor := ReadString('VendorIdentifier');
     if ReadString('MMXIdentifier')<>'' then      ProcessorMMX    := ReadString('MMXIdentifier');
     CloseKey;

     OpenKey(WIN98_CoProcessor_Key, False);
     if ReadString('DeviceDesc')<>'' then         CoProcessor     := ReadString('DeviceDesc');
     CloseKey;

     ProcessorSpeed := Format('%f MHz', [GetCPUSpeed]);        // AW - 12/07/1999
     GetSystemInfo(SI);                                        // AW - 12/07/1999
     NumberOfProcessors := IntToStr(SI.dwNumberOfProcessors);  // AW - 12/07/1999
     ActiveProcessor    := IntToStr(SI.dwActiveProcessorMask); // AW - 12/07/1999
     ProcessorRevision  := IntToStr(SI.wProcessorRevision);    // AW - 13/07/1999

   end;
   with FHard.Controller do begin
     OpenKey(WIN98_IDE_Key2, False);
     if ReadString('PortDriver')<>'' then  Temp2:=ReadString('PortDriver') else Temp2:='no portdriver';
     CloseKey;

     OpenKey(WIN98_IDE_Key1, False);
     if ReadString('DriverDate')<>'' then  Temp:='('+ReadString('DriverDate')+', ' else temp:='(no Date, ';
     if ReadString('DriverDesc')<>'' then  Controller.Add('IDE Controller: '+temp+temp2+')');
     CloseKey;

     OpenKey(WIN98_SCSI_Key, False);
     if ReadString('DriverDate')<>'' then temp:='('+ReadString('DriverDate')+', ' else temp:='(no Date, ';
     if ReadString('PortDriver')<>'' then temp:=temp+ReadString('PortDriver')+')' else temp:=temp+', no portdriver)';
     if ReadString('DriverDesc')<>'' then Controller.Add('SCSI Controller: '+ReadString('DriverDesc')+temp);
     CloseKey;

     OpenKey(WIN98_USB_Key, False);
     if ReadString('DriverDate')<>'' then temp:='('+ReadString('DriverDate')+', ' else temp:='(no Date, ';
     if ReadString('NTMPDriver')<>'' then temp:=temp+ReadString('NTMPDriver')+')' else temp:=temp+', no portdriver)';
     if ReadString('DriverDesc')<>'' then Controller.Add('USB Controller: '+ReadString('DriverDesc')+temp);
     CloseKey;
   end;
   with Fhard.Display do begin
    OpenKey(WIN98_Display_Key1, False);
    if ReadString('DPILogicalX')<>'' then          DisplayDPI       := ReadString('DPILogicalX');
    if ReadString('Resolution')<>'' then           DisplayResolution:= ReadString('Resolution');
    if ReadString('BitsPerPixel')<>'' then         DisplayBPP       := ReadString('BitsPerPixel');
    CloseKey;

    OpenKey(WIN98_Display_Key2, False);
    if ReadString('DriverDesc')<>'' then           Display_Driver_Description:= ReadString('DriverDesc');
    CloseKey;

    OpenKey(WIN98_Display_Key2+'\Default', False);
    if ReadString('Drv')<>'' then                  Display_Driver:= ReadString('Drv');
    CloseKey;

    OpenKey(WIN98_Monitor_Key, False);
    if ReadString('DriverDesc')<>'' then      Monitor:= ReadString('DriverDesc');
    CloseKey;

    devmode.dmSize        := SizeOf(TDEVMODE);
    devmode.dmDriverExtra := 0;
    for i := 0 to 25 do
      if EnumDisplaySettings(nil, i, devmode) then
        Modes.Add(IntToStr(devmode.dmPelsWidth) + ' x ' + IntToStr(devmode.dmPelsHeight) + ' - ' + IntToStr(devmode.dmBitsPerPel) + 'Bit');
   end;

   for i:= 0 to 10 do
   begin
      r:=inttostr(i);
      if i<10 then r:='0'+r;
      if KeyExists(WIN98_Media_key1+'\00'+r) then
      begin
        OpenKey(WIN98_Media_key1+'\00'+r, False);
        if ReadString('DriverDesc')<>'' then
        begin
          FHard.MultiMedia.Media.Add(ReadString('DriverDesc'));
        end;
        CloseKey;
      end;
   end;
   if Fhard.MultiMedia.Media.count=0 then FHard.MultiMedia.Media.Add('(unavailable)');

   for i:=0 to 30 do
   begin
     r:=inttostr(i);
     if i<10 then r:='0'+r;
      if KeyExists(WIN98_System_key+'\00'+r) then
      begin
        OpenKey(WIN98_System_key+'\00'+r, False);
        if ReadString('DriverDesc')<>'' then
        begin
          Provider:=ReadString('ProviderName');
          DrvDate:=ReadString('DriverDate');
          VXD:=ReadString('DevLoader');
          if Provider='' then Provider:='no Providername';
          if DrvDate='' then DrvDate:='??.??.????';
          if VXD='' then VXD:='no VXD';
          FHard.Controller.System_components.Add(ReadString('DriverDesc')+'  ('+Provider+', '+DrvDate+', '+VXD+')');
        end;
        CloseKey;
      end;
   end;
   if Fhard.Controller.System_Components.count=0 then FHard.Controller.System_Components.Add('(unavailable)');

   for i:=0 to 30 do
   begin
     r:=inttostr(i);
     if i<10 then r:='0'+r;
      if KeyExists(WIN98_Net_Key1+'\00'+r) then
      begin
        OpenKey(WIN98_Net_Key1+'\00'+r, False);
        if ReadString('DriverDesc')<>'' then
        begin
          Provider:=ReadString('ProviderName');
          DrvDate:=ReadString('DriverDate');
          VXD:=ReadString('DeviceVxds');
          if Provider='' then Provider:='no Providername';
          if DrvDate='' then DrvDate:='??.??.????';
          if VXD='' then VXD:='no VXD';
          FHard.Network.Net.Add(ReadString('DriverDesc')+'  ('+Provider+', '+DrvDate+', '+VXD+')');
        end;
         CloseKey;
     end;
   end;

   for i:=0 to 30 do
   begin
     r:=inttostr(i);
     if i<10 then r:='0'+r;
      if KeyExists(WIN98_Net_Key2+'\00'+r) then
      begin
        OpenKey(WIN98_Net_Key2+'\00'+r, False);
        if ReadString('DriverDesc')<>'' then
        begin
          Provider:=ReadString('ProviderName');
          DrvDate:=ReadString('DriverDate');
          VXD:=ReadString('DeviceVxds');
          if Provider='' then Provider:='no Providername';
          if DrvDate='' then DrvDate:='??.??.????';
          if VXD='' then VXD:='no VXD';
          FHard.Network.Net.Add(ReadString('DriverDesc')+'  ('+Provider+', '+DrvDate+', '+VXD+')');
        end;
        CloseKey;
      end;
   end;

   for i:=0 to 30 do
   begin
     r:=inttostr(i);
     if i<10 then r:='0'+r;
      if KeyExists(WIN98_Net_Key3+'\00'+r) then
      begin
        OpenKey(WIN98_Net_Key3+'\00'+r, False);
        if ReadString('DriverDesc')<>'' then
        begin
          Provider:=ReadString('ProviderName');
          DrvDate:=ReadString('DriverDate');
          VXD:=ReadString('DeviceVxds');
          if Provider='' then Provider:='no Providername';
          if DrvDate='' then DrvDate:='??.??.????';
          if VXD='' then VXD:='no VXD';
          FHard.Network.Net.Add(ReadString('DriverDesc')+'  ('+Provider+', '+DrvDate+', '+VXD+')');
         end;
        CloseKey;
      end;
   end;
   if Fhard.NetWork.Net.count=0 then FHard.NetWork.Net.Add('(unavailable)');

   for i:=0 to 30 do
   begin
     r:=inttostr(i);
     if i<10 then r:='0'+r;
      if KeyExists(WIN98_NetProtocol_key+'\00'+r) then
      begin
        OpenKey(WIN98_NetProtocol_key+'\00'+r, False);
        if ReadString('DriverDesc')<>'' then
        begin
          Provider:=ReadString('ProviderName');
          DrvDate:=ReadString('DriverDate');
          VXD:=ReadString('DeviceVxds');
          if Provider='' then Provider:='no Providername';
          if DrvDate='' then DrvDate:='??.??.????';
          if VXD='' then VXD:='no VXD';
           FHard.Network.NetProtocol.Add(ReadString('DriverDesc')+'  ('+Provider+', '+DrvDate+', '+VXD+')');
        end;
        CloseKey;
      end;
   end;
   if Fhard.NetWork.NetProtocol.count=0 then FHard.NetWork.NetProtocol.Add('(unavailable)');

   RootKey := Root2;
   LazyWrite := false;

   OpenKey(WIN98_Email_Key,false);
   GetKeyNames(Emails);
   CloseKey;
   if Emails.Count>0 then begin
 
   for i:=0 to Emails.Count-1 do begin
     OpenKey(WIN98_Email_Key+'\'+Emails.Strings[i], False);
     AccountName:=ReadString('Account Name');
     POP3Server:=ReadString('POP3 Server');
     POP3User:=ReadString('POP3 User Name');
     SMTPServer:=ReadString('SMTP Server');
     SMTPName:=ReadString('SMTP Display Name');
     SMTPEmailAdress:=ReadString('SMTP Email Address');
     if AccountName='' then AccountName:='no Account Name';
     if POP3User='' then POP3User:='no POP3 User';
     if SMTPName='' then SMTPName:='no SMTP Display Name';
     if SMTPEmailAdress='' then SMTPEmailAdress:='no SMTP Email Adress';

     EmailTemp:=AccountName+'; '+POP3Server+'; '+POP3User+'; '+SMTPServer+'; '+SMTPName+'; '+SMTPEmailAdress;
     if POP3Server<>'' then begin
      if SMTPServer<>'' then begin
       FHard.Network.Email_Accounts.Add(EmailTemp);
      end;
     end;
     CloseKey;
    end;
   end;
   if Fhard.NetWork.Email_Accounts.count=0 then FHard.NetWork.Email_Accounts.Add('(unavailable)');

   OpenKey(WIN98_Proxy_Key,false);
   if ReadString('ProxyOverride')<>'' then FHard.Network.ProxyServer.ProxyOverride:=ReadString('ProxyOverride');
   if ReadString('ProxyServer')<>'' then ProxyTemp:=ReadString('ProxyServer')+';';
   if ProxyTemp<>'' then begin
    for i:=0 to length(ProxyTemp) do
    begin
     if uppercase(copy(ProxyTemp,i,4))='FTP=' then begin
       for k:=i to length(ProxyTemp) do
       begin
        if copy(ProxyTemp,k,1)=';' then begin
         FHard.Network.ProxyServer.FTP:=copy(ProxyTemp,4+i,k-4-i);
         goto 2;
        end;
       end;
     end;
     if uppercase(copy(ProxyTemp,i,7))='GOPHER=' then begin
       for k:=i to length(ProxyTemp) do
       begin
        if copy(ProxyTemp,k,1)=';' then begin
         FHard.Network.ProxyServer.GOPHER:=copy(ProxyTemp,7+i,k-7-i);
         goto 2;
        end;
      end;
     end;
     if uppercase(copy(ProxyTemp,i,5))='HTTP=' then begin
       for k:=i to length(ProxyTemp) do
       begin
        if copy(ProxyTemp,k,1)=';' then begin
         FHard.Network.ProxyServer.HTTP:=copy(ProxyTemp,5+i,k-5-i);
         goto 2;
        end;
       end;
     end;
     if uppercase(copy(ProxyTemp,i,6))='HTTPS=' then begin
       for k:=i to length(ProxyTemp) do
       begin
        if copy(ProxyTemp,k,1)=';' then begin
         FHard.Network.ProxyServer.HTTPS:=copy(ProxyTemp,6+i,k-6-i);
         goto 2;
        end;
       end;
     end;
     if uppercase(copy(ProxyTemp,i,6))='SOCKS=' then
     begin
        for k:=i to length(ProxyTemp) do
        begin
         if copy(ProxyTemp,k,1)=';' then begin
          FHard.Network.ProxyServer.SOCKS:=copy(ProxyTemp,6+i,k-6-i);
         goto 2;
        end;
       end;
     end; 

2:
    end;
   end;

   CloseKey;
   RootKey := Root1;
   LazyWrite := false;

   OpenKey(WIN98_Modem_Key+'\0000', False);
   if ReadString('DriverDesc')<>'' then FHard.MultiMedia.Modem:=ReadString('DriverDesc');
   CloseKey;

   OpenKey(WIN98_Printer_Key, False);
   if ReadString('Default')<>'' then    FHard.Printer.Printer:= ReadString('Default');
   CloseKey;


   //=== Begin: AW - 14/07/1999 =================================================
   Comms := 'COMX';
   COMM  := StrAlloc(5);

   // COM1-4
   with FHard.Interfaces do begin
    for c := Ord('1') to Ord('4') do begin
     comms[4] := Chr(c);
     StrPCopy(COMM, comms);
     CC.dwSize := SizeOf(TCOMMCONFIG);
     GetDefaultCommConfig(COMM, CC, CC.dwSize);
     h := CreateFile(COMM, GENERIC_READ or GENERIC_WRITE, 0, nil, OPEN_EXISTING, 0, 0);
     if h <> INVALID_HANDLE_VALUE then begin
       case c of
          Ord('1') : COM1.Available := true;
          Ord('2') : COM2.Available := true;
          Ord('3') : COM3.Available := true;
          Ord('4') : COM4.Available := true;
       end;
       GetCommProperties(h, CP);
       case c of
          Ord('1') : SetCOMProps(COM1, CP);
          Ord('2') : SetCOMProps(COM2, CP);
          Ord('3') : SetCOMProps(COM3, CP);
          Ord('4') : SetCOMProps(COM4, CP);
       end;
     end else begin
       case c of
          Ord('1') : COM1.Available := false;
          Ord('2') : COM2.Available := false;
          Ord('3') : COM3.Available := false;
          Ord('4') : COM4.Available := false;
       end;
     end;
     CloseHandle(h);
    end;

    //LPT1-4
    comms := 'LPTX';
    for c := Ord('1') to ORD('4') do begin
     comms[4] := Chr(c);
     StrPCopy(COMM, comms);
     h := CreateFile(COMM, GENERIC_READ OR GENERIC_WRITE, 0, nil, OPEN_EXISTING, 0, 0);
     if h = INVALID_HANDLE_VALUE then begin
       case c of
          Ord('1') : LPT1_Available := false;
          Ord('2') : LPT2_Available := false;
          Ord('3') : LPT3_Available := false;
          Ord('4') : LPT4_Available := false;
       end;
     end else begin
       case c of
          Ord('1') : LPT1_Available := true;
          Ord('2') : LPT2_Available := true;
          Ord('3') : LPT3_Available := true;
          Ord('4') : LPT4_Available := true;
       end;
     end;
     CloseHandle(h);
    end;
    StrDispose(COMM);
   end;
   //=== End: AW - 14/07/1999 ===================================================


   //=== Begin: AW - 13/07/1999 =================================================
   with TRegistry.Create do
      try
         RootKey := HKEY_DYN_DATA;
         OpenKey('PerfStats\StatData', false);

         ReadBinaryData('KERNEL\CPUUsage', lData, GetDataSize('KERNEL\CPUUsage'));
         FHard.Kernel.CPUUsage := lData;

         ReadBinaryData('KERNEL\Threads', lData, GetDataSize('KERNEL\Threads'));
         FHard.Kernel.NumberOfThreads := lData;

         ReadBinaryData('KERNEL\VMs', lData, GetDataSize('KERNEL\VMs'));
         FHard.Kernel.NumberOfDOSVirtualMachines := lData;

         ReadBinaryData('VFat\BReadsSec', lData, GetDataSize('VFat\BReadsSec'));
         FHard.VFAT.BytesReadPerSecond := lData div 1024;

         ReadBinaryData('VFat\BWritesSec', lData, GetDataSize('VFat\BWritesSec'));
         FHard.VFAT.BytesWrittenPerSecond := lData div 1024;

         ReadBinaryData('VFat\DirtyData', lData, GetDataSize('VFat\DirtyData'));
         FHard.VFAT.Dirty := lData;

         ReadBinaryData('VFat\ReadsSec', lData, GetDataSize('VFat\ReadsSec'));
         FHard.VFAT.ReadsPerSecond := lData;

         ReadBinaryData('VFat\WritesSec', lData, GetDataSize('VFat\WritesSec'));
         FHard.VFAT.WritesPerSecond := lData;
      finally
         free;
      end;
   //=== End: AW - 13/07/1999 =================================================

   //=== Begin: AW - 15/07/1999 ===============================================
   FHard.Input.Mouse.Available := Boolean(GetSystemMetrics(SM_MOUSEPRESENT));
   FHard.Input.Mouse.NumberOfButtons := GetSystemMetrics(SM_CMOUSEBUTTONS);
   FHard.Input.Mouse.ButtonsExchanged := Boolean(GetSystemMetrics(SM_SWAPBUTTON));
   FHard.Input.Mouse.MouseWheelAvailable := Boolean(GetSystemMetrics(SM_MOUSEWHEELPRESENT));

   RootKey := Root2;
   LazyWrite := false;

   OpenKey(WIN98_Mouse_Key2, False);
   if ReadString('DoubleClickSpeed')<>'' then FHard.Input.Mouse.FDoubleClickSpeed:=ReadString('DoubleClickSpeed');
   if ReadString('MouseSpeed')<>'' then FHard.Input.Mouse.MouseSpeed:=ReadString('MouseSpeed');
   CloseKey;

   RootKey := Root1;
   LazyWrite := false;

   OpenKey(WIN98_Mouse_Key1, False);
   if ReadString('DriverDesc')<>'' then FHard.Input.Mouse.Description := ReadString('DriverDesc');

   CloseKey;

   OpenKey(WIN98_Keyboard_Key, False);
   if ReadString('DriverDesc')<>'' then FHard.Input.KeyBoard.Keyboard:= ReadString('DriverDesc');
   CloseKey;

   FHard.Input.KeyBoard.NumberOfFunctionKeys := IntToStr(GetKeyboardType(2));
   //=== End: AW - 15/07/1999 =================================================

   //=== Begin: AW - 22/07/1999 ===============================================
   ReadFontData;

   with FSys.Operating_System.Environment.SystemMetrics do begin
      case GetSystemMetrics(SM_CLEANBOOT) of
        0: BootInfo :='normal';
        1: BootInfo :='abgesichert';
        2: BootInfo :='abgesichert mit Netzwerk';
      end;
      BorderSizes       := 'x: ' + IntToStr(GetSystemMetrics(SM_CXBORDER)) + ', y: ' + IntToStr(GetSystemMetrics(SM_CYBORDER));
      CursorSize        := 'x: ' + IntToStr(GetSystemMetrics(SM_CXCURSOR)) + ', y: ' + IntToStr(GetSystemMetrics(SM_CYCURSOR));
      DefaultIconSize   := 'x: ' + IntToStr(GetSystemMetrics(SM_CXICON))   + ', y: ' + IntToStr(GetSystemMetrics(SM_CYICON));
      DialogFrameSize   := 'x: ' + IntToStr(GetSystemMetrics(SM_CXDLGFRAME))+ ', y: ' +IntToStr(GetSystemMetrics(SM_CYDLGFRAME));
      SizableFrameSize  := 'x: ' + IntToStr(GetSystemMetrics(SM_CXFRAME))  + ', y: ' + IntToStr(GetSystemMetrics(SM_CYFRAME));
      ThickFrameSize    := 'x: ' + IntToStr(GetSystemMetrics(SM_CXSIZEFRAME))+', y: '+ IntToStr(GetSystemMetrics(SM_CYSIZEFRAME));
      UsableFullScreen  := 'x: ' + IntToStr(GetSystemMetrics(SM_CXFULLSCREEN))+', y: '+IntToStr(GetSystemMetrics(SM_CYFULLSCREEN));
      PenwindowsSupport := Boolean(GetSystemMetrics(SM_PENWINDOWS));
      if Boolean(GetSystemMetrics(SM_MENUDROPALIGNMENT)) then
        MenuDropAlignment := 'rightaligned'
      else
        MenuDropAlignment := 'leftaligned (standard)';
   end;
   //=== End: AW - 22/07/1999 =================================================

   //Memory
   with FMem do
   begin
    PhysicalMemory_Total    :=GetTotalPhysMemory;
    PhysicalMemory_Available:=GetAvailPhysMemory;
    SwapMemory_Total        :=GetTotalSwapMemory;
    SwapMemory_Available    :=GetAvailSwapMemory;
    VirtualMemory_Total     :=GetTotalVirtualMemory;
    VirtualMemory_Available :=GetAvailVirtualMemory;
   end;

   //System
   with FSys.User do
   begin
    OpenKey(WIN98_Name_Key, False);
    if ReadString('Workgroup')<>'' then              Workgroup              := ReadString('Workgroup');
    if ReadString('ComputerName')<>'' then           ComputerName           := ReadString('ComputerName');
    if ReadString('Comment')<>'' then                Comment                := ReadString('Comment');
    CloseKey;

    OpenKey(WIN98_Win_Key, False);
    if ReadString('RegisteredOwner')<>'' then        RegisteredOwner             := ReadString('RegisteredOwner');
    if ReadString('RegisteredOrganization')<>'' then RegisteredOrganization      := ReadString('RegisteredOrganization');
    if ReadString('BootCount')<>'' then              FSys.BootCount              := ReadString('BootCount');
    if ReadString('PF_AccessoriesName')<>'' then     FSys.PF_AccessoriesName     := ReadString('PF_AccessoriesName');
    if ReadString('SM_AccessoriesName')<>'' then     FSys.SM_AccessoriesName     := ReadString('SM_AccessoriesName');
    CloseKey;
   end;

   //SystemPath
   with FSys.FSP do begin
    OpenKey(WIN98_Win_Key, False);
    if ReadString('WallPaperDir')<>'' then     WallPaperDir      := ReadString('WallPaperDir');
    if ReadString('CommonFilesDir')<>'' then   CommonFilesDir    := ReadString('CommonFilesDir');
    if ReadString('ConfigPath')<>'' then       ConfigPath        := ReadString('ConfigPath');
    if ReadString('DevicePath')<>'' then       DevicePath        := ReadString('DevicePath');
    if ReadString('MediaPath')<>'' then        MediaPath         := ReadString('MediaPath');
    if ReadString('OtherDevicePath')<>'' then  OtherDevicePath   := ReadString('OtherDevicePath');
    if ReadString('SystemRoot')<>'' then       SystemRoot        := ReadString('SystemRoot');
    if ReadString('ProgramFilesPath')<>'' then ProgramFilesPath  := ReadString('ProgramFilesPath');
    CloseKey;

    RootKey := Root2;
    LazyWrite := false;
    OpenKey(WIN98_Path_Key, False);
    if ReadString('Desktop')<>'' then    Desktop       := ReadString('Desktop');
    if ReadString('Templates')<>'' then  Templates     := ReadString('Templates');
    if ReadString('AppData')<>'' then    AppData       := ReadString('AppData');
    if ReadString('Start Menu')<>'' then Start_Menu    := ReadString('Start Menu');
    if ReadString('Programs')<>'' then   Programs      := ReadString('Programs');
    if ReadString('Startup')<>'' then    Startup       := ReadString('Startup');
    if ReadString('Fonts')<>'' then      Fonts         := ReadString('Fonts');
    if ReadString('SendTo')<>'' then     SendTo        := ReadString('SendTo');
    if ReadString('Recent')<>'' then     Recent        := ReadString('Recent');
    if ReadString('Favorites')<>'' then  Favorites     := ReadString('Favorites');
    if ReadString('NetHood')<>'' then    NetHood       := ReadString('NetHood');
    if ReadString('Personal')<>'' then   Personal      := ReadString('Personal');
    if ReadString('Cache')<>'' then      Cache         := ReadString('Cache');
    if ReadString('Cookies')<>'' then    Cookies       := ReadString('Cookies');
    if ReadString('History')<>'' then    History       := ReadString('History');
    CloseKey;
   end;

   //OperatingSystem
   with FSys.FOS do begin
    RootKey := Root1;
    LazyWrite := false;
    OpenKey(WIN98_Win_Key, False);
    if ReadString('ProductName')<>'' then   ProductName   := ReadString('ProductName');
    if ReadString('ProductType')<>'' then   ProductType   := ReadString('ProductType');
    if ReadString('ProductId')<>'' then     ProductId     := ReadString('ProductId');
    if ReadString('ProductKey')<>'' then    ProductKey    := ReadString('ProductKey');
    if ReadString('Version')<>'' then       Version       := ReadString('Version');
    if ReadString('VersionNumber')<>'' then VersionNumber := ReadString('VersionNumber');
    CloseKey;
    i := GetTickCount; // AW - 12/07/1999
    Runtime := (IntToStr(i div (60 * 60 * 1000)) + ' hour(s) and ' + IntToStr((i div (60 * 1000)) - (i div (60 * 60 * 1000)) * 60) + ' minute(s)'); // AW - 12/07/1999

    OpenKey(WIN98_DirectX_Key, False);
    if ReadString('Version')<>'' then DirectX.Version        := ReadString('Version');
    CloseKey;

    OpenKey(WIN98_DirectMusic_Key+'\Defaults', False);
    if ReadString('DefaultOutputPort')<>'' then temp:=ReadString('DefaultOutputPort');
    CloseKey;

    if KeyExists(WIN98_DirectMusic_Key+'\SoftwareSynths\'+temp) then begin
       OpenKey(WIN98_DirectMusic_Key+'\SoftwareSynths\'+temp, False);
       if ReadString('Description')<>'' then FSys.Fos.DirectX.DirectMusic:= ReadString('Description');
       Closekey;
    end;

    OpenKey(WIN98_Direct3D_Key, False);
    GetKeyNames(D3DTemp);
    CloseKey;

    for i:=0 to D3DTemp.Count-1 do begin
      OpenKey(WIN98_Direct3D_Key+'\'+D3DTemp.Strings[i], False);
      if ReadString('Description')<>'' then begin
        FSys.FOS.DirectX.Direct3D.Add(ReadString('Description'));
      end;
      CloseKey;
    end;

    OpenKey(WIN98_DirectPlay_Key, False);
    GetKeyNames(DPlayTemp);
    CloseKey;

    for i:=0 to DPlayTemp.Count-1 do begin
      OpenKey(WIN98_DirectPlay_Key+'\'+DPlayTemp.Strings[i], False);
      if ReadString('DescriptionA')<>'' then begin
        FSys.FOS.DirectX.DirectPlay.Add(ReadString('DescriptionA'));
      end;
      CloseKey;
    end;

    OpenKey(WIN98_UnInstall_Key, False);
    GetKeyNames(UnInstallList);
    CloseKey;

    for i:=0 to UnInstallList.Count-1 do begin
      OpenKey(WIN98_UnInstall_Key+'\'+UnInstallList.Strings[i], False);
      if ReadString('DisplayName')<>'' then begin
        FSys.FOS.FUnInstall.Add(ReadString('DisplayName'));
      end;
      CloseKey;
    end;

    MediaTemp.Clear;
    OpenKey(WIN98_Media_Key2+'\ICM', False);
    GetKeyNames(MediaTemp);
    CloseKey;

    for i:=0 to MediaTemp.Count-1 do begin
      OpenKey(WIN98_Media_Key2+'\ICM\'+MediaTemp.Strings[i], False);
      if ReadString('Description')<>'' then begin
        FHard.MultiMedia.Image_Compress.Add(ReadString('Description'));
      end;
      CloseKey;
    end;

    MediaTemp.Clear;
    OpenKey(WIN98_Media_Key2+'\MCI', False);
    GetKeyNames(MediaTemp);
    CloseKey;

    for i:=0 to MediaTemp.Count-1 do begin
      OpenKey(WIN98_Media_Key2+'\MCI\'+MediaTemp.Strings[i], False);
      if ReadString('FriendlyName')<>'' then begin
        FHard.MultiMedia.Media_Controll.Add(ReadString('FriendlyName'));
      end;
      CloseKey;
    end;

    MediaTemp.Clear;
    OpenKey(WIN98_Media_Key2+'\WAVE', False);
    GetKeyNames(MediaTemp);
    CloseKey;

    for i:=0 to MediaTemp.Count-1 do begin
      OpenKey(WIN98_Media_Key2+'\WAVE\'+MediaTemp.Strings[i], False);
      if ReadString('FriendlyName')<>'' then begin
        FHard.MultiMedia.Wave.Add(ReadString('FriendlyName'));
      end;
      CloseKey;
    end;

    MediaTemp.Clear;
    OpenKey(WIN98_Media_Key2+'\MIDI', False);
    GetKeyNames(MediaTemp);
    CloseKey;

    for i:=0 to MediaTemp.Count-1 do begin
      OpenKey(WIN98_Media_Key2+'\MIDI\'+MediaTemp.Strings[i], False);
      if ReadString('FriendlyName')<>'' then begin
        FHard.MultiMedia.Midi.Add(ReadString('FriendlyName'));
      end;
      CloseKey;
    end;

    MediaTemp.Clear;
    OpenKey(WIN98_Media_Key2+'\ACM', False);
    GetKeyNames(MediaTemp);
    CloseKey;

    for i:=0 to MediaTemp.Count-1 do begin
      OpenKey(WIN98_Media_Key2+'\ACM\'+MediaTemp.Strings[i], False);
      if ReadString('Description')<>'' then begin
        FHard.MultiMedia.Audio_Compress.Add(ReadString('Description'));
      end;
      CloseKey;
    end;

    MediaTemp.Clear;
    OpenKey(WIN98_Media_Key2+'\MIXER', False);
    GetKeyNames(MediaTemp);
    CloseKey;

    OpenKey(WIN98_Media_Key2+'\MIXER\'+MediaTemp.Strings[0], False);
    if ReadString('FriendlyName')<>'' then FHard.MultiMedia.Mixer:=ReadString('FriendlyName');
    CloseKey;


   end;
  end;
  with FHard.Display.Capabilities do begin
    {raster capabilities}
   FRasterCapabilities.Clear;
   if (GetDeviceCaps(dc, RASTERCAPS) and
       RC_BANDING)=RC_BANDING then
         FRasterCapabilities.Add('Requires Banding');
   if (GetDeviceCaps(dc, RASTERCAPS) and
      RC_BITBLT)=RC_BITBLT then
        FRasterCapabilities.Add('Can Transer Bitmaps');
   if (GetDeviceCaps(dc, RASTERCAPS) and
      RC_BITMAP64)=RC_BITMAP64 then
        FRasterCapabilities.Add('Supports Bitmaps > 64K');
   if (GetDeviceCaps(dc, RASTERCAPS) and
      RC_DI_BITMAP)=RC_DI_BITMAP then
        FRasterCapabilities.Add('Supports SetDIBits and GetDIBits');
   if (GetDeviceCaps(dc, RASTERCAPS) and
      RC_DIBTODEV)=RC_DIBTODEV then
        FRasterCapabilities.Add('Supports SetDIBitsToDevice');
   if (GetDeviceCaps(dc, RASTERCAPS) and
      RC_FLOODFILL)=RC_FLOODFILL then
        FRasterCapabilities.Add('Can Perform Floodfills');
   if (GetDeviceCaps(dc, RASTERCAPS) and
      RC_GDI20_OUTPUT)=RC_GDI20_OUTPUT then
        FRasterCapabilities.Add('Supports Windows 2.0 Features');
   if (GetDeviceCaps(dc, RASTERCAPS) and
      RC_PALETTE)=RC_PALETTE then
        FRasterCapabilities.Add('Palette Based');
   if (GetDeviceCaps(dc, RASTERCAPS) and
      RC_SCALING)=RC_SCALING then
        FRasterCapabilities.Add('Supports Scaling');
   if (GetDeviceCaps(dc, RASTERCAPS) and
      RC_STRETCHBLT)=RC_STRETCHBLT then
        FRasterCapabilities.Add('Supports StretchBlt');
   if (GetDeviceCaps(dc, RASTERCAPS) and
      RC_STRETCHDIB)=RC_STRETCHDIB then
        FRasterCapabilities.Add('Supports StretchDIBits');

   {curve capabilities}
   FCurveCapabilities.clear;
   if GetDeviceCaps(dc, CURVECAPS)=CC_NONE then
    FCurveCapabilities.Add('Device Does Not Support Curves')
   else
   begin
    if (GetDeviceCaps(dc, CURVECAPS) and
        CC_CIRCLES)=CC_CIRCLES then
          FCurveCapabilities.Add('Supports Cirles');
    if (GetDeviceCaps(dc, CURVECAPS) and
        CC_PIE)=CC_PIE then
          FCurveCapabilities.Add('Supports Pie Wedges');
    if (GetDeviceCaps(dc, CURVECAPS) and
        CC_CHORD)=CC_CHORD then
          FCurveCapabilities.Add('Supports Chords');
    if (GetDeviceCaps(dc, CURVECAPS) and
        CC_ELLIPSES)=CC_ELLIPSES then
          FCurveCapabilities.Add('Supports Ellipses');
    if (GetDeviceCaps(dc, CURVECAPS) and
        CC_WIDE)=CC_WIDE then
          FCurveCapabilities.Add('Supports Wide Borders');
    if (GetDeviceCaps(dc, CURVECAPS) and
        CC_STYLED)=CC_STYLED then
          FCurveCapabilities.Add('Supports Styled Borders');
    if (GetDeviceCaps(dc, CURVECAPS) and
        CC_WIDESTYLED)=CC_WIDESTYLED then
          FCurveCapabilities.Add('Supports Wide And Styled Borders');
    if (GetDeviceCaps(dc, CURVECAPS) and
        CC_INTERIORS)=CC_INTERIORS then
          FCurveCapabilities.Add('Supports Interiors');
    if (GetDeviceCaps(dc, CURVECAPS) and
        CC_ROUNDRECT)=CC_ROUNDRECT then
          FCurveCapabilities.Add('Supports Rounded Rectangles');
   end;

   {line capabilities}
   FLineCapabilities.clear;
   if GetDeviceCaps(dc, LINECAPS)=LC_NONE then
     FLineCapabilities.Add('Device Does Not Support Lines')
   else
   begin
    if (GetDeviceCaps(dc, LINECAPS) and
        LC_POLYLINE)=LC_POLYLINE then
          FLineCapabilities.Add('Supports Polylines');
    if (GetDeviceCaps(dc, LINECAPS) and
        LC_MARKER)=LC_MARKER then
          FLineCapabilities.Add('Supports Markers');
    if (GetDeviceCaps(dc, LINECAPS) and
        LC_POLYMARKER)=LC_POLYMARKER then
          FLineCapabilities.Add('Supports Multiple Markers');
    if (GetDeviceCaps(dc, LINECAPS) and
        LC_WIDE)=LC_WIDE then
          FLineCapabilities.Add('Supports Wide Lines');
    if (GetDeviceCaps(dc, LINECAPS) and
        LC_STYLED)=LC_STYLED then
          FLineCapabilities.Add('Supports Styled Lines');
    if (GetDeviceCaps(dc, LINECAPS) and
        LC_WIDESTYLED)=LC_WIDESTYLED then
          FLineCapabilities.Add('Supports Wide And Styled Lines');
    if (GetDeviceCaps(dc, LINECAPS) and
        LC_INTERIORS)=LC_INTERIORS then
          FLineCapabilities.Add('Supports Interiors');
   end;

   {polygonal capabilities}
   FPolygonalCapabilities.clear;
   if GetDeviceCaps(dc, POLYGONALCAPS)=PC_NONE then
     FPolygonalCapabilities.Add('Device Does Not Support Polygons')
   else
   begin
    if (GetDeviceCaps(dc, POLYGONALCAPS) and
        PC_POLYGON)=PC_POLYGON then
          FPolygonalCapabilities.Add('Supports Alternate Fill Polygons');
    if (GetDeviceCaps(dc, POLYGONALCAPS) and
        PC_RECTANGLE)=PC_RECTANGLE then
          FPolygonalCapabilities.Add('Supports Rectangles');
    if (GetDeviceCaps(dc, POLYGONALCAPS) and
        PC_WINDPOLYGON)=PC_WINDPOLYGON then
          FPolygonalCapabilities.Add('Supports Winding Fill Polygons');
    if (GetDeviceCaps(dc, POLYGONALCAPS) and
        PC_SCANLINE)=PC_SCANLINE then
          FPolygonalCapabilities.Add('Supports Single Scanlines');
    if (GetDeviceCaps(dc, POLYGONALCAPS) and
        PC_WIDE)=PC_WIDE then
          FPolygonalCapabilities.Add('Supports Wide Borders');
    if (GetDeviceCaps(dc, POLYGONALCAPS) and
        PC_STYLED)=PC_STYLED then
          FPolygonalCapabilities.Add('Supports Styled Borders');
    if (GetDeviceCaps(dc, POLYGONALCAPS) and
        PC_WIDESTYLED)=PC_WIDESTYLED then
          FPolygonalCapabilities.Add('Supports Wide And Styled Borders');
    if (GetDeviceCaps(dc, POLYGONALCAPS) and
        PC_INTERIORS)=PC_INTERIORS then
          FPolygonalCapabilities.Add('Supports Interiors');
   end;

   {text capabilities}
   FTextCapabilities.clear;
   if (GetDeviceCaps(dc, TEXTCAPS) and
      TC_OP_CHARACTER)=TC_OP_CHARACTER then
        FTextCapabilities.Add('Capable of Character Output Precision');
   if (GetDeviceCaps(dc, TEXTCAPS) and
      TC_OP_STROKE)=TC_OP_STROKE then
        FTextCapabilities.Add('Capable of Stroke Output Precision');
   if (GetDeviceCaps(dc, TEXTCAPS) and
      TC_CP_STROKE)=TC_CP_STROKE then
        FTextCapabilities.Add('Capable of Stroke Clip Precision');
   if (GetDeviceCaps(dc, TEXTCAPS) and
      TC_CR_90)=TC_CR_90 then
        FTextCapabilities.Add('Supports 90 Degree Character Rotation');
   if (GetDeviceCaps(dc, TEXTCAPS) and
      TC_CR_ANY)=TC_CR_ANY then
        FTextCapabilities.Add('Supports Character Rotation to Any Angle');
   if (GetDeviceCaps(dc, TEXTCAPS) and
      TC_SF_X_YINDEP)=TC_SF_X_YINDEP then
        FTextCapabilities.Add('X And Y Scale Independent');
   if (GetDeviceCaps(dc, TEXTCAPS) and
      TC_SA_DOUBLE)=TC_SA_DOUBLE then
        FTextCapabilities.Add('Supports Doubled Character Scaling');
   if (GetDeviceCaps(dc, TEXTCAPS) and
      TC_SA_INTEGER)=TC_SA_INTEGER then
        FTextCapabilities.Add('Supports Integer Multiples Only When Scaling');
   if (GetDeviceCaps(dc, TEXTCAPS) and
      TC_SA_CONTIN)=TC_SA_CONTIN then
        FTextCapabilities.Add('Supports Any Multiples For Exact Character Scaling');
   if (GetDeviceCaps(dc, TEXTCAPS) and
      TC_EA_DOUBLE)=TC_EA_DOUBLE then
        FTextCapabilities.Add('Supports Double Weight Characters');
   if (GetDeviceCaps(dc, TEXTCAPS) and
      TC_IA_ABLE)=TC_IA_ABLE then
        FTextCapabilities.Add('Supports Italics');
   if (GetDeviceCaps(dc, TEXTCAPS) and
      TC_UA_ABLE)=TC_UA_ABLE then
        FTextCapabilities.Add('Supports Underlines');
   if (GetDeviceCaps(dc, TEXTCAPS) and
      TC_SO_ABLE)=TC_SO_ABLE then
        FTextCapabilities.Add('Supports Strikeouts');
   if (GetDeviceCaps(dc, TEXTCAPS) and
      TC_RA_ABLE)=TC_RA_ABLE then
        FTextCapabilities.Add('Supports Raster Fonts');
   if (GetDeviceCaps(dc, TEXTCAPS) and
      TC_VA_ABLE)=TC_VA_ABLE then
        FTextCapabilities.Add('Supports Vector Fonts');
   if (GetDeviceCaps(dc, TEXTCAPS) and
      TC_SCROLLBLT)=TC_SCROLLBLT then
        FTextCapabilities.Add('Cannot Scroll Using Blts');
  end;
  ReleaseDC(0, dc);  // free Device-Context

   //DiskInfo
  FDisk.Drive:='C';
  FDisk.setdrive('C');
  FDisk.DriveType:=FDisk.GetDriveTyp;

  LReg.Free;
  UnInstallList.Free;
  Emails.Free;
  D3DTemp.Free;
  DPlayTemp.Free;
  MediaTemp.Free;
 end;

end.
