unit Demo;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, SystemInfo2000X, ComCtrls, ImgList, FileCtrl, Gauges,
  Grids, Buttons, ShellApi;

type
  TMain = class(TForm)
    SI: TSystemInfo2000X;
    IL: TImageList;
    
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;

    Label10: TLabel;
    Label11: TLabel;
    Label13: TLabel;
    Label12: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;

    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Label23: TLabel;
    Label24: TLabel;
    Label25: TLabel;
    Label26: TLabel;
    Label27: TLabel;
    Label28: TLabel;
    Label29: TLabel;

    Label30: TLabel;
    Label31: TLabel;
    Label32: TLabel;
    Label33: TLabel;
    Label34: TLabel;
    Label35: TLabel;
    Label36: TLabel;
    Label37: TLabel;
    Label38: TLabel;
    Label39: TLabel;

    Label40: TLabel;
    Label41: TLabel;
    Label42: TLabel;
    Label43: TLabel;
    Label44: TLabel;
    Label45: TLabel;
    Label46: TLabel;
    Label47: TLabel;
    Label48: TLabel;
    Label49: TLabel;

    Label50: TLabel;
    Label51: TLabel;
    Label52: TLabel;
    Label53: TLabel;
    Label54: TLabel;
    Label55: TLabel;
    Label56: TLabel;
    Label57: TLabel;
    Label58: TLabel;
    Label59: TLabel;

    Label60: TLabel;
    Label61: TLabel;
    Label62: TLabel;
    Label63: TLabel;
    Label64: TLabel;
    Label65: TLabel;
    Label66: TLabel;
    Label67: TLabel;
    Label68: TLabel;
    Label69: TLabel;

    Label70: TLabel;
    Label71: TLabel;
    Label72: TLabel;
    Label73: TLabel;
    Label74: TLabel;
    Label75: TLabel;
    Label76: TLabel;
    Label77: TLabel;
    Label78: TLabel;
    Label79: TLabel;

    Label80: TLabel;
    Label81: TLabel;
    Label82: TLabel;
    Label83: TLabel;
    Label84: TLabel;
    Label85: TLabel;
    Label86: TLabel;
    Label87: TLabel;
    Label88: TLabel;
    Label89: TLabel;

    Label90: TLabel;
    Label91: TLabel;
    Label92: TLabel;
    Label93: TLabel;
    Label94: TLabel;
    Label95: TLabel;
    Label96: TLabel;
    Label97: TLabel;
    Label98: TLabel;
    Label99: TLabel;

    Label100: TLabel;
    Label101: TLabel;
    Label102: TLabel;
    Label103: TLabel;
    Label104: TLabel;
    Label105: TLabel;
    Label106: TLabel;
    Label107: TLabel;
    Label108: TLabel;
    Label109: TLabel;

    Label110: TLabel;
    Label111: TLabel;
    Label112: TLabel;
    Label113: TLabel;
    Label114: TLabel;
    Label115: TLabel;
    Label116: TLabel;
    Label117: TLabel;
    Label119: TLabel;
    Label120: TLabel;

    Lbl_Mem_Tot_Virtual:                        TLabel;
    Lbl_Mem_Tot_Physical:                       TLabel;
    Lbl_Mem_Tot_Swap:                           TLabel;
    Lbl_Mem_Av_Virtual:                         TLabel;
    Lbl_Mem_Av_Physical:                        TLabel;
    Lbl_Mem_Av_Swap:                            TLabel;
    Lbl_Input_Keyboard_NumberOfFunctionKeys:    TLabel;
    Lbl_Input_Keyboard_Description:             TLabel;
    Lbl_Input_Mouse_WheelAvailable:             TLabel;
    Lbl_Input_Mouse_ButtonsExchanged:           TLabel;
    Lbl_Input_Mouse_NumberOfButtons:            TLabel;
    Lbl_Input_Mouse_Description:                TLabel;
    Lbl_Input_Mouse_Available:                  TLabel;
    Lbl_Input_Mouse_DblClickSpeed:              TLabel;
    Lbl_Input_Mouse_MouseSpeed:                 TLabel;
    Lbl_DI_VolumeName:                          TLabel;
    Lbl_DI_SerialNumber:                        TLabel;
    Lbl_DI_DriveType:                           TLabel;
    Lbl_DI_FileSystemType:                      TLabel;
    Lbl_DI_Clusters:                            TLabel;
    Lbl_DI_FreeClusters:                        TLabel;
    Lbl_DI_SectorsPerCluster:                   TLabel;
    Lbl_DI_BytesPerSector:                      TLabel;
    Lbl_DI_TotalDiskSpace:                      TLabel;
    Lbl_DI_FreeDiskSpace:                       TLabel;
    Lbl_CPU_CoProcessor:                        TLabel;
    Lbl_CPU_NumberOfProcessors:                 TLabel;
    Lbl_CPU_Speed:                              TLabel;
    Lbl_CPU_Vendor:                             TLabel;
    Lbl_CPU_Revision:                           TLabel;
    Lbl_CPU_MMX:                                TLabel;
    Lbl_CPU_Processor:                          TLabel;
    Lbl_CPU_ActiveProcessor:                    TLabel;
    Lbl_Motherboard_VFAT_BytesReadPerSecond:    TLabel;
    Lbl_Motherboard_VFAT_BytesWrittenPerSecond: TLabel;
    Lbl_Motherboard_VFAT_ReadsPerSecond:        TLabel;
    Lbl_Motherboard_VFAT_WritesPerSecond:       TLabel;
    Lbl_Motherboard_MachineType:                TLabel;
    Lbl_Motherboard_BusType:                    TLabel;
    Lbl_Motherboard_BIOSDate:                   TLabel;
    Lbl_Motherboard_BIOSName:                   TLabel;
    Lbl_Motherboard_BIOSVersion:                TLabel;
    Lbl_Others_NumberOfDOSVirtualMachines:      TLabel;
    Lbl_Others_NumberOfThreads:                 TLabel;
    Lbl_Others_BootCount:                       TLabel;
    Lbl_Others_Modem_Description:               TLabel;
    Lbl_Others_Printer_Description:             TLabel;
    Lbl_User_RegisteredOrganisation:            TLabel;
    Lbl_User_RegisteredOwner:                   TLabel;
    Lbl_User_Workgroup:                         TLabel;
    Lbl_User_ComputerName:                      TLabel;
    Lbl_User_Name:                              TLabel;
    Lbl_Network_Proxy_ProxyOverride:            TLabel;
    Lbl_Network_Proxy_SOCKS:                    TLabel;
    Lbl_Network_Proxy_HTTP:                     TLabel;
    Lbl_Network_Proxy_HTTPS:                    TLabel;
    Lbl_Network_Proxy_FTP:                      TLabel;
    Lbl_Network_Proxy_GOPHER:                   TLabel;
    Lbl_SystemMetrics_PenwindowsSupport:        TLabel;
    Lbl_SystemMetrics_MenuDropAlignment:        TLabel;
    Lbl_SystemMetrics_UsableFullScreen:         TLabel;
    Lbl_SystemMetrics_ThickFrameSize:           TLabel;
    Lbl_SystemMetrics_SizableFrameSize:         TLabel;
    Lbl_SystemMetrics_BootInfo:                 TLabel;
    Lbl_SystemMetrics_BorderSizes:              TLabel;
    Lbl_SystemMetrics_CursorSize:               TLabel;
    Lbl_SystemMetrics_DefaultIconSize:          TLabel;
    Lbl_SystemMetrics_DialogFrameSize:          TLabel;
    Lbl_MM_Mixer:                               TLabel;
    Lbl_OS_Name:                                TLabel;
    Lbl_OS_Version:                             TLabel;
    Lbl_OS_VersionNumber:                       TLabel;
    Lbl_OS_Type:                                TLabel;
    Lbl_OS_ID:                                  TLabel;
    Lbl_OS_Key:                                 TLabel;
    Lbl_OS_Runtime:                             TLabel;
    Lbl_OS_DirectXVersion:                      TLabel;
    Lbl_OS_DirectMusic:                         TLabel;
    Lbl_Display_Monitor:                        TLabel;
    Lbl_Display_DriverDescription:              TLabel;
    Lbl_Display_Driver:                         TLabel;
    Lbl_Display_DPI:                            TLabel;
    Lbl_Display_BPP:                            TLabel;
    Lbl_Display_CurrentResolution:              TLabel;

    But_Close:   TButton;
    But_Refresh: TButton;

    But_About:      TSpeedButton;
    But_SystemInfo: TSpeedButton;

    Notebook: TNotebook;

    Shape2: TShape;
    Img_Logo: TImage;
    Img_Hardware_Motherboard: TImage;
    Img_Hardware_CPU:         TImage;
    Img_Disks:                TImage;
    Img_Display:              TImage;
    Img_Input_Mouse:          TImage;
    Img_Input_Keyboard:       TImage;
    Img_SystemPaths:          TImage;
    Img_OS:                   TImage;
    Img_Interfaces:           TImage;
    Img_Hardware:             TImage;
    Img_User:                 TImage;
    Img_Others_Printer:       TImage;
    Img_Others_Modem:         TImage;
    Img_About_eMail:          TImage;
    Img_Network:              TImage;
    Img_Fonts:                TImage;
    Img_SystemMetrics:        TImage;
    Img_Multimedia:           TImage;

    PC:          TPageControl;
    PC_Hardware: TPageControl;

    Motherboard:               TTabSheet;
    CPU:                       TTabSheet;
    DiskInfo:                  TTabSheet;
    Display:                   TTabSheet;
    Input:                     TTabSheet;
    Memory:                    TTabSheet;
    SysPaths:                  TTabSheet;
    OS:                        TTabSheet;
    Interfaces:                TTabSheet;
    Hardware:                  TTabSheet;
    Hardware_Controller:       TTabSheet;
    Hardware_SystemComponents: TTabSheet;
    User:                      TTabSheet;
    Others:                    TTabSheet;
    Network:                   TTabSheet;
    Fonts:                     TTabSheet;
    SystemMetrics:             TTabSheet;
    Multimedia:                TTabSheet;
    TabSheet1:                 TTabSheet;
    TabSheet2:                 TTabSheet;
    TabSheet3:                 TTabSheet;
    TabSheet4:                 TTabSheet;
    TabSheet5:                 TTabSheet;
    TabSheet6:                 TTabSheet;
    TabSheet7:                 TTabSheet;
    TabSheet8:                 TTabSheet;
    TabSheet9:                 TTabSheet;
    TabSheet10:                TTabSheet;
    TabSheet11:                TTabSheet;
    TabSheet12:                TTabSheet;
    TabSheet13:                TTabSheet;
    TabSheet14:                TTabSheet;
    TabSheet15:                TTabSheet;
    TabSheet16:                TTabSheet;
    TabSheet17:                TTabSheet;
    TabSheet18:                TTabSheet;
    TabSheet19:                TTabSheet;
    TabSheet20:                TTabSheet;

    GroupBox1:  TGroupBox;
    GroupBox2:  TGroupBox;
    GroupBox3:  TGroupBox;
    GroupBox4:  TGroupBox;
    GroupBox5:  TGroupBox;
    GroupBox6:  TGroupBox;
    GroupBox7:  TGroupBox;
    GroupBox8:  TGroupBox;
    GroupBox9:  TGroupBox;
    GroupBox10: TGroupBox;
    GroupBox11: TGroupBox;
    GroupBox12: TGroupBox;
    GroupBox13: TGroupBox;
    GroupBox14: TGroupBox;
    GroupBox15: TGroupBox;
    GroupBox16: TGroupBox;
    GroupBox17: TGroupBox;
    GroupBox18: TGroupBox;
    GroupBox19: TGroupBox;
    GroupBox20: TGroupBox;
    GroupBox21: TGroupBox;

    Gauge_CPU_Usage:    TGauge;
    Gauge_Mem_GDI:      TGauge;
    Gauge_Mem_System:   TGauge;
    Gauge_Mem_User:     TGauge;
    Gauge_Mem_Virtual:  TGauge;
    Gauge_Mem_Swap:     TGauge;
    Gauge_Mem_Physical: TGauge;

    Bevel1: TBevel;
    Bevel3: TBevel;

    Panel1:  TPanel;
    Panel2:  TPanel;
    Panel3:  TPanel;
    Panel4:  TPanel;
    Panel5:  TPanel;
    Panel6:  TPanel;
    Panel7:  TPanel;
    Panel8:  TPanel;
    Panel9:  TPanel;
    Panel10: TPanel;

    DCB_Disks: TDriveComboBox;

    LV_SystemPaths: TListView;
    LV_Fonts:       TListView;

    Grid_Interfaces_COM: TStringGrid;
    Grid_Interfaces_LPT: TStringGrid;

    List_Hardware_Controller:       TListBox;
    List_Hardware_SystemComponents: TListBox;
    List_Network_eMailAccounts:     TListBox;
    List_Network_Net:               TListBox;
    List_Network_NetProtocol:       TListBox;
    List_MM_AudioCompression:       TListBox;
    List_MM_ImageCompression:       TListBox;
    List_MM_Media:                  TListBox;
    List_MM_MediaController:        TListBox;
    List_MM_Midi:                   TListBox;
    List_MM_Wave:                   TListBox;
    List_OS_Direct3D:               TListBox;
    List_OS_DirectPlay:             TListBox;

    PageControl1: TPageControl;
    PageControl2: TPageControl;
    PageControl3: TPageControl;
    PageControl4: TPageControl;
    PageControl5: TPageControl;

    Memo_Display_PossibleModes: TMemo;
    Memo_Display_Cap_Curve: TMemo;
    Memo_Display_Cap_Line: TMemo;
    Memo_Display_Cap_Polygon: TMemo;
    Memo_Display_Cap_Raster: TMemo;
    Memo_Display_Cap_Text: TMemo;

    procedure FormCreate(Sender: TObject);
    procedure DCB_DisksChange(Sender: TObject);
    procedure But_RefreshClick(Sender: TObject);
    procedure But_CloseClick(Sender: TObject);
    procedure Label101MouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure Button_Click(Sender: TObject);
    procedure LV_ColumnClick(Sender: TObject; Column: TListColumn);
  private
    { Private-Deklarationen }
    procedure Refresh_Multimedia;
    procedure Refresh_SystemMetrics;
    procedure Refresh_Fonts;
    procedure Refresh_CPU;
    procedure Refresh_User;
    procedure Refresh_Motherboard;
    procedure Refresh_Hardware;
    procedure Refresh_Interfaces;
    procedure Refresh_DiskInfo;
    procedure Refresh_Display;
    procedure Refresh_Input;
    procedure Refresh_Memory;
    procedure Refresh_SystemPath;
    procedure Refresh_OS;
    procedure Refresh_Others;
    procedure Refresh_Network;
    procedure Refresh_All;
  public
    { Public-Deklarationen }
  end;

var
  Main: TMain;

implementation

uses Splash;

{$R *.DFM}

{==============================================================================}
procedure TMain.Refresh_All;
{==============================================================================}
begin
    Refresh_CPU;
    Refresh_User;
    Refresh_Motherboard;
    Refresh_Hardware;
    Refresh_Interfaces;
    Refresh_DiskInfo;
    Refresh_Display;
    Refresh_Input;
    Refresh_Memory;
    Refresh_SystemPath;
    Refresh_OS;
    Refresh_Others;
    Refresh_Network;
    Refresh_Fonts;
    Refresh_SystemMetrics;
    Refresh_Multimedia;
end;
{==============================================================================}
function Check(B : Boolean) : String;
{==============================================================================}
begin
  if B then Result := 'Yes' else Result := 'No';
end;
{==============================================================================}
procedure TMain.Refresh_Motherboard;
{==============================================================================}
begin
  with SI.Hardware.Motherboard do begin
    Lbl_Motherboard_MachineType.Caption := MachineType;
    Lbl_Motherboard_BusType.Caption :=     BusType;
    Lbl_Motherboard_BIOSDate.Caption :=    BIOSDate;
    Lbl_Motherboard_BIOSName.Caption :=    BIOSName;
    Lbl_Motherboard_BIOSVersion.Caption := BIOSVer;
  end;
  with SI.Hardware.VFAT do begin
    Lbl_Motherboard_VFAT_BytesReadPerSecond.Caption :=    IntToStr(BytesReadPerSecond);
    Lbl_Motherboard_VFAT_BytesWrittenPerSecond.Caption := IntToStr(BytesWrittenPerSecond);
    Lbl_Motherboard_VFAT_ReadsPerSecond.Caption :=        IntToStr(ReadsPerSecond);
    Lbl_Motherboard_VFAT_WritesPerSecond.Caption :=       IntToStr(WritesPerSecond);
  end;
end;
{==============================================================================}
procedure TMain.Refresh_Multimedia;
{==============================================================================}
begin
  with SI.Hardware.Multimedia do begin
    List_MM_AudioCompression.Items.Assign(Audio_Compress);
    List_MM_ImageCompression.Items.Assign(Image_Compress);
    List_MM_MediaController.Items.Assign(Media_Controll);
    List_MM_Midi.Items.Assign(Midi);
    List_MM_Wave.Items.Assign(Wave);
    List_MM_Media.Items.Assign(Media);
    Lbl_MM_Mixer.Caption := Mixer;
  end;
end;
{==============================================================================}
procedure TMain.Refresh_SystemMetrics;
{==============================================================================}
begin
  with SI.System.Operating_System.Environment.SystemMetrics do begin
    Lbl_SystemMetrics_BootInfo.Caption          := BootInfo;
    Lbl_SystemMetrics_BorderSizes.Caption       := BorderSizes;
    Lbl_SystemMetrics_CursorSize.Caption        := CursorSize;
    Lbl_SystemMetrics_DefaultIconSize.Caption   := DefaultIconSize;
    Lbl_SystemMetrics_DialogframeSize.Caption   := DialogFrameSize;
    Lbl_SystemMetrics_SizableFrameSize.Caption  := SizableFrameSize;
    Lbl_SystemMetrics_ThickframeSize.Caption    := ThickFrameSize;
    Lbl_SystemMetrics_UsableFullscreen.Caption  := UsableFullScreen;
    Lbl_SystemMetrics_MenudropAlignment.Caption := MenuDropAlignment;
    Lbl_SystemMetrics_PenwindowsSupport.Caption := Check(PenwindowsSupport);
  end;
end;
{==============================================================================}
procedure TMain.Refresh_User;
{==============================================================================}
begin
  with SI.System.User do begin
    Lbl_User_Name.Caption :=                   Comment;
    Lbl_User_ComputerName.Caption :=           ComputerName;
    Lbl_User_RegisteredOrganisation.Caption := RegisteredOrganization;
    Lbl_User_RegisteredOwner.Caption :=        RegisteredOwner;
    Lbl_User_Workgroup.Caption :=              Workgroup;
  end;
end;
{==============================================================================}
procedure TMain.Refresh_Others;
{==============================================================================}
begin
  with SI.Hardware do begin
    Lbl_Others_Printer_Description.Caption :=        Printer.Printer;
    Lbl_Others_Modem_Description.Caption :=          MultiMedia.Modem;
    Lbl_Others_NumberOfDOSVirtualMachines.Caption := IntToStr(Kernel.NumberOfDOSVirtualMachines);
    Lbl_Others_NumberOfThreads.Caption :=            IntToStr(Kernel.NumberOfThreads);
  end;
  Lbl_Others_BootCount.Caption := SI.System.BootCount;
end;
{==============================================================================}
procedure TMain.Refresh_CPU;
{==============================================================================}
begin
  with SI.Hardware.CPU do begin
    Lbl_CPU_Processor.Caption :=          Processor;
    Lbl_CPU_Speed.Caption :=              ProcessorSpeed;
    Lbl_CPU_CoProcessor.Caption :=        CoProcessor;
    Lbl_CPU_MMX.Caption :=                ProcessorMMX;
    Lbl_CPU_Revision.Caption :=           ProcessorRevision;
    Lbl_CPU_Vendor.Caption :=             ProcessorVendor;
    Lbl_CPU_NumberOfProcessors.Caption := NumberOfProcessors;
    Lbl_CPU_ActiveProcessor.Caption :=    ActiveProcessor;
    Gauge_CPU_Usage.Progress :=           SI.Hardware.Kernel.CPUUsage;
  end;
end;
{==============================================================================}
procedure TMain.Refresh_Hardware;
{==============================================================================}
begin
  with SI.Hardware do begin
    List_Hardware_Controller.Items.Assign(Controller.Controller);
    List_Hardware_SystemComponents.Items.Assign(Controller.System_Components);
  end;
end;
{==============================================================================}
procedure TMain.Refresh_Network;
{==============================================================================}
begin
  with SI.Hardware.Network do begin
    List_Network_Net.Items.Assign(Net);
    List_Network_NetProtocol.Items.Assign(NetProtocol);
    List_Network_eMailAccounts.Items.Assign(EMail_Accounts);
    with ProxyServer do begin
      Lbl_Network_Proxy_FTP.Caption           := FTP;
      Lbl_Network_Proxy_GOPHER.Caption        := GOPHER;
      Lbl_Network_Proxy_HTTP.Caption          := HTTP;
      Lbl_Network_Proxy_HTTPS.Caption         := HTTPS;
      Lbl_Network_Proxy_SOCKS.Caption         := SOCKS;
      Lbl_Network_Proxy_ProxyOverride.Caption := ProxyOverride;
    end;
  end;
end;
{==============================================================================}
procedure TMain.Refresh_Interfaces;
{==============================================================================}
  function CheckA(S : String) : String;
  begin
    if S = '(unavailable)' then Result := '(n/a)' else Result := S;
  end;
begin
  with SI.Hardware.Interfaces do begin
    with Grid_Interfaces_COM do begin
      Cells[0,0] := 'COM-Port';
      Cells[1,0] := 'COM1'; Cells[2,0] := 'COM2';
      Cells[3,0] := 'COM3'; Cells[4,0] := 'COM4';

      Cells[0,1] := 'Available';
      Cells[1,1] := Check(COM1.Available); Cells[2,1] := Check(COM2.Available);
      Cells[3,1] := Check(COM3.Available); Cells[4,1] := Check(COM4.Available);

      Cells[0,2] := 'Baudrate';
      Cells[1,2] := CheckA(COM1.Baudrate); Cells[2,2] := CheckA(COM2.Baudrate);
      Cells[3,2] := CheckA(COM3.Baudrate); Cells[4,2] := CheckA(COM4.Baudrate);

      Cells[0,3] := 'Max IBuff';
      Cells[1,3] := IntToStr(COM1.MaxInputBuffer); Cells[2,3] := IntToStr(COM2.MaxInputBuffer);
      Cells[3,3] := IntToStr(COM3.MaxInputBuffer); Cells[4,3] := IntToStr(COM4.MaxInputBuffer);

      Cells[0,4] := 'Max OBuff';
      Cells[1,4] := IntToStr(COM1.MaxOutputBuffer); Cells[2,4] := IntToStr(COM2.MaxOutputBuffer);
      Cells[3,4] := IntToStr(COM3.MaxOutputBuffer); Cells[4,4] := IntToStr(COM4.MaxOutputBuffer);

      Cells[0,5] := 'Pack Len';
      Cells[1,5] := IntToStr(COM1.PacketLength); Cells[2,5] := IntToStr(COM2.PacketLength);
      Cells[3,5] := IntToStr(COM3.PacketLength); Cells[4,5] := IntToStr(COM4.PacketLength);

      Cells[0,6] := 'Pack Vers';
      Cells[1,6] := IntToStr(COM1.PacketVersion); Cells[2,6] := IntToStr(COM2.PacketVersion);
      Cells[3,6] := IntToStr(COM3.PacketVersion); Cells[4,6] := IntToStr(COM4.PacketVersion);
    end;
    with Grid_Interfaces_LPT do begin
      Cells[0,0] := 'LPT-Port';
      Cells[1,0] := 'LPT1'; Cells[2,0] := 'LPT2';
      Cells[3,0] := 'LPT3'; Cells[4,0] := 'LPT4';

      Cells[0,1] := 'Available';
      Cells[1,1] := Check(LPT1_Available); Cells[2,1] := Check(LPT2_Available);
      Cells[3,1] := Check(LPT3_Available); Cells[4,1] := Check(LPT4_Available);
    end;
  end;
end;
{==============================================================================}
procedure TMain.Refresh_DiskInfo;
{==============================================================================}
begin
  with SI.DiskInfo do begin
    Drive := DCB_Disks.Drive;
    Lbl_DI_VolumeName.Caption        := VolumeName;
    Lbl_DI_SerialNumber.Caption      := SerialNumber;
    Lbl_DI_DriveType.Caption         := DriveType;
    Lbl_DI_FileSystemType.Caption    := FileSystemType;
    Lbl_DI_Clusters.Caption          := IntToStr(Clusters);
    Lbl_DI_FreeClusters.Caption      := IntToStr(FreeClusters);
    Lbl_DI_SectorsPerCluster.Caption := IntToStr(SectorsPerCluster);
    Lbl_DI_BytesPerSector.Caption    := IntToStr(BytesPerSector);
    Lbl_DI_TotalDiskSpace.Caption    := TotalDiskSpace;
    Lbl_DI_FreeDiskSpace.Caption     := DiskFreeSpace;
  end;
end;
{==============================================================================}
procedure TMain.Refresh_Display;
{==============================================================================}
begin
  with SI.Hardware.Display do begin
    Lbl_Display_CurrentResolution.Caption := DisplayResolution;
    Lbl_Display_BPP.Caption               := DisplayBPP;
    Lbl_Display_DPI.Caption               := DisplayDPI;
    Lbl_Display_Driver.Caption            := Display_Driver;
    Lbl_Display_DriverDescription.Caption := Display_Driver_Description;
    Lbl_Display_Monitor.Caption           := Monitor;
    Memo_Display_PossibleModes.Lines.Assign(Modes);
    with Capabilities do begin
      Memo_Display_Cap_Curve.Lines.Assign(CurveCapabilities);
      Memo_Display_Cap_Line.Lines.Assign(LineCapabilities);
      Memo_Display_Cap_Polygon.Lines.Assign(PolygonalCapabilities);
      Memo_Display_Cap_Raster.Lines.Assign(RasterCapabilities);
      Memo_Display_Cap_Text.Lines.Assign(TextCapabilities);
    end;
  end;
end;
{==============================================================================}
procedure TMain.Refresh_Input;
{==============================================================================}
begin
  with SI.Hardware.Input do begin
    with Mouse do begin
      Lbl_Input_Mouse_Available.Caption := Check(Available);
      Lbl_Input_Mouse_Description.Caption := Description;
      Lbl_Input_Mouse_NumberOfButtons.Caption := IntToStr(NumberOfButtons);
      Lbl_Input_Mouse_ButtonsExchanged.Caption := Check(ButtonsExchanged);
      Lbl_Input_Mouse_WheelAvailable.Caption := Check(MouseWheelAvailable);
      Lbl_Input_Mouse_DblClickSpeed.Caption := DoubleClickSpeed;
      Lbl_Input_Mouse_MouseSpeed.Caption := MouseSpeed;
    end;
    Lbl_Input_Keyboard_Description.Caption := Keyboard.Keyboard;
    Lbl_Input_Keyboard_NumberOfFunctionKeys.Caption := Keyboard.NumberOfFunctionKeys;
  end;
end;
{==============================================================================}
procedure TMain.Refresh_Memory;
{==============================================================================}
begin
  with SI.Memory do begin
    Lbl_Mem_Av_Swap.caption:=inttostr(SwapMemory_Available div 1024)+' MB';
    Lbl_Mem_Tot_Swap.caption:=inttostr(SwapMemory_Total div 1024)+' MB';
    Gauge_Mem_Swap.progress:=(SwapMemory_Available*100) div SwapMemory_Total;

    Lbl_Mem_Av_Physical.caption:=inttostr(PhysicalMemory_Available div 1024)+' MB';
    Lbl_Mem_Tot_Physical.caption:=inttostr(PhysicalMemory_Total div 1024)+' MB';
    Gauge_Mem_Physical.progress:=(PhysicalMemory_Available*100) div PhysicalMemory_Total;

    Lbl_Mem_Av_Virtual.caption:=inttostr(VirtualMemory_Available div 1024)+' MB';
    Lbl_Mem_Tot_Virtual.caption:=inttostr(VirtualMemory_Total div 1024)+' MB';
    Gauge_Mem_Virtual.progress:=(VirtualMemory_Available*100) div VirtualMemory_Total;

    Gauge_Mem_GDI.progress:=ResourcesGDI;
    Gauge_Mem_System.progress:=ResourcesSystem;
    Gauge_Mem_User.progress:=ResourcesUser;
  end;
end;
{==============================================================================}
procedure TMain.Refresh_SystemPath;
{==============================================================================}
  procedure AddPath(Name, Path : String);
  var
    LI : TListItem;
  begin
    LI := LV_SystemPaths.Items.Add;
    LI.Caption := Name;
    LI.SubItems.Add(Path);
  end;
begin
  LV_SystemPaths.Items.Clear;
  with SI.System.System_Path do begin
    AddPath('AppData', AppData);
    AddPath('Cache', Cache);
    AddPath('Common Files', CommonFilesDir);
    AddPath('Config', ConfigPath);
    AddPath('Cookies', Cookies);
    AddPath('Desktop', Desktop);
    AddPath('Device', DevicePath);
    AddPath('Favorites', Favorites);
    AddPath('Fonts', Fonts);
    AddPath('History', History);
    AddPath('Media', MediaPath);
    AddPath('NetHood', NetHood);
    AddPath('Other Devices', OtherDevicePath);
    AddPath('Personal', Personal);
    AddPath('Program Files', ProgramFilesPath);
    AddPath('Programs', Programs);
    AddPath('Recent', Recent);
    AddPath('SentTo', SendTo);
    AddPath('StartUp', StartUp);
    AddPath('Startmenu', Start_Menu);
    AddPath('SystemRoot', SystemRoot);
    AddPath('Templates', Templates);
    AddPath('Wallpaper', WallpaperDir);
  end;
end;
{==============================================================================}
procedure TMain.Refresh_OS;
{==============================================================================}
begin
  with SI.System.Operating_System do begin
    Lbl_OS_Name.Caption :=           ProductName;
    Lbl_OS_Version.Caption :=        Version;
    Lbl_OS_VersionNumber.Caption :=  VersionNumber;
    Lbl_OS_Type.Caption :=           ProductType;
    Lbl_OS_ID.Caption :=             ProductID;
    Lbl_OS_Key.Caption :=            ProductKey;
    Lbl_OS_Runtime.Caption :=        Runtime;
    with DirectX do begin
      Lbl_OS_DirectXVersion.Caption := Version;
      Lbl_OS_DirectMusic.Caption    := DirectMusic;
      List_OS_Direct3D.Items.Assign(Direct3D);
      List_OS_DirectPlay.Items.Assign(DirectPlay);
    end;
  end;
end;
{==============================================================================}
procedure TMain.Refresh_Fonts;
{==============================================================================}
var
  i  : integer;
  LI : TListItem;
begin
  with SI.System.Operating_System.Environment.Fonts do begin
     for i := 1 to FontName.Count do begin
       LI := LV_Fonts.Items.Add;
       LI.Caption := IntToStr(i);
       LI.SubItems.Add(FontName[i-1]);
       LI.SubItems.Add(FontFile[i-1]);
       LI.SubItems.Add(FontType[i-1]);
     end;
  end;
end;
{==============================================================================}
procedure TMain.FormCreate(Sender: TObject);
{==============================================================================}
begin
  SI.Refresh;

  SplashScreen.IL.GetBitmap(0,Img_Logo.picture.bitmap);
  IL.GetBitmap(0,Img_Hardware_Motherboard.picture.bitmap);
  IL.GetBitmap(1,Img_Hardware_CPU.picture.bitmap);
  IL.GetBitmap(2,Img_Disks.picture.bitmap);
  IL.GetBitmap(3,Img_Display.picture.bitmap);
  IL.GetBitmap(4,Img_Input_Mouse.picture.bitmap);
  IL.GetBitmap(5,Img_Input_Keyboard.picture.bitmap);
  IL.GetBitmap(6,Img_SystemPaths.picture.bitmap);
  IL.GetBitmap(7,Img_OS.picture.bitmap);
  IL.GetBitmap(8,Img_Interfaces.picture.bitmap);
  IL.GetBitmap(9,Img_Hardware.picture.bitmap);
  IL.GetBitmap(10,Img_User.picture.bitmap);
  IL.GetBitmap(11,Img_Others_Printer.picture.bitmap);
  IL.GetBitmap(12,Img_Others_Modem.picture.bitmap);
  IL.GetBitmap(13,Img_About_eMail.picture.bitmap);
  IL.GetBitmap(14,Img_Network.picture.bitmap);
  IL.GetBitmap(15,Img_Fonts.picture.bitmap);
  IL.GetBitmap(16,Img_SystemMetrics.picture.bitmap);
  IL.GetBitmap(17,Img_Multimedia.picture.bitmap);

  Label69.Caption := 'Please contact me, if you should have any comments or corrections relating to this sample project or if you should even find a bug or something like that.' + #13#10 + 'To do so, please click at the eMail-link at the bottom.';

  DCB_Disks.Drive := 'C';
  Refresh_All;
end;
{==============================================================================}
procedure TMain.DCB_DisksChange(Sender: TObject);
{==============================================================================}
begin
  Refresh_DiskInfo;
end;
{==============================================================================}
procedure TMain.But_RefreshClick(Sender: TObject);
{==============================================================================}
begin
  SI.Refresh;
  Refresh_All;
end;
{==============================================================================}
procedure TMain.But_CloseClick(Sender: TObject);
{==============================================================================}
begin
  Close;
end;
{==============================================================================}
procedure TMain.Label101MouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
{==============================================================================}
begin
  ShellExecute(Handle, 'open', PChar('mailto:wist@gmx.de'), nil, nil, SW_SHOW);
end;
{==============================================================================}
procedure TMain.Button_Click(Sender: TObject);
{==============================================================================}
begin
   But_About.Font.Style := [];
   But_SystemInfo.Font.Style := [];

   Notebook.ActivePage := IntToStr((Sender as TSpeedButton).Tag);
   (Sender as TSpeedButton).Font.Style := [fsBold];
end;
{==============================================================================}
procedure TMain.LV_ColumnClick(Sender: TObject; Column: TListColumn);
{==============================================================================}
const
  asc : boolean = true;
  lastix : integer = -1;

  function customsortproc(item1, item2: tlistitem; paramsort: integer): integer; stdcall;
  var
    sr1,sr2 : string;
  begin
    if lastix = 0 then begin
       sr1 := item1.caption;
       sr2 := item2.caption
    end else begin
       sr1:= item1.subitems[lastix-1];
       sr2:= item2.subitems[lastix-1];
    end;
    result := lstrcmp(pchar(sr1),
    pchar(sr2));
    if not asc then result := -result;
  end;
begin
  if column.index <> lastix then asc := true else asc := not asc;
  lastix := column.index;
  (Sender as TListView).customsort(@customsortproc,0);
end;

end.
