unit Axes;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ScGraph, Menus, StdCtrls;

type
  TAxesForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Close1: TMenuItem;
    Printersetup1: TMenuItem;
    Print1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Edit1: TMenuItem;
    Copygraph1: TMenuItem;
    Mouse1: TMenuItem;
    ScGraph1: TScGraph;
    Scaling1: TMenuItem;
    Moving1: TMenuItem;
    Label1: TLabel;
    Label2: TLabel;
    Drawing1: TMenuItem;
    Autometrics1: TMenuItem;
    Help1: TMenuItem;
    procedure Close1Click(Sender: TObject);
    procedure Printersetup1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure Copygraph1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Scaling(Sender: TObject);
    procedure ScGraph1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ScGraph1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Moving1Click(Sender: TObject);
    procedure ScGraph1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Drawing1Click(Sender: TObject);
    procedure Autometrics1Click(Sender: TObject);
    procedure Help1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AxesForm: TAxesForm;
  AxesText: TStringList;

implementation

uses DemoMain, Help;

{$R *.DFM}

const
  ScaleMode: boolean = false;
  DrawMode : boolean = false;

var
  XX1, YY1, XX2, YY2: double;

procedure TAxesForm.Close1Click(Sender: TObject);
begin
  DemoForm.CloseWindow1Click(Self);
end;

procedure TAxesForm.Printersetup1Click(Sender: TObject);
begin
  DemoForm.PrinterSetupDialog1.Execute;
end;

procedure TAxesForm.Print1Click(Sender: TObject);
begin
  ScGraph1.PrintGraph(-1, -1, 140, 120);
end;

procedure TAxesForm.Copygraph1Click(Sender: TObject);
begin
  ScGraph1.CopyGraphToClipboard;
end;

///////////////////////////////////////////////
procedure TAxesForm.FormCreate(Sender: TObject);
var i: integer;
begin
  with ScGraph1 do
  begin
    // set up series
    SetSeries(1, true, true, clNavy, '---');
    // get a nice function for the data
    AddPoint(1, 0, 1, -1, -1);
    for i := 1 to 100 do
    begin
      AddPoint(1, i/10, sin(i/2)/i*2, -1, -1);
      AddPoint(1, -i/10, sin(i/2)/i*2, -1, -1);
    end;
    // set up line type
    SetSeriesLine(1, true, pmLine, 3, psSolid);

    // prepare for a second line with points
    SetSeries(2, true, true, clRed, '');
    SetSeriesLine(2, true, pmLine, 3, psDot);
    SetSeriesPoints(2, true, psTriangleUp, 10);
    Scaling(Self);

    // paint always to get something on the graph
    Paint;
  end;

  AxesText := TStringList.Create;
  with AxesText do begin
    Add(' Edit  : Copy Graph - copies graph to clipboard');
    Add('         Autometrics- autoadjust various sizes,');
    Add('         line widths and distances');
    Add(' Mouse : ');
    Add('    - Scaling: clicking and dragging the mouse ');
    Add('         changes both x- and y-scale factors   ');
    Add('    - Moving : clicking and dragging the mouse ');
    Add('         moves the plot                        ');
    Add('    - Drawing: clicking the mouse button draws ');
    Add('         symbols and lines on the plot         ');
  end;
end;

procedure TAxesForm.FormDestroy(Sender: TObject);
begin
  AxesText.Free;
end;

procedure TAxesForm.Exit1Click(Sender: TObject);
begin
  DemoForm.Exit1Click(Self);
end;

///////// change the mouse function scaling ///////
procedure TAxesForm.Scaling(Sender: TObject);
begin
  Scaling1.Checked:= true;
  Moving1.Checked:= false;
  Drawing1.Checked:= false;
  ScaleMode:= true;
  DrawMode:= false;
  ScGraph1.Cursor:= crSizeNESW;
  ScGraph1.GraphTitle.Caption:=
    'Scales and Mouse functions - <i>scale factors';
  ScGraph1.Paint;
end;

///////// change the mouse function to graph panning ///////
procedure TAxesForm.Moving1Click(Sender: TObject);
begin
  Scaling1.Checked:= false;
  Moving1.Checked:= true;
  Drawing1.Checked:= false;
  ScaleMode:= false;
  DrawMode:= false;
  ScGraph1.Cursor:= crDefault;
  ScGraph1.GraphTitle.Caption:=
    'Scales and Mouse functions - <i>moving the plot';
  ScGraph1.Paint;
end;

///////// change the mouse function to drawing of points ///////
procedure TAxesForm.Drawing1Click(Sender: TObject);
begin
  Scaling1.Checked:= false;
  Moving1.Checked:= false;
  Drawing1.Checked:= true;
  ScaleMode:= false;
  DrawMode:= true;
  ScGraph1.Cursor:= crCross;
  ScGraph1.GraphTitle.Caption:=
    'Scales and Mouse functions - <i>Drawing points';
  ScGraph1.Paint;
end;

/////// add a point by clicking the mouse ///////////
procedure TAxesForm.ScGraph1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  with ScGraph1 do
  begin
    // mouse position for dragging, scaling and drawing
    XX1:= GetMouseX(X);  YY1:= GetMouseY(Y);
    if DrawMode and
       (XX1 > XScale.Min) and (XX1 < XScale.Max) and
       (YY1 > YScale.Min) and (YY1 < YScale.Max) then
    begin
      AddPoint(2, XX1, YY1, -1, -1);
      Paint;
    end;
  end;
end;

/////// scaling or dragging/Panning when releasing the mouse button
procedure TAxesForm.ScGraph1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var r: double;
begin
  with ScGraph1 do
    if not DrawMode then
    begin
      XX2:= GetMouseX(X);
      YY2:= GetMouseY(Y);
      if ScaleMode then
      begin // change scales, limit the change to factor of 10
        r:= 1.0;
        if (XX2 - XScale.Min) > 0 then
          r:= (XX1 - XScale.Min) / (XX2 - XScale.Min);
        if r > 10 then r:= 10
        else if r < 0.1 then r:= 0.1;
        XScale.Max:= XScale.Min + (XScale.Max - XScale.Min) * r;
        if (XScale.Max - XScale.Min) < abs(XScale.Min * 0.001) then
        begin
          XScale.Max:= XScale.Min + abs(XScale.Min * 0.001);
          Beep;
        end;

        r:= 1.0;
        if (YY2 - YScale.Min) > 0 then
          r:= (YY1 - YScale.Min) / (YY2 - YScale.Min);
        if r > 10 then r:= 10
        else if r < 0.1 then r:= 0.1;
        YScale.Max:= YScale.Min + (YScale.Max - YScale.Min) * r;
        if (YScale.Max - YScale.Min) < abs(YScale.Min * 0.001) then
        begin
          YScale.Max:= YScale.Min + abs(YScale.Min * 0.001);
          Beep;
        end;
      end
      else
      begin // move graph
        XScale.Min:= XScale.Min - XX2 + XX1;
        XScale.Max:= XScale.Max - XX2 + XX1;
        YScale.Min:= YScale.Min - YY2 + YY1;
        YScale.Max:= YScale.Max - YY2 + YY1;;
      end;
      Paint;
    end;
end;

// showing scaled mouse coordinates
procedure TAxesForm.ScGraph1MouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
  Label1.Caption := 'X= ' + FloatToStrF(ScGraph1.GetMouseX(X), ffGeneral, 3, 5);
  Label2.Caption := 'Y= ' + FloatToStrF(ScGraph1.GetMouseY(Y), ffGeneral, 3, 5);
  ScGraph1MouseUp(self, mbLeft, Shift, x, y);
  ScGraph1.Paint;
end;

procedure TAxesForm.Autometrics1Click(Sender: TObject);
begin
  ScGraph1.Autometrics := ScGraph1.Autometrics xor true;
  Autometrics1.Checked := ScGraph1.Autometrics;
  ScGraph1.Paint;
end;

procedure TAxesForm.Help1Click(Sender: TObject);
begin
  HelpForm.HelpMemo.Lines.Assign(AxesText);
  HelpForm.ShowModal;
end;

end.
