unit ScriptDemoWin;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, StdCtrls, ScriptTypes, ScriptExceptions, Tokenizer, ComCtrls, ExtCtrls,
  Db, DBTables, Menus;

type
  TfrmScriptDemo = class(TForm)
    script: TScript;
    fncsGraphix: TFuncs;
    fncDot: TFunc;
    fncSin: TFunc;
	fncCos: TFunc;
	fncPrint: TFunc;
    Panel2: TPanel;
    imPix: TImage;
    lbLog: TListBox;
    MainMenu1: TMainMenu;
    FileMenu: TMenuItem;
    NewItem: TMenuItem;
    OpenItem: TMenuItem;
    SaveItem: TMenuItem;
    ExitItem: TMenuItem;
    N1: TMenuItem;
    ScriptMenu: TMenuItem;
    CompileItem: TMenuItem;
    ExecuteItem: TMenuItem;
    N2: TMenuItem;
    ShowTreeItem: TMenuItem;
    Memo1: TMemo;
    DemosMenu: TMenuItem;
	CircleItem: TMenuItem;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    fncClearPix: TFunc;
    N3: TMenuItem;
    VariablesItem: TMenuItem;
	fncLine: TFunc;
    LinesItem: TMenuItem;
    N4: TMenuItem;
    MacroStartItem: TMenuItem;
    MacroStopItem: TMenuItem;
	Procedures1: TMenuItem;
    ParametersandResult1: TMenuItem;
    Array1: TMenuItem;
    HelpMenu: TMenuItem;
    SyntaxItem: TMenuItem;
    TechItem: TMenuItem;
    ClassItem: TMenuItem;
    FuncItem: TMenuItem;
    N5: TMenuItem;
    HomeItem: TMenuItem;
    AboutItem: TMenuItem;
	procedure fncSinEval(Sender: TObject; args: TArgList; var Result: Variant);
	procedure fncPrintEval(Sender: TObject; args: TArgList; var Result: Variant);
	procedure fncCosEval(Sender: TObject; args: TArgList; var Result: Variant);
	procedure fncDotEval(Sender: TObject; args: TArgList; var Result: Variant);
	procedure fncClearPixEval(Sender: TObject; args: TArgList; var Result: Variant);
    procedure NewItemClick(Sender: TObject);
    procedure OpenItemClick(Sender: TObject);
    procedure SaveItemClick(Sender: TObject);
    procedure CompileItemClick(Sender: TObject);
    procedure ExecuteItemClick(Sender: TObject);
	procedure ExitItemClick(Sender: TObject);
	procedure ShowTreeItemClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CircleItemClick(Sender: TObject);
	procedure Memo1Change(Sender: TObject);
	procedure VariablesItemClick(Sender: TObject);
	procedure fncLineEval(Sender: TObject; args: TArgList;
	  var Result: Variant);
    procedure MacroStartItemClick(Sender: TObject);
    procedure LinesItemClick(Sender: TObject);
    procedure MacroStopItemClick(Sender: TObject);
    procedure imPixMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure imPixMouseUp(Sender: TObject; Button: TMouseButton;
	  Shift: TShiftState; X, Y: Integer);
    procedure fncIncEval(Sender: TObject; args: TArgList;
      var Result: Variant);
    procedure Procedures1Click(Sender: TObject);
    procedure ParametersandResult1Click(Sender: TObject);
    procedure Array1Click(Sender: TObject);
    procedure SyntaxItemClick(Sender: TObject);
    procedure FuncItemClick(Sender: TObject);
    procedure ClassItemClick(Sender: TObject);
    procedure TechItemClick(Sender: TObject);
    procedure HomeItemClick(Sender: TObject);
    procedure AboutItemClick(Sender: TObject);
  private
	dx, dy : Integer;
	orgx, orgy : Integer;
	macro : boolean;
  public
	progpath : string;
	ScriptChanged : Boolean;
  end;

var
  frmScriptDemo: TfrmScriptDemo;

implementation

uses ScriptDemoTree, ScriptDemoVar, ShellApi;

{$R *.DFM}

procedure TfrmScriptDemo.FormCreate(Sender: TObject);
begin
	progpath := ExtractFilePath (Application.Exename);
	ScriptChanged := false;
	Macro := false;

	dx := imPix.Width div 2;
	dy := imPix.Height div 2;
end;

procedure TfrmScriptDemo.Memo1Change(Sender: TObject);
begin
	ScriptChanged := true;
end;

procedure TfrmScriptDemo.NewItemClick(Sender: TObject);
begin
	Memo1.Clear;
end;

procedure TfrmScriptDemo.OpenItemClick(Sender: TObject);
begin
	OpenDialog1.InitialDir := progpath;
	if OpenDialog1.Execute then
		Memo1.Lines.LoadFromFile (OpenDialog1.FileName);
end;

procedure TfrmScriptDemo.SaveItemClick(Sender: TObject);
begin
	SaveDialog1.InitialDir := progpath;
	if SaveDialog1.Execute then
		Memo1.Lines.SaveToFile (SaveDialog1.FileName);
end;

procedure TfrmScriptDemo.ExitItemClick(Sender: TObject);
begin
	Close
end;

procedure TfrmScriptDemo.CompileItemClick(Sender: TObject);
begin
	lbLog.Clear;
	try
		// Assigns the script code in the memo to the script component
		script.Text := Memo1.Lines.Text;
		ScriptChanged := false;

		// Compiles the script
		script.Compile;
		lbLog.Items.Add ('*** Compiled.');
	except
		// Errors in the script syntax will raise an EScriptError-exception
		on e : EScriptError do begin
			// The position of the token causing the error is stored in e.ePos
			memo1.SelStart := e.ePos - 1;
			memo1.SelLength := 1;
			ShowMessage (e.Message);
		end;
		on e : Exception do
			ShowMessage (e.Message);
	end;
end;

procedure TfrmScriptDemo.ExecuteItemClick(Sender: TObject);
begin
	lbLog.Clear;
	try
		if ScriptChanged then script.Text := Memo1.Lines.Text;
		ScriptChanged := false;
		lbLog.Items.Add ('*** Executing...');
		// If the script is not yet compiled Execute will do this now.
		script.Execute;
		lbLog.Items.Add ('*** Executed.');
		// Shows the value of the script variable "result" 
		lbLog.Items.Add ('*** Result: ' + VarToStr (script.Result));
	except
		// Runtime errors in the script will raise an EScriptError-exception
		on e : EScriptError do begin
			// Highlight the position of the runtime error
			Memo1.SelStart := e.ePos - 1;
			Memo1.SelLength := 1;
			ShowMessage (e.Message);
		end;
		on e : Exception do
			ShowMessage (e.Message);
	end;
end;

procedure TfrmScriptDemo.VariablesItemClick(Sender: TObject);
begin
	frmScriptDemoVar.ShowModal;
end;

procedure TfrmScriptDemo.ShowTreeItemClick(Sender: TObject);
begin
	// Shows the code tree, generated by the script compiler in a TTreeView component
	script.ShowTree (frmScriptTree.TV);
	frmScriptTree.ShowModal;
end;

procedure TfrmScriptDemo.CircleItemClick(Sender: TObject);
begin
	Memo1.Lines.LoadFromFile (progpath + 'circle.sct');
end;

procedure TfrmScriptDemo.LinesItemClick(Sender: TObject);
begin
	Memo1.Lines.LoadFromFile (progpath + 'lines.sct');
end;

procedure TfrmScriptDemo.Array1Click(Sender: TObject);
begin
	Memo1.Lines.LoadFromFile (progpath + 'array.sct');
end;

procedure TfrmScriptDemo.Procedures1Click(Sender: TObject);
begin
	Memo1.Lines.LoadFromFile (progpath + 'dprocs.sct');
end;

procedure TfrmScriptDemo.ParametersandResult1Click(Sender: TObject);
begin
	Memo1.Lines.LoadFromFile (progpath + 'paramres.sct');
end;

procedure TfrmScriptDemo.MacroStartItemClick(Sender: TObject);
var
	res : Integer;
begin                	
	res := MessageDlg ('Do you wan''t to save this script? Recording a macro will delete any unsaved changes!', 
		mtInformation, [mbYes, mbNo, mbCancel], 0);
	if res = mrCancel then exit;
	if res = mrYes then SaveItemClick (self);

	// Initialization
	imPix.Canvas.FillRect (imPix.ClientRect);
	Memo1.Clear;
	Memo1.Lines.LoadFromFile (progpath + 'macro.sct');

	Macro := True;
end;

procedure TfrmScriptDemo.MacroStopItemClick(Sender: TObject);
begin
	Macro := False;
end;

procedure TfrmScriptDemo.imPixMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
	if not Macro then exit;
	// Remember mouse position.
	orgx := x - dx; orgy := y - dy;
end;

procedure TfrmScriptDemo.imPixMouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
	// Mousebutton released in the image surface
	if not Macro then exit;
	
	imPix.Canvas.MoveTo (orgx + dx, orgy + dy);
	imPix.Canvas.LineTo (x, y);

	x := x - dx; y := y - dy;

	Memo1.Lines.Add (Format ('Line (%d, %d, %d, %d);', [orgx, orgy, x, y]));
end;

procedure TfrmScriptDemo.fncSinEval (Sender: TObject; args: TArgList; var Result: Variant);
begin
	{
	The declaration of fncSin is: Sin (float) : float
	-> args contains 1 TConstExpr of type float.
	-> args.count will always return 1
	-> if result is not a floating point value, a runtime error will occur
	}
	result := System.Sin (args[0].Eval);
end;

procedure TfrmScriptDemo.fncPrintEval (Sender: TObject; args: TArgList; var Result: Variant);
var
	x : Integer;
begin
	{
	The declaration of fncPrint is: Print (all open)
	-> args contains args.count TConstExpr of any possible type.
	-> args.count will return the number of arguments overgiven
	}
	for x := 0 to args.count - 1 do
		lbLog.Items.Add (VarToStr (args[x].Eval));
end;

procedure TfrmScriptDemo.fncCosEval (Sender: TObject; args: TArgList; var Result: Variant);
begin
	{
	The declaration of fncCos is: Cos (float) : float
	-> args contains 1 TConstExpr of type float.
	-> args.count will always return 1
	-> if result is not a floating point value, a runtime error will occur
	}
	result := System.Cos (args[0].Eval);
end;

procedure TfrmScriptDemo.fncDotEval (Sender: TObject; args: TArgList; var Result: Variant);
var
	x, y, dx, dy : Integer;
begin
	{
	The declaration of fncDot is: Dot (integer, integer)
	-> args contains 2 TConstExpr. 0..1 of type integer.
	-> args.count will always return 2
	}
	dx := imPix.Width div 2;
	dy := imPix.Height div 2;
	x := Round(args[0].Eval);
	y := Round(args[1].Eval);
	imPix.Canvas.Pixels[x + dx, y + dy] := clBlue;
end;

procedure TfrmScriptDemo.fncClearPixEval (Sender: TObject; args: TArgList; var Result: Variant);
begin
	{
	The declaration of fncClearPix is: ClearPix ()
	-> args is empty
	-> args.count will always return 0
	}
	imPix.Canvas.FillRect (imPix.ClientRect);
end;

procedure TfrmScriptDemo.fncLineEval(Sender: TObject; args: TArgList; var Result: Variant);
var
	ax, ay, bx, by : Integer;
begin
	{
	The declaration of fncLine is: Line (mult, mult, mult, mult, integer)
	-> args contains 5 TConstExpr. 0..3 of type integer or float, 4 of type integer
	-> args.count will always return 5
	}
	ax := Round(args[0].Eval) + dx;
	ay := Round(args[1].Eval) + dy;
	bx := Round(args[2].Eval) + dx;
	by := Round(args[3].Eval) + dy;
	if args.Count > 4 then
		imPix.Canvas.Pen.Color := args[4].Eval;
	imPix.Canvas.MoveTo (ax, ay);
	imPix.Canvas.LineTo (bx, by);
end;

procedure TfrmScriptDemo.fncIncEval(Sender: TObject; args: TArgList; var Result: Variant);
begin
	{
	The declaration of fncInc is: Inc (var integer)
	-> args contains 1 TVarExpr of type integer
	-> args.count will always return 1
	}
	TVarExpr (args[0]).SetValue (args[0].Eval + 1);
	result := args[0].Eval;
end;

procedure OpenFile(const FileName : string);
begin
	if FileExists (FileName) then
		ShellExecute(Application.MainForm.Handle, 'open', PChar (FileName), nil, nil, SW_SHOW)
	else
		ShowMessage (Filename + ' not found');
end;

procedure TfrmScriptDemo.SyntaxItemClick(Sender: TObject);
begin
	OpenFile ('syntax.txt');
end;

procedure TfrmScriptDemo.FuncItemClick(Sender: TObject);
begin
	OpenFile ('funcs.txt');
end;

procedure TfrmScriptDemo.ClassItemClick(Sender: TObject);
begin
	OpenFile ('classes.txt');
end;

procedure TfrmScriptDemo.TechItemClick(Sender: TObject);
begin
	OpenFile ('techtalk.txt');
end;

procedure TfrmScriptDemo.HomeItemClick(Sender: TObject);
begin
	ShellExecute(Application.MainForm.Handle, 'open', 'http://n.ethz.ch/student/ackermma/delph_en.html', nil, nil, SW_SHOW)
end;

procedure TfrmScriptDemo.AboutItemClick(Sender: TObject);
begin
	ShowMessage ('Demonstration Programm for TScript Component'#10#13'(c) 1999 by Matthias Ackermann, Switzerland');
end;

end.
