unit abDlgSecurity;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, ExtCtrls, ActnList, abSecurity, Menus;

type
  TfrmSecurity = class(TForm)
    btnNewUser: TButton;
    btnOK: TButton;
    btnCancel: TButton;
    btnDeleteUser: TButton;
    ActionList1: TActionList;
    actAddUser: TAction;
    actRemoveUser: TAction;
    actOK: TAction;
    actCancel: TAction;
    ftvUserTemplate: TTreeView;
    procedure actRemoveUserExecute(Sender: TObject);
    procedure actRemoveUserUpdate(Sender: TObject);
    procedure actAddUserExecute(Sender: TObject);
    procedure actAddUserUpdate(Sender: TObject);
    procedure tvDblClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    IsSupervisor: boolean;
    //ftvUserTemplate: TevSecurityTemplateStore;
    ftvSecurityTemplate: TabSecurityTemplate;
  end;

implementation

{$R *.DFM}

uses abNewUserDlg, abUserPasswordDlg, abCript;

procedure TfrmSecurity.actRemoveUserExecute(Sender: TObject);
var
  tnUserNode: TTreeNode;
begin
  tnUserNode := TabSecurityTemplate(ftvUserTemplate).GetUserNodeForSelected;
  TabSecurityTemplate(ftvUserTemplate).DeleteNode(tnUserNode);
end;

procedure TfrmSecurity.actAddUserExecute(Sender: TObject);
var
  dlgNewUser: TdlgNewUser;
begin
  dlgNewUser := TdlgNewUser.Create(Self);
  try
    if mrOK = dlgNewUser.ShowModal then
    begin
      TabSecurityTemplate(ftvUserTemplate).AddUserToUserTemplate(ftvSecurityTemplate, dlgNewUser.edtNewUserName.Text, '', true);
    end;
  finally
    dlgNewUser.Destroy;
  end;
end;

procedure TfrmSecurity.actRemoveUserUpdate(Sender: TObject);
var
  tn: TTreeNode;
begin
  tn := TabSecurityTemplate(ftvUserTemplate).GetUserNodeForSelected;
  TAction(Sender).Enabled := IsSupervisor and Assigned(tn) and (tn.Text <> C_SUPERVISOR_NAME);
end;


procedure TfrmSecurity.actAddUserUpdate(Sender: TObject);
begin
  TAction(Sender).Enabled := IsSupervisor;
end;

procedure TfrmSecurity.tvDblClick(Sender: TObject);
var
  sUser, sPassword: string;
  dlgUserPassword: TdlgUserPassword;
begin
  case TabSecurityTemplate(ftvUserTemplate).GetSelectedNodeType(sUser, sPassword) of
  ntNone:;
  ntPassword:
  begin
    dlgUserPassword := TdlgUserPassword.Create(nil);
    try
      dlgUserPassword.fsCurrentPassword := sPassword;
      if mrOK = dlgUserPassword.ShowModal then
      begin
        PNodeData(ftvUserTemplate.Selected.Data)^.sCaption := TCripter.Cript(dlgUserPassword.edtNewPassword.Text);
      end;
    finally
      dlgUserPassword.Destroy;
    end;
  end;
  ntUserLeave:
  begin
    if IsSupervisor then
    begin
      if PNodeData(ftvUserTemplate.Selected.Data)^.bCheckOK then
      begin
        PNodeData(ftvUserTemplate.Selected.Data)^.bCheckOK := false;
        ftvUserTemplate.Selected.Text := PNodeData(ftvUserTemplate.Selected.Data)^.sCaption + ' ' + C_NO;
      end
      else
      begin
        PNodeData(ftvUserTemplate.Selected.Data)^.bCheckOK := true;
        ftvUserTemplate.Selected.Text := PNodeData(ftvUserTemplate.Selected.Data)^.sCaption + ' ' + C_YES;
      end;
    end;
  end;
  end;
end;



procedure TfrmSecurity.FormDestroy(Sender: TObject);
begin
  TabSecurityTemplate(ftvUserTemplate).ClearTemplate;
end;

end.
