unit Main;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, Menus,
  StdCtrls, Dialogs, Buttons, Messages, ExtCtrls, ComCtrls, StdActns,
  ActnList, ToolWin, ImgList, abActnLst, abSecurity;

type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    FileNewItem: TMenuItem;
    FileOpenItem: TMenuItem;
    FileCloseItem: TMenuItem;
    Window1: TMenuItem;
    Help1: TMenuItem;
    N1: TMenuItem;
    FileExitItem: TMenuItem;
    WindowCascadeItem: TMenuItem;
    WindowTileItem: TMenuItem;
    WindowArrangeItem: TMenuItem;
    HelpAboutItem: TMenuItem;
    OpenDialog: TOpenDialog;
    FileSaveItem: TMenuItem;
    FileSaveAsItem: TMenuItem;
    Edit1: TMenuItem;
    CutItem: TMenuItem;
    CopyItem: TMenuItem;
    PasteItem: TMenuItem;
    WindowMinimizeItem: TMenuItem;
    StatusBar: TStatusBar;
    ActionList1: TabActionList;
    EditCut1: TabAction;
    EditCopy1: TabAction;
    EditPaste1: TabAction;
    FileNew1: TabAction;
    FileSave1: TabAction;
    FileExit1: TabAction;
    FileOpen1: TabAction;
    FileSaveAs1: TabAction;
    WindowCascade1: TabAction;
    WindowTileHorizontal1: TabAction;
    WindowArrangeAll1: TabAction;
    WindowMinimizeAll1: TabAction;
    HelpAbout1: TabAction;
    FileClose1: TabAction;
    WindowTileVertical1: TabAction;
    WindowTileItem2: TMenuItem;
    ToolBar2: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton9: TToolButton;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    ToolButton10: TToolButton;
    ToolButton11: TToolButton;
    ImageList1: TImageList;
    BitBtn1: TBitBtn;
    abactCheckRights: TabAction;
    Button1: TButton;
    BitBtn2: TBitBtn;
    abactChangeLogon: TabAction;
    abSecurity1: TabSecurity;
    edtMainWnd: TEdit;
    abAutoGenerated: TabAction;
    procedure FileNew1Execute(Sender: TObject);
    procedure FileOpen1Execute(Sender: TObject);
    procedure HelpAbout1Execute(Sender: TObject);
    procedure FileExit1Execute(Sender: TObject);
    procedure abactCheckRightsExecute(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FileClose1Execute(Sender: TObject);
    procedure abactChangeLogonExecute(Sender: TObject);
  private
    { Private declarations }
    procedure CreateMDIChild(const Name: string);
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

uses ChildWin, About;

procedure TMainForm.CreateMDIChild(const Name: string);
var
  Child: TMDIChild;
begin
  { create a new MDI child window }
  Child := TMDIChild.Create(Application);
  Child.Caption := Name;
  if FileExists(Name) then Child.Memo1.Lines.LoadFromFile(Name);
end;

procedure TMainForm.FileNew1Execute(Sender: TObject);
begin
  CreateMDIChild('NONAME' + IntToStr(MDIChildCount + 1));
end;

procedure TMainForm.FileOpen1Execute(Sender: TObject);
begin
  if OpenDialog.Execute then
    CreateMDIChild(OpenDialog.FileName);
end;

procedure TMainForm.HelpAbout1Execute(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

procedure TMainForm.FileExit1Execute(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.abactCheckRightsExecute(Sender: TObject);
begin
  abSecurity1.ShowPrivileges;
end;

procedure TMainForm.Button1Click(Sender: TObject);
begin
  if abSecurity1.CheckId(30) then
    ShowMessage('ID 30 Enabled')
  else
    ShowMessage('ID 30 Disabled');
end;

procedure TMainForm.FileClose1Execute(Sender: TObject);
begin
  if Assigned(ActiveMDIChild) then
    ActiveMDIChild.Close;
end;

procedure TMainForm.abactChangeLogonExecute(Sender: TObject);
begin
  abSecurity1.Logon;
end;

end.
