unit rs_str;
// *********************************************
// RAD-Studio string resources table
// (C)opyright by Vipper Software 1998-2002
// http://www.rad-studio.com
// *********************************************

{$I rs.inc}

interface

const
  SProductVersion = '4.2.2';
  SProductName = 'RAD-Studio';

resourcestring

// *********************************************
//         English string resources table
// *********************************************
{$IFDEF RSL_ENGLISH}
  SRSLanguage = 'English';
  SEmpty = 'Empty';
  SToday = 'Today';
  SClear = 'Clear';
  SSearchPrompt = 'Search: ';
  SFooterStateStrings = 'Average;Count;Maximum;Minimum;Sum;None';
  SFooterStateMarkers = 'AVG;CNT;MAX;MIN;SUM;';

  // grid customizer
  SDefGridCustomizer = 'Default customizer. Please include "rs_gcc.pas" into your project';
  SPickerCaption = 'Customize';
  SPickerClose = '[Close]';

  // vision toolform
  SToolFormPrompt = 'Place controls here';

  // errors
  SEInternal = 'Internal error: %s';
  SENegativeValue = 'Value can not be negative (%d)';
  SEPositiveValue = 'Value must be positive (%d)';
  SEInvalidIndex  = 'Index is out of range (%d/%d)';
  SEInvalidSelection = 'Unable to select column (%d)';
  SEMethodCanceled = 'Method call was cancelled (%s)';
  SEInvalidLayoutPos = 'Invalid layout position (%d,%d)';
  SEInvalidColumnsMargin = 'Invalid column margin. Correct value must be in 0..3 range';

  // input errors
  SEInvalidInputText = 'Invalid input text';
  SEInputDateValue = 'Please input date value';
  SENumericValueBlank = 'Input value can not be blank. Please input valid numeric value';
  SEInvalidNumericValue = '"%s" is not a valid numeric value';
  SENumericValueOutOfRange = '"%s" is out of range. The allowed range is %g to %g';

  // objdataset errors
  SENoDataProvider = 'No data provider. Please assign value to "ObjectRef" property';
  SEBookmarkNotFound = 'Bookmark not found';
  SEUnableToInsertDate = 'unable to insert data';
  SENoRecords = 'no records';

  {$IFDEF RS_STARTUP_TIP}
  SPromptHeader1 = ' Help system ';
  SPromptHeader2 = ' Wizard ';
  SPromptText1 =
    'It is recommended to learn some basic component''s concepts. '+
    'Press <F1> key to invoke TDBGridPro help. Then '+
    'click on "See also" button and choose "Basic concepts".';
  SPromptText2 =
    'Start with TDBGridPro wizard for initializing component''s properties.'#13+
    '1. Right-click on the component'#13+
    '2. Choose "Wizard ..." from menu'#13+
    '3. Follow the wizard instructions';
  {$ENDIF}
{$ENDIF}


// *********************************************
//         Russian string resources table
// *********************************************
{$IFDEF RSL_RUSSIAN}
  // common strings
  SRSLanguage = 'Russian';
  SEmpty = '';
  SToday = '';
  SClear = '';
  SSearchPrompt = ': ';
  SFooterStateStrings = ';;;;;';
  SFooterStateMarkers = ';;;;;';

  // grid customizer
  SDefGridCustomizer = '   . '+
    ',  "rs_gcc.pas"   ';
  SPickerCaption = ' ';
  SPickerClose = '[]';

  // vision toolform
  SToolFormPrompt = '   (controls) ';
  
  // errors
  SEInternal = ' : %s';
  SENegativeValue = '     (%d)';
  SEPositiveValue = '    (%d)';
  SEInvalidIndex = '   (%d/%d)';
  SEMethodCanceled = '    (%s)';
  SEInvalidLayoutPos = '   (%d,%d)';
  SEInvalidSelection = '   (%d)';
  SEInvalidColumnsMargin = '    ,     0  3';

  // input errors
  SEInvalidInputText = '  ';
  SEInputDateValue = '  ';
  SENumericValueBlank = '     . '+
    ',    ';
  SEInvalidNumericValue = '"%s"     ';
  SENumericValueOutOfRange = '"%s"  .    -  %g  %g';

  // objdataset errors
  SENoDataProvider = '  . ,    "ObjectRef"';
  SEBookmarkNotFound = '  ';
  SEUnableToInsertDate = '  ';
  SENoRecords = ' ';

  {$ifdef gp_startup_tip}
  SPromptHeader1 = '   ';
  SPromptHeader2 = '  ';
  SPromptText1 =
    '        . '+
    ' <F1>      TDBGridPro. , '+
    '   ". "    " ".';
  SPromptText2 =
    '    TDBGridPro  .'#13+
    '1.       '#13+
    '2.    " ..."'#13+
    '3.       ';
  {$endif}
{$ENDIF}


implementation

end.
