unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables, ExtCtrls, StdCtrls, Mask, Provider, DBClient, rs, rs_std
  {$IFDEF VER140}, variants {$ENDIF};

type
  TForm1 = class(TForm)
    dsVendors: TDataSource;
    datVendors: TTable;
    visPhoneFax: TLiteVision;
    visZipCode: TLiteVision;
    visUSState: TXStateVision;
    StandardDesigner1: TStandardDesigner;
    Panel2: TPanel;
    Label1: TLabel;
    DBGridPro1: TDBGridPro;
    cdatVendors: TClientDataSet;
    DataSetProvider1: TDataSetProvider;
    procedure DBGridPro1TitleStateChange(Sender: TObject;
      Column: TgpColumn);
    procedure DBGridPro1FooterStateChange(Sender: TObject;
      Column: TgpColumn);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
{$R *.DFM}
uses
  rs_rtm;

procedure TForm1.DBGridPro1TitleStateChange(Sender: TObject;
  Column: TgpColumn);
var
  I: integer;
  Item: TgpColumn;
  IdxDef: TIndexDef;
begin
  cdatVendors.IndexDefs[0].Free;
  IdxDef := cdatVendors.IndexDefs.AddIndexDef;
  with DBGridPro1.Columns do
    for I := 0 to TitleStatedCount-1 do begin
      Item := TitleStated[I];
      IdxDef.Fields := lioAdd(IdxDef.Fields,Item.FieldName);
      if (Item.TitleState = tsSortedDown) then
        IdxDef.DescFields := lioAdd(IdxDef.DescFields,Item.FieldName);
    end;
  if (IdxDef.Fields <> '') then begin
    IdxDef.Name := 'DefIndex'+IntToStr(GetTickCount);
    cdatVendors.IndexName := IdxDef.Name;
  end else
    cdatVendors.IndexName := '';
end;


procedure TForm1.DBGridPro1FooterStateChange(Sender: TObject;
  Column: TgpColumn);
const
  Mapper: array [TgpColumnFooterState] of string = ('Avg','Count','Max','Min','Sum','');
var
  Agg: TAggregate;
begin
  Agg := cdatVendors.Aggregates.Find('Agg'+Column.FieldName);
  if (Column.FooterState <> fsNone) then begin
    if (Agg = nil) then begin
      Agg := cdatVendors.Aggregates.Add;
      Agg.AggregateName := 'Agg'+Column.FieldName;
    end;
    Agg.Active := false;
    Agg.Expression := Format('%s(%s)',[Mapper[Column.FooterState],Column.FieldName]);
    Agg.Active := true;
    Column.FooterText := VarToStr(Agg.Value);
  end else
    Agg.Free;
end;


end.
