unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Db, rs, rs_std, rs_rtm;

type
  TStoresInfo = class;
  TLoadsInfo = class;

  TForm1 = class(TForm)
    gpStores: TDBGridPro;
    Splitter1: TSplitter;
    gpLoads: TDBGridPro;
    datStores: TObjDataSet;
    dsStores: TDataSource;
    datLoads: TObjDataSet;
    dsLoads: TDataSource;
    visStore: TVLookupVision;
    Panel1: TPanel;
    cmxInputType: TComboBox;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure gpLoadsAfterFieldPost(Sender: TObject; Column: TgpColumn;
      PostCode: TgpFieldPostCode; var Action: TgpFieldEditAction);
    procedure gpLoadsColEnter(Sender: TObject; ACol: Integer);
  private
    FStoresInfo: TStoresInfo;
    FLoadsInfo: TLoadsInfo;
  public
    { Public declarations }
  end;


  TStoreInfo = class (TCollectionItem)
  private
    FStoreNo: integer;
    FStoreName: string;
  published
    property StoreNo: integer read FStoreNo write FStoreNo;
    property StoreName: string read FStoreName write FStoreName;
  end;


  TStoresInfo = class (TCollection)
  public
    constructor Create;
  end;


  TLoadInfo = class (TCollectionItem)
  private
    FStoreNo: integer;
    FQuantity: double;
  published
    property StoreNo: integer read FStoreNo write FStoreNo;
    property Quantity: double read FQuantity write FQuantity;
  end;


  TLoadsInfo = class (TCollection)
  public
    constructor Create;
  end;


var
  Form1: TForm1;


implementation
{$R *.DFM}

constructor TStoresInfo.Create;
begin
  inherited Create(TStoreInfo);
end;


constructor TLoadsInfo.Create;
begin
  inherited Create(TLoadInfo);
end;


procedure TForm1.FormCreate(Sender: TObject);

  procedure InitStores;
  begin
    with TStoreInfo(FStoresInfo.Add) do begin
      StoreNo := 1;
      StoreName := 'Default store';
    end;
    with TStoreInfo(FStoresInfo.Add) do begin
      StoreNo := 2;
      StoreName := 'Remote store';
    end;
    with TStoreInfo(FStoresInfo.Add) do begin
      StoreNo := 3;
      StoreName := 'Local store';
    end;
  end;


  procedure InitLoads;
  begin
    with TLoadInfo(FLoadsInfo.Add) do begin
      StoreNo := 3;
      Quantity := 50;
    end;
    with TLoadInfo(FLoadsInfo.Add) do begin
      StoreNo := 3;
      Quantity := 2.05;
    end;
    with TLoadInfo(FLoadsInfo.Add) do begin
      StoreNo := 1;
      Quantity := 150;
    end;
    with TLoadInfo(FLoadsInfo.Add) do begin
      StoreNo := 2;
      Quantity := 17;
    end;
    with TLoadInfo(FLoadsInfo.Add) do begin
      StoreNo := 3;
      Quantity := 141;
    end;
    with TLoadInfo(FLoadsInfo.Add) do begin
      StoreNo := 2;
      Quantity := 32;
    end;
  end;

begin
  inherited;
  FStoresInfo := TStoresInfo.Create;
  FLoadsInfo := TLoadsInfo.Create;
  InitStores;
  InitLoads;
  datStores.ObjectRef := FStoresInfo;
  datLoads.ObjectRef := FLoadsInfo;
  datStores.Active := true;
  datLoads.Active := true;
  cmxInputType.ItemIndex := 0;
end;


procedure TForm1.FormDestroy(Sender: TObject);
begin
  FStoresInfo.Free;
  FLoadsInfo.Free;
  inherited;
end;


procedure TForm1.FormShow(Sender: TObject);
begin
  visStore.LookupParams.DataSource := dsStores;
end;


procedure TForm1.gpLoadsAfterFieldPost(Sender: TObject; Column: TgpColumn;
  PostCode: TgpFieldPostCode; var Action: TgpFieldEditAction);
begin
  if (PostCode = fpcReturnKey) and (datLoads.State = dsInsert) then
    if (Column.Tag = 0) then begin
      if datLoads.Eof then
        datLoads.Append
      else begin
        datLoads.MoveBy(1);
        datLoads.Insert;
      end;
      gpLoads.Columns.ByTag(cmxInputType.ItemIndex+1).Editing := true;
    end else begin
      gpLoads.Columns.ByField('quantity').Editing := true;
    end;
end;


procedure TForm1.gpLoadsColEnter(Sender: TObject; ACol: Integer);
begin
  if (datLoads.State = dsInsert) then
    if (gpLoads.Columns[ACol].Tag <> 0) then
      cmxInputType.ItemIndex := gpLoads.Columns[ACol].Tag-1;
end;


end.
