unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Db, DBTables, rs_std, rs, rs_rtm;

type
  TForm1 = class(TForm)
    gpList: TDBGridPro;
    dsSource: TDataSource;
    datSource: TTable;
    StandardDesigner1: TStandardDesigner;
    LiteDesigner1: TLiteDesigner;
    pnDesigns: TPanel;
    rgDesigns: TRadioGroup;
    GroupBox1: TGroupBox;
    cbxRows: TCheckBox;
    cbxCells: TCheckBox;
    cbxStripStep: TCheckBox;
    dsgDefaultList: TStandardDesigner;
    procedure rgDesignsClick(Sender: TObject);
    procedure gpListGetRowAttrs(Sender: TObject; RowAttrs: TgpRowAttrs);
    procedure cbxRowsClick(Sender: TObject);
    procedure cbxStripStepClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.rgDesignsClick(Sender: TObject);
begin
  inherited;
  case rgDesigns.ItemIndex of
    0: gpList.Designer := nil;
    1: gpList.Designer := rsDefPack.DsgnListFlat;
    2: gpList.Designer := rsDefPack.DsgnListNormal;
    3: gpList.Designer := dsgDefaultList;
    4: gpList.Designer := LiteDesigner1;
    5: gpList.Designer := StandardDesigner1;
  end;
end;


procedure TForm1.gpListGetRowAttrs(Sender: TObject;
  RowAttrs: TgpRowAttrs);
var
  S: string;
begin
  inherited;
  if (RowAttrs.BgColor = clNone) then begin
    if (RowAttrs.StripIndex = 1) then
      RowAttrs.BgColor := $00F2F2F2;
    if cbxCells.Checked and (RowAttrs['LastName'].BgColor = clNone) then begin
      S := datSource.FindField('LastName').AsString;
      if (Length(S) > 0) then
        if AnsiSameText('B',S[1]) then
          RowAttrs['LastName'].BgColor := clRed;
    end;
    if cbxRows.Checked then
      if (datSource.FindField('Salary').AsFloat > 40000) then
        RowAttrs.BgColor := clYellow;
  end;
end;


procedure TForm1.cbxRowsClick(Sender: TObject);
begin
  inherited;
  gpList.InvalidateGrid;
end;


procedure TForm1.cbxStripStepClick(Sender: TObject);
begin
  inherited;
  if cbxStripStep.Checked then
    gpList.StripStep := 2
  else
    gpList.StripStep := -1;
end;


end.
