unit rs_gcc;
// *********************************************
// RAD-Studio TDBGridPro columns customizer
// (C)opyright by Vipper Software 1998-2001
// http://www.rad-studio.com
// *********************************************

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, Buttons, ExtCtrls, rs, rs_std, rs_rtm;

type
  TfrmColumnPicker = class(TForm)
    gpList: TDBGridPro;
    dsFields: TDataSource;
    datFields: TObjDataSet;
    ldDesigner: TLiteDesigner;
    Panel1: TPanel;
    pnButton: TPanel;
    btnClose: TSpeedButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure gpListDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure gpListDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure btnCloseClick(Sender: TObject);
  private
    FForceClose: boolean;
    FStrings: TStringList;
    FGrid: TDBGridPro;
    FAllFields: string;
    FAllCaptions: string;
    FVisibleFields: string;
    FInvisibleFields: string;
    procedure WMSizing (var Msg: TMessage); message WM_SIZING;
    procedure CMCustomizer (var Msg: TMessage); message CM_CUSTOMIZER;
    procedure InitFieldList;
    function GetAlignedHeight (AHeight: integer): integer;
  private
    FMode: TgpCustomizeMode;
  protected
    procedure Notification (AComponent: TComponent; Operation: TOperation); override;
  end;

var
  frmColumnPicker: TfrmColumnPicker = nil;


implementation
{$R *.DFM}
uses
  rs_str;

var
  WinXpos: integer = 240;
  WinYpos: integer = 100;
  WinWidth: integer = 224;
  WinHeight: integer = 340;


procedure ShowGridCustomizerProc (Grid: TDBGridPro; const AllFields,AllCaptions,
  VisibleFields: string; Mode: TgpCustomizeMode);
begin
  if (frmColumnPicker <> nil) then begin
    frmColumnPicker.FForceClose := true;
    frmColumnPicker.Close;
  end;
  frmColumnPicker := TfrmColumnPicker.Create(Application);
  frmColumnPicker.FGrid := Grid;
  frmColumnPicker.FAllFields := AllFields;
  frmColumnPicker.FAllCaptions := AllCaptions;
  frmColumnPicker.FVisibleFields := VisibleFields;
  frmColumnPicker.FMode := Mode;
  frmColumnPicker.Show;
end;


procedure TfrmColumnPicker.FormCreate(Sender: TObject);
begin
  FStrings := TStringList.Create;
end;


procedure TfrmColumnPicker.FormDestroy(Sender: TObject);
begin
  FStrings.Free;
end;


procedure TfrmColumnPicker.FormShow(Sender: TObject);
begin
  Caption := rs_str.SPickerCaption;
  btnClose.Caption := rs_str.SPickerClose;

  datFields.ObjectRef := FStrings;
  InitFieldList;
  datFields.Active := true;
  FGrid.Perform(CM_CUSTOMIZER,integer(gcaStart),integer(Self));
  FGrid.FreeNotification(Self);

  // restore position
  Left := WinXpos+8;
  Top := WinYpos+8;
  Width := WinWidth;
  Height := WinHeight;
  Height := GetAlignedHeight(Height);
end;


procedure TfrmColumnPicker.FormClose (Sender: TObject; var Action: TCloseAction);
begin
  FGrid.Perform(CM_CUSTOMIZER,integer(gcaFinish),integer(Self));
  Action := caFree;
  if (not FForceClose) then begin
    frmColumnPicker := nil;
    // save position
    WinXpos := Left;
    WinYpos := Top;
    WinWidth := Width;
    WinHeight := Height;
  end;
end;


procedure TfrmColumnPicker.WMSizing (var Msg: TMessage);
var
  iHeight: integer;
  RctRef: ^TRect;
begin
  inherited;
  RctRef := pointer(Msg.LParam);
  iHeight := GetAlignedHeight(RctRef^.Bottom-RctRef^.Top);
  if (RctRef^.Top <> Top) then
    RctRef^.Top := RctRef^.Bottom-iHeight
  else
    RctRef^.Bottom := RctRef^.Top+iHeight;
end;


procedure TfrmColumnPicker.CMCustomizer (var Msg: TMessage);

  function GetSel: TgpColumn;
  begin
    Result := FGrid.Columns.ByField(
      lioRead(FInvisibleFields,gpList.Selection.Current.RecNo-1)
    );
  end;

var
  Column: TgpColumn;
  MeasureColumn: TgpColumn;
begin
  case TgpCustomizerAction(Msg.WParam) of
    gcaBeforeAddColumn: begin
      TgpColumn(Msg.LParam).FieldName :=
        lioRead(FInvisibleFields,gpList.Selection.Current.RecNo-1);
    end;
    
    gcaAddColumn,gcaShowColumn: begin
      FVisibleFields := lioAdd2(FVisibleFields,TgpColumn(Msg.LParam).FieldName);
      InitFieldList;
      datFields.Refresh;
      datFields.Resync([rmCenter]);
    end;
    
    gcaRemoveColumn,gcaHideColumn: begin
      FVisibleFields := lioRemove(FVisibleFields,FGrid.CustomizedColumn.FieldName);
      case FMode of
        gcmRemove: FGrid.CustomizedColumn.Free; // destroy column
        gcmHide: FGrid.CustomizedColumn.Visible := false; // hide column
      end;
      InitFieldList;
      gpList.RefreshData;
    end;

    gcaGetSel:
      Msg.Result := integer(pointer(GetSel));

    gcaDragDrop: begin
      if (FMode = gcmRemove) then begin // create column
        MeasureColumn := TgpColumn.Create(nil);
        try
          FGrid.Perform(CM_CUSTOMIZER,integer(gcaBeforeAddColumn),integer(MeasureColumn));
          with FGrid,FGrid.Dragger do
            if (TitleHitTest <> chtUndefined) then
              Column := Columns.Insert(DragDestGroup,DragLayoutLevel,DragLayoutIndex,MeasureColumn)
            else
              Column := Columns.Insert(nil,-1,-1,MeasureColumn);
          FGrid.Perform(CM_CUSTOMIZER,integer(gcaAddColumn),integer(Column));
        finally
          MeasureColumn.Free;
        end;

      end else begin // show column
        Column := GetSel;
        with FGrid,FGrid.Dragger do begin
          FreezeGrid;
          try
            if (TitleHitTest = chtMovingSingle) then
              Columns.Outgroup(Column,DragDestGroup)
            else
              if (TitleHitTest in [chtNewLayoutLevel,chtNewLayoutIndex]) then
                Columns.Regroup(Column,DragDestGroup,DragLayoutLevel,DragLayoutIndex)
            else
              Column.Visible := true; 
            FGrid.Perform(CM_CUSTOMIZER,integer(gcaShowColumn),integer(Column));
          finally
            UnfreezeGrid(true);
          end;
        end;
        
      end;
    end;
  end;
end;


procedure TfrmColumnPicker.Notification (AComponent: TComponent;
  Operation: TOperation);
begin
  inherited;
  if (AComponent = FGrid) and (Operation = opRemove) then
    Close;
end;


procedure TfrmColumnPicker.InitFieldList;
var
  I: integer;
begin
  FStrings.Clear;
  FInvisibleFields := '';
  for I := 0 to lioCount2(FAllFields)-1 do
    if not lioHasItem(FVisibleFields,lioRead(FAllFields,I)) then begin
      FStrings.Add(lioRead(FAllCaptions,I));
      FInvisibleFields := lioAdd2(FInvisibleFields,lioRead(FAllFields,I));
    end;
end;


function TfrmColumnPicker.GetAlignedHeight (AHeight: integer): integer;
var
  iStart: integer;
  I: integer;
begin
  iStart := (Height-ClientHeight)+gpList.Height-gpList.ClientHeight;
  I := (AHeight-iStart) div gpList.RowHeightPx;
  if (I < 2) then
    I := 2;
  Result := I*gpList.RowHeightPx+iStart;
end;


procedure TfrmColumnPicker.gpListDragOver (Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
  Accept := (Source = FGrid) and (FGrid.Dragger.DraggingCustomizer) and
    not (cboNoCustomizing in FGrid.CustomizedColumn.OptionsBehavior);
end;


procedure TfrmColumnPicker.gpListDragDrop (Sender,Source: TObject; X,
  Y: Integer);
begin
  if (Source = FGrid) then
    FGrid.Perform(CM_CUSTOMIZER,integer(gcaRemoveColumn),integer(FGrid.CustomizedColumn));
end;


procedure TfrmColumnPicker.btnCloseClick(Sender: TObject);
begin
  Close;
end;


initialization
  ShowGridCustomizer := ShowGridCustomizerProc;

end.
