unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Buttons, Db, DBTables, rs_std, rs, rs_map;

type
  TForm1 = class(TForm)
    gpList: TDBGridPro;
    pnControl: TPanel;
    btnCustomize: TSpeedButton;
    dsSource: TDataSource;
    datSource: TTable;
    QuickFieldMapper1: TQuickFieldMapper;
    btnSaveLayout: TSpeedButton;
    btnRestoreLayout: TSpeedButton;
    StandardDesigner1: TStandardDesigner;
    LiteDesigner1: TLiteDesigner;
    pnDesigns: TPanel;
    rgDesigns: TRadioGroup;
    procedure btnCustomizeClick(Sender: TObject);
    procedure rgDesignsClick(Sender: TObject);
    procedure btnSaveLayoutClick(Sender: TObject);
    procedure btnRestoreLayoutClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
{$R *.DFM}
uses
  rs_rtm;

procedure TForm1.btnCustomizeClick(Sender: TObject);
begin
  inherited;
  gpList.Customize(gcmRemove,'');
end;


procedure TForm1.rgDesignsClick(Sender: TObject);
begin
  inherited;
  case rgDesigns.ItemIndex of
    0: gpList.Designer := StandardDesigner1;
    1: gpList.Designer := LiteDesigner1;
  end;
end;


procedure TForm1.btnSaveLayoutClick(Sender: TObject);
var
  S: string;
  Columns: TgpColumns;
  Strings: TStringList;
begin
  inherited;
  Columns := TgpColumns.Create(nil);
  Strings := TStringList.Create;
  try
    Columns.AssignEx(gpList.Columns,true,gpcpLayout or gpcpFieldName or gpcpStates);
    Strings.Text := ObjectToStr(Columns); // "dbgp_rtm" unit
    S := ExtractFilePath(Application.ExeName)+'Saves\layout.txt';
    Strings.SaveToFile(S);
    if Application.MessageBox(
      PChar(Format('Layout has been saved to %s. Would you like to open it ?',[S])),
      'Question', MB_YESNO) = id_yes
    then
      WinExec(pChar('notepad '+'"'+S+'"'),SW_SHOWNORMAL);
  finally
    Strings.Free;
    Columns.Free;
  end;
end;


procedure TForm1.btnRestoreLayoutClick(Sender: TObject);
var
  S: string;
  Columns: TgpColumns;
  Strings: TStringList;
begin
  Columns := TgpColumns.Create(nil);
  Strings := TStringList.Create;
  try
    S := ExtractFilePath(Application.ExeName)+'Saves\layout.txt';
    Strings.LoadFromFile(S);
    StrToObject(Columns,Strings.Text); // "dbgp_rtm" unit
    gpList.Columns.AssignEx(Columns,true,(gpcpLayout or gpcpFieldName or gpcpStates));
  finally
    Strings.Free;
    Columns.Free;
  end;
end;


end.
