unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Db, DBTables, StdCtrls, rs_rtm, rs, rs_str {$IFDEF VER140}, variants {$ENDIF};

type
  TCustomerInfo = class;
  TCustomersInfo = class;

  TForm1 = class(TForm)
    gpList1: TDBGridPro;
    Splitter1: TSplitter;
    gpList2: TDBGridPro;
    dsSource: TDataSource;
    datSource: TTable;
    datDest: TObjDataSet;
    dsDest: TDataSource;
    Panel3: TPanel;
    lbStatus: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure gpList2DragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure gpList2DragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure gpList1SelectionChange(Sender: TObject);
    procedure gpList2EndDrag(Sender, Target: TObject; X, Y: Integer);
  private
    FStorage: TCustomersInfo;
  public
    procedure UpdateStatus;
  end;


  TCustomerInfo = class (TCollectionItem)
  private
    FCustNo: integer;
    FState: string;
    FCountry: string;
  published
    property CustNo: integer read FCustNo write FCustNo;
    property State: string read FState write FState;
    property Country: string read FCountry write FCountry;
  end;


  TCustomersInfo = class (TCollection)
  private
    function GetItem(ItemIndex: integer): TCustomerInfo;
  public
    property Items[ItemIndex: integer]: TCustomerInfo read GetItem; default;
    constructor Create;
    function Add: TCustomerInfo;
  end;



var
  Form1: TForm1;

implementation

{$R *.DFM}

// LOCAL DATA STORAGE
constructor TCustomersInfo.Create;
begin
  inherited Create(TCustomerInfo);
end;


function TCustomersInfo.GetItem(ItemIndex: integer): TCustomerInfo;
begin
  Result := TCustomerInfo(inherited Items[ItemIndex]);
end;


function TCustomersInfo.Add: TCustomerInfo;
begin
  Result := TCustomerInfo(inherited Add);
end;


// FORM HANDLERS
procedure TForm1.FormCreate(Sender: TObject);
begin
  inherited;
  FStorage := TCustomersInfo.Create;
  datDest.ObjectRef := FStorage;
  datDest.Active := true;
end;


procedure TForm1.FormDestroy(Sender: TObject);
begin
  inherited;
  FStorage.Free;
end;


procedure TForm1.gpList2DragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
begin
  inherited;
  if (Source = gpList1) then
    Accept := gpList1.HasCurrent
  else
    if (Source = gpList2) then begin
      Accept := gpList2.HasCurrent and (gpList2.Dragger.HotSpotRecShot.RecNo <> -1);
      UpdateStatus;
    end;
end;


procedure TForm1.gpList2DragDrop(Sender, Source: TObject; X,Y: Integer);
var
  I: integer;
begin
  inherited;
  if (Source = gpList1) then begin
    for I := 0 to gpList1.Selection.Count-1 do
      with FStorage.Add do begin
        CustNo := gpList1.Selection[I].ID;
        State := VarToStr(gpList1.Selection[I].Data[0]);
        Country := VarToStr(gpList1.Selection[I].Data[1]);
      end;
    gpList1.Selection.Clear;
  end else
    if (Source = gpList2) then
      if (gpList2.Dragger.HotSpotRecShot.RecNo <> -1) then begin
        FStorage.Items[gpList2.Selection.Current.RecNo-1].Index :=
          gpList2.Dragger.HotSpotRecShot.RecNo-1;
      end;
  datDest.Refresh;
end;


procedure TForm1.UpdateStatus;
var
  I: integer;
  S: string;
begin
  S := Format(' List #1: %d record(s) selected',[gpList1.Selection.Count]);
  S := S+#13;
  with gpList2.Dragger do
    if Dragging then begin
      I := HotSpotRecShot.RecNo;
      if (I <> -1) then
        S := S+Format(' List #2: record moving (from %d to %d)',
          [gpList2.Selection.Current.RecNo,I])
      else
        S := S+' List #2: record moving (N/A)'
    end else
      S := S+' List #2: no record moving';
  lbStatus.Caption := S;
end;


procedure TForm1.gpList1SelectionChange(Sender: TObject);
begin
  inherited;
  UpdateStatus;
end;


procedure TForm1.gpList2EndDrag(Sender, Target: TObject; X,Y: Integer);
begin
  inherited;
  UpdateStatus;
end;


end.
