unit bitIO;

interface
uses OFile;

type
  TBitFile = class
  private
    f: TOFile;
    mask: byte;
    rack: longint;
    pacifier_counter: integer;

    IsOpenInput: boolean;

  public
    procedure Open(name: string; _IsOpenInput: boolean);
    procedure Close;

    procedure OutputBit(bit: byte);
    procedure OutputBits(code: longint; count: byte);
    function  InputBit: byte;
    function  InputBits( count: byte ): longint;
  end;

implementation


procedure TBitFile.Open(name: string; _IsOpenInput: boolean);
begin
  IsOpenInput := _IsOpenInput;

  f := TOFile.create;
  f.AssignFile(name);
  if IsOpenInput then
    f.Reset(1)
  else
    f.Rewrite(1);

  rack := 0;
  mask := $80;
  pacifier_counter := 0;
end;

procedure TBitFile.Close;
begin
  if (not IsOpenInput) and (Mask <> $80) then f.WriteByte(rack);
  f.Close;
  f.free;
end;

procedure TBitFile.OutputBit(bit: byte);
begin
  if bit = 1 then
    rack := rack or mask;

  mask := mask shr 1;
  if mask = 0 then
  begin
    f.WriteByte(rack);
    rack := 0;
    mask := $80;
  end;
end;

procedure TBitFile.OutputBits(code: longint; count: byte);
var
  TempMask: longint;
begin
  TempMask := 1 Shl (Count-1);
  while TempMask <> 0 do
  begin
    if (TempMask and Code <> 0) then
      Rack := Rack or Mask;

    Mask := Mask shr 1;
    if Mask = 0 then
    begin
      f.WriteByte(Rack);
      Rack := 0;
      Mask := $80;
    end;

    TempMask := TempMask shr 1;
  end;
end;

function TBitFile.InputBit: byte;
var
  value: byte;
begin
  if mask = $80 then
  begin
    rack := f.GetByte;
    //if f.EOF then ShowMessage('Fatal: End of file reached');
  end;

  value := Rack and Mask;
  Mask := Mask shr 1;
  if Mask = 0 then Mask := $80;

  if value = 0 then
    result := 0
  else
    result := 1;
end;

function TBitFile.InputBits( count: byte ): longint;
var
  TempMask: Longint;
  value: longint;
begin
  TempMask := 1 shl (count-1);
  value := 0;

  while TempMask <> 0 do
  begin
    if Mask = $80 then Rack := f.GetByte;

    if (Rack and Mask <> 0) then
      value := (value or TempMask);

    TempMask := TempMask shr 1;

    Mask := Mask shr 1;
    if Mask = 0 then Mask := $80;
  end;

  result := value;
end;


end.
